/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.model;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.util.TwoDArrayIterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface IDisplaySetContainer {
    public IDisplaySet getDisplaySetAt(int var1);

    public int getDisplaySetCount();

    default public IDisplaySet getRelatedDisplaySet(IDisplaySet iDisplaySet) {
        return this.streamRelatedDisplaySets(iDisplaySet).findAny().orElse(null);
    }

    default public Stream<IDisplaySet> streamRelatedDisplaySets(IDisplaySet iDisplaySet) {
        return IntStream.range(0, this.getDisplaySetCount()).mapToObj(this::getDisplaySetAt).filter(iDisplaySet2 -> IDisplaySetContainer.relatesEachOther(iDisplaySet, iDisplaySet2));
    }

    public static boolean relatesEachOther(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2) {
        if (!CompareUtils.equals((Object)iDisplaySet.getFrameOfReferenceUID(), (Object)iDisplaySet2.getFrameOfReferenceUID())) {
            return false;
        }
        FrameObjectDataCollection frameObjectDataCollection = new FrameObjectDataCollection(iDisplaySet);
        FrameObjectDataCollection frameObjectDataCollection2 = new FrameObjectDataCollection(iDisplaySet2);
        return IDisplaySetContainer.isRelated(frameObjectDataCollection, frameObjectDataCollection2) || IDisplaySetContainer.isRelated(frameObjectDataCollection2, frameObjectDataCollection);
    }

    public static <T> boolean isRelated(ISortedCollection<T> iSortedCollection, ISortedCollection<T> iSortedCollection2) {
        return iSortedCollection2.contains(iSortedCollection.first()) && (iSortedCollection.size() == 1 || iSortedCollection2.contains(iSortedCollection.last()));
    }

    public static class FrameObjectDataCollection
    implements ISortedCollection<IFrameObjectData> {
        private final IDisplaySet displaySet;

        FrameObjectDataCollection(IDisplaySet iDisplaySet) {
            this.displaySet = iDisplaySet;
        }

        @Override
        public int size() {
            return this.displaySet.getTotalFrameCount();
        }

        @Override
        public boolean contains(IFrameObjectData iFrameObjectData) {
            for (IFrameObjectData iFrameObjectData2 : new TwoDArrayIterator<IFrameObjectData>(this.displaySet.getFrames())) {
                if (!iFrameObjectData2.equals(iFrameObjectData)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IFrameObjectData first() {
            return this.displaySet.getFrames()[0][0];
        }

        @Override
        public IFrameObjectData last() {
            IFrameObjectData[][] iFrameObjectDataArray = this.displaySet.getFrames();
            IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray[iFrameObjectDataArray.length - 1];
            return iFrameObjectDataArray2[iFrameObjectDataArray2.length - 1];
        }
    }

    public static interface ISortedCollection<T> {
        public int size();

        public boolean contains(T var1);

        public T first();

        public T last();
    }
}

