/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.runtime.AbstractSplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.DisplaySetContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.FrameContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.ManualSplitAndSortEngine;
import com.agfa.pacs.impaxee.splitsort.runtime.SplitAndSortEngine;
import com.agfa.pacs.impaxee.splitsort.runtime.Utils4D;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.util.TwoDArrayIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;

public class ConditionalSplitAndSortRuntime
extends AbstractSplitAndSortRuntime
implements IDisplaySetContainerRuntime {
    private DisplaySetContainer runtimeContainer;
    private DisplaySetContainer defaultContainer = DisplaySetContainer.createDefaultInstance(this);
    private DisplaySetContainer koContainer = DisplaySetContainer.createKeyImageInstance(this);
    private final Map<String, IDisplaySet> koDisplaySetsPerStudy = new HashMap<String, IDisplaySet>();
    private boolean loading = false;

    public ConditionalSplitAndSortRuntime(IPatientRepresentation iPatientRepresentation) {
        super(iPatientRepresentation);
        this.runtimeContainer = DisplaySetContainer.createRuntimeInstance(this);
    }

    @Override
    public List<String> getStudyOrdering() {
        return this.runtimeContainer.getStudyOrdering();
    }

    @Override
    public void addDisplaySet(IDisplaySet iDisplaySet, SplitAndSortChangeType splitAndSortChangeType) {
        this.populateContainers(Collections.singletonList(TwoDArrayIterator.toArray(iDisplaySet.getFrames())), iDisplaySet, null, new ArrayList<String>(Arrays.asList(iDisplaySet.getStudy().getModalitiesInStudy())));
    }

    @Override
    public void removeDisplaySet(IDisplaySet iDisplaySet, SplitAndSortChangeType splitAndSortChangeType) {
        this.runtimeContainer.removeDisplaySet(iDisplaySet, null);
        this.defaultContainer.removeRelatedDisplaySet(iDisplaySet);
        this.koContainer.removeRelatedDisplaySet(iDisplaySet);
    }

    @Override
    public IDisplaySet getDisplaySetAt(int n) {
        return this.runtimeContainer.getDisplaySetAt(n);
    }

    @Override
    public IDisplaySet getDisplaySetByID(int n) {
        return this.runtimeContainer.getDisplaySetForId(n);
    }

    @Override
    public IDisplaySet getKeyImageDisplaySet(IStudyData iStudyData) {
        return this.koDisplaySetsPerStudy.get(iStudyData.getKey());
    }

    @Override
    public int getDisplaySetCount() {
        return this.runtimeContainer.getDisplaySetCount();
    }

    @Override
    public int getDisplaySetPosition(IDisplaySet iDisplaySet) {
        return this.runtimeContainer.getIndexOfDisplaySet(iDisplaySet);
    }

    @Override
    public IDisplaySet[] getDisplaySets() {
        return this.runtimeContainer.getDisplaySets().toArray(new IDisplaySet[0]);
    }

    @Override
    public void splitAndSortSingleStudy(IStudyData iStudyData, SplitAndSort splitAndSort) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IDisplaySet[] object22 = this.getDisplaySets();
        int n = object22.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object22[n2];
            if (object2.getStudy().getKey().equals(iStudyData.getKey())) {
                arrayList.add(object2);
            }
            ++n2;
        }
        for (Object object2 : arrayList) {
            this.removeDisplaySet((IDisplaySet)object2, SplitAndSortChangeType.MANUAL_SPLIT_AND_SORT_CHANGE);
        }
        object2 = new ManualSplitAndSortEngine(splitAndSort);
        List<IFrameObjectData[]> list = ((SplitAndSortEngine)object2).splitPresortData(iStudyData.getSeries());
        HashSet<String> hashSet = new HashSet<String>();
        for (ISeriesData iSeriesData : iStudyData.getSeries()) {
            hashSet.add(iSeriesData.getModality());
        }
        this.populateContainers(list, null, null, Collections.singletonMap(iStudyData.getStudyInstanceUID(), ((SplitAndSortEngine)object2).getDisplaySetComparator(((IFrameObjectData[])list.get(0))[0])), hashSet);
    }

    @Override
    public SplitAndSortChangeSet addSeries(Collection<ISeriesData> collection) {
        List<IFrameObjectData[]> list = SplitAndSortEngine.getInstance().splitPresortData(collection);
        DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet(SplitAndSortChangeType.DATA_LOAD);
        HashSet<String> hashSet = new HashSet<String>();
        for (ISeriesData iSeriesData : collection) {
            hashSet.add(iSeriesData.getModality());
        }
        this.populateContainers(list, null, changeSet, hashSet);
        return changeSet;
    }

    @Override
    public boolean isStudyCollapsableOrExpandable(IStudyData iStudyData) {
        IDisplaySet iDisplaySet = this.getDisplaySetForStudyExpansionStatus(iStudyData);
        if (iDisplaySet != null) {
            if (this.isDisplaySetCollapsed(iDisplaySet)) {
                return !this.isStudyLoaded(iStudyData) || this.defaultContainer.containsDisplaySetOfStudy(iStudyData);
            }
            return this.koContainer.containsDisplaySetOfStudy(iStudyData);
        }
        return false;
    }

    @Override
    public boolean isStudyCollapsed(IStudyData iStudyData) {
        IDisplaySet iDisplaySet = this.getDisplaySetForStudyExpansionStatus(iStudyData);
        if (iDisplaySet != null) {
            return this.isDisplaySetCollapsed(iDisplaySet);
        }
        return false;
    }

    private IDisplaySet getDisplaySetForStudyExpansionStatus(IStudyData iStudyData) {
        Optional<IDisplaySet> optional = this.runtimeContainer.streamDisplaySetsOfStudy(iStudyData).filter(((Predicate<IDisplaySet>)this::hasOnlyKeyImages).negate()).findFirst();
        if (!optional.isPresent()) {
            optional = this.runtimeContainer.streamDisplaySetsOfStudy(iStudyData).findFirst();
        }
        return optional.orElse(null);
    }

    @Override
    public boolean isDisplaySetCollapsable(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet)) {
            return this.koContainer.containsDisplaySet(iDisplaySet) || this.koContainer.getRelatedDisplaySet(iDisplaySet) != null;
        }
        return false;
    }

    @Override
    public boolean isDisplaySetExpandable(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet)) {
            return !this.isStudyLoaded(iDisplaySet.getStudy()) || this.hasDifferentRelatedDisplaySet(this.defaultContainer, iDisplaySet);
        }
        return false;
    }

    private boolean hasDifferentRelatedDisplaySet(DisplaySetContainer displaySetContainer, IDisplaySet iDisplaySet) {
        return this.hasRelatedDisplaySet(displaySetContainer, iDisplaySet, false);
    }

    private boolean hasSameSizeRelatedDisplaySet(DisplaySetContainer displaySetContainer, IDisplaySet iDisplaySet) {
        return this.hasRelatedDisplaySet(displaySetContainer, iDisplaySet, true);
    }

    private boolean hasRelatedDisplaySet(DisplaySetContainer displaySetContainer, IDisplaySet iDisplaySet, boolean bl) {
        IDisplaySet iDisplaySet2 = displaySetContainer.getRelatedDisplaySet(iDisplaySet);
        return iDisplaySet2 != null && iDisplaySet.getTotalFrameCount() == iDisplaySet2.getTotalFrameCount() == bl;
    }

    @Override
    public boolean isDisplaySetCollapsed(IDisplaySet iDisplaySet) {
        return this.koContainer.containsDisplaySet(iDisplaySet) || !this.defaultContainer.containsDisplaySet(iDisplaySet);
    }

    @Override
    public boolean hasOnlyKeyImages(IDisplaySet iDisplaySet) {
        return this.isDisplaySetCollapsed(iDisplaySet) && !this.isDisplaySetExpandable(iDisplaySet) || this.defaultContainer.containsDisplaySet(iDisplaySet) && this.hasSameSizeRelatedDisplaySet(this.koContainer, iDisplaySet);
    }

    @Override
    public void setStudyCollapsed(IStudyData iStudyData) {
        List<IDisplaySet> list;
        if (!this.isStudyCollapsed(iStudyData) && (list = this.runtimeContainer.getDisplaySetsOfStudy(iStudyData)) != null) {
            DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet(SplitAndSortChangeType.KEY_IMAGE_EXPANSION_TOGGLE);
            for (IDisplaySet iDisplaySet : list) {
                IDisplaySet iDisplaySet2 = this.koContainer.getRelatedDisplaySet(iDisplaySet);
                if (iDisplaySet2 != null) {
                    this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
                    continue;
                }
                this.runtimeContainer.removeDisplaySet(iDisplaySet, changeSet);
            }
            DataManager.getInstance().applySplitAndSortChange(changeSet);
        }
    }

    @Override
    public void setStudyExpanded(IStudyData iStudyData) {
        if (this.isStudyCollapsed(iStudyData)) {
            List<IDisplaySet> list;
            if (!this.isStudyLoaded(iStudyData)) {
                this.loadStudy(iStudyData);
            }
            if ((list = this.defaultContainer.getDisplaySetsOfStudy(iStudyData)) != null) {
                DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet(SplitAndSortChangeType.KEY_IMAGE_EXPANSION_TOGGLE);
                for (IDisplaySet iDisplaySet : list) {
                    IDisplaySet iDisplaySet2 = this.runtimeContainer.getRelatedDisplaySet(iDisplaySet);
                    if (iDisplaySet2 != null) {
                        this.runtimeContainer.replaceDisplaySet(iDisplaySet2, iDisplaySet, changeSet);
                        continue;
                    }
                    this.runtimeContainer.addDisplaySets(Collections.singletonList(iDisplaySet), changeSet);
                }
                DataManager.getInstance().applySplitAndSortChange(changeSet);
            }
        }
    }

    @Override
    public void setDisplaySetCollapsed(IDisplaySet iDisplaySet) {
        IDisplaySet iDisplaySet2;
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet) && !this.isDisplaySetCollapsed(iDisplaySet) && (iDisplaySet2 = this.koContainer.getRelatedDisplaySet(iDisplaySet)) != null) {
            DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet(SplitAndSortChangeType.KEY_IMAGE_EXPANSION_TOGGLE);
            this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
            DataManager.getInstance().applySplitAndSortChange(changeSet);
        }
    }

    @Override
    public void setDisplaySetExpanded(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet) && this.isDisplaySetCollapsed(iDisplaySet)) {
            IDisplaySet iDisplaySet2;
            IStudyData iStudyData = iDisplaySet.getStudy();
            if (iStudyData != null && !this.isStudyLoaded(iStudyData)) {
                this.loadStudy(iStudyData);
            }
            if ((iDisplaySet2 = this.defaultContainer.getRelatedDisplaySet(iDisplaySet)) != null) {
                DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet(SplitAndSortChangeType.KEY_IMAGE_EXPANSION_TOGGLE);
                this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
                DataManager.getInstance().applySplitAndSortChange(changeSet);
            }
        }
    }

    private synchronized void populateContainers(List<IFrameObjectData[]> list, IDisplaySet iDisplaySet, DisplaySetContainer.ChangeSet changeSet, Collection<String> collection) {
        this.populateContainers(list, iDisplaySet, changeSet, null, collection);
    }

    private synchronized void populateContainers(List<IFrameObjectData[]> list, IDisplaySet iDisplaySet, DisplaySetContainer.ChangeSet changeSet, Map<String, DisplaySetComparator> map, Collection<String> collection) {
        if (list.isEmpty()) {
            return;
        }
        if (iDisplaySet != null && list.size() > 1) {
            throw new UnsupportedOperationException();
        }
        boolean bl = DataManager.getInstance().isPreferablyLoadKeyImagesEnabled();
        boolean bl2 = false;
        boolean bl3 = false;
        for (IStudyData iStudyData2 : this.getPatientRepresentation().getPatientData().getStudies()) {
            if (!iStudyData2.getKeyImageManager().hasKeyImages()) continue;
            bl3 = true;
            break;
        }
        boolean bl4 = iDisplaySet == null;
        Object object2 = null;
        ArrayList<Object> arrayList = null;
        boolean bl5 = false;
        ArrayList<IDisplaySet> arrayList2 = new ArrayList<IDisplaySet>(list.size());
        ArrayList<IDisplaySet> arrayList3 = new ArrayList<IDisplaySet>(list.size());
        List<FrameContainer> list2 = Utils4D.handle4DMerge(list, collection);
        for (FrameContainer frameContainer : list2) {
            if (frameContainer == null) continue;
            bl2 = false;
            arrayList = null;
            if (bl3) {
                for (Object object : frameContainer) {
                    if (object.getKeyImageInfo().isMarked()) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>(32);
                        }
                        arrayList.add(object);
                        bl5 = true;
                    }
                    if (bl2 || object.getMainFrame().getFrameCount() <= 1) continue;
                    bl2 = true;
                }
            }
            if (bl4) {
                iDisplaySet = HangingFactory.getInstance().newDisplaySet(frameContainer, this);
            }
            object2 = null;
            if (arrayList != null) {
                if (arrayList.size() == frameContainer.size()) {
                    Object object;
                    object2 = iDisplaySet;
                    this.koContainer.addDisplaySets(Collections.singletonList(iDisplaySet), map, null);
                    object = HangingFactory.getInstance().newDisplaySet(frameContainer, this);
                    this.defaultContainer.addDisplaySets(Collections.singletonList(object), map, null);
                } else {
                    object2 = HangingFactory.getInstance().newDisplaySet(new FrameContainer((Collection<IFrameObjectData>)arrayList), this);
                    this.koContainer.addDisplaySets(Collections.singletonList(object2), map, null);
                }
            }
            if (arrayList == null || arrayList.size() != frameContainer.size()) {
                arrayList2.add(iDisplaySet);
            }
            if (this.loading) continue;
            if (bl && bl2 && object2 != null && arrayList != null && arrayList.size() != frameContainer.size()) {
                arrayList3.add((IDisplaySet)object2);
                continue;
            }
            arrayList3.add(iDisplaySet);
        }
        if (bl5) {
            HashMap<IStudyData, List> hashMap = new HashMap<IStudyData, List>(3);
            for (IDisplaySet iDisplaySet2 : this.koContainer.getDisplaySets()) {
                CollectionUtils.addAll((Collection)hashMap.computeIfAbsent(iDisplaySet2.getStudy(), iStudyData -> new ArrayList()), (Object[])iDisplaySet2.getObjects());
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                IDisplaySet iDisplaySet3 = HangingFactory.getInstance().newDisplaySet(new FrameContainer((Collection)entry.getValue()), this);
                iDisplaySet3.getDisplaySetType();
                this.koDisplaySetsPerStudy.put(((IStudyData)entry.getKey()).getKey(), iDisplaySet3);
            }
        }
        if (!arrayList2.isEmpty()) {
            this.defaultContainer.addDisplaySets(arrayList2, map, changeSet);
        }
        if (!arrayList3.isEmpty()) {
            this.runtimeContainer.addDisplaySets(arrayList3, map, changeSet);
        }
    }

    private void loadStudy(IStudyData iStudyData) {
        try {
            this.loading = true;
            DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getRetriever().loadCompleteStudy(iStudyData);
        }
        finally {
            this.loading = false;
        }
    }

    private boolean isStudyLoaded(IStudyData iStudyData) {
        return iStudyData.getNumberOfLoadedImages() >= iStudyData.getNumberOfAvailableImages();
    }
}

