/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSetItem;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.IDisplaySetContainer;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

class DisplaySetContainer
implements IDisplaySetContainer {
    private IDisplaySet[] displaySets;
    private Set<String> studies = new HashSet<String>();
    private final boolean trackable;
    private ISplitAndSortRuntime sasRuntime;

    private DisplaySetContainer(ISplitAndSortRuntime iSplitAndSortRuntime, boolean bl) {
        this.trackable = bl;
        this.sasRuntime = iSplitAndSortRuntime;
    }

    public ChangeSet createNewChangeSet(SplitAndSortChangeType splitAndSortChangeType) {
        if (this.trackable) {
            return new ChangeSet(this.sasRuntime, splitAndSortChangeType);
        }
        return null;
    }

    static DisplaySetContainer createRuntimeInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, true);
    }

    static DisplaySetContainer createDefaultInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, false);
    }

    static DisplaySetContainer createKeyImageInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, false);
    }

    public List<String> getStudyOrdering() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (IDisplaySet iDisplaySet : this.getDisplaySets()) {
            if (string.equals(iDisplaySet.getStudyUID())) continue;
            string = iDisplaySet.getStudyUID();
            arrayList.add(string);
        }
        return arrayList;
    }

    void addDisplaySets(List<IDisplaySet> list, ChangeSet changeSet) {
        this.addDisplaySets(list, null, changeSet);
    }

    /*
     * WARNING - void declaration
     */
    void addDisplaySets(List<IDisplaySet> list, Map<String, DisplaySetComparator> map, ChangeSet changeSet) {
        void var5_13;
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(list.size());
        for (IDisplaySet iDisplaySet : list) {
            if (iDisplaySet == null) continue;
            IDisplaySet iDisplaySet2 = this.getContainedDisplaySet(iDisplaySet);
            if (iDisplaySet2 != null) {
                if (iDisplaySet2.getID() == iDisplaySet.getID()) continue;
                this.replaceDisplaySet(iDisplaySet2, iDisplaySet, changeSet);
                continue;
            }
            arrayList.add(iDisplaySet);
            if (changeSet == null || !this.trackable) continue;
            changeSet.addItem(SplitAndSortChangeSetItem.createAddInstance(iDisplaySet));
        }
        if (this.displaySets == null) {
            IDisplaySet[] iDisplaySetArray = arrayList.toArray(new IDisplaySet[arrayList.size()]);
        } else {
            void var6_7;
            IDisplaySet[] iDisplaySetArray = Arrays.copyOf(this.displaySets, this.displaySets.length + arrayList.size());
            boolean n = false;
            while (var6_7 < arrayList.size()) {
                iDisplaySetArray[var6_7 + this.displaySets.length] = (IDisplaySet)arrayList.get((int)var6_7);
                ++var6_7;
            }
        }
        for (IDisplaySet iDisplaySet : arrayList) {
            this.studies.add(iDisplaySet.getStudyUID());
        }
        Arrays.sort(var5_13, new CrossStudyDisplaySetComparator(map));
        this.displaySets = var5_13;
    }

    private IDisplaySet getContainedDisplaySet(IDisplaySet iDisplaySet) {
        IDisplaySet iDisplaySet2 = this.getDisplaySetForId(iDisplaySet.getID());
        if (iDisplaySet2 == null) {
            iDisplaySet2 = this.getRelatedDisplaySet(iDisplaySet);
        }
        return iDisplaySet2;
    }

    boolean replaceDisplaySet(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2, ChangeSet changeSet) {
        int n;
        if (iDisplaySet != null && iDisplaySet2 != null && iDisplaySet != iDisplaySet2 && (n = ArrayUtils.indexOf((Object[])this.displaySets, (Object)iDisplaySet)) >= 0) {
            this.displaySets[n] = iDisplaySet2;
            if (changeSet != null && this.trackable) {
                changeSet.addItem(SplitAndSortChangeSetItem.createChangeInstance(iDisplaySet, iDisplaySet2));
            }
            return true;
        }
        return false;
    }

    boolean removeRelatedDisplaySet(IDisplaySet iDisplaySet) {
        IDisplaySet iDisplaySet2 = this.getContainedDisplaySet(iDisplaySet);
        return iDisplaySet2 != null && this.removeDisplaySet(iDisplaySet2, null);
    }

    boolean removeDisplaySet(IDisplaySet iDisplaySet, ChangeSet changeSet) {
        if (this.displaySets != null) {
            int n = ArrayUtils.indexOf((Object[])this.displaySets, (Object)iDisplaySet);
            if (n < 0) {
                return false;
            }
            this.displaySets = (IDisplaySet[])ArrayUtils.remove((Object[])this.displaySets, (int)n);
            if (changeSet != null && this.trackable) {
                changeSet.addItem(SplitAndSortChangeSetItem.createRemoveInstance(iDisplaySet));
            }
            HashSet<String> hashSet = new HashSet<String>();
            IDisplaySet[] iDisplaySetArray = this.displaySets;
            int n2 = this.displaySets.length;
            int n3 = 0;
            while (n3 < n2) {
                IDisplaySet iDisplaySet2 = iDisplaySetArray[n3];
                hashSet.add(iDisplaySet2.getStudyUID());
                ++n3;
            }
            this.studies = hashSet;
            return true;
        }
        return false;
    }

    boolean containsDisplaySet(IDisplaySet iDisplaySet) {
        return ArrayUtils.contains((Object[])this.displaySets, (Object)iDisplaySet);
    }

    boolean containsDisplaySetOfStudy(IStudyData iStudyData) {
        return this.studies.contains(iStudyData.getStudyInstanceUID());
    }

    List<IDisplaySet> getDisplaySetsOfStudy(IStudyData iStudyData) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        if (this.displaySets != null) {
            IDisplaySet[] iDisplaySetArray = this.displaySets;
            int n = this.displaySets.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplaySet iDisplaySet = iDisplaySetArray[n2];
                if (iStudyData.getKey().equals(iDisplaySet.getStudyUID())) {
                    arrayList.add(iDisplaySet);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    Stream<IDisplaySet> streamDisplaySetsOfStudy(IStudyData iStudyData) {
        String string = iStudyData.getStudyInstanceUID();
        if (!this.studies.contains(string)) {
            return Stream.empty();
        }
        return Arrays.stream(this.displaySets).filter(iDisplaySet -> iStudyData.getKey().equals(iDisplaySet.getStudyUID()));
    }

    public List<IDisplaySet> getDisplaySets() {
        if (this.displaySets != null) {
            return Arrays.asList(this.displaySets);
        }
        return Collections.emptyList();
    }

    @Override
    public IDisplaySet getDisplaySetAt(int n) {
        return this.displaySets != null ? this.displaySets[n] : null;
    }

    int getIndexOfDisplaySet(IDisplaySet iDisplaySet) {
        return ArrayUtils.indexOf((Object[])this.displaySets, (Object)iDisplaySet);
    }

    @Override
    public int getDisplaySetCount() {
        return this.displaySets != null ? this.displaySets.length : 0;
    }

    IDisplaySet getDisplaySetForId(int n) {
        if (this.displaySets != null) {
            IDisplaySet[] iDisplaySetArray = this.displaySets;
            int n2 = this.displaySets.length;
            int n3 = 0;
            while (n3 < n2) {
                IDisplaySet iDisplaySet = iDisplaySetArray[n3];
                if (n == iDisplaySet.getID()) {
                    return iDisplaySet;
                }
                ++n3;
            }
        }
        return null;
    }

    static class ChangeSet
    extends SplitAndSortChangeSet {
        private ChangeSet(ISplitAndSortRuntime iSplitAndSortRuntime, SplitAndSortChangeType splitAndSortChangeType) {
            super(iSplitAndSortRuntime, splitAndSortChangeType, null);
        }

        private void addItem(SplitAndSortChangeSetItem splitAndSortChangeSetItem) {
            this.addItem(this.items != null ? this.items.size() : 0, splitAndSortChangeSetItem);
        }

        private void addItem(int n, SplitAndSortChangeSetItem splitAndSortChangeSetItem) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(n, splitAndSortChangeSetItem);
        }
    }
}

