/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IFrameContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.Utils4D;
import com.tiani.base.data.IFrameObjectData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FrameContainer
implements IFrameContainer {
    private static final Set<String> enhancedSOPClasses = new HashSet<String>(Arrays.asList("1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.4.1", "1.2.840.10008.5.1.4.1.1.130"));
    private static boolean handleEnhanced4DSeries = Config.impaxee.jvision.SORTSPLIT.handleEnhanced4DSeries.get();
    private static boolean handleNormal4DSeries = Config.impaxee.jvision.SORTSPLIT.handleNormal4DSeries.get();
    private IFrameObjectData[][] frames;
    private Utils4D.SplitBy type = null;

    public FrameContainer(IFrameObjectData[] iFrameObjectDataArray) {
        if (Config.impaxee.jvision.SEQPANEL.D4Support.get() && this.checkOn4D(iFrameObjectDataArray)) {
            this.frames = this.splitOn4D(iFrameObjectDataArray);
            if (this.frames.length == iFrameObjectDataArray.length || this.frames.length == 1) {
                this.frames = new IFrameObjectData[][]{iFrameObjectDataArray};
                this.type = null;
            }
        } else {
            this.frames = new IFrameObjectData[][]{iFrameObjectDataArray};
        }
    }

    private IFrameObjectData[][] splitOn4D(IFrameObjectData[] iFrameObjectDataArray) {
        if (this.type == Utils4D.SplitBy.TEMPORAL_INDEX) {
            return Utils4D.splitSortSeriesByTemporalIndex(iFrameObjectDataArray);
        }
        if (this.type == Utils4D.SplitBy.IN_SERIES_BY_SPACE) {
            return Utils4D.splitSeriesInSpace(iFrameObjectDataArray);
        }
        if (this.type == Utils4D.SplitBy.IN_SERIES_BY_TIME) {
            return Utils4D.splitSeriesInTime(iFrameObjectDataArray);
        }
        return new IFrameObjectData[][]{iFrameObjectDataArray};
    }

    private boolean checkOn4D(IFrameObjectData[] iFrameObjectDataArray) {
        if (iFrameObjectDataArray.length > 0 && enhancedSOPClasses.contains(iFrameObjectDataArray[0].getSOPClassUID()) && handleEnhanced4DSeries) {
            IntHashSet intHashSet = new IntHashSet();
            IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
                intHashSet.add(iFrameObjectData.getImageInformation().getTemporalPosition());
                if (intHashSet.size() > 1) {
                    this.type = Utils4D.SplitBy.TEMPORAL_INDEX;
                    return true;
                }
                ++n2;
            }
        } else if (iFrameObjectDataArray.length > 50 && handleNormal4DSeries) {
            this.type = Utils4D.fast4DSplitDetector(iFrameObjectDataArray);
            return this.type != null;
        }
        return false;
    }

    public FrameContainer(Collection<IFrameObjectData> collection) {
        this.frames = new IFrameObjectData[1][];
        this.frames[0] = collection.toArray(new IFrameObjectData[collection.size()]);
    }

    public FrameContainer(List<IFrameObjectData[]> list, Utils4D.SplitBy splitBy) {
        this.type = splitBy;
        this.frames = new IFrameObjectData[list.size()][];
        int n = 0;
        for (IFrameObjectData[] iFrameObjectDataArray : list) {
            this.frames[n] = iFrameObjectDataArray;
            ++n;
        }
    }

    @Override
    public IFrameObjectData[][] getFrames() {
        return this.frames;
    }

    @Override
    public boolean isPrimaryNavigationInSpace() {
        return this.type != Utils4D.SplitBy.IN_SERIES_BY_TIME;
    }

    @Override
    public Iterator<IFrameObjectData> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<IFrameObjectData> {
        private int x = 0;
        private int y = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return FrameContainer.this.frames.length > this.y && FrameContainer.this.frames[this.y].length > this.x;
        }

        @Override
        public IFrameObjectData next() {
            IFrameObjectData iFrameObjectData = FrameContainer.this.frames[this.y][this.x];
            ++this.x;
            if (this.x >= FrameContainer.this.frames[this.y].length) {
                this.x = 0;
                ++this.y;
            }
            return iFrameObjectData;
        }
    }
}

