/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.FrameObjectDataComparator;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractSplitSortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.impaxee.splitsort.runtime.FrameContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.Pre4DSorter;
import com.agfa.pacs.impaxee.splitsort.runtime.SortableDisplaySet;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.util.expressions.BooleanExpression;
import com.tiani.util.expressions.IEvaluableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.dcm4che3.data.Attributes;

public class Utils4D {
    private static final ALogger LOGGER = ALogger.getLogger(Utils4D.class);
    private static final double MAX_4D_EPSILON = 0.1;
    private static final double MAX_4D_ORIENTATION_EPSILON = 0.001;
    private static final Set<String> MODALITIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CT", "MR", "PT")));
    private static BooleanExpression condition4DMerge = new BooleanExpression(Config.impaxee.jvision.SORTSPLIT.merge4DCondition.get());
    private static boolean mergeDiffusionSeries = Config.impaxee.jvision.SORTSPLIT.mergeDiffusionImages.get();
    private static boolean mergeOtherSeries = Config.impaxee.jvision.SORTSPLIT.mergeOtherImages.get();

    private static boolean matchIn4D(IFrameObjectData[] iFrameObjectDataArray, IFrameObjectData[] iFrameObjectDataArray2) {
        if (iFrameObjectDataArray.length == iFrameObjectDataArray2.length) {
            IImageInformation iImageInformation = iFrameObjectDataArray[0].getImageInformation();
            IImageInformation iImageInformation2 = iFrameObjectDataArray2[0].getImageInformation();
            if (iImageInformation.getImageClass() == iImageInformation2.getImageClass() && Objects.equals(iImageInformation.getFrameOfReferenceUID(), iImageInformation2.getFrameOfReferenceUID())) {
                double[] dArray;
                double[] dArray2;
                Point3d point3d = iImageInformation.getPointOrigin();
                Point3d point3d2 = iImageInformation2.getPointOrigin();
                if (point3d != null && point3d2 != null && point3d.epsilonEquals((Tuple3d)point3d2, 0.1) && Utils4D.almostEqual(dArray2 = iImageInformation.getImageOrientation(), dArray = iImageInformation2.getImageOrientation(), 0.001)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean almostEqual(double[] dArray, double[] dArray2, double d) {
        if (dArray == null || dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            if (Math.abs(dArray[n] - dArray2[n]) > d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static SplitBy fast4DSplitDetector(IFrameObjectData[] iFrameObjectDataArray) {
        if (!MODALITIES.contains(iFrameObjectDataArray[0].getModality())) {
            return null;
        }
        IFrameObjectData iFrameObjectData = iFrameObjectDataArray[1];
        IFrameObjectData iFrameObjectData2 = iFrameObjectDataArray[2];
        IFrameObjectData iFrameObjectData3 = iFrameObjectDataArray[iFrameObjectDataArray.length - 2];
        if (iFrameObjectData.getImageInformation().getImageClass() == IImageInformation.ImageClass.MR) {
            int n = iFrameObjectData.getImageInformation().getDataset().getInt(2097413, 1);
            int n2 = iFrameObjectData.getImageInformation().getTemporalPosition();
            int n3 = iFrameObjectData2.getImageInformation().getTemporalPosition();
            int n4 = iFrameObjectData3.getImageInformation().getTemporalPosition();
            if (n > 1 && n2 > 0 && n3 > 0 && n4 > 1) {
                return SplitBy.TEMPORAL_INDEX;
            }
        }
        Point3d point3d = iFrameObjectData.getImageInformation().getPointOrigin();
        Point3d point3d2 = iFrameObjectData2.getImageInformation().getPointOrigin();
        Point3d point3d3 = iFrameObjectData3.getImageInformation().getPointOrigin();
        if (point3d == null || point3d2 == null || point3d3 == null) {
            return null;
        }
        if (point3d.epsilonEquals((Tuple3d)point3d2, 0.1)) {
            return SplitBy.IN_SERIES_BY_TIME;
        }
        if (point3d.distance(point3d2) * (double)iFrameObjectDataArray.length > 1.8 * point3d.distance(point3d3)) {
            return SplitBy.IN_SERIES_BY_SPACE;
        }
        return null;
    }

    private static boolean shouldMergeSeriesTo4D(List<IFrameObjectData[]> list) {
        IFrameObjectData iFrameObjectData = list.get(0)[0];
        if (iFrameObjectData.getImageInformation().getImageClass() == IImageInformation.ImageClass.MR && mergeDiffusionSeries) {
            IFrameObjectData[] iFrameObjectDataArray3 = new HashSet();
            for (IFrameObjectData[] iFrameObjectDataArray4 : list) {
                Set<ImageType> set;
                if (iFrameObjectDataArray4[0].getImageInformation().getDiffusionBValue() != null) {
                    iFrameObjectDataArray3.add(iFrameObjectDataArray4[0].getImageInformation().getDiffusionBValue());
                }
                if ((set = iFrameObjectDataArray4[0].getImageInformation().getImageType()).contains(ImageType.EADC) || set.contains(ImageType.ADC)) break;
            }
            if (iFrameObjectDataArray3.size() == list.size()) {
                list.sort((iFrameObjectDataArray, iFrameObjectDataArray2) -> Double.compare(iFrameObjectDataArray[0].getImageInformation().getDiffusionBValue(), iFrameObjectDataArray2[0].getImageInformation().getDiffusionBValue()));
                return true;
            }
        }
        if (mergeOtherSeries) {
            for (IFrameObjectData[] iFrameObjectDataArray3 : list) {
                if (condition4DMerge.evaluate(new DS4DEvaluable(iFrameObjectDataArray3[0], list.size()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<FrameContainer> handle4DMerge(List<IFrameObjectData[]> list, Collection<String> collection) {
        collection.retainAll(MODALITIES);
        if (!(Config.impaxee.jvision.SEQPANEL.D4Support.get() && (mergeOtherSeries && !collection.isEmpty() || mergeDiffusionSeries && collection.contains("MR")))) {
            ArrayList<FrameContainer> arrayList = new ArrayList<FrameContainer>(list.size());
            for (IFrameObjectData[] iFrameObjectDataArray : list) {
                arrayList.add(new FrameContainer(iFrameObjectDataArray));
            }
            return arrayList;
        }
        Collections.sort(list, new Pre4DSorter());
        ArrayList<FrameContainer> arrayList = new ArrayList<FrameContainer>();
        IFrameObjectData[] iFrameObjectDataArray = null;
        ArrayList<IFrameObjectData[]> arrayList2 = new ArrayList<IFrameObjectData[]>();
        for (IFrameObjectData[] iFrameObjectDataArray2 : list) {
            IImageInformation.ImageClass imageClass = iFrameObjectDataArray2[0].getImageInformation().getImageClass();
            if ((imageClass == IImageInformation.ImageClass.CT || imageClass == IImageInformation.ImageClass.MR || imageClass == IImageInformation.ImageClass.PT) && iFrameObjectDataArray2.length > 5) {
                if (iFrameObjectDataArray != null && Utils4D.matchIn4D(iFrameObjectDataArray2, iFrameObjectDataArray)) {
                    arrayList2.add(iFrameObjectDataArray2);
                    continue;
                }
                Utils4D.processMergedSeries(iFrameObjectDataArray, arrayList2, arrayList);
                arrayList2.clear();
                iFrameObjectDataArray = iFrameObjectDataArray2;
                continue;
            }
            Utils4D.processMergedSeries(iFrameObjectDataArray, arrayList2, arrayList);
            arrayList2.clear();
            iFrameObjectDataArray = null;
            arrayList.add(new FrameContainer(iFrameObjectDataArray2));
        }
        Utils4D.processMergedSeries(iFrameObjectDataArray, arrayList2, arrayList);
        return arrayList;
    }

    private static void processMergedSeries(IFrameObjectData[] iFrameObjectDataArray, List<IFrameObjectData[]> list, List<FrameContainer> list2) {
        if (list.isEmpty()) {
            if (iFrameObjectDataArray != null) {
                list2.add(new FrameContainer(iFrameObjectDataArray));
            }
            return;
        }
        if (iFrameObjectDataArray != null) {
            list.add(0, iFrameObjectDataArray);
        }
        while (list.size() > 1) {
            list = Utils4D.tryToMergeSeries(list, list2);
        }
        if (list.size() == 1) {
            list2.add(new FrameContainer(list.get(0)));
        }
    }

    private static List<IFrameObjectData[]> tryToMergeSeries(List<IFrameObjectData[]> list, List<FrameContainer> list2) {
        ArrayList<IFrameObjectData[]> arrayList = new ArrayList<IFrameObjectData[]>();
        while (list.size() >= 2) {
            if (Utils4D.shouldMergeSeriesTo4D(list)) {
                list.sort(new ComparatorAdapter(new CrossStudyDisplaySetComparator()));
                list2.add(new FrameContainer(list, SplitBy.MERGED));
                break;
            }
            arrayList.add(0, list.remove(list.size() - 1));
        }
        if (list.size() == 1) {
            list2.add(new FrameContainer(list.get(0)));
        }
        return arrayList;
    }

    public static IFrameObjectData[][] splitSeriesInTime(IFrameObjectData[] iFrameObjectDataArray) {
        Point3d point3d;
        Point3d point3d2 = iFrameObjectDataArray[0].getImageInformation().getPointOrigin();
        int n = 0;
        do {
            point3d = iFrameObjectDataArray[++n].getImageInformation().getPointOrigin();
        } while (point3d2 != null && point3d != null && point3d2.epsilonEquals((Tuple3d)point3d, 0.1) && n < iFrameObjectDataArray.length - 1);
        if (n == iFrameObjectDataArray.length - 1 || point3d2 == null || point3d == null) {
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        int n2 = n;
        if (iFrameObjectDataArray.length % n2 != 0) {
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        int n3 = iFrameObjectDataArray.length / n2;
        IFrameObjectData[][] iFrameObjectDataArray2 = new IFrameObjectData[n2][];
        int n4 = 0;
        while (n4 < n2) {
            iFrameObjectDataArray2[n4] = new IFrameObjectData[n3];
            ++n4;
        }
        n = 0;
        Point3d point3d3 = null;
        try {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = 0;
                while (n6 < n2) {
                    iFrameObjectDataArray2[n6][n5] = iFrameObjectDataArray[n];
                    if (n6 == 0) {
                        point3d3 = iFrameObjectDataArray[n].getImageInformation().getPointOrigin();
                    } else if (point3d3 == null || !point3d3.epsilonEquals((Tuple3d)iFrameObjectDataArray[n].getImageInformation().getPointOrigin(), 0.1)) {
                        LOGGER.warn("Position mismatch in 4D series:{}", (Object)iFrameObjectDataArray[0].getParent().getSeriesInstanceUID());
                        return Utils4D.packFrameArray(iFrameObjectDataArray);
                    }
                    ++n;
                    ++n6;
                }
                ++n5;
            }
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.debug("Not all have 3D position", (Throwable)nullPointerException);
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        return iFrameObjectDataArray2;
    }

    public static IFrameObjectData[][] splitSortSeriesByTemporalIndex(IFrameObjectData[] iFrameObjectDataArray3) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        IFrameObjectData[] iFrameObjectDataArray4 = iFrameObjectDataArray3;
        int n = iFrameObjectDataArray3.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = iFrameObjectDataArray4[n2];
            hashMap.putIfAbsent(object2.getImageInformation().getTemporalPosition(), new ArrayList());
            object = (List)hashMap.get(object2.getImageInformation().getTemporalPosition());
            object.add(object2);
            ++n2;
        }
        object2 = new IFrameObjectData[hashMap.size()][];
        n2 = 0;
        for (List list : hashMap.values()) {
            object = new SortField();
            ((AbstractSplitSortField)((Object)object)).setTag(2097171);
            ((SortField)((Object)object)).setIsDescending(false);
            SortField sortField = new SortField();
            sortField.setTag(-65535);
            sortField.setIsDescending(false);
            Collections.sort(list, new FrameObjectDataComparator(Arrays.asList(object, sortField)));
            object2[n2] = list.toArray(new IFrameObjectData[list.size()]);
            ++n2;
        }
        Arrays.sort(object2, (iFrameObjectDataArray, iFrameObjectDataArray2) -> Integer.compare(iFrameObjectDataArray[0].getImageInformation().getTemporalPosition(), iFrameObjectDataArray2[0].getImageInformation().getTemporalPosition()));
        return object2;
    }

    public static IFrameObjectData[][] splitSeriesInSpace(IFrameObjectData[] iFrameObjectDataArray) {
        Point3d point3d;
        Point3d point3d2 = iFrameObjectDataArray[0].getImageInformation().getPointOrigin();
        int n = 0;
        do {
            point3d = iFrameObjectDataArray[++n].getImageInformation().getPointOrigin();
        } while (point3d2 != null && point3d != null && !point3d2.epsilonEquals((Tuple3d)point3d, 0.1) && n < iFrameObjectDataArray.length - 1);
        if (n == iFrameObjectDataArray.length - 1 || point3d2 == null || point3d == null) {
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        int n2 = n;
        if (iFrameObjectDataArray.length % n2 != 0) {
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        int n3 = iFrameObjectDataArray.length / n2;
        IFrameObjectData[][] iFrameObjectDataArray2 = new IFrameObjectData[n3][];
        n = 0;
        Point3d[] point3dArray = new Point3d[n2];
        try {
            int n4 = 0;
            while (n4 < n3) {
                iFrameObjectDataArray2[n4] = new IFrameObjectData[n2];
                int n5 = 0;
                while (n5 < n2) {
                    iFrameObjectDataArray2[n4][n5] = iFrameObjectDataArray[n];
                    if (n4 == 0) {
                        point3dArray[n5] = iFrameObjectDataArray[n].getImageInformation().getPointOrigin();
                    } else if (!point3dArray[n5].epsilonEquals((Tuple3d)iFrameObjectDataArray[n].getImageInformation().getPointOrigin(), 0.1)) {
                        LOGGER.warn("Position mismatch in 4D series:{}", (Object)iFrameObjectDataArray[0].getParent().getSeriesInstanceUID());
                        return Utils4D.packFrameArray(iFrameObjectDataArray);
                    }
                    ++n;
                    ++n5;
                }
                ++n4;
            }
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.debug("Not all have 3D position", (Throwable)nullPointerException);
            return Utils4D.packFrameArray(iFrameObjectDataArray);
        }
        return iFrameObjectDataArray2;
    }

    private static IFrameObjectData[][] packFrameArray(IFrameObjectData[] iFrameObjectDataArray) {
        return new IFrameObjectData[][]{iFrameObjectDataArray};
    }

    private static class ComparatorAdapter
    implements Comparator<IFrameObjectData[]> {
        private Comparator<IDisplaySet> comparator;

        public ComparatorAdapter(Comparator<IDisplaySet> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(IFrameObjectData[] iFrameObjectDataArray, IFrameObjectData[] iFrameObjectDataArray2) {
            return this.comparator.compare(new SortableDisplaySet(iFrameObjectDataArray), new SortableDisplaySet(iFrameObjectDataArray2));
        }
    }

    private static class DS4DEvaluable
    implements IEvaluableData {
        private final IFrameObjectData frame;
        private final int runs;

        public DS4DEvaluable(IFrameObjectData iFrameObjectData, int n) {
            this.frame = iFrameObjectData;
            this.runs = n;
        }

        @Override
        public String resolveString(int n) {
            if (n == -65521) {
                return Integer.toString(this.runs);
            }
            return this.frame.resolveString(n);
        }

        @Override
        public String[] resolveStrings(int n) {
            return this.frame.resolveStrings(n);
        }

        @Override
        public Attributes resolveStringEnhanced(int[] nArray, int n) {
            return this.frame.resolveStringEnhanced(nArray, n);
        }
    }

    public static enum SplitBy {
        TEMPORAL_INDEX,
        IN_SERIES_BY_TIME,
        IN_SERIES_BY_SPACE,
        MERGED;

    }
}

