/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.statistics;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;

public final class StatisticsChartDataPoint<T extends IImageInformationProvider>
implements Comparable<StatisticsChartDataPoint<T>> {
    private static final ALogger log = ALogger.getLogger(StatisticsChartDataPoint.class);
    private static final long[] POSSIBLE_DATE_TIME_TAGS = new long[]{2251945843097650L, 2251950138064947L};
    private static final AtomicInteger ID_PROVIDER = new AtomicInteger(0);
    private final T data;
    private final long acquisitionDateTime;
    private final int id;

    private StatisticsChartDataPoint(T t, long l) {
        this.data = t;
        this.acquisitionDateTime = l;
        this.id = ID_PROVIDER.incrementAndGet();
    }

    static <T extends IImageInformationProvider> List<StatisticsChartDataPoint<T>> create(List<T> list) {
        ArrayList<StatisticsChartDataPoint<T>> arrayList = new ArrayList<StatisticsChartDataPoint<T>>(list.size());
        Long l = null;
        int n = 0;
        while (n < list.size()) {
            Date date;
            IImageInformationProvider iImageInformationProvider = (IImageInformationProvider)list.get(n);
            IImageInformation iImageInformation = iImageInformationProvider.getImageInformation();
            if (l == null) {
                l = StatisticsChartDataPoint.getDateTimeTag(iImageInformation.getDataset());
            }
            if ((date = StatisticsChartDataPoint.getDateTime(iImageInformation.getDataset(), l)) == null) {
                log.warn("Skipping image without date/time information: " + iImageInformation.getSeriesInstanceUID());
            } else {
                long l2 = date.getTime();
                arrayList.add(new StatisticsChartDataPoint<IImageInformationProvider>(iImageInformationProvider, l2));
            }
            ++n;
        }
        return arrayList;
    }

    public static <T extends IImageInformationProvider> List<StatisticsChartDataPoint<T>> createSortedList(List<T> list) {
        List<StatisticsChartDataPoint<T>> list2 = StatisticsChartDataPoint.create(list);
        Collections.sort(list2);
        return list2;
    }

    private static Long getDateTimeTag(Attributes attributes) {
        long[] lArray = POSSIBLE_DATE_TIME_TAGS;
        int n = POSSIBLE_DATE_TIME_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            Date date = attributes.getDate(l);
            if (date != null) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    private static Date getDateTime(Attributes attributes, Long l) {
        if (l == null) {
            return null;
        }
        return attributes.getDate(l.longValue());
    }

    public T getData() {
        return this.data;
    }

    long getAcquisitionDateTime() {
        return this.acquisitionDateTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticsChartDataPoint)) {
            return false;
        }
        return this.id == ((StatisticsChartDataPoint)object).id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(StatisticsChartDataPoint<T> statisticsChartDataPoint) {
        if (this.acquisitionDateTime < statisticsChartDataPoint.acquisitionDateTime) {
            return -1;
        }
        if (this.acquisitionDateTime > statisticsChartDataPoint.acquisitionDateTime) {
            return 1;
        }
        return Integer.compare(this.id, statisticsChartDataPoint.id);
    }
}

