/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.statistics;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.statistics.ChartDataPoint;
import com.agfa.pacs.impaxee.statistics.ChartSeriesData;
import com.agfa.pacs.impaxee.statistics.StatisticsChart;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class StatisticsTable {
    private static int HORIZONTAL_PADDING = 46;
    private static int VERTICAL_PADDING = 16;
    private final ChartSeriesData chartSeriesData;
    private String[] headers;
    private Graphics2D g2;
    private double[] maxColumnWidths;
    private double maxRowHeight = 0.0;
    private String[][] tableContent;
    private double tableWidth;
    private int maxSubTableHeight;
    private int maxDataRowsPerTable;
    private int numberOfTables;
    private int currentTableNumber = 1;
    private int rowIndex = 0;
    private List<BufferedImage> bufferedImages;

    StatisticsTable(ChartSeriesData chartSeriesData, int n, int n2) {
        this.chartSeriesData = chartSeriesData;
        this.maxSubTableHeight = n2;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        this.g2 = bufferedImage.createGraphics();
        this.init();
        int n3 = 0;
        while (n3 < this.numberOfTables) {
            this.paintComponent(new BufferedImage(n, n2, 1));
            ++n3;
        }
    }

    private void paintComponent(BufferedImage bufferedImage) {
        this.g2 = bufferedImage.createGraphics();
        this.createTable();
        this.bufferedImages.add(bufferedImage);
    }

    protected List<BufferedImage> getBufferdImages() {
        return this.bufferedImages;
    }

    private void initHeaders() {
        String string = this.chartSeriesData.getYUnit();
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = StatisticsChart.formatYUnit("Unit");
        }
        this.headers = new String[]{"Ser. No.", "sec", Messages.getString("StatisticsChart.AcquisitionTime"), string, StatisticsChart.RELATIVE_Y_AXIS_UNIT};
    }

    private void init() {
        this.initHeaders();
        this.bufferedImages = new ArrayList<BufferedImage>();
        int n = this.headers.length;
        this.maxColumnWidths = new double[n];
        this.tableContent = new String[n][this.chartSeriesData.getChartData().size()];
        Font font = this.g2.getFont().deriveFont(16.0f);
        FontRenderContext fontRenderContext = this.g2.getFontRenderContext();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        String[] stringArray = new String[n];
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("#0.0");
        int n2 = 0;
        while (n2 < this.chartSeriesData.getChartData().size()) {
            ChartDataPoint chartDataPoint = this.chartSeriesData.getChartData().get(n2);
            Date date = new Date(chartDataPoint.getAcquisitionDateTime());
            stringArray[0] = Integer.toString(chartDataPoint.getSeriesNumber());
            stringArray[1] = decimalFormat.format(chartDataPoint.getX());
            stringArray[2] = simpleDateFormat.format(date);
            stringArray[3] = String.valueOf(decimalFormat2.format(chartDataPoint.getY()));
            stringArray[4] = String.valueOf(decimalFormat2.format(chartDataPoint.getYRel()));
            int n3 = 0;
            while (n3 < stringArray.length) {
                float f = (float)font.getStringBounds(stringArray[n3], fontRenderContext).getWidth();
                float f2 = (float)font.getStringBounds(stringArray[n3], fontRenderContext).getHeight();
                if ((double)f > this.maxColumnWidths[n3]) {
                    this.maxColumnWidths[n3] = f + (float)HORIZONTAL_PADDING;
                }
                if ((double)f2 > this.maxRowHeight) {
                    this.maxRowHeight = f2 + (float)VERTICAL_PADDING;
                }
                this.tableContent[n3][n2] = stringArray[n3];
                ++n3;
            }
            ++n2;
        }
        this.initTableSize();
        this.numberOfTables = (int)Math.ceil((float)this.chartSeriesData.getChartData().size() / (float)this.maxDataRowsPerTable);
    }

    private void initTableSize() {
        this.tableWidth = 0.0;
        int n = 0;
        while (n < this.maxColumnWidths.length) {
            this.tableWidth += this.maxColumnWidths[n];
            ++n;
        }
        this.maxDataRowsPerTable = (int)Math.floor(((double)this.maxSubTableHeight - this.maxRowHeight - this.maxRowHeight / 2.0) / this.maxRowHeight) - 2;
    }

    private void createTable() {
        float f;
        Font font = this.g2.getFont().deriveFont(16);
        this.g2.setFont(font);
        FontRenderContext fontRenderContext = this.g2.getFontRenderContext();
        double d = 0.0;
        double d2 = this.maxRowHeight;
        int n = this.tableContent[0].length;
        int n2 = this.tableContent.length;
        String string = this.chartSeriesData.getROIName();
        this.g2.drawString(string, (float)(d + 256.0), (float)(this.maxRowHeight + (double)font.getLineMetrics(string, fontRenderContext).getAscent()) / 2.0f);
        this.g2.draw(new Line2D.Double(0.0, d2, this.tableWidth, d2));
        int n3 = 0;
        while (n3 < this.headers.length) {
            float f2 = (float)font.getStringBounds(this.headers[n3], fontRenderContext).getWidth();
            LineMetrics lineMetrics = font.getLineMetrics(this.headers[n3], fontRenderContext);
            f = (float)(d + (this.maxColumnWidths[n3] - (double)f2) / 2.0);
            float f3 = (float)(d2 + (this.maxRowHeight + (double)lineMetrics.getAscent()) / 2.0);
            this.g2.drawString(this.headers[n3], f, f3);
            d += this.maxColumnWidths[n3];
            ++n3;
        }
        d2 += this.maxRowHeight;
        n3 = this.rowIndex + this.maxDataRowsPerTable;
        if (n3 > n) {
            n3 = n;
        }
        int n4 = this.rowIndex;
        while (n4 < n3) {
            if (this.rowIndex > n) {
                return;
            }
            d = 0.0;
            int n5 = 0;
            while (n5 < n2) {
                f = (float)font.getStringBounds(this.tableContent[n5][n4], fontRenderContext).getWidth();
                LineMetrics lineMetrics = font.getLineMetrics(this.tableContent[n5][n4], fontRenderContext);
                float f4 = (float)(d + (this.maxColumnWidths[n5] - (double)f) / 2.0);
                float f5 = (float)(d2 + (this.maxRowHeight + (double)lineMetrics.getAscent()) / 2.0);
                this.g2.drawString(this.tableContent[n5][n4], f4, f5);
                d += this.maxColumnWidths[n5];
                if ((double)f > this.maxColumnWidths[n5]) {
                    this.maxColumnWidths[n5] = f;
                }
                ++n5;
            }
            this.g2.draw(new Line2D.Double(0.0, d2, this.tableWidth, d2));
            d2 += this.maxRowHeight;
            ++n4;
        }
        this.g2.draw(new Line2D.Double(0.0, d2, this.tableWidth, d2));
        double d3 = this.maxColumnWidths[0];
        double d4 = this.maxRowHeight;
        double d5 = d2;
        this.g2.draw(new Line2D.Double(0.0, d4, 0.0, d5));
        int n6 = 1;
        while (n6 < this.maxColumnWidths.length) {
            this.g2.draw(new Line2D.Double(d3, d4, d3, d5));
            d3 += this.maxColumnWidths[n6];
            ++n6;
        }
        this.g2.draw(new Line2D.Double(d3, d4, d3, d5));
        this.g2.drawString(String.valueOf(this.currentTableNumber) + "/" + this.numberOfTables, (float)d3 + 10.0f, (float)d5);
        ++this.currentTableNumber;
        this.rowIndex += this.maxDataRowsPerTable;
        this.g2.draw(new Line2D.Double(d3, d4, d3, d5));
    }
}

