/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.sync.DisplaySynchronizationManager;
import com.agfa.pacs.impaxee.sync.IFrameOfReferenceCheck;
import com.agfa.pacs.impaxee.sync.ISynchronizableImageFrames;
import com.agfa.pacs.impaxee.sync.SynchronizationOrientationChecker;
import com.tiani.base.data.IImagePlaneInformation;
import com.tiani.base.data.IImagePlaneInformationContainer;
import javax.vecmath.Vector3d;

class AutomaticSynchronizationAnalyzer {
    private AutomaticSynchronizationAnalyzer() {
    }

    private static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    private static boolean isDisplaySetSyncConsistent(IImagePlaneInformationContainer iImagePlaneInformationContainer) {
        if (iImagePlaneInformationContainer == null) {
            return false;
        }
        int n = iImagePlaneInformationContainer.getRunFrameCount();
        if (n <= 2) {
            return false;
        }
        IImagePlaneInformation iImagePlaneInformation = iImagePlaneInformationContainer.getImagePlaneInformation(n / 2);
        String string = AutomaticSynchronizationAnalyzer.nullToEmpty(iImagePlaneInformation.getModality());
        Vector3d vector3d = iImagePlaneInformation.getPlaneNormalUV();
        int n2 = 0;
        int n3 = 2;
        while (n3 < n) {
            IImagePlaneInformation iImagePlaneInformation2 = iImagePlaneInformationContainer.getImagePlaneInformation(n3);
            if (!string.equals(AutomaticSynchronizationAnalyzer.nullToEmpty(iImagePlaneInformation2.getModality()))) {
                return false;
            }
            Vector3d vector3d2 = iImagePlaneInformation2.getPlaneNormalUV();
            if (!SynchronizationOrientationChecker.equalsOrientation(vector3d, vector3d2)) {
                ++n2;
            }
            ++n3;
        }
        return n2 < 3 && n - n2 > 2;
    }

    static boolean isAutomaticSynchronizationPossible(DisplaySynchronizationManager displaySynchronizationManager, DisplaySynchronizationManager displaySynchronizationManager2, IFrameOfReferenceCheck iFrameOfReferenceCheck) {
        if (displaySynchronizationManager == displaySynchronizationManager2) {
            return true;
        }
        if (!displaySynchronizationManager.isAutomaticSynchronizationSupported() || !displaySynchronizationManager2.isAutomaticSynchronizationSupported()) {
            return false;
        }
        ISynchronizableImageFrames iSynchronizableImageFrames = displaySynchronizationManager.getImageFrames();
        ISynchronizableImageFrames iSynchronizableImageFrames2 = displaySynchronizationManager2.getImageFrames();
        if (!AutomaticSynchronizationAnalyzer.isDisplaySetSyncConsistent(iSynchronizableImageFrames) || !AutomaticSynchronizationAnalyzer.isDisplaySetSyncConsistent(iSynchronizableImageFrames2)) {
            return false;
        }
        boolean bl = iSynchronizableImageFrames.isPrimaryNavigationInSpace();
        boolean bl2 = iSynchronizableImageFrames2.isPrimaryNavigationInSpace();
        if (!bl || !bl2) {
            return false;
        }
        return AutomaticSynchronizationAnalyzer.isAutomaticSynchronizationPossible(iSynchronizableImageFrames, iSynchronizableImageFrames2, iFrameOfReferenceCheck);
    }

    static boolean isAutomaticSynchronizationPossible(IImagePlaneInformationContainer iImagePlaneInformationContainer, IImagePlaneInformationContainer iImagePlaneInformationContainer2, IFrameOfReferenceCheck iFrameOfReferenceCheck) {
        String string;
        IImagePlaneInformation iImagePlaneInformation;
        IImagePlaneInformation iImagePlaneInformation2 = iImagePlaneInformationContainer.getMiddleImagePlaneInformation();
        if (!SynchronizationOrientationChecker.hasSameOrientation(iImagePlaneInformation2, iImagePlaneInformation = iImagePlaneInformationContainer2.getMiddleImagePlaneInformation(), iFrameOfReferenceCheck.getWorldToWorldTransformer())) {
            return false;
        }
        String string2 = iImagePlaneInformation2.getFrameOfReferenceUID();
        if (string2 != null ^ (string = iImagePlaneInformation.getFrameOfReferenceUID()) != null) {
            return false;
        }
        return iFrameOfReferenceCheck.isCompatible(string2, string);
    }
}

