/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.sync.AutomaticSynchronizationAnalyzer;
import com.agfa.pacs.impaxee.sync.DisplaySynchronizationManager;
import com.agfa.pacs.impaxee.sync.FrameOfReferenceCheck;
import com.agfa.pacs.impaxee.sync.IFrameOfReferenceCheck;
import com.agfa.pacs.impaxee.sync.ISynchronizationPosition;
import com.agfa.pacs.impaxee.sync.StudyLinkageInfo;
import com.agfa.pacs.impaxee.sync.SynchronizationSupport;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import com.tiani.base.data.IImagePlaneInformation;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3d;

class AutomaticSynchronizationInitializer {
    private static final ALogger LOGGER = ALogger.getLogger(AutomaticSynchronizationInitializer.class);
    private static final Set<String> AUTO_SYNC_MODALITIES = new HashSet<String>(Arrays.asList(Pattern.SLASH.split(Config.impaxee.jvision.SYNCHRONIZE.AutoSyncOnModality.get())));

    private AutomaticSynchronizationInitializer() {
    }

    static boolean startAutomaticSynchronization(VisDisplay2 visDisplay2) {
        ISynchronizationPosition iSynchronizationPosition;
        DisplaySynchronizationManager displaySynchronizationManager;
        if (!AutomaticSynchronizationInitializer.isAutoSyncEnabled(visDisplay2)) {
            return false;
        }
        LOGGER.info("Performing auto sync");
        DisplaySynchronizationManager displaySynchronizationManager2 = visDisplay2.getSynchronizationManager();
        boolean bl = AutomaticSynchronizationInitializer.containSpaceInformation(displaySynchronizationManager2);
        int n = bl ? displaySynchronizationManager2.getImageFrames().getRunFrameCount() / 2 : 0;
        displaySynchronizationManager2.enableSynchronization(n);
        ISynchronizationPosition iSynchronizationPosition2 = displaySynchronizationManager2.getReferencePosition();
        List<VisDisplay2> list = JVision2.getMainFrame().getDisplays();
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(list.size());
        for (VisDisplay2 object2 : list) {
            if (object2 == visDisplay2 || !object2.hasData()) continue;
            object2.getSynchronizationManager().disableSynchronization();
            arrayList.add(object2);
        }
        StudyLinkageInfo studyLinkageInfo = displaySynchronizationManager2.getManualSynchronizationInfo();
        if (studyLinkageInfo != null) {
            Iterator<VisDisplay2> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DisplaySynchronizationManager displaySynchronizationManager3;
                VisDisplay2 visDisplay22 = iterator.next();
                displaySynchronizationManager = studyLinkageInfo.getLinked(visDisplay22.getData().getDisplaySet());
                if (displaySynchronizationManager == null || !AutomaticSynchronizationAnalyzer.isAutomaticSynchronizationPossible(displaySynchronizationManager3 = visDisplay22.getSynchronizationManager(), displaySynchronizationManager2, (IFrameOfReferenceCheck)FrameOfReferenceCheck.IGNORE_FRAME_OF_REFERENCE) || (iSynchronizationPosition = displaySynchronizationManager3.searchAppropriateSynchronizationPosition(iSynchronizationPosition2, (Vector3d)displaySynchronizationManager, false)) == null) continue;
                displaySynchronizationManager3.enableSynchronizationWithManualLinking(iSynchronizationPosition);
                visDisplay22.repaint();
                iterator.remove();
            }
        }
        for (VisDisplay2 visDisplay23 : arrayList) {
            displaySynchronizationManager = visDisplay23.getSynchronizationManager();
            boolean bl2 = AutomaticSynchronizationAnalyzer.isAutomaticSynchronizationPossible(displaySynchronizationManager, displaySynchronizationManager2, FrameOfReferenceCheck.createCheckWithReferenceTransform(displaySynchronizationManager.getWorldToWorldTransformer()));
            if (bl2) {
                if (bl) {
                    iSynchronizationPosition = displaySynchronizationManager.searchAppropriateSynchronizationPosition(iSynchronizationPosition2, true);
                    if (iSynchronizationPosition != null) {
                        displaySynchronizationManager.enableSynchronization(iSynchronizationPosition);
                    }
                } else {
                    displaySynchronizationManager.enableSynchronization(0);
                }
            }
            visDisplay23.repaint();
        }
        return true;
    }

    private static boolean isAutoSyncEnabled(VisDisplay2 visDisplay2) {
        if (!visDisplay2.hasData()) {
            return false;
        }
        SynchronizationSupport synchronizationSupport = visDisplay2.getData().getDisplayPlugin().getSynchronizationSupport();
        return synchronizationSupport == SynchronizationSupport.FULL && AutomaticSynchronizationInitializer.hasAutoSyncModality(visDisplay2);
    }

    private static boolean hasAutoSyncModality(VisDisplay2 visDisplay2) {
        return AUTO_SYNC_MODALITIES.contains(visDisplay2.getFirstVis().getImageInformation().getModality());
    }

    private static boolean containSpaceInformation(DisplaySynchronizationManager displaySynchronizationManager) {
        IImagePlaneInformation iImagePlaneInformation = displaySynchronizationManager.getFirstImagePlaneInformation();
        return iImagePlaneInformation != null && iImagePlaneInformation.getFrameOfReferenceUID() != null && iImagePlaneInformation.getPointCenter() != null;
    }
}

