/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformer;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.navigation.RelativeNavigationStep;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPluginNavigationHandlers;
import com.agfa.pacs.impaxee.sync.AutomaticSynchronizationInitializer;
import com.agfa.pacs.impaxee.sync.CurrentSynchronizationPositionOffset;
import com.agfa.pacs.impaxee.sync.DummyDisplaySynchronizationPositionHandler;
import com.agfa.pacs.impaxee.sync.IDisplaySynchronizationListener;
import com.agfa.pacs.impaxee.sync.IDisplaySynchronizationManager;
import com.agfa.pacs.impaxee.sync.IDisplaySynchronizationPositionHandler;
import com.agfa.pacs.impaxee.sync.ISynchronizableImageFrames;
import com.agfa.pacs.impaxee.sync.ISynchronizationPosition;
import com.agfa.pacs.impaxee.sync.StudyLinkageInfo;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.agfa.pacs.impaxee.sync.SynchronizationOrientationChecker;
import com.agfa.pacs.impaxee.sync.SynchronizationSupport;
import com.agfa.pacs.impaxee.sync.SynchronizationVisNavigationEventHandler;
import com.agfa.pacs.impaxee.sync.VisDataSynchronizationPositionHandler;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.GeomUtil;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IImagePlaneInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.renderer.RendererSyncData;
import com.tiani.jvision.toptoolbar.SyncOptionsActionProvider;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.event.IVisNavigationEventHandler;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import java.util.Hashtable;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class DisplaySynchronizationManager
implements IDisplaySynchronizationManager {
    private static final ALogger LOGGER = ALogger.getLogger(DisplaySynchronizationManager.class);
    private static final PIcon ICON_SYNC = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize.svg");
    private static final PIcon ICON_SYNCPOINT = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_point.svg");
    private static final PIcon ICON_SYNC_MANUAL = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_manual.svg");
    private static final PIcon ICON_SYNCPOINT_MANUAL = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_manual_point.svg");
    private final VisDisplay2 display;
    private final IDisplaySynchronizationPositionHandler defaultSynchronizationPositionHandler;
    private boolean isSynchronized;
    private boolean manuallyLinked;
    private ISynchronizationPosition referencePosition;
    private ISynchronizationPosition currentSynchronizationPosition;
    private boolean synchronizedMatchSize = false;
    private boolean useLocationInformation = true;

    public DisplaySynchronizationManager(VisDisplay2 visDisplay2) {
        this.display = visDisplay2;
        this.defaultSynchronizationPositionHandler = new VisDataSynchronizationPositionHandler(visDisplay2);
    }

    int getReferencePositionNavigationIndex() {
        return this.referencePosition == null ? 0 : this.referencePosition.getNavigationIndex();
    }

    ISynchronizationPosition getReferencePosition() {
        return this.referencePosition;
    }

    private void setReferencePosition(ISynchronizationPosition iSynchronizationPosition) {
        this.referencePosition = iSynchronizationPosition;
        this.currentSynchronizationPosition = iSynchronizationPosition != null ? this.getSynchronizationPositionHandler().createSynchronizationPosition(this.getCurrentNavigationIndex()) : null;
    }

    double getDistanceToReferencePosition(int n) {
        if (!this.useLocationInformation()) {
            return Double.NaN;
        }
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        if (iSynchronizableImageFrames == null) {
            return Double.NaN;
        }
        return iSynchronizableImageFrames.getRelativeSliceLocation(n) - iSynchronizableImageFrames.getRelativeSliceLocation(this.getReferencePositionNavigationIndex());
    }

    int getCurrentSynchronizationPositionNavigationIndex() {
        return this.currentSynchronizationPosition == null ? 0 : this.currentSynchronizationPosition.getNavigationIndex();
    }

    private ISynchronizationPosition getCurrentSynchronizationPosition() {
        return this.currentSynchronizationPosition;
    }

    ISynchronizationPosition getPotentialSynchronizationPosition(RelativeNavigationStep relativeNavigationStep, int n) {
        IDisplaySynchronizationPositionHandler iDisplaySynchronizationPositionHandler = this.getSynchronizationPositionHandler();
        return iDisplaySynchronizationPositionHandler.createSynchronizationPosition(this.getCurrentSynchronizationPositionNavigationIndex(), relativeNavigationStep, n);
    }

    void setCurrentSynchronizationPosition(ISynchronizationPosition iSynchronizationPosition) {
        this.currentSynchronizationPosition = iSynchronizationPosition;
    }

    @Override
    public void moveCurrentSynchronizationPositionTo(int n) {
        if (!this.isSynchronizedNavigationEnabled()) {
            return;
        }
        ISynchronizationPosition iSynchronizationPosition = this.getCurrentSynchronizationPosition();
        this.setCurrentSynchronizationPosition(this.getSynchronizationPositionHandler().createSynchronizationPosition(n));
        SynchronizationManager.getInstance().setCurrentSynchronizationPositionOffsetBasedOn(this);
        if (iSynchronizationPosition != null) {
            iSynchronizationPosition.repaintVisualBorder();
        }
        this.synchronizeOthersWithCurrentSynchronizationPosition();
    }

    @Override
    public int getMaximumSynchronizationPositionIndex() {
        return this.getSynchronizationPositionHandler().getMaximumSynchronizationPositionIndex();
    }

    private int getDestinationIndex(VisNavigationEvent visNavigationEvent) {
        int n;
        switch (visNavigationEvent.getMoveEvent()) {
            case FIRST_IMAGE: {
                n = 0;
                break;
            }
            case LAST_IMAGE: {
                n = this.display.getNavigationHandler().getRunLength();
                break;
            }
            default: {
                n = visNavigationEvent.getValue();
            }
        }
        return n;
    }

    void updateNavigationAndSynchronizationPositionsForAbsoluteNavigation(VisNavigationEvent visNavigationEvent) {
        int n = Math.min(this.getMaximumSynchronizationPositionIndex(), Math.max(0, this.getDestinationIndex(visNavigationEvent)));
        this.updateNavigationAndSynchronizationPositions(visNavigationEvent, this.getSynchronizationPositionHandler().createSynchronizationPosition(n));
    }

    void updateNavigationAndSynchronizationPositions(VisNavigationEvent visNavigationEvent, ISynchronizationPosition iSynchronizationPosition) {
        this.display.handleUnsynchronizedNavigationEvent(visNavigationEvent);
        this.setCurrentSynchronizationPosition(iSynchronizationPosition);
    }

    void showStopSignIfNecessary() {
        this.display.checkStopSign();
    }

    @Override
    public ISynchronizationPosition searchAppropriateSynchronizationPosition(IImagePlaneInformation iImagePlaneInformation) {
        return this.searchAppropriateSynchronizationPosition(iImagePlaneInformation, false);
    }

    ISynchronizationPosition searchAppropriateSynchronizationPosition(IImagePlaneInformation iImagePlaneInformation, boolean bl) {
        return this.searchAppropriateSynchronizationPosition(iImagePlaneInformation, null, bl);
    }

    ISynchronizationPosition searchAppropriateSynchronizationPosition(ISynchronizationPosition iSynchronizationPosition, boolean bl) {
        return this.searchAppropriateSynchronizationPosition(iSynchronizationPosition, null, bl);
    }

    ISynchronizationPosition searchAppropriateSynchronizationPosition(ISynchronizationPosition iSynchronizationPosition, Vector3d vector3d, boolean bl) {
        return this.searchAppropriateSynchronizationPosition(iSynchronizationPosition.getImageInformation(), vector3d, bl);
    }

    private ISynchronizationPosition searchAppropriateSynchronizationPosition(IImagePlaneInformation iImagePlaneInformation, Vector3d vector3d, boolean bl) {
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        if (iSynchronizableImageFrames == null) {
            LOGGER.debug("Auto sync position not found because no synchronization positions available");
            return null;
        }
        IImagePlaneInformation iImagePlaneInformation2 = this.getFirstImagePlaneInformation();
        if (iImagePlaneInformation.getPointCenter() == null || iImagePlaneInformation2.getPointCenter() == null) {
            LOGGER.debug("Auto sync position not found because image position not available");
            return null;
        }
        IImagePlaneInformation iImagePlaneInformation3 = null;
        int n = 0;
        double d = Double.MAX_VALUE;
        int n2 = iSynchronizableImageFrames.getRunFrameCount();
        String string = iImagePlaneInformation.getFrameOfReferenceUID();
        Point3d point3d = iImagePlaneInformation.getPointCenter();
        Vector3d vector3d2 = iImagePlaneInformation.getPlaneNormalUV();
        int n3 = 0;
        while (n3 < n2) {
            try {
                IImagePlaneInformation iImagePlaneInformation4 = iSynchronizableImageFrames.getImagePlaneInformation(n3);
                Point3d point3d2 = iImagePlaneInformation4.getPointCenter();
                if (point3d2 != null && !iImagePlaneInformation4.isLocalizer()) {
                    double d2;
                    String string2;
                    point3d2 = new Point3d(point3d2);
                    if (vector3d != null) {
                        point3d2.add((Tuple3d)vector3d);
                    }
                    if ((!bl || CompareUtils.equals((Object)string, (Object)(string2 = iImagePlaneInformation4.getFrameOfReferenceUID())) || this.getWorldToWorldTransformer().convertPoint(point3d2, string2, string)) && (d2 = GeomUtil.getDistanceFromPlane((Tuple3d)point3d2, (Point3d)point3d, (Vector3d)vector3d2)) < d) {
                        d = d2;
                        iImagePlaneInformation3 = iImagePlaneInformation4;
                        n = n3;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error on synchronization", (Throwable)exception);
            }
            ++n3;
        }
        LOGGER.debug("Best auto sync position has distance: {}", (Object)d);
        if (iImagePlaneInformation3 == null) {
            return null;
        }
        Double d3 = (Double)CompareUtils.max((Comparable)iImagePlaneInformation3.getSliceThickness(), (Comparable)iImagePlaneInformation.getSliceThickness());
        if (d3 != null && d3 * 3.0 < d) {
            LOGGER.info("Nearest position too far to synchronize: {}", (Object)d);
            return null;
        }
        LOGGER.info("Best auto sync position is at navigation index {} with distance {}", (Object)n, (Object)d);
        return this.getSynchronizationPositionHandler().createSynchronizationPosition(n);
    }

    @Override
    public void startAutomaticSynchronization() {
        this.startAutomaticSynchronization(false);
    }

    private void startAutomaticSynchronization(boolean bl) {
        if (AutomaticSynchronizationInitializer.startAutomaticSynchronization(this.display)) {
            this.ensureCurrentSynchronizationPosition(bl);
        } else {
            SynchronizationManager.getInstance().disableSynchronization();
        }
    }

    private void ensureCurrentSynchronizationPosition(boolean bl) {
        if (bl || this.isCurrentSynchronizationPositionOffsetMissingLocationInformation()) {
            SynchronizationManager.getInstance().setCurrentSynchronizationPositionOffsetBasedOn(this);
        }
    }

    void reinitAutomaticSynchronization() {
        this.startAutomaticSynchronization(true);
        this.synchronizeOthersWithCurrentSynchronizationPosition();
    }

    void synchronizeOthersWithCurrentSynchronizationPosition() {
        SynchronizationManager.getInstance().getEnabledDisplaySynchronizationManagers().forEach(this::synchronizeOtherWithCurrentSynchronizationPosition);
    }

    private void synchronizeOtherWithCurrentSynchronizationPosition(DisplaySynchronizationManager displaySynchronizationManager) {
        if (displaySynchronizationManager != this) {
            displaySynchronizationManager.synchronizeWithCurrentSynchronizationPosition();
        }
    }

    void synchronizeWithCurrentSynchronizationPosition() {
        this.synchronizeWithCurrentSynchronizationPosition(0);
    }

    void synchronizeWithCurrentSynchronizationPosition(int n) {
        Vis2 vis2;
        if (!this.isSynchronizedNavigationEnabled()) {
            return;
        }
        ISynchronizationPosition iSynchronizationPosition = this.getCurrentSynchronizationPosition();
        int n2 = iSynchronizationPosition == null ? -1 : iSynchronizationPosition.getNavigationIndex();
        double d = Double.MAX_VALUE;
        int n3 = -1;
        double d2 = 5.0;
        Double d3 = this.getFirstImagePlaneInformation().getSliceThickness();
        if (d3 != null) {
            d2 = 4.0 * d3;
        }
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        int n4 = iSynchronizableImageFrames.getRunFrameCount();
        CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset = SynchronizationManager.getInstance().getCurrentSynchronizationPositionOffset();
        if (this.useLocationInformation() && currentSynchronizationPositionOffset.hasLocationInformation()) {
            double d4 = iSynchronizableImageFrames.getRelativeSliceLocation(this.getReferencePositionNavigationIndex());
            int n5 = 0;
            while (n5 < n4) {
                double d5 = Math.abs(currentSynchronizationPositionOffset.getOffsetInMillimeters() - (iSynchronizableImageFrames.getRelativeSliceLocation(n5) - d4));
                if (d5 < d || d5 == d && DisplaySynchronizationManager.isMinimalIndexChange(n5, n2, n3, n)) {
                    d = d5;
                    n3 = n5;
                }
                ++n5;
            }
        } else {
            int n6 = this.getReferencePositionNavigationIndex() + currentSynchronizationPositionOffset.getOffsetInNumberOfImageFrames();
            if (n6 < 0) {
                n3 = 0;
            } else if (n6 < n4) {
                n3 = n6;
            } else {
                n3 = n4 - 1;
                d = d2 + 1.0;
            }
        }
        if (n3 == -1) {
            return;
        }
        ISynchronizationPosition iSynchronizationPosition2 = this.getSynchronizationPositionHandler().createSynchronizationPosition(n3);
        this.setCurrentSynchronizationPosition(iSynchronizationPosition2);
        if (iSynchronizationPosition != null) {
            if (n2 != -1) {
                this.display.move2synchronisedPosition(n3);
            }
            iSynchronizationPosition.repaintVisualBorder();
        }
        if ((vis2 = iSynchronizationPosition2.getVisual()) != null) {
            if ((n3 == 0 || n3 + 1 == n4) && d > d2) {
                vis2.showStopSign();
            }
            vis2.repaintBorder();
        }
    }

    private static boolean isMinimalIndexChange(int n, int n2, int n3, int n4) {
        return n2 != -1 && (long)n4 * (long)(n - n2) > 0L && (n3 == n2 || Math.abs(n - n2) < Math.abs(n3 - n2));
    }

    private boolean isCurrentSynchronizationPositionOffsetMissingLocationInformation() {
        return this.useLocationInformation() && !SynchronizationManager.getInstance().getCurrentSynchronizationPositionOffset().hasLocationInformation();
    }

    boolean useLocationInformation() {
        return this.useLocationInformation && this.hasLocationInformation();
    }

    @Override
    public boolean hasLocationInformation() {
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        return iSynchronizableImageFrames != null && iSynchronizableImageFrames.hasLocationInformation();
    }

    @Override
    public boolean isUsingLocationInformation() {
        return this.useLocationInformation;
    }

    @Override
    public void toggleUseLocationInformation() {
        this.setUseLocationInformation(!this.useLocationInformation);
    }

    private void setUseLocationInformation(boolean bl) {
        this.useLocationInformation = bl;
        SynchronizationManager.getInstance().setCurrentSynchronizationPositionOffsetBasedOn(this);
        this.synchronizeOthersWithCurrentSynchronizationPosition();
    }

    StudyLinkageInfo getManualSynchronizationInfo() {
        return this.display.getData().getPatientRepresentation().getLinkage(this.getDisplaySet());
    }

    private IDisplaySet getDisplaySet() {
        return this.display.getData().getDisplaySet();
    }

    private IDisplayPlugin getDisplayPlugin() {
        return this.display.getData().getDisplayPlugin();
    }

    IImagePlaneInformation getFirstImagePlaneInformation() {
        return this.getImagePlaneInformation(0);
    }

    @Override
    public IImagePlaneInformation getActiveImagePlaneInformation() {
        return this.getImagePlaneInformation(this.getCurrentNavigationIndex());
    }

    private IImagePlaneInformation getImagePlaneInformation(int n) {
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        if (iSynchronizableImageFrames == null) {
            return null;
        }
        return iSynchronizableImageFrames.getImagePlaneInformation(n);
    }

    ISynchronizableImageFrames getImageFrames() {
        return this.getSynchronizationPositionHandler().getImageFrames();
    }

    private int getCurrentNavigationIndex() {
        return this.display.getNavigationHandler().getCurrentPositionInRun();
    }

    @Override
    public PIcon getStatusIcon(Vis2 vis2) {
        PIcon pIcon;
        if (this.isSynchronized) {
            boolean bl = this.getSynchronizationPositionHandler().isReferencePosition(vis2);
            pIcon = this.manuallyLinked ? (bl ? ICON_SYNCPOINT_MANUAL : ICON_SYNC_MANUAL) : (bl ? ICON_SYNCPOINT : ICON_SYNC);
        } else {
            pIcon = null;
        }
        return pIcon;
    }

    @Override
    public IVisNavigationEventHandler createVisNavigationEventHandler() {
        return new SynchronizationVisNavigationEventHandler(this);
    }

    @Override
    public void reset() {
        this.setSynchronized(false, false);
        this.setReferencePosition(null);
    }

    boolean isSynchronizationSupported() {
        return this.display.hasData() && this.getDisplayPlugin().getSynchronizationSupport() != SynchronizationSupport.NONE;
    }

    boolean isAutomaticSynchronizationSupported() {
        return this.display.hasData() && this.getDisplayPlugin().getSynchronizationSupport() == SynchronizationSupport.FULL;
    }

    private IDisplaySynchronizationPositionHandler getSynchronizationPositionHandler() {
        IPluginNavigationHandlers iPluginNavigationHandlers = this.getDisplayPlugin().getNavigationHandlers();
        if (iPluginNavigationHandlers == null) {
            return this.defaultSynchronizationPositionHandler;
        }
        IDisplaySynchronizationPositionHandler iDisplaySynchronizationPositionHandler = iPluginNavigationHandlers.getSynchronizationPositionHandler();
        if (iDisplaySynchronizationPositionHandler == null) {
            iDisplaySynchronizationPositionHandler = DummyDisplaySynchronizationPositionHandler.INSTANCE;
        }
        return iDisplaySynchronizationPositionHandler;
    }

    IWorldToWorldTransformer getWorldToWorldTransformer() {
        return this.getDisplayPlugin().getWorldToWorldTransformer();
    }

    private void notifyListener() {
        IDisplaySynchronizationListener iDisplaySynchronizationListener = this.getDisplayPlugin().getSynchronizationListener();
        if (iDisplaySynchronizationListener != null) {
            if (this.isSynchronized) {
                iDisplaySynchronizationListener.notifySynchronizationActivation();
            } else {
                iDisplaySynchronizationListener.notifySynchronizationDeactivation();
            }
        }
    }

    @Override
    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    @Override
    public boolean isSynchronizedNavigationEnabled() {
        return this.isSynchronized() && SyncOptionsActionProvider.SyncOption.SCROLLING.isSelected() && this.isSynchronizedNavigationSupported();
    }

    private boolean isSynchronizedNavigationSupported() {
        return this.getImageFrames() != null;
    }

    boolean isManuallySynced() {
        return this.manuallyLinked;
    }

    private void setSynchronized(boolean bl, boolean bl2) {
        this.isSynchronized = bl;
        this.manuallyLinked = bl2;
        this.synchronizedMatchSize = false;
        if (this.display.hasAction("SYNCHRONIZE")) {
            this.display.getAction("SYNCHRONIZE").fireSelectionChanged();
        }
        this.notifyListener();
        if (!bl && JVision2.getMainFrame().getDisplays().stream().noneMatch(VisDisplay2::isSynchronized)) {
            SynchronizationManager.getInstance().resetCurrentSynchronizationPositionOffset();
        }
    }

    void enableSynchronizationWithManualLinking(ISynchronizationPosition iSynchronizationPosition) {
        this.enableSynchronization(iSynchronizationPosition, true);
    }

    void enableSynchronizationWithBestMatchAsReferencePosition() {
        ISynchronizableImageFrames iSynchronizableImageFrames = this.getImageFrames();
        int n = iSynchronizableImageFrames == null ? -1 : this.findBestMatch(iSynchronizableImageFrames, SynchronizationManager.getInstance().getCurrentSynchronizationPositionOffset());
        if (n != -1) {
            this.enableSynchronization(n);
        } else {
            this.enableSynchronizationWithCurrentNavigationPositionAsReferencePosition();
        }
    }

    private int findBestMatch(ISynchronizableImageFrames iSynchronizableImageFrames, CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset) {
        double d = currentSynchronizationPositionOffset.getOffsetInMillimeters();
        double d2 = iSynchronizableImageFrames.getRelativeSliceLocation(this.getCurrentNavigationIndex());
        double d3 = Double.MAX_VALUE;
        int n = -1;
        int n2 = iSynchronizableImageFrames.getRunFrameCount();
        int n3 = 0;
        while (n3 < n2) {
            double d4 = Math.abs(d - (d2 - iSynchronizableImageFrames.getRelativeSliceLocation(n3)));
            if (d4 < d3) {
                d3 = d4;
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    @Override
    public void enableSynchronizationWithCurrentNavigationPositionAsReferencePosition() {
        this.enableSynchronization(this.getCurrentNavigationIndex());
    }

    @Override
    public void enableSynchronization(int n) {
        this.enableSynchronization(this.getSynchronizationPositionHandler().createSynchronizationPosition(n));
    }

    void enableSynchronization(ISynchronizationPosition iSynchronizationPosition) {
        this.enableSynchronization(iSynchronizationPosition, false);
    }

    private void enableSynchronization(ISynchronizationPosition iSynchronizationPosition, boolean bl) {
        if (iSynchronizationPosition == null && this.isSynchronizedNavigationSupported()) {
            LOGGER.error("Missing reference position for synchronization");
            return;
        }
        if (!this.display.hasData() || !this.isSynchronizationSupported()) {
            if (this.display.hasAction("SYNCHRONIZE")) {
                this.display.getAction("SYNCHRONIZE").forcedSelectionChanged();
            }
            return;
        }
        this.setSynchronized(true, bl);
        ISynchronizationPosition iSynchronizationPosition2 = this.getReferencePosition();
        this.setReferencePosition(null);
        if (iSynchronizationPosition2 != null) {
            iSynchronizationPosition2.repaintVisualBorder();
        }
        this.setReferencePosition(iSynchronizationPosition);
        if (this.isAutomaticSynchronizationSupported()) {
            TEvent tEvent = new TEvent(88);
            RendererSyncData rendererSyncData = new RendererSyncData("Renderer");
            TEventDispatch.sendEvent(tEvent, rendererSyncData);
        } else {
            TEvent tEvent = new TEvent(90);
            TEventDispatch.sendEventToVis(this.display, tEvent, new Hashtable(), 16);
        }
        this.display.paintBorder();
        this.display.repaint();
    }

    void disableSynchronization() {
        this.setSynchronized(false, false);
        this.setReferencePosition(null);
        List<VisData> list = this.display.getVis();
        for (VisData visData : list) {
            visData.getView().invalidate();
        }
        this.display.paintBorder();
        this.display.repaint();
    }

    boolean handleManualSynchronizationDuringAutomaticSynchronization(boolean bl) {
        DisplaySynchronizationManager displaySynchronizationManager = AbstractPDataAction.getCurrentDisplay().getSynchronizationManager();
        IPatientRepresentation iPatientRepresentation = this.display.getData().getPatientRepresentation();
        if (!bl) {
            iPatientRepresentation.removeLinkageInformation(this.getDisplaySet());
        } else if (this.useLocationInformation() && displaySynchronizationManager.useLocationInformation() && displaySynchronizationManager.isSynchronized()) {
            IImagePlaneInformation iImagePlaneInformation;
            IImagePlaneInformation iImagePlaneInformation2 = this.getActiveImagePlaneInformation();
            if (!SynchronizationOrientationChecker.hasSameOrientation(iImagePlaneInformation2, iImagePlaneInformation = displaySynchronizationManager.getActiveImagePlaneInformation()) || !SynchronizationOrientationChecker.hasDifferentFrameOfReference(iImagePlaneInformation2, iImagePlaneInformation)) {
                return false;
            }
            iPatientRepresentation.addLinkageInformation(this.getDisplaySet(), displaySynchronizationManager.getDisplaySet(), DisplaySynchronizationManager.calculateShift(iImagePlaneInformation2, iImagePlaneInformation));
        } else {
            return false;
        }
        displaySynchronizationManager.reinitAutomaticSynchronization();
        return true;
    }

    private static Vector3d calculateShift(IImagePlaneInformation iImagePlaneInformation, IImagePlaneInformation iImagePlaneInformation2) {
        Vector3d vector3d = iImagePlaneInformation.getVectorCenter();
        vector3d.sub((Tuple3d)iImagePlaneInformation2.getPointCenter());
        return vector3d;
    }

    @Override
    public void enableMatchSizeOnSynchronisation() {
        if (this.isSynchronized) {
            this.synchronizedMatchSize = true;
        }
    }

    @Override
    public boolean isMatchSizeOnSynchronisation() {
        return this.synchronizedMatchSize;
    }
}

