/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.DefaultWorldToWorldTransformer;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.navigation.RelativeNavigationStep;
import com.agfa.pacs.impaxee.sync.AutomaticSynchronizationAnalyzer;
import com.agfa.pacs.impaxee.sync.CurrentSynchronizationPositionOffset;
import com.agfa.pacs.impaxee.sync.DisplaySynchronizationManager;
import com.agfa.pacs.impaxee.sync.FrameOfReferenceCheck;
import com.agfa.pacs.impaxee.sync.IFrameOfReferenceCheck;
import com.agfa.pacs.impaxee.sync.ISynchronizationPosition;
import com.agfa.pacs.impaxee.sync.VisDataSynchronizationPosition;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import com.tiani.util.message.Message;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public enum SynchronizationManager {
    INSTANCE;

    private static final ALogger LOGGER;
    private static final double SYNCHRONIZATION_POSITION_EPSILON = 0.001;
    private static final double PIXEL_SPACING_EPSILON = 1.0E-4;
    private CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset = CurrentSynchronizationPositionOffset.NONE;

    static {
        LOGGER = ALogger.getLogger(SynchronizationManager.class);
    }

    public static SynchronizationManager getInstance() {
        return INSTANCE;
    }

    synchronized CurrentSynchronizationPositionOffset getCurrentSynchronizationPositionOffset() {
        return this.currentSynchronizationPositionOffset;
    }

    void setCurrentSynchronizationPositionOffsetBasedOn(DisplaySynchronizationManager displaySynchronizationManager) {
        this.setCurrentSynchronizationPositionOffsetBasedOn(displaySynchronizationManager, displaySynchronizationManager.getCurrentSynchronizationPositionNavigationIndex());
    }

    private void setCurrentSynchronizationPositionOffsetBasedOn(DisplaySynchronizationManager displaySynchronizationManager, int n) {
        this.setCurrentSynchronizationPositionOffset(new CurrentSynchronizationPositionOffset(displaySynchronizationManager.getDistanceToReferencePosition(n), n - displaySynchronizationManager.getReferencePositionNavigationIndex()));
    }

    private synchronized void setCurrentSynchronizationPositionOffset(CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset) {
        this.currentSynchronizationPositionOffset = currentSynchronizationPositionOffset;
    }

    synchronized void resetCurrentSynchronizationPositionOffset() {
        this.currentSynchronizationPositionOffset = CurrentSynchronizationPositionOffset.NONE;
    }

    boolean moveCurrentSynchronizationPosition(DisplaySynchronizationManager displaySynchronizationManager, List<DisplaySynchronizationManager> list, RelativeNavigationStep relativeNavigationStep, int n) {
        boolean bl;
        CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset = null;
        if (this.getCurrentSynchronizationPositionOffset().hasLocationInformation()) {
            LinkedHashMap<DisplaySynchronizationManager, ISynchronizationPosition> linkedHashMap = new LinkedHashMap<DisplaySynchronizationManager, ISynchronizationPosition>();
            currentSynchronizationPositionOffset = this.findClosestSynchronizationPosition(list, relativeNavigationStep, n, linkedHashMap);
            if (!linkedHashMap.isEmpty()) {
                this.moveCurrentSynchronizationPositionWithZeroDistance(displaySynchronizationManager, relativeNavigationStep, n, linkedHashMap);
                return true;
            }
        }
        if (bl = this.moveCurrentSynchronizationPosition(displaySynchronizationManager, relativeNavigationStep, n, currentSynchronizationPositionOffset)) {
            for (DisplaySynchronizationManager displaySynchronizationManager2 : list) {
                displaySynchronizationManager2.synchronizeWithCurrentSynchronizationPosition(n);
            }
        } else {
            list.forEach(DisplaySynchronizationManager::showStopSignIfNecessary);
        }
        return bl;
    }

    private boolean moveCurrentSynchronizationPosition(DisplaySynchronizationManager displaySynchronizationManager, RelativeNavigationStep relativeNavigationStep, int n, CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset) {
        if (currentSynchronizationPositionOffset == null) {
            ISynchronizationPosition iSynchronizationPosition = displaySynchronizationManager.getPotentialSynchronizationPosition(relativeNavigationStep, n);
            if (iSynchronizationPosition == null) {
                return false;
            }
            this.setCurrentSynchronizationPositionOffsetBasedOn(displaySynchronizationManager, iSynchronizationPosition.getNavigationIndex());
        } else {
            this.setCurrentSynchronizationPositionOffset(currentSynchronizationPositionOffset);
        }
        return true;
    }

    private void moveCurrentSynchronizationPositionWithZeroDistance(DisplaySynchronizationManager displaySynchronizationManager, RelativeNavigationStep relativeNavigationStep, int n, Map<DisplaySynchronizationManager, ISynchronizationPosition> map) {
        Object object;
        ISynchronizationPosition iSynchronizationPosition;
        DisplaySynchronizationManager displaySynchronizationManager2 = displaySynchronizationManager;
        if (map.containsKey(displaySynchronizationManager2)) {
            iSynchronizationPosition = map.get(displaySynchronizationManager2);
        } else {
            object = map.entrySet().iterator().next();
            displaySynchronizationManager2 = object.getKey();
            iSynchronizationPosition = object.getValue();
        }
        this.setCurrentSynchronizationPositionOffsetBasedOn(displaySynchronizationManager2, iSynchronizationPosition.getNavigationIndex());
        object = relativeNavigationStep.createVisNavigationEvent(n);
        for (Map.Entry<DisplaySynchronizationManager, ISynchronizationPosition> entry : map.entrySet()) {
            entry.getKey().updateNavigationAndSynchronizationPositions((VisNavigationEvent)object, entry.getValue());
        }
    }

    private CurrentSynchronizationPositionOffset findClosestSynchronizationPosition(List<DisplaySynchronizationManager> list, RelativeNavigationStep relativeNavigationStep, int n, Map<DisplaySynchronizationManager, ISynchronizationPosition> map) {
        CurrentSynchronizationPositionOffset currentSynchronizationPositionOffset = null;
        double d = this.getCurrentSynchronizationPositionOffset().getOffsetInMillimeters();
        double d2 = Double.MAX_VALUE;
        for (DisplaySynchronizationManager displaySynchronizationManager : list) {
            ISynchronizationPosition iSynchronizationPosition;
            if (!displaySynchronizationManager.useLocationInformation() || (iSynchronizationPosition = displaySynchronizationManager.getPotentialSynchronizationPosition(relativeNavigationStep, n)) == null) continue;
            int n2 = iSynchronizationPosition.getNavigationIndex();
            double d3 = displaySynchronizationManager.getDistanceToReferencePosition(n2);
            double d4 = Math.abs(d - d3);
            if (d4 < d2 && d4 > 0.001) {
                currentSynchronizationPositionOffset = new CurrentSynchronizationPositionOffset(d3, n2 - displaySynchronizationManager.getReferencePositionNavigationIndex());
                d2 = d4;
                continue;
            }
            if (!(d4 <= 0.001)) continue;
            map.put(displaySynchronizationManager, iSynchronizationPosition);
        }
        return currentSynchronizationPositionOffset;
    }

    public List<VisDisplay2> getSynchronizedDisplays() {
        return this.getSynchronizedDisplaysStream().collect(Collectors.toList());
    }

    private Stream<VisDisplay2> getSynchronizedDisplaysStream() {
        return JVision2.getMainFrame().getScreens().stream().flatMap(SynchronizationManager::getDisplays).filter(VisDisplay2::hasSynchronizedData);
    }

    private static Stream<VisDisplay2> getDisplays(VisScreen2 visScreen2) {
        return visScreen2.getDisplays().stream();
    }

    Stream<DisplaySynchronizationManager> getEnabledDisplaySynchronizationManagers() {
        return this.getSynchronizedDisplaysStream().map(VisDisplay2::getSynchronizationManager);
    }

    public void reinitAutomaticSynchronizationIfEnabled() {
        this.updateAutomaticSynchronizationIfEnabled(DisplaySynchronizationManager::reinitAutomaticSynchronization);
    }

    public void startAutomaticSynchronizationIfEnabled() {
        this.updateAutomaticSynchronizationIfEnabled(DisplaySynchronizationManager::startAutomaticSynchronization);
    }

    private void updateAutomaticSynchronizationIfEnabled(Consumer<DisplaySynchronizationManager> consumer) {
        VisDisplay2 visDisplay2;
        if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get() && (visDisplay2 = AbstractPDataAction.getCurrentDisplay()) != null) {
            consumer.accept(visDisplay2.getSynchronizationManager());
        }
    }

    public boolean isAutomaticSynchronizationPossible(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2, IFrameOfReferenceCheck iFrameOfReferenceCheck) {
        return AutomaticSynchronizationAnalyzer.isAutomaticSynchronizationPossible(iDisplaySet, iDisplaySet2, iFrameOfReferenceCheck);
    }

    public List<VisData> getCompatibleDisplaySets(VisData visData, List<VisDisplay2> list, CompatibilityMode compatibilityMode) {
        ArrayList<VisData> arrayList = new ArrayList<VisData>(list.size() + 1);
        IImageInformation iImageInformation = visData.getImageInformation();
        if (iImageInformation.is3D()) {
            return arrayList;
        }
        int n = iImageInformation.getRows();
        int n2 = iImageInformation.getColumns();
        double[] dArray = iImageInformation.getPixelSpacing();
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        Point3d point3d = iImageInformation.getPointOrigin();
        String string = iImageInformation.getModality();
        if (dArray == null || vector3d == null || point3d == null || string == null || !DoubleEquals.equals((double)dArray[0], (double)dArray[1], (double)1.0E-4)) {
            return arrayList;
        }
        VisDisplay2 visDisplay2 = visData.getParent().getVisDisplay();
        DisplaySynchronizationManager displaySynchronizationManager = visDisplay2.getSynchronizationManager();
        for (VisDisplay2 visDisplay22 : list) {
            ISynchronizationPosition iSynchronizationPosition;
            DisplaySynchronizationManager displaySynchronizationManager2 = visDisplay22.getSynchronizationManager();
            if (visDisplay22 == visDisplay2 || !visDisplay22.hasData() || !visDisplay22.getData().isDefaultPluginActive() || !AutomaticSynchronizationAnalyzer.isAutomaticSynchronizationPossible(displaySynchronizationManager2, displaySynchronizationManager, compatibilityMode.getFrameOfReferenceCheck()) || !((iSynchronizationPosition = displaySynchronizationManager2.searchAppropriateSynchronizationPosition(iImageInformation, compatibilityMode.isWorldToWorldTransformEnabled())) instanceof VisDataSynchronizationPosition)) continue;
            IImageInformation iImageInformation2 = ((VisDataSynchronizationPosition)iSynchronizationPosition).getImageInformation();
            double[] dArray2 = iImageInformation2.getPixelSpacing();
            if (compatibilityMode.isDimensionCheckEnabled() && (n != iImageInformation2.getRows() || n2 != iImageInformation2.getColumns()) || compatibilityMode.isDimensionCheckEnabled() && (!DoubleEquals.equals((double)dArray[0], (double)dArray2[0], (double)1.0E-4) || !DoubleEquals.equals((double)dArray[1], (double)dArray2[1], (double)1.0E-4)) || !DisplayLocalizerInfo.isParallel(vector3d, iImageInformation2.getPlaneNormalUV()) || !DoubleEquals.equals((double)dArray2[0], (double)dArray2[1], (double)1.0E-4)) continue;
            Point3d point3d2 = iImageInformation2.getPointOrigin();
            if (compatibilityMode.isDimensionCheckEnabled() && (!DoubleEquals.equals((double)point3d.x, (double)point3d2.x, (double)(dArray[1] / 2.0)) || !DoubleEquals.equals((double)point3d.y, (double)point3d2.y, (double)(dArray[0] / 2.0)))) continue;
            arrayList.add(visDisplay22.getVis(iSynchronizationPosition.getNavigationIndex()));
        }
        return arrayList;
    }

    void disableSynchronization() {
        for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
            for (VisDisplay2 visDisplay2 : visScreen2.getAllDisplays()) {
                visDisplay2.getSynchronizationManager().disableSynchronization();
            }
        }
    }

    public boolean toggleSynchronization(List<VisDisplay2> list) {
        Consumer<DisplaySynchronizationManager> consumer;
        boolean bl;
        boolean bl2 = bl = !SynchronizationManager.isAnySynchronized(list);
        if (list.size() == 1) {
            consumer = list.get(0);
            DisplaySynchronizationManager displaySynchronizationManager = ((VisDisplay2)((Object)consumer)).getSynchronizationManager();
            if (bl && !displaySynchronizationManager.isSynchronizationSupported()) {
                Message.info(MessageFormat.format(Messages.getString("SynchronizeDataAction.UnsupportedPlugin.Message"), ((VisDisplay2)((Object)consumer)).getData().getPlugin().getDescription()));
                return false;
            }
            if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get() && displaySynchronizationManager.handleManualSynchronizationDuringAutomaticSynchronization(bl)) {
                return true;
            }
        }
        if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get()) {
            LOGGER.info("Manual override of automatic synchronisation");
            Config.impaxee.jvision.SYNCHRONIZE.AutoSync.set(false);
        }
        consumer = !bl ? DisplaySynchronizationManager::disableSynchronization : (!this.getCurrentSynchronizationPositionOffset().hasLocationInformation() ? DisplaySynchronizationManager::enableSynchronizationWithCurrentNavigationPositionAsReferencePosition : DisplaySynchronizationManager::enableSynchronizationWithBestMatchAsReferencePosition);
        list.stream().map(VisDisplay2::getSynchronizationManager).forEach(consumer);
        return true;
    }

    private static boolean isAnySynchronized(List<VisDisplay2> list) {
        return list.stream().anyMatch(VisDisplay2::hasSynchronizedData);
    }

    public static enum CompatibilityMode {
        SAME_DIMENSION(OverlaySynchronizationMode.IMAGE_COORDINATES, FrameOfReferenceCheck.SAME_FRAME_OF_REFERENCE),
        SAME_FRAME_OF_REFERENCE(OverlaySynchronizationMode.WORLD_COORDINATES, FrameOfReferenceCheck.SAME_FRAME_OF_REFERENCE),
        FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE(OverlaySynchronizationMode.WORLD_COORDINATES, FrameOfReferenceCheck.createCheckWithReferenceTransform(DefaultWorldToWorldTransformer.INSTANCE));

        private final OverlaySynchronizationMode syncMode;
        private final IFrameOfReferenceCheck frameOfReferenceCheck;

        private CompatibilityMode(OverlaySynchronizationMode overlaySynchronizationMode, IFrameOfReferenceCheck iFrameOfReferenceCheck) {
            this.syncMode = overlaySynchronizationMode;
            this.frameOfReferenceCheck = iFrameOfReferenceCheck;
        }

        public OverlaySynchronizationMode getOverlaySynchronizationMode() {
            return this.syncMode;
        }

        IFrameOfReferenceCheck getFrameOfReferenceCheck() {
            return this.frameOfReferenceCheck;
        }

        boolean isDimensionCheckEnabled() {
            return this.syncMode != OverlaySynchronizationMode.WORLD_COORDINATES;
        }

        boolean isWorldToWorldTransformEnabled() {
            return this.frameOfReferenceCheck.getWorldToWorldTransformer() != null;
        }
    }
}

