/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformer;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IImagePlaneInformation;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class SynchronizationOrientationChecker {
    private static final ALogger LOGGER = ALogger.getLogger(SynchronizationOrientationChecker.class);
    private static final double orientationAngle = Math.cos(Math.PI / 180 * Config.impaxee.jvision.SYNCHRONIZE.OrientationAngle.get());

    private SynchronizationOrientationChecker() {
    }

    static boolean hasDifferentFrameOfReference(IImagePlaneInformation iImagePlaneInformation, IImagePlaneInformation iImagePlaneInformation2) {
        String string = iImagePlaneInformation.getFrameOfReferenceUID();
        String string2 = iImagePlaneInformation2.getFrameOfReferenceUID();
        return string != null && string2 != null && !string.equals(string2);
    }

    static boolean hasSameOrientation(IImagePlaneInformation iImagePlaneInformation, IImagePlaneInformation iImagePlaneInformation2) {
        return SynchronizationOrientationChecker.hasSameOrientation(iImagePlaneInformation, iImagePlaneInformation2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasSameOrientation(IImagePlaneInformation iImagePlaneInformation, IImagePlaneInformation iImagePlaneInformation2, IWorldToWorldTransformer iWorldToWorldTransformer) {
        Point3d point3d;
        Point3d point3d2;
        Vector3d vector3d;
        block3: {
            try {
                String string;
                String string2;
                vector3d = iImagePlaneInformation2.getPlaneNormalUV();
                if (iWorldToWorldTransformer == null || CompareUtils.equals((Object)(string2 = iImagePlaneInformation.getFrameOfReferenceUID()), (Object)(string = iImagePlaneInformation2.getFrameOfReferenceUID()))) return SynchronizationOrientationChecker.equalsOrientation(iImagePlaneInformation.getPlaneNormalUV(), vector3d);
                point3d2 = new Point3d((Tuple3d)vector3d);
                point3d = new Point3d();
                if (iWorldToWorldTransformer.convertPoint(point3d2, string, string2) && iWorldToWorldTransformer.convertPoint(point3d, string, string2)) break block3;
                return false;
            }
            catch (Exception exception) {
                LOGGER.error("Check for same orientation failed", (Throwable)exception);
                return false;
            }
        }
        vector3d = new Vector3d();
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        return SynchronizationOrientationChecker.equalsOrientation(iImagePlaneInformation.getPlaneNormalUV(), vector3d);
    }

    static boolean equalsOrientation(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d == null || vector3d2 == null) {
            LOGGER.debug("Orientation missing");
            return false;
        }
        if (vector3d.equals((Tuple3d)vector3d2)) {
            return true;
        }
        if (vector3d.dot(vector3d2) < orientationAngle) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Orientation difference exceeded: " + Math.acos(vector3d.dot(vector3d2)) / (Math.PI / 180));
            }
            return false;
        }
        return true;
    }
}

