/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.navigation.RelativeNavigationStep;
import com.agfa.pacs.impaxee.sync.DisplaySynchronizationManager;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.tiani.jvision.vis.event.IVisNavigationEventHandler;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import java.util.List;
import java.util.stream.Collectors;

class SynchronizationVisNavigationEventHandler
implements IVisNavigationEventHandler {
    private final DisplaySynchronizationManager masterSyncManager;
    private final List<DisplaySynchronizationManager> enabledDisplaySynchronizationManagers;

    SynchronizationVisNavigationEventHandler(DisplaySynchronizationManager displaySynchronizationManager) {
        this.masterSyncManager = displaySynchronizationManager;
        this.enabledDisplaySynchronizationManagers = SynchronizationManager.getInstance().getEnabledDisplaySynchronizationManagers().collect(Collectors.toList());
    }

    @Override
    public boolean handleNavigationEvent(VisNavigationEvent visNavigationEvent) {
        SynchronizationManager synchronizationManager = SynchronizationManager.getInstance();
        VisNavigationEvent.MoveEvent moveEvent = visNavigationEvent.getMoveEvent();
        if (VisNavigationEvent.MoveEvent.RELATIVE == moveEvent) {
            synchronizationManager.moveCurrentSynchronizationPosition(this.masterSyncManager, this.enabledDisplaySynchronizationManagers, RelativeNavigationStep.SINGLE_IMAGE, visNavigationEvent.getValue());
        } else if (VisNavigationEvent.MoveEvent.RELATIVE_SCREENWISE == moveEvent) {
            synchronizationManager.moveCurrentSynchronizationPosition(this.masterSyncManager, this.enabledDisplaySynchronizationManagers, RelativeNavigationStep.SCREENWISE, visNavigationEvent.getValue());
        } else {
            this.masterSyncManager.updateNavigationAndSynchronizationPositionsForAbsoluteNavigation(visNavigationEvent);
            synchronizationManager.setCurrentSynchronizationPositionOffsetBasedOn(this.masterSyncManager);
            for (DisplaySynchronizationManager displaySynchronizationManager : this.enabledDisplaySynchronizationManagers) {
                if (displaySynchronizationManager == this.masterSyncManager) continue;
                displaySynchronizationManager.synchronizeWithCurrentSynchronizationPosition();
            }
        }
        return true;
    }
}

