/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sync;

import com.agfa.pacs.impaxee.navigation.RelativeNavigationStep;
import com.agfa.pacs.impaxee.sync.IDisplaySynchronizationPositionHandler;
import com.agfa.pacs.impaxee.sync.ISynchronizableImageFrames;
import com.agfa.pacs.impaxee.sync.ISynchronizationPosition;
import com.agfa.pacs.impaxee.sync.VisDataSynchronizationPosition;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;

class VisDataSynchronizationPositionHandler
implements IDisplaySynchronizationPositionHandler {
    private final VisDisplay2 display;

    VisDataSynchronizationPositionHandler(VisDisplay2 visDisplay2) {
        this.display = visDisplay2;
    }

    @Override
    public ISynchronizableImageFrames getImageFrames() {
        return this.display.getData().getCurrentRun();
    }

    @Override
    public ISynchronizationPosition createSynchronizationPosition(int n) {
        VisData visData = this.display.getVis(n);
        if (visData == null) {
            return null;
        }
        return new VisDataSynchronizationPosition(visData, n);
    }

    @Override
    public ISynchronizationPosition createSynchronizationPosition(int n, RelativeNavigationStep relativeNavigationStep, int n2) {
        int n3 = this.display.getVisCount();
        int n4 = this.display.getVisViewCount();
        int n5 = n2;
        if (relativeNavigationStep == RelativeNavigationStep.SCREENWISE) {
            n5 *= n4;
        }
        int n6 = n + n5;
        if (n5 < 0 && n6 < n3 - 1 && n6 >= n3 - n4) {
            n6 = n3 - n4 - 1;
        }
        return this.createSynchronizationPosition(n6);
    }

    @Override
    public int getMaximumSynchronizationPositionIndex() {
        return this.display.getVisCount() - this.display.getVisViewCount();
    }

    @Override
    public boolean isReferencePosition(Vis2 vis2) {
        ISynchronizationPosition iSynchronizationPosition = this.display.getSynchronizationManager().getReferencePosition();
        return iSynchronizationPosition != null && iSynchronizationPosition.getVisual() == vis2;
    }
}

