/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.base.swing.util.ComponentUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.ui.ActionComponentFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.toolbar.ToolbarAction;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainer;
import com.agfa.pacs.impaxee.toolbar.ToolbarLayout;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Toolbar
extends JPanel {
    private static final ALogger log = ALogger.getLogger(Toolbar.class);
    public static final int HORZ_GAP = GUI.getScaledDiagnosticInt((int)2);
    public static final int MORE_BUTTON_WIDTH = GUI.getScaledDiagnosticInt((int)16);
    private static final int MORE_BUTTON_INSET = GUI.getScaledDiagnosticInt((int)2);
    public static final int DRAG_THUMB_WIDTH = GUI.getScaledDiagnosticInt((int)5);
    private static final int DRAG_THUMB_INSET = GUI.getScaledDiagnosticInt((int)2);
    private static final int RESIZE_THUMB_WIDTH = GUI.getScaledDiagnosticInt((int)16);
    private static final int RESIZE_THUMB_INSET = GUI.getScaledDiagnosticInt((int)2);
    private int monitorNumber;
    private ToolbarModel model;
    private LinkedHashMap<ToolbarAction, IActionUI> actionMap;
    private JButton moreButton;
    private Icon resizeIcon;
    private Icon resizeRolloverIcon;
    private ToolbarModelHandler modelHandler;
    private boolean editing;

    public Toolbar(int n, ToolbarModel toolbarModel) {
        super(new ToolbarLayout(toolbarModel.isResizeable(), HORZ_GAP));
        this.monitorNumber = n;
        this.model = toolbarModel;
        this.actionMap = new LinkedHashMap();
        this.modelHandler = new ToolbarModelHandler();
        this.moreButton = new MoreButton();
        this.moreButton.setName("ImageAreaButton");
        this.resizeIcon = this.createResizeThumbIcon(false);
        this.resizeRolloverIcon = this.createResizeThumbIcon(true);
        this.editing = false;
        this.setName(toolbarModel.getName());
        this.initActionUIMap();
        this.getModel().addModelListener(this.modelHandler);
        if (toolbarModel.isResizeable()) {
            this.addMouseListener(new MoreMenuHandler());
        }
        ToolbarHoverHandler toolbarHoverHandler = new ToolbarHoverHandler();
        this.addMouseListener(toolbarHoverHandler);
        this.addMouseMotionListener(toolbarHoverHandler);
    }

    public final ToolbarModel getModel() {
        return this.model;
    }

    public final void setModel(ToolbarModel toolbarModel) {
        ToolbarModel toolbarModel2 = this.getModel();
        if (toolbarModel2 != null) {
            toolbarModel2.removeModelListener(this.modelHandler);
        }
        this.model = toolbarModel;
        this.initActionUIMap();
        if (toolbarModel != null) {
            toolbarModel.addModelListener(this.modelHandler);
        }
    }

    @Override
    public final ToolbarLayout getLayout() {
        return (ToolbarLayout)super.getLayout();
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof ToolbarLayout)) {
            throw new UnsupportedOperationException("layout is not supported!");
        }
        super.setLayout(layoutManager);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
        for (IActionUI iActionUI : this.actionMap.values()) {
            if (this.editing) {
                JComponent jComponent = iActionUI.getComponent();
                jComponent.setEnabled(false);
                SwingUtilities2.setComponentHierarchyEnabled((Container)jComponent, (boolean)false, (Component[])new Component[0]);
                continue;
            }
            iActionUI.release();
            iActionUI.bind();
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isInDragArea(Point point) {
        if (this.isEditing() && this.model.isRelocatable()) {
            return this.getDragThumbShape().contains(point);
        }
        return false;
    }

    public boolean isInMoreBtnArea(Point point) {
        if (!this.isEditing()) {
            return this.getMoreButtonShape().contains(point);
        }
        return false;
    }

    public boolean isInResizeArea(Point point) {
        if (this.isEditing() && this.model.isResizeable()) {
            Shape shape = this.getResizeThumbShape();
            Rectangle rectangle = shape.getBounds();
            rectangle.width += GUI.getScaledDiagnosticInt((int)5);
            return rectangle.contains(point);
        }
        return false;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        this.updateInsets(insets);
        return insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets insets2 = super.getInsets(insets);
        this.updateInsets(insets2);
        return insets2;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model.isRelocatable() && this.isEditing()) {
            this.paintDragThumb(graphics);
        }
        if (this.model.isResizeable()) {
            if (this.isEditing()) {
                this.paintResizeThumb(graphics);
            } else if (!this.canAccommodateAllComponents()) {
                Shape shape = this.getMoreButtonShape();
                this.moreButton.setBounds(shape.getBounds());
                SwingUtilities.paintComponent(graphics, this.moreButton, this, shape.getBounds());
            }
        }
    }

    private void actionChanged(ToolbarAction toolbarAction) {
    }

    private void actionAdded(ToolbarAction toolbarAction) {
        if (!this.actionMap.containsKey(toolbarAction)) {
            try {
                IActionUI iActionUI;
                PAction pAction = this.resolveAction(toolbarAction);
                if (pAction != null && (iActionUI = ActionUIFactory.createUI(pAction, ActionUIScope.TopToolbar)) != null) {
                    this.actionMap.put(toolbarAction, iActionUI);
                    this.addToContainer(iActionUI.getComponent(), toolbarAction);
                }
            }
            catch (Exception exception) {
                log.error("Creating action-ui failed!", (Throwable)exception);
            }
        }
    }

    private void actionRemoved(ToolbarAction toolbarAction) {
        if (this.actionMap.containsKey(toolbarAction)) {
            IActionUI iActionUI = this.actionMap.get(toolbarAction);
            this.removeFromContainer(iActionUI.getComponent());
            this.actionMap.remove(toolbarAction);
            iActionUI.release();
        }
    }

    private void initActionUIMap() {
        for (IActionUI object2 : this.actionMap.values()) {
            object2.release();
        }
        this.actionMap.clear();
        this.removeAll();
        Collection<ToolbarAction> collection = this.getModel().getActions();
        for (Object toolbarAction : collection) {
            try {
                IActionUI iActionUI;
                PAction exception = this.resolveAction((ToolbarAction)toolbarAction);
                if (exception == null || (iActionUI = ActionUIFactory.createUI(exception, ActionUIScope.TopToolbar)) == null) continue;
                this.actionMap.put((ToolbarAction)toolbarAction, iActionUI);
                this.addToContainer(iActionUI.getComponent(), (ToolbarAction)toolbarAction);
            }
            catch (Exception exception) {
                log.error("Creating action-ui for action '" + ((PActionPersistenceRef)toolbarAction).getActionId() + "' failed! Action won't be visible in toolbar...", (Throwable)exception);
            }
        }
        this.revalidate();
    }

    private PAction resolveAction(ToolbarAction toolbarAction) {
        try {
            return toolbarAction.resolveAction(this.monitorNumber);
        }
        catch (ActionNotFoundException actionNotFoundException) {
            log.warn("Resolving action with id '" + toolbarAction.getActionId() + "' failed! Action is skipped...");
            return null;
        }
    }

    private void addToContainer(Component component, ToolbarAction toolbarAction) {
        this.add(component, toolbarAction.toLayoutConstraint());
    }

    private void removeFromContainer(Component component) {
        this.remove(component);
    }

    private boolean canAccommodateAllComponents() {
        if (this.model.isResizeable() && this.getComponentCount() > 0) {
            Insets insets = super.getInsets();
            if (this.model.isRelocatable()) {
                insets.left += DRAG_THUMB_WIDTH;
                insets.left += DRAG_THUMB_INSET * 2;
            }
            int n = this.getWidth() - insets.right;
            int n2 = insets.left;
            Component[] componentArray = this.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                if (component.isVisible()) {
                    int n5 = this.getLayout().getPreferredWidth(this, component);
                    if (n2 + n5 > n) {
                        return false;
                    }
                    n2 += n5 + HORZ_GAP;
                }
                ++n4;
            }
        }
        return true;
    }

    private void updateInsets(Insets insets) {
        if (this.model.isRelocatable()) {
            insets.left += DRAG_THUMB_WIDTH;
            insets.left += DRAG_THUMB_INSET * 2;
        }
        if (this.model.isResizeable()) {
            if (this.isEditing()) {
                insets.right += RESIZE_THUMB_WIDTH;
                insets.right += RESIZE_THUMB_INSET * 2;
            } else if (!this.canAccommodateAllComponents()) {
                insets.right += MORE_BUTTON_WIDTH;
                insets.right += MORE_BUTTON_INSET;
            }
        }
    }

    private void paintDragThumb(Graphics graphics) {
        Shape shape = this.getDragThumbShape();
        Rectangle rectangle = shape.getBounds();
        Color color = graphics.getColor();
        int n = GUI.getScaledDiagnosticInt((int)4);
        int n2 = n / 2;
        int n3 = rectangle.height / (n + n2);
        int n4 = rectangle.x + rectangle.width / 2 - n / 2;
        int n5 = rectangle.y + n / 2;
        graphics.setColor(ColorUtils.brighter((Color)this.getBackground(), (float)(this.isDragThumbRollover() ? 0.1f : 0.4f)));
        int n6 = 0;
        while (n6 < n3) {
            graphics.fill3DRect(n4, n5, n, n, false);
            n5 += n;
            n5 += n2;
            ++n6;
        }
        graphics.setColor(color);
    }

    private void paintResizeThumb(Graphics graphics) {
        Shape shape = this.getResizeThumbShape();
        Rectangle rectangle = shape.getBounds();
        boolean bl = this.isResizeThumbRollover();
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            GradientPaint gradientPaint = new GradientPaint(rectangle.x, 0.0f, this.getBackground(), rectangle.x + rectangle.width, 0.0f, ColorUtils.brighter((Color)this.getBackground(), (float)(bl ? 0.25f : 0.4f)));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setPaint(paint);
        }
        if (bl) {
            this.resizeRolloverIcon.paintIcon(this, graphics, rectangle.x + rectangle.width / 2 - this.resizeRolloverIcon.getIconWidth() / 2 + 2, rectangle.y + rectangle.height / 2 - this.resizeRolloverIcon.getIconHeight() / 2);
        } else {
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + rectangle.width / 2 - this.resizeIcon.getIconWidth() / 2 + 2, rectangle.y + rectangle.height / 2 - this.resizeIcon.getIconHeight() / 2);
        }
    }

    private boolean isMoreMenuRollover() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point point = pointerInfo.getLocation();
            Shape shape = this.getMoreButtonShape();
            SwingUtilities.convertPointFromScreen(point, this);
            return shape.contains(point);
        }
        return false;
    }

    private boolean isDragThumbRollover() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point point = pointerInfo.getLocation();
            Shape shape = this.getDragThumbShape();
            SwingUtilities.convertPointFromScreen(point, this);
            return shape.contains(point);
        }
        return false;
    }

    private boolean isResizeThumbRollover() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point point = pointerInfo.getLocation();
            Shape shape = this.getResizeThumbShape();
            SwingUtilities.convertPointFromScreen(point, this);
            return shape.contains(point);
        }
        return false;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.getParent() instanceof ToolbarContainer && mouseEvent.getID() != 505) {
            this.getParent().dispatchEvent(mouseEvent);
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.getParent() instanceof ToolbarContainer) {
            this.getParent().dispatchEvent(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private Shape getDragThumbShape() {
        Insets insets = super.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left + DRAG_THUMB_INSET;
        rectangle.y = insets.top + DRAG_THUMB_INSET;
        rectangle.width = DRAG_THUMB_WIDTH;
        rectangle.height = this.getHeight() - insets.top - insets.bottom - 2 * DRAG_THUMB_INSET;
        return rectangle;
    }

    private Shape getResizeThumbShape() {
        Insets insets = super.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getWidth() - insets.right - RESIZE_THUMB_WIDTH - RESIZE_THUMB_INSET;
        rectangle.y = insets.top + RESIZE_THUMB_INSET;
        rectangle.width = RESIZE_THUMB_WIDTH;
        rectangle.height = this.getHeight() - insets.top - insets.bottom - 2 * RESIZE_THUMB_INSET;
        return rectangle;
    }

    private Shape getMoreButtonShape() {
        Insets insets = super.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getWidth() - insets.right - MORE_BUTTON_WIDTH;
        rectangle.y = insets.top + MORE_BUTTON_INSET;
        rectangle.width = MORE_BUTTON_WIDTH;
        rectangle.height = this.getHeight() - insets.top - insets.bottom - MORE_BUTTON_INSET * 2;
        return rectangle;
    }

    private Icon createResizeThumbIcon(boolean bl) {
        return new ResizeThumbIcon(ColorUtils.brighter((Color)this.getBackground(), (float)(bl ? 0.1f : 0.25f)), (int)((double)RESIZE_THUMB_WIDTH * 0.25 + 0.5), 3);
    }

    private JPopupMenu createMoreMenu() throws Exception {
        Object object2;
        Object object3;
        Component component22;
        Collection<Component> collection = this.findMoreMenuComponents();
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        for (Component component22 : collection) {
            object3 = ComponentUtil.getComponentID((Component)component22);
            object2 = this.findToolbarActionForId((String)object3);
            if (object2 == null) continue;
            arrayList.add(this.actionMap.get(object2).getAction());
        }
        component22 = ActionComponentFactory.createPopupMenu(arrayList, ActionUIScope.TopToolbar);
        Map<Component, PAction> map = ActionUIUtilities.createComponentActionMap((Container)component22, arrayList);
        object3 = new HashMap();
        object2 = new HashMap();
        for (Map.Entry object4 : map.entrySet()) {
            if (ActionUIUtilities.isIconButtonAction((PAction)object4.getValue())) {
                object3.put((Component)object4.getKey(), (PAction)object4.getValue());
                continue;
            }
            object2.put((Component)object4.getKey(), (PAction)object4.getValue());
        }
        final IActionUI[] iActionUIArray = ActionUIFactory.createUIs((Map<Component, PAction>)object3, ActionUIScope.TopToolbar);
        final IActionUI[] iActionUIArray2 = ActionUIFactory.createUIs((Map<Component, PAction>)object2, ActionUIScope.VisMenu);
        ((JPopupMenu)component22).addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.cleanup((JPopupMenu)popupMenuEvent.getSource());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.cleanup((JPopupMenu)popupMenuEvent.getSource());
            }

            private void cleanup(JPopupMenu jPopupMenu) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IActionUI iActionUI;
                        IActionUI[] iActionUIArray3 = iActionUIArray;
                        int n = iActionUIArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            iActionUI = iActionUIArray3[n2];
                            iActionUI.release();
                            ++n2;
                        }
                        iActionUIArray3 = iActionUIArray2;
                        n = iActionUIArray2.length;
                        n2 = 0;
                        while (n2 < n) {
                            iActionUI = iActionUIArray3[n2];
                            iActionUI.release();
                            ++n2;
                        }
                        Toolbar.this.repaint();
                    }
                });
            }
        });
        return component22;
    }

    private Collection<Component> findMoreMenuComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        int n = this.getComponentCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Component component = this.getComponent(n2);
                if (component.isVisible()) {
                    Dimension dimension = component.getSize();
                    if (dimension.width == 0 && dimension.height == 0) {
                        arrayList.add(component);
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private ToolbarAction findToolbarActionForId(String string) {
        if (string != null) {
            for (ToolbarAction toolbarAction : this.actionMap.keySet()) {
                if (!toolbarAction.getActionId().equals(string)) continue;
                return toolbarAction;
            }
        }
        return null;
    }

    private static class MoreArrowIcon
    implements Icon {
        protected Color c;
        private int width;
        private int height;

        public MoreArrowIcon(Color color, int n, int n2) {
            this.c = color;
            this.width = n;
            this.height = n2;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            Insets insets = component instanceof JComponent ? ((JComponent)component).getInsets() : null;
            n2 = component.getHeight() - n4 - (insets != null ? insets.bottom : 0) - 2;
            graphics.setColor(this.c);
            int n5 = (int)((double)n4 * 0.3 + 0.5);
            graphics.fillRect(n, n2, n3, n5);
            int n6 = (int)((double)n4 * 0.2 + 0.5);
            graphics.fillPolygon(new int[]{n, n + n3 / 2, n + n3}, new int[]{n2 += n5 + n6, n2 + (n4 -= n5 + n6), n2}, 3);
            graphics.setColor(color);
        }
    }

    private class MoreButton
    extends JButton {
        public MoreButton() {
            this.setIcon(new MoreArrowIcon(this.getMoreArrowColor(false, false), (int)((double)MORE_BUTTON_WIDTH * 0.4 + 0.5), (int)((double)MORE_BUTTON_WIDTH * 0.4 + 0.5)));
            this.setRolloverIcon(new MoreArrowIcon(this.getMoreArrowColor(true, false), (int)((double)MORE_BUTTON_WIDTH * 0.4 + 0.5), (int)((double)MORE_BUTTON_WIDTH * 0.4 + 0.5)));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Icon icon;
            super.paintComponent(graphics);
            boolean bl = Toolbar.this.isMoreMenuRollover();
            Insets insets = super.getInsets();
            Icon icon2 = icon = bl ? this.getRolloverIcon() : this.getIcon();
            if (icon != null) {
                icon.paintIcon(this, graphics, this.getWidth() - insets.right - MORE_BUTTON_WIDTH / 2 - icon.getIconWidth() / 2 + 2, this.getHeight() - insets.bottom - icon.getIconHeight() - 2);
            }
        }

        private Color getMoreArrowColor(boolean bl, boolean bl2) {
            Color color = this.getBackground();
            boolean bl3 = ColorUtils.isBright((Color)color);
            if (bl2) {
                return bl3 ? ColorUtils.darker((Color)color, (float)0.9f) : ColorUtils.brighter((Color)color, (float)0.5f);
            }
            if (bl) {
                return bl3 ? ColorUtils.darker((Color)color, (float)0.9f) : ColorUtils.brighter((Color)color, (float)0.2f);
            }
            return bl3 ? ColorUtils.darker((Color)color, (float)0.75f) : ColorUtils.brighter((Color)color, (float)0.275f);
        }
    }

    private class MoreMenuHandler
    extends MouseAdapter {
        private MoreMenuHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Shape shape;
            if (!Toolbar.this.canAccommodateAllComponents() && (shape = Toolbar.this.getMoreButtonShape()).contains(mouseEvent.getPoint())) {
                try {
                    JPopupMenu jPopupMenu = Toolbar.this.createMoreMenu();
                    jPopupMenu.pack();
                    Point point = new Point(shape.getBounds().x, shape.getBounds().height);
                    SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                    jPopupMenu.show(Toolbar.this, shape.getBounds().x, shape.getBounds().height);
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
        }
    }

    private static class ResizeThumbIcon
    implements Icon {
        protected Color c;
        private int width;
        private int gap;

        public ResizeThumbIcon(Color color, int n, int n2) {
            this.c = color;
            this.width = n;
            this.gap = n2;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return 3 * this.width + this.gap;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            graphics.setColor(this.c);
            graphics.fillPolygon(new int[]{n, n + n3, n + n3}, new int[]{n2 + n3, n2, n2 + n3 * 2}, 3);
            graphics.fillPolygon(new int[]{n, n + n3, n}, new int[]{n2 += n3 + this.gap, n2 + n3, n2 + n3 * 2}, 3);
            graphics.setColor(color);
        }
    }

    private class ToolbarHoverHandler
    extends MouseAdapter {
        private ToolbarHoverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Toolbar.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Toolbar.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Toolbar.this.repaint();
        }
    }

    private class ToolbarModelHandler
    implements ToolbarModel.IToolbarModelListener {
        private ToolbarModelHandler() {
        }

        @Override
        public void actionsChanged(ToolbarModel toolbarModel, Collection<ToolbarAction> collection) {
            Toolbar.this.initActionUIMap();
        }

        @Override
        public void actionChanged(ToolbarAction toolbarAction, ToolbarModel toolbarModel) {
            Toolbar.this.actionChanged(toolbarAction);
        }

        @Override
        public void actionAdded(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
            Toolbar.this.actionAdded(toolbarAction);
        }

        @Override
        public void actionRemoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
            Toolbar.this.actionRemoved(toolbarAction);
        }

        @Override
        public void actionMoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction, int n) {
            Toolbar.this.initActionUIMap();
        }

        @Override
        public void layoutConstraintChanged(ToolbarModel toolbarModel) {
        }
    }
}

