/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.DummyPDataProvider;
import com.agfa.pacs.impaxee.toolbar.ToolbarLayoutConstraint;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ToolbarAction
extends PActionPersistenceRef {
    static final String XML_ELEMENT_NAME = "action-ref";
    private static final String COLUMN_XML_ATTR_NAME = "column";
    private static final String WIDTH_XML_ATTR_NAME = "width";
    private static final String REMOVABLE_XML_ATTR_NAME = "removable";
    private static final String CONCEALABLE_XML_ATTR_NAME = "concealable";
    private static final Map<String, String> RENAMED_ACTIONS = new HashMap<String, String>(3);
    private String toolbarName;
    private int column;
    private double width;
    private boolean removable;
    private boolean concealable;
    private boolean modified;
    private Collection<ToolbarActionListener> listeners;

    static {
        RENAMED_ACTIONS.put("WINDOWLEVEL_GROUP", "WINDOWLEVEL_GROUP@" + PDataScope.CurrentDisplay.name());
    }

    public ToolbarAction(String string, String string2, int n, double d, boolean bl, boolean bl2) {
        super(ToolbarAction.encodeActionId(string2));
        this.toolbarName = string;
        this.column = n;
        this.width = d;
        this.removable = bl;
        this.concealable = bl2;
        this.modified = false;
    }

    public ToolbarAction(String string, String string2, int n) {
        this(string, string2, n, ToolbarAction.getDefaultWidth(), true, true);
    }

    public static ToolbarAction create(String string, Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = namedNodeMap.getNamedItem("id").getNodeValue();
        if (RENAMED_ACTIONS.containsKey(string2)) {
            string2 = RENAMED_ACTIONS.get(string2);
        }
        int n = Integer.valueOf(namedNodeMap.getNamedItem(COLUMN_XML_ATTR_NAME).getNodeValue());
        double d = ToolbarAction.containsNode(namedNodeMap, WIDTH_XML_ATTR_NAME) ? Double.valueOf(namedNodeMap.getNamedItem(WIDTH_XML_ATTR_NAME).getNodeValue()) : ToolbarAction.getDefaultWidth();
        boolean bl = ToolbarAction.containsNode(namedNodeMap, REMOVABLE_XML_ATTR_NAME) ? Boolean.valueOf(namedNodeMap.getNamedItem(REMOVABLE_XML_ATTR_NAME).getNodeValue()) : true;
        boolean bl2 = ToolbarAction.containsNode(namedNodeMap, CONCEALABLE_XML_ATTR_NAME) ? Boolean.valueOf(namedNodeMap.getNamedItem(CONCEALABLE_XML_ATTR_NAME).getNodeValue()) : true;
        return new ToolbarAction(string, string2, n, d, bl, bl2);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isConcealable() {
        return this.concealable;
    }

    public String getToolbarName() {
        return this.toolbarName;
    }

    public void setToolbarName(String string) {
        if (!this.toolbarName.equals(string)) {
            this.toolbarName = string;
            this.modified = true;
            this.fireActionChanged();
        }
    }

    public PAction resolveAction(Integer n) throws ActionNotFoundException {
        VisScreen2 visScreen2 = n != null ? JVision2.getMainFrame().getAllScreens().get(n) : null;
        return PActionRegistry.getAction(ToolbarAction.decodeActionId(this.getActionId()), visScreen2 == null ? new DummyPDataProvider(PDataProvider.ProviderType.Screen) : visScreen2);
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        if (this.column != n) {
            this.column = n;
            this.modified = true;
            this.fireActionChanged();
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        if (this.width != d) {
            this.width = d;
            this.modified = true;
            this.fireActionChanged();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ToolbarAction) {
            ToolbarAction toolbarAction = (ToolbarAction)object;
            return this.getActionId().equals(toolbarAction.getActionId()) && this.getToolbarName().equals(toolbarAction.getToolbarName());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.getActionId());
        hashCodeBuilder.append((Object)this.getToolbarName());
        return hashCodeBuilder.toHashCode();
    }

    public ToolbarAction copy() {
        return new ToolbarAction(this.getToolbarName(), this.getActionId(), this.getColumn(), this.getWidth(), this.isRemovable(), this.isConcealable());
    }

    public void update(ToolbarAction toolbarAction) {
        if (!this.toolbarName.equals(toolbarAction.toolbarName)) {
            this.toolbarName = toolbarAction.toolbarName;
            this.modified = true;
        }
        if (this.column != toolbarAction.column) {
            this.column = toolbarAction.column;
            this.modified = true;
        }
        if (this.width != toolbarAction.width) {
            this.width = toolbarAction.width;
            this.modified = true;
        }
        if (this.modified) {
            this.fireActionChanged();
        }
    }

    public void addActionListener(ToolbarActionListener toolbarActionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ToolbarActionListener>();
        }
        if (!this.listeners.contains(toolbarActionListener)) {
            this.listeners.add(toolbarActionListener);
        }
    }

    public void removeActionListener(ToolbarActionListener toolbarActionListener) {
        if (this.listeners != null) {
            this.listeners.remove(toolbarActionListener);
        }
    }

    @Override
    public String toXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.getXmlElementName());
        String string2 = this.attrsToXML();
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(">");
        String string3 = this.childrenToXML();
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getXmlElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public ToolbarLayoutConstraint toLayoutConstraint() {
        return new ToolbarLayoutConstraint(this.column, this.width > 1.0 ? (double)GUI.getScaledDiagnosticInt((int)((int)this.width)) : this.width, this.concealable);
    }

    protected String getXmlElementName() {
        return XML_ELEMENT_NAME;
    }

    protected String childrenToXML() {
        return null;
    }

    @Override
    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(" ");
        stringBuilder.append("id");
        stringBuilder.append("=\"");
        stringBuilder.append(ToolbarAction.decodeActionId(this.getActionId()));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(COLUMN_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Integer.toString(this.column));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(WIDTH_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Double.toString(this.width));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(REMOVABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.removable));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(CONCEALABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.concealable));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static double getDefaultWidth() {
        return -1.0;
    }

    private static String encodeActionId(String string) {
        if ("SEPARATOR".equals(string)) {
            return String.valueOf(string) + '-' + ThreadLocalRandom.current().nextInt();
        }
        return string;
    }

    private static String decodeActionId(String string) {
        if (string.startsWith("SEPARATOR")) {
            return "SEPARATOR";
        }
        return string;
    }

    private static boolean containsNode(NamedNodeMap namedNodeMap, String string) {
        return namedNodeMap.getNamedItem(string) != null;
    }

    private void fireActionChanged() {
        if (this.listeners != null) {
            for (ToolbarActionListener toolbarActionListener : this.listeners) {
                toolbarActionListener.actionChanged(this);
            }
        }
    }

    public static interface ToolbarActionListener {
        public void actionChanged(ToolbarAction var1);
    }
}

