/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.toolbar.Toolbar;
import com.agfa.pacs.impaxee.toolbar.ToolbarAction;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainerLayout;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainerLayoutConstraint;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ToolbarContainer
extends JPanel {
    private static final int DROP_INDICATOR_WIDTH = GUI.getScaledDiagnosticInt((int)4);
    private static final int ROW_HEIGHT = PActionIconFactory.LARGE_ICON_HEIGHT + GUI.getScaledDiagnosticInt((int)10);
    private static final int HORZ_ROW_GAP = GUI.getScaledDiagnosticInt((int)12);
    private static final int VERT_ROW_GAP = GUI.getScaledDiagnosticInt((int)2);
    private static final int MAX_NUMBER_OF_ROWS = 2;
    private ToolbarDragHandler dragHandler;
    private ToolbarResizeHandler resizeHandler;
    private ToolbarModelHandler toolbarModelHandler = new ToolbarModelHandler();
    private boolean editing = false;

    public ToolbarContainer() {
        this.dragHandler = new ToolbarDragHandler();
        this.resizeHandler = new ToolbarResizeHandler();
        this.dragHandler.register(this);
        this.resizeHandler.register(this);
        this.setLayout(new ToolbarContainerLayout(ROW_HEIGHT, HORZ_ROW_GAP, VERT_ROW_GAP));
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public int getNumberOfRows() {
        return this.getLastRow() + 1;
    }

    public List<Toolbar> getToolbars() {
        ArrayList<Toolbar> arrayList = new ArrayList<Toolbar>();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof Toolbar) {
                arrayList.add((Toolbar)component);
            }
            ++n2;
        }
        Collections.sort(arrayList, new Comparator<Toolbar>(){

            @Override
            public int compare(Toolbar toolbar, Toolbar toolbar2) {
                int n = toolbar.getLocation().x;
                int n2 = toolbar2.getLocation().x;
                int n3 = Integer.compare(n, n2);
                return n3 != 0 ? n3 : 1;
            }
        });
        return arrayList;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        Rectangle rectangle = this.dragHandler.getNearestDropBounds();
        Rectangle rectangle2 = this.dragHandler.getDragBounds();
        if (rectangle != null) {
            graphics.setColor(this.getDropIndicatorColor());
            graphics.fillRoundRect(rectangle.x, rectangle.y + 2, DROP_INDICATOR_WIDTH, rectangle.height - 4, 2, 2);
        }
        if (rectangle2 != null) {
            Graphics2D graphics2D = (Graphics2D)(graphics instanceof Graphics2D ? graphics : graphics.create());
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f}, 0.0f);
            graphics2D.setColor(this.getDragOutlineColor());
            graphics2D.setStroke(basicStroke);
            graphics2D.drawRoundRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 10, 10);
        }
        graphics.setColor(color);
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component instanceof Toolbar) {
            ((Toolbar)component).getModel().removeModelListener(this.toolbarModelHandler);
        }
        super.remove(n);
        this.updateSize();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateSize();
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
        for (Toolbar toolbar : this.getToolbars()) {
            toolbar.setEditing(bl);
        }
    }

    private int getLastRow() {
        int n = 0;
        for (Toolbar toolbar : this.getToolbars()) {
            int n2 = toolbar.getModel().getLayoutConstraint().getRow();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getRowAt(int n) {
        return (n - this.getInsets().top) / (ROW_HEIGHT + VERT_ROW_GAP);
    }

    private Rectangle getRowBounds(int n) {
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top + n * (ROW_HEIGHT + VERT_ROW_GAP);
        rectangle.width = this.getWidth() - insets.right;
        rectangle.height = ROW_HEIGHT;
        return rectangle;
    }

    private List<Toolbar> getToolbarsInRow(int n) {
        ArrayList<Toolbar> arrayList = new ArrayList<Toolbar>();
        for (Toolbar toolbar : this.getToolbars()) {
            if (toolbar.getModel().getLayoutConstraint().getRow() != n) continue;
            arrayList.add(toolbar);
        }
        return arrayList;
    }

    private ToolbarContainerLayoutConstraint checkToSetLayoutConstraint(Toolbar toolbar) {
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = toolbar.getModel().getLayoutConstraint();
        if (toolbarContainerLayoutConstraint == null) {
            toolbarContainerLayoutConstraint = this.createBottomRightLayoutConstraint();
            toolbar.getModel().setLayoutConstraint(toolbarContainerLayoutConstraint);
        }
        return toolbarContainerLayoutConstraint;
    }

    private ToolbarContainerLayoutConstraint createBottomRightLayoutConstraint() {
        int n = this.getLastRow();
        double d = 0.0;
        if (n >= 0) {
            List<Toolbar> list = this.getToolbarsInRow(n);
            for (Toolbar toolbar : list) {
                double d2 = toolbar.getModel().getLayoutConstraint().getPosition();
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return ToolbarContainerLayoutConstraint.create(n, d + 0.01, -1.0, ToolbarContainerLayoutConstraint.Anchor.left);
    }

    @Override
    protected final void addImpl(Component component, Object object, int n) {
        if (this.getLayout() instanceof ToolbarContainerLayout) {
            ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = null;
            toolbarContainerLayoutConstraint = component instanceof Toolbar ? this.checkToSetLayoutConstraint((Toolbar)component) : this.createBottomRightLayoutConstraint();
            super.addImpl(component, toolbarContainerLayoutConstraint, n);
        } else {
            super.addImpl(component, object, n);
        }
        if (component instanceof Toolbar) {
            ((Toolbar)component).getModel().addModelListener(this.toolbarModelHandler);
        }
        this.updateSize();
    }

    private Color getDropIndicatorColor() {
        Color color = this.getDragOutlineColor();
        return color.brighter();
    }

    private Color getDragOutlineColor() {
        Color color = UIManager.getColor("ToolBar.foreground");
        if (color == null) {
            color = UIManager.getColor("controlText");
        }
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    private void updateSize() {
        int n = this.getNumberOfRows();
        this.setPreferredSize(new Dimension(100, this.getInsets().top + this.getInsets().bottom + n * ROW_HEIGHT + (n - 1) * VERT_ROW_GAP));
    }

    private void resizeToolbar(Toolbar toolbar, int n) {
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint;
        int n2 = toolbar.getWidth();
        if (n2 != n && (toolbarContainerLayoutConstraint = toolbar.getModel().getLayoutConstraint()) != null) {
            toolbarContainerLayoutConstraint.setPreferredWidth(n);
            this.revalidate();
            this.repaint();
        }
    }

    private Rectangle findNearestDropBounds(Toolbar toolbar, int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = this.getRowAt(n2);
        if (n6 != (n4 = toolbar.getModel().getLayoutConstraint().getRow()) && !((ToolbarContainerLayout)this.getLayout()).fitsIntoRow(this, toolbar, n6)) {
            return toolbar.getBounds();
        }
        Rectangle rectangle = this.getRowBounds(n6);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        List<Toolbar> list = this.getToolbarsInRow(n6);
        for (Toolbar toolbar2 : list) {
            arrayList.add(toolbar2.getLocation().x + toolbar2.getWidth() + HORZ_ROW_GAP - 1);
        }
        int n7 = GUI.getScaledDiagnosticInt((int)30);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Integer n8 = (Integer)iterator.next();
            if (n < n8 - n7 || n > n8 + n7) continue;
            n5 = n8;
            break;
        }
        if (n5 < 0) {
            n5 = n;
        }
        int n9 = rectangle.width - Toolbar.DRAG_THUMB_WIDTH;
        n5 = Math.min(n5, n9);
        Iterator iterator2 = iterator = !list.isEmpty() ? list.get(list.size() - 1) : null;
        if (iterator != null && n5 >= (n3 = ((Component)((Object)iterator)).getLocation().x) && n3 + ((JComponent)((Object)iterator)).getWidth() + HORZ_ROW_GAP - 1 > n9) {
            return toolbar.getBounds();
        }
        return new Rectangle(n5, rectangle.y, 0, rectangle.height);
    }

    /*
     * WARNING - void declaration
     */
    private void moveToolbarToRow(Toolbar toolbar, int n, int n2) {
        void var9_14;
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = toolbar.getModel().getLayoutConstraint();
        int n3 = toolbar.getModel().getLayoutConstraint().getRow();
        int n4 = Math.min(1, this.getRowAt(n2));
        List<Toolbar> list = this.getToolbarsInRow(n4);
        HashMap<Toolbar, Rectangle> hashMap = new HashMap<Toolbar, Rectangle>();
        for (Toolbar map2 : list) {
            hashMap.put(map2, map2.getBounds());
        }
        Object var9_11 = null;
        if (n3 == n4) {
            Map<? extends Component, Rectangle> map = ((ToolbarContainerLayout)this.getLayout()).moveToRow(this, toolbar, hashMap, n4, n);
        } else {
            Map<? extends Component, Rectangle> map = ((ToolbarContainerLayout)this.getLayout()).moveToRow(this, toolbar, hashMap, n4, n);
            toolbarContainerLayoutConstraint.setRow(n4);
        }
        Insets insets = this.getInsets();
        for (Map.Entry entry : var9_14.entrySet()) {
            ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint2 = ((Toolbar)entry.getKey()).getModel().getLayoutConstraint();
            int n5 = ((Rectangle)entry.getValue()).x - insets.left;
            int n6 = ((Rectangle)entry.getValue()).width;
            if (toolbarContainerLayoutConstraint2.getPreferredPosition() != (double)n5) {
                ToolbarContainerLayoutConstraint.Anchor anchor = toolbarContainerLayoutConstraint2.getAnchor();
                if (ToolbarContainerLayoutConstraint.Anchor.center.equals((Object)anchor)) {
                    n5 += n6 / 2;
                } else if (ToolbarContainerLayoutConstraint.Anchor.right.equals((Object)anchor)) {
                    n5 += n6;
                }
                toolbarContainerLayoutConstraint2.setPreferredPosition(n5);
            }
            if (toolbarContainerLayoutConstraint2.getWidth() == (double)n6 || n6 >= ((Component)entry.getKey()).getPreferredSize().width) continue;
            toolbarContainerLayoutConstraint2.setPreferredWidth(n6);
        }
        this.revalidate();
        this.repaint();
    }

    private int moveToolbarInRow(Toolbar toolbar, int n, boolean bl) {
        int n2;
        List<Toolbar> list = this.getToolbarsInRow(toolbar.getModel().getLayoutConstraint().getRow());
        HashMap<Toolbar, Rectangle> hashMap = new HashMap<Toolbar, Rectangle>();
        for (Toolbar toolbar2 : list) {
            hashMap.put(toolbar2, toolbar2.getBounds());
        }
        int n3 = n2 = bl ? ((ToolbarContainerLayout)this.getLayout()).moveLeft(this, toolbar, hashMap, n, true) : ((ToolbarContainerLayout)this.getLayout()).moveRight(this, toolbar, hashMap, n, true);
        if (n2 > 0) {
            Insets insets = this.getInsets();
            for (Map.Entry entry : hashMap.entrySet()) {
                ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = ((Toolbar)entry.getKey()).getModel().getLayoutConstraint();
                int n4 = ((Rectangle)entry.getValue()).x - insets.left;
                int n5 = ((Rectangle)entry.getValue()).width;
                if (toolbarContainerLayoutConstraint.getPreferredPosition() != (double)n4) {
                    ToolbarContainerLayoutConstraint.Anchor anchor = toolbarContainerLayoutConstraint.getAnchor();
                    if (ToolbarContainerLayoutConstraint.Anchor.center.equals((Object)anchor)) {
                        n4 += n5 / 2;
                    } else if (ToolbarContainerLayoutConstraint.Anchor.right.equals((Object)anchor)) {
                        n4 += n5;
                    }
                    toolbarContainerLayoutConstraint.setPreferredPosition(n4);
                }
                if (toolbarContainerLayoutConstraint.getWidth() == (double)n5 || n5 >= ((Toolbar)entry.getKey()).getPreferredSize().width) continue;
                toolbarContainerLayoutConstraint.setPreferredWidth(n5);
            }
            this.revalidate();
            this.repaint();
        }
        return n2;
    }

    private static class ToolbarDragHandler
    extends MouseAdapter {
        private boolean canStartDraging = false;
        private boolean isDraging = false;
        private Rectangle nearestDropBounds;
        private Rectangle dragBounds;
        private int lastDragX;
        private int dragStartXOff;
        private int dragStartYOff;
        private int dragStartRow;
        private boolean dragInRow;
        private ToolbarContainer container;
        private Toolbar curToolbar;
        private Cursor dragCursor = Cursor.getPredefinedCursor(13);

        private ToolbarDragHandler() {
        }

        public void register(ToolbarContainer toolbarContainer) {
            if (this.container != null) {
                this.unregister();
            }
            this.container = toolbarContainer;
            if (this.container != null) {
                this.container.addMouseListener(this);
                this.container.addMouseMotionListener(this);
            }
        }

        public void unregister() {
            if (this.container != null) {
                this.container.removeMouseListener(this);
                this.container.removeMouseMotionListener(this);
            }
        }

        public Rectangle getNearestDropBounds() {
            return this.dragInRow ? null : this.nearestDropBounds;
        }

        public Rectangle getDragBounds() {
            return this.dragInRow ? null : this.dragBounds;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Component component = mouseEvent.getComponent();
            if (this.container == component && !(rectangle = new Rectangle(1, 1, component.getWidth() - 1, component.getHeight() - 1)).contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.canStartDraging = false;
                if (this.isDraging) {
                    this.isDraging = false;
                    this.finishDraging(this.curToolbar, mouseEvent);
                }
                this.resetCursor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDraging) {
                this.isDraging = false;
                this.finishDraging(this.curToolbar, mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.canStartDraging && !this.isDraging) {
                this.isDraging = true;
                this.startDraging(this.curToolbar, mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.canStartDraging || this.isDraging) {
                if (!this.isDraging) {
                    this.isDraging = true;
                    this.startDraging(this.curToolbar, mouseEvent);
                } else {
                    this.handleDraging(this.curToolbar, mouseEvent);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            for (Toolbar toolbar : this.container.getToolbars()) {
                Point point = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
                SwingUtilities.convertPointFromScreen(point, toolbar);
                if (!toolbar.getModel().isRelocatable() || !toolbar.isInDragArea(point)) continue;
                this.canStartDraging = true;
                this.curToolbar = toolbar;
                this.setDragCursor();
                return;
            }
            if (this.canStartDraging || this.curToolbar != null) {
                this.canStartDraging = false;
                this.curToolbar = null;
                this.resetCursor();
            }
        }

        private void startDraging(Toolbar toolbar, MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(point, this.container);
            this.dragStartRow = this.container.getRowAt(point.y);
            this.dragStartXOff = point.x - toolbar.getX();
            this.dragStartYOff = point.y - toolbar.getY();
            this.lastDragX = point.x;
            this.nearestDropBounds = new Rectangle(toolbar.getBounds());
            this.dragBounds = new Rectangle(toolbar.getBounds());
            this.container.repaint();
        }

        private void handleDraging(Toolbar toolbar, MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(point, this.container);
            int n = this.container.getRowAt(point.y);
            Rectangle rectangle = this.container.getRowBounds(n);
            if (this.dragInRow) {
                int n2;
                if (n != this.dragStartRow || !rectangle.contains(point.x, point.y)) {
                    this.dragInRow = false;
                }
                if (this.dragInRow && (n2 = Math.abs(point.x - this.lastDragX)) > 0) {
                    boolean bl = this.dragInRow = this.container.moveToolbarInRow(toolbar, n2, point.x < this.lastDragX) > 0;
                }
            }
            if (!this.dragInRow) {
                this.dragToolbar(toolbar, point);
            }
            this.lastDragX = point.x;
            this.dragBounds.x = point.x - this.dragStartXOff;
            this.dragBounds.y = point.y - this.dragStartYOff;
            this.container.revalidate();
            this.container.repaint();
        }

        public void dragToolbar(Toolbar toolbar, Point point) {
            Rectangle rectangle;
            if (this.container.getNumberOfRows() < 2) {
                int n = ROW_HEIGHT / 3;
                if (point.y >= this.container.getHeight() - n) {
                    this.container.setPreferredSize(new Dimension(100, this.container.getHeight() + ROW_HEIGHT + VERT_ROW_GAP));
                }
            }
            if ((rectangle = this.container.findNearestDropBounds(toolbar, point.x, point.y)) != null) {
                this.nearestDropBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private void finishDraging(Toolbar toolbar, MouseEvent mouseEvent) {
            if (!this.dragInRow) {
                this.container.moveToolbarToRow(toolbar, this.nearestDropBounds.x, this.nearestDropBounds.y);
            }
            this.dragStartXOff = 0;
            this.dragStartYOff = 0;
            this.lastDragX = 0;
            this.nearestDropBounds = null;
            this.dragBounds = null;
            this.container.updateSize();
            this.container.revalidate();
            this.container.repaint();
        }

        private void resetCursor() {
            this.container.setCursor(Cursor.getDefaultCursor());
        }

        private void setDragCursor() {
            this.container.setCursor(this.dragCursor);
        }
    }

    private class ToolbarModelHandler
    implements ToolbarModel.IToolbarModelListener {
        private ToolbarModelHandler() {
        }

        @Override
        public void actionsChanged(ToolbarModel toolbarModel, Collection<ToolbarAction> collection) {
        }

        @Override
        public void actionChanged(ToolbarAction toolbarAction, ToolbarModel toolbarModel) {
        }

        @Override
        public void actionAdded(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
        }

        @Override
        public void actionRemoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
        }

        @Override
        public void actionMoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction, int n) {
        }

        @Override
        public void layoutConstraintChanged(ToolbarModel toolbarModel) {
            ToolbarContainer.this.revalidate();
            ToolbarContainer.this.repaint();
        }
    }

    private static class ToolbarResizeHandler
    extends MouseAdapter {
        private boolean canStartResizing = false;
        private boolean isResizing = false;
        private int resizeStartWidth;
        private int resizeStartX;
        private ToolbarContainer container;
        private Toolbar curToolbar;
        private Cursor resizeCursor = Cursor.getPredefinedCursor(11);

        private ToolbarResizeHandler() {
        }

        public void register(ToolbarContainer toolbarContainer) {
            if (this.container != null) {
                this.unregister();
            }
            this.container = toolbarContainer;
            if (this.container != null) {
                this.container.addMouseListener(this);
                this.container.addMouseMotionListener(this);
            }
        }

        public void unregister() {
            if (this.container != null) {
                this.container.removeMouseListener(this);
                this.container.removeMouseMotionListener(this);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Component component = mouseEvent.getComponent();
            if (!(this.container != component || (rectangle = new Rectangle(1, 1, component.getWidth() - 1, component.getHeight() - 1)).contains(mouseEvent.getX(), mouseEvent.getY()) && this.findResizableToolbar(new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen())) != null)) {
                this.canStartResizing = false;
                if (this.isResizing) {
                    this.isResizing = false;
                    this.finishResizing(this.curToolbar, mouseEvent);
                }
                this.resetCursor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isResizing) {
                this.isResizing = false;
                this.finishResizing(this.curToolbar, mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.canStartResizing && !this.isResizing) {
                this.isResizing = true;
                this.startResizing(this.curToolbar, mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.canStartResizing || this.isResizing) {
                if (!this.isResizing) {
                    this.isResizing = true;
                    this.startResizing(this.curToolbar, mouseEvent);
                } else {
                    this.handleResizing(this.curToolbar, mouseEvent);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Toolbar toolbar = this.findResizableToolbar(new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen()));
            if (toolbar != null) {
                this.canStartResizing = true;
                this.curToolbar = toolbar;
                this.setResizeCursor();
                return;
            }
            if (this.canStartResizing || this.curToolbar != null) {
                this.canStartResizing = false;
                this.curToolbar = null;
                this.resetCursor();
            }
        }

        private Toolbar findResizableToolbar(Point point) {
            for (Toolbar toolbar : this.container.getToolbars()) {
                Point point2 = new Point(point.x, point.y);
                SwingUtilities.convertPointFromScreen(point2, toolbar);
                if (!toolbar.getModel().isResizeable() || !toolbar.isInResizeArea(point2)) continue;
                return toolbar;
            }
            return null;
        }

        private void startResizing(Toolbar toolbar, MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(point, toolbar);
            this.resizeStartWidth = toolbar.getWidth();
            this.resizeStartX = (int)point.getX();
        }

        private void handleResizing(Toolbar toolbar, MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(point, toolbar);
            int n = (int)(point.getX() - (double)this.resizeStartX);
            int n2 = this.resizeStartWidth + n;
            int n3 = toolbar.getMinimumSize().width;
            int n4 = toolbar.getPreferredSize().width;
            if (n2 < n3) {
                n2 = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            this.container.resizeToolbar(toolbar, n2);
            this.container.revalidate();
        }

        private void finishResizing(Toolbar toolbar, MouseEvent mouseEvent) {
            this.resizeStartWidth = 0;
            this.resizeStartX = 0;
        }

        private void resetCursor() {
            this.container.setCursor(Cursor.getDefaultCursor());
        }

        private void setResizeCursor() {
            this.container.setCursor(this.resizeCursor);
        }
    }
}

