/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.impaxee.toolbar.Toolbar;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainerLayoutConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ToolbarContainerLayout
implements LayoutManager2 {
    private static final int DEFAULT_HORZ_GAP = 4;
    private static final int DEFAULT_VERT_GAP = 4;
    private static final int DEFAULT_ROW_HEIGHT = 30;
    private int rowHeight;
    private int horzGap;
    private int vertGap;
    private Map<Component, ToolbarContainerLayoutConstraint> constraints;

    public ToolbarContainerLayout() {
        this(30, 4, 4);
    }

    public ToolbarContainerLayout(int n, int n2, int n3) {
        this.rowHeight = n;
        this.horzGap = n2;
        this.vertGap = n3;
        this.constraints = new HashMap<Component, ToolbarContainerLayoutConstraint>();
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width += insets.left;
        dimension.width += insets.right;
        dimension.height += insets.top;
        dimension.height += insets.bottom;
        if (container.getComponentCount() > 0) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component n6 = componentArray[n2];
                int n3 = this.getRow(n6);
                int n4 = this.getPreferredBounds((Container)container, (Component)n6).width;
                Integer n5 = (Integer)hashMap.get(n3);
                if (n5 == null) {
                    hashMap.put(n3, n4);
                } else {
                    hashMap.put(n3, n4 + n5 + this.horzGap);
                }
                ++n2;
            }
            int n6 = 0;
            n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                if ((Integer)entry.getKey() > n6) {
                    n6 = (Integer)entry.getKey();
                }
                if ((Integer)entry.getValue() <= n2) continue;
                n2 = (Integer)entry.getValue();
            }
            int n7 = n6 + 1;
            dimension.height += n7 * this.rowHeight + (n7 - 1) * this.vertGap;
            dimension.width += n2;
        }
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width += insets.left;
        dimension.width += insets.right;
        dimension.height += insets.top;
        dimension.height += insets.bottom;
        if (container.getComponentCount() > 0) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component n6 = componentArray[n2];
                int n3 = this.getRow(n6);
                int n4 = this.getMinimumBounds((Container)container, (Component)n6).width;
                Integer n5 = (Integer)hashMap.get(n3);
                if (n5 == null) {
                    hashMap.put(n3, n4);
                } else {
                    hashMap.put(n3, n4 + n5 + this.horzGap);
                }
                ++n2;
            }
            int n6 = 0;
            n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                if ((Integer)entry.getKey() > n6) {
                    n6 = (Integer)entry.getKey();
                }
                if ((Integer)entry.getValue() <= n2) continue;
                n2 = (Integer)entry.getValue();
            }
            int n7 = n6 + 1;
            dimension.height += n7 * this.rowHeight + (n7 - 1) * this.vertGap;
            dimension.width += n2;
        }
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Map<Component, Rectangle> map;
        if (container.getComponentCount() > 0 && (map = this.getLayoutBounds(container, Arrays.asList(container.getComponents()))) != null) {
            for (Map.Entry<Component, Rectangle> entry : map.entrySet()) {
                this.updateComponent(container, entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this.constraints.put(component, ToolbarContainerLayoutConstraint.create());
        } else if (object instanceof ToolbarContainerLayoutConstraint) {
            this.constraints.put(component, (ToolbarContainerLayoutConstraint)object);
        } else {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a ToolbarLayoutConstraint");
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component != null) {
            this.constraints.remove(component);
        }
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getVerticalGap() {
        return this.vertGap;
    }

    public int getHorizontalGap() {
        return this.horzGap;
    }

    public ToolbarContainerLayoutConstraint getConstraint(Component component) {
        return this.constraints.get(component);
    }

    public Map<Component, Rectangle> getLayoutBounds(Container container, Collection<Component> collection) {
        HashMap<Component, Rectangle> hashMap = new HashMap<Component, Rectangle>();
        if (container.getComponentCount() > 0) {
            int n = this.getLastRow(container);
            int n2 = 0;
            while (n2 <= n) {
                Component component2;
                HashMap<Component, Rectangle> hashMap2 = new HashMap<Component, Rectangle>();
                Collection<Component> collection2 = this.getComponentsInRow(collection, n2);
                Collection<Component> collection3 = this.getComponentsSortedByAnchorPosition(container, collection2);
                for (Component component2 : collection3) {
                    Rectangle rectangle = this.getPreferredBounds(container, component2);
                    if (this.getComponentAtPos(hashMap2, rectangle.x) != null) {
                        ++rectangle.x;
                    }
                    hashMap2.put(component2, rectangle);
                }
                component2 = this.getNextComponent(null, hashMap2);
                while (component2 != null) {
                    this.minimizeOverlap(container, component2, hashMap2, true);
                    component2 = this.getNextComponent(component2, hashMap2);
                }
                hashMap.putAll(hashMap2);
                ++n2;
            }
        }
        return hashMap;
    }

    public boolean fitsIntoRow(Container container, Component component, int n) {
        int n2 = this.getUnassignedWidth(container, n);
        return n2 > this.getMinimumWidth(container, component) + this.horzGap;
    }

    public Map<? extends Component, Rectangle> moveToRow(Container container, Component component, Map<? extends Component, Rectangle> map, int n, int n2) {
        int n3 = this.getRow(component);
        if (n3 == n) {
            map.get((Object)component).x = n2;
            this.minimizeOverlap(container, component, map, true);
            return map;
        }
        if (this.fitsIntoRow(container, component, n)) {
            Rectangle rectangle = this.getRowBounds(container, n);
            int n4 = this.getUnassignedWidth(container, n);
            int n5 = this.getPreferredWidth(container, component);
            int n6 = this.getMinimumWidth(container, component);
            int n7 = Math.max(n6, Math.min(n5, n4));
            Rectangle rectangle2 = new Rectangle(n2, rectangle.y, n7, rectangle.height);
            HashMap<? extends Component, Rectangle> hashMap = new HashMap<Component, Rectangle>();
            hashMap.putAll(map);
            hashMap.put(component, rectangle2);
            this.minimizeOverlap(container, component, hashMap, true);
            return hashMap;
        }
        return null;
    }

    public int moveRight(Container container, Component component, Map<? extends Component, Rectangle> map, int n, boolean bl) {
        int n2;
        if (!this.isRelocatable(component)) {
            return 0;
        }
        Component component2 = this.getNextComponent(component, map);
        Rectangle rectangle = component2 != null ? map.get(component2) : null;
        Rectangle rectangle2 = map.get(component);
        int n3 = container.getWidth() - container.getInsets().right;
        if (rectangle != null && rectangle.x - this.horzGap < n3) {
            n3 = rectangle.x - this.horzGap;
        }
        if (rectangle2.x + rectangle2.width + n <= n3) {
            rectangle2.x += n;
            return n;
        }
        int n4 = Math.max(0, n3 - (rectangle2.x + rectangle2.width));
        if (component2 != null) {
            if (this.isRelocatable(component2)) {
                n4 += this.moveRight(container, component2, map, n - n4, bl);
            }
            if (bl && n4 < n && this.isResizeable(component2) && rectangle != null) {
                n2 = Math.max(this.getMinimumWidth(container, component2), rectangle.width - (n - n4));
                n4 += rectangle.width - n2;
                rectangle.width = n2;
            }
        }
        if (bl && n4 < n && this.isResizeable(component)) {
            n2 = Math.max(this.getMinimumWidth(container, component), rectangle2.width - (n - n4));
            n4 += rectangle2.width - n2;
            rectangle2.width = n2;
        }
        rectangle2.x += n4;
        return n4;
    }

    public int moveLeft(Container container, Component component, Map<? extends Component, Rectangle> map, int n, boolean bl) {
        int n2;
        if (!this.isRelocatable(component)) {
            return 0;
        }
        Component component2 = this.getPreviousComponent(component, map);
        Rectangle rectangle = component2 != null ? map.get(component2) : null;
        Rectangle rectangle2 = map.get(component);
        int n3 = container.getInsets().left;
        if (rectangle != null && rectangle.x + rectangle.width + this.horzGap > n3) {
            n3 = rectangle.x + rectangle.width + this.horzGap;
        }
        if (rectangle2.x - n >= n3) {
            rectangle2.x -= n;
            return n;
        }
        int n4 = Math.max(0, rectangle2.x - n3);
        if (component2 != null) {
            if (this.isRelocatable(component2)) {
                n4 += this.moveLeft(container, component2, map, n - n4, bl);
            }
            if (bl && n4 < n && this.isResizeable(component2) && rectangle != null) {
                n2 = Math.max(this.getMinimumWidth(container, component2), rectangle.width - (n - n4));
                n4 += rectangle.width - n2;
                rectangle.width = n2;
            }
        }
        rectangle2.x -= n4;
        if (bl && n4 < n && this.isResizeable(component)) {
            n2 = Math.max(this.getMinimumWidth(container, component), rectangle2.width - (n - n4));
            n4 += rectangle2.width - n2;
            rectangle2.width = n2;
        }
        return n4;
    }

    private boolean isResizeable(Component component) {
        if (component instanceof Toolbar) {
            return ((Toolbar)component).getModel().isResizeable();
        }
        return false;
    }

    private boolean isRelocatable(Component component) {
        if (component instanceof Toolbar) {
            return ((Toolbar)component).getModel().isRelocatable();
        }
        return false;
    }

    private int getRow(Component component) {
        int n = ToolbarContainerLayoutConstraint.getDefaultRow();
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = this.constraints.get(component);
        if (toolbarContainerLayoutConstraint != null) {
            n = toolbarContainerLayoutConstraint.getRow();
        }
        return n;
    }

    private ToolbarContainerLayoutConstraint.Anchor getAnchor(Component component) {
        ToolbarContainerLayoutConstraint.Anchor anchor = ToolbarContainerLayoutConstraint.getDefaultAnchor();
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = this.constraints.get(component);
        if (toolbarContainerLayoutConstraint != null) {
            anchor = toolbarContainerLayoutConstraint.getAnchor();
        }
        return anchor;
    }

    private int getAnchorPosition(Container container, Component component) {
        double d = ToolbarContainerLayoutConstraint.getDefaultPosition();
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = this.constraints.get(component);
        if (toolbarContainerLayoutConstraint != null) {
            d = toolbarContainerLayoutConstraint.getPreferredPosition();
        }
        Insets insets = container.getInsets();
        if (d >= 0.0 && d < 1.0) {
            return insets.left + (int)((double)(container.getWidth() - insets.left - insets.right) * d + 0.5);
        }
        if (d >= 1.0) {
            return insets.left + (int)d;
        }
        return insets.left;
    }

    private int getPosition(Container container, Component component) {
        int n;
        int n2;
        ToolbarContainerLayoutConstraint.Anchor anchor = this.getAnchor(component);
        int n3 = this.getAnchorPosition(container, component);
        if (ToolbarContainerLayoutConstraint.Anchor.left.equals((Object)anchor)) {
            return n3;
        }
        int n4 = this.getPreferredWidth(container, component);
        int n5 = n2 = n4 < (n = this.getMinimumWidth(container, component)) ? n : n4;
        if (ToolbarContainerLayoutConstraint.Anchor.center.equals((Object)anchor)) {
            return n3 - (int)((double)n2 / 2.0 + 0.5);
        }
        if (ToolbarContainerLayoutConstraint.Anchor.right.equals((Object)anchor)) {
            return n3 - n2;
        }
        return n3;
    }

    private int getPreferredWidth(Container container, Component component) {
        double d = ToolbarContainerLayoutConstraint.getDefaultWidth();
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = this.constraints.get(component);
        if (toolbarContainerLayoutConstraint != null) {
            d = toolbarContainerLayoutConstraint.getPreferredWidth();
        }
        int n = component.getPreferredSize().width;
        if (d < 0.0) {
            return n;
        }
        if (d >= 0.0 && d < 1.0) {
            int n2 = container.getWidth() - container.getInsets().left - container.getInsets().right;
            int n3 = (int)((double)n2 * d + 0.5);
            if (n3 > n) {
                n3 = n;
            }
            return n3;
        }
        return (int)d;
    }

    private int getMinimumWidth(Container container, Component component) {
        if (!this.isResizeable(component)) {
            return this.getPreferredWidth(container, component);
        }
        return component.getMinimumSize().width;
    }

    private Rectangle getRowBounds(Container container, int n) {
        Insets insets = container.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top + n * (this.rowHeight + this.vertGap);
        rectangle.width = container.getWidth() - insets.right - insets.left;
        rectangle.height = this.rowHeight;
        return rectangle;
    }

    private Rectangle getPreferredBounds(Container container, Component component) {
        int n;
        int n2 = this.getPreferredWidth(container, component);
        return this.getBounds(container, component, n2 < (n = this.getMinimumWidth(container, component)) ? n : n2);
    }

    private Rectangle getMinimumBounds(Container container, Component component) {
        return this.getBounds(container, component, this.getMinimumWidth(container, component));
    }

    private Rectangle getBounds(Container container, Component component, int n) {
        Rectangle rectangle = this.getRowBounds(container, this.getRow(component));
        return new Rectangle(this.getPosition(container, component), rectangle.y, n, rectangle.height);
    }

    private int getLastRow(Container container) {
        int n = 1;
        int n2 = container.getComponentCount();
        if (n2 > 0) {
            Component[] componentArray = container.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                int n5 = this.getRow(component);
                if (n5 > n) {
                    n = n5;
                }
                ++n4;
            }
        }
        return n;
    }

    private Collection<Component> getComponentsInRow(Collection<Component> collection, int n) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : collection) {
            if (this.getRow(component) != n) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    private Collection<Component> getComponentsSortedByAnchorPosition(final Container container, Collection<Component> collection) {
        ArrayList<Component> arrayList = new ArrayList<Component>(collection);
        Collections.sort(arrayList, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                int n = component != null ? ToolbarContainerLayout.this.getAnchorPosition(container, component) : 0;
                int n2 = component2 != null ? ToolbarContainerLayout.this.getAnchorPosition(container, component2) : 0;
                int n3 = Integer.compare(n, n2);
                return n3 != 0 ? n3 : 1;
            }
        });
        return arrayList;
    }

    private void updateComponent(Container container, Component component, Rectangle rectangle) {
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = this.getConstraint(component);
        if (toolbarContainerLayoutConstraint != null) {
            Insets insets = container.getInsets();
            ToolbarContainerLayoutConstraint.Anchor anchor = this.getAnchor(component);
            int n = container.getWidth() - insets.left - insets.right;
            double d = 0.0;
            if (ToolbarContainerLayoutConstraint.Anchor.left.equals((Object)anchor)) {
                d = (double)(rectangle.x - insets.left) / (double)n;
                if (d <= 0.01) {
                    d = 0.0;
                }
            } else if (ToolbarContainerLayoutConstraint.Anchor.center.equals((Object)anchor)) {
                d = ((double)rectangle.x + (double)rectangle.width / 2.0 - (double)insets.left) / (double)n;
            } else if (ToolbarContainerLayoutConstraint.Anchor.right.equals((Object)anchor) && (d = (double)(rectangle.x + rectangle.width - insets.left) / (double)n) >= 0.99) {
                d = 0.9999;
            }
            toolbarContainerLayoutConstraint.setPosition(d);
            int n2 = container.getWidth() - container.getInsets().left - container.getInsets().right;
            toolbarContainerLayoutConstraint.setWidth((double)rectangle.width / (double)n2);
        }
        component.setBounds(rectangle);
    }

    private void minimizeOverlap(Container container, Component component, Map<? extends Component, Rectangle> map, boolean bl) {
        Serializable serializable;
        Rectangle rectangle = map.get(component);
        Component component2 = this.getPreviousComponent(component, map);
        if (component2 != null) {
            serializable = map.get(component2);
            int n = serializable.x + serializable.width + this.horzGap - rectangle.x;
            if (n > 0) {
                this.moveLeft(container, component2, map, n, bl);
            }
        }
        if ((serializable = this.getNextComponent(component, map)) != null) {
            Rectangle rectangle2 = map.get(serializable);
            int n = rectangle.x + rectangle.width + this.horzGap - rectangle2.x;
            if (n > 0) {
                this.moveRight(container, (Component)serializable, map, n, bl);
            }
        }
    }

    private Component getComponentAtPos(Map<Component, Rectangle> map, int n) {
        for (Map.Entry<Component, Rectangle> entry : map.entrySet()) {
            if (entry.getValue().x != n) continue;
            return entry.getKey();
        }
        return null;
    }

    private Component getPreviousComponent(Component component, Map<? extends Component, Rectangle> map) {
        int n = component != null ? map.get((Object)component).x : Integer.MAX_VALUE;
        Component component2 = null;
        for (Map.Entry<? extends Component, Rectangle> entry : map.entrySet()) {
            int n2;
            if (entry.getKey() == component) continue;
            int n3 = entry.getValue().x;
            int n4 = n2 = component2 != null ? map.get(component2).x : -1;
            if (n <= n3 || n3 <= n2) continue;
            component2 = entry.getKey();
        }
        return component2;
    }

    private Component getNextComponent(Component component, Map<? extends Component, Rectangle> map) {
        int n = component != null ? map.get((Object)component).x : -1;
        Component component2 = null;
        for (Map.Entry<? extends Component, Rectangle> entry : map.entrySet()) {
            int n2;
            if (entry.getKey() == component) continue;
            int n3 = entry.getValue().x;
            int n4 = n2 = component2 != null ? map.get(component2).x : Integer.MAX_VALUE;
            if (n >= n3 || n3 >= n2) continue;
            component2 = entry.getKey();
        }
        return component2;
    }

    private int getUnassignedWidth(Container container, int n) {
        Collection<Component> collection = this.getComponentsInRow(Arrays.asList(container.getComponents()), n);
        Map<Component, Rectangle> map = this.getLayoutBounds(container, collection);
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right + map.size() > 0 ? (map.size() - 1) * this.horzGap : 0;
        for (Rectangle rectangle : map.values()) {
            n2 += rectangle.width;
        }
        return Math.max(0, container.getWidth() - n2);
    }
}

