/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ToolbarContainerLayoutConstraint {
    public static final String XML_ELEMENT_NAME = "layout-constraint";
    private static final String ROW_XML_ATTR_NAME = "row";
    private static final String ANCHOR_XML_ATTR_NAME = "anchor";
    private static final String POS_XML_ATTR_NAME = "pos";
    private static final String WIDTH_XML_ATTR_NAME = "width";
    private int row;
    private double pos;
    private Anchor anchor;
    private double width;
    private double prefPos;
    private double prefWidth;
    private Map<String, String> attrs;
    private Collection<IToolbarLayoutConstraintListener> listeners;
    private boolean modified;

    private ToolbarContainerLayoutConstraint(int n, double d, double d2, Anchor anchor) {
        this.row = n;
        this.pos = d;
        this.anchor = anchor;
        this.width = d2;
        this.prefPos = d;
        this.prefWidth = d2;
        this.modified = false;
    }

    public static ToolbarContainerLayoutConstraint create() {
        return ToolbarContainerLayoutConstraint.create(ToolbarContainerLayoutConstraint.getDefaultRow(), ToolbarContainerLayoutConstraint.getDefaultPosition(), ToolbarContainerLayoutConstraint.getDefaultWidth(), ToolbarContainerLayoutConstraint.getDefaultAnchor());
    }

    public static ToolbarContainerLayoutConstraint create(int n, double d, double d2, Anchor anchor) {
        return new ToolbarContainerLayoutConstraint(n, d, d2, anchor);
    }

    public static ToolbarContainerLayoutConstraint create(Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = ToolbarContainerLayoutConstraint.containsNode(namedNodeMap, ROW_XML_ATTR_NAME) ? Integer.valueOf(namedNodeMap.getNamedItem(ROW_XML_ATTR_NAME).getNodeValue()) : ToolbarContainerLayoutConstraint.getDefaultRow();
        Anchor anchor = ToolbarContainerLayoutConstraint.containsNode(namedNodeMap, ANCHOR_XML_ATTR_NAME) ? Anchor.valueOf(namedNodeMap.getNamedItem(ANCHOR_XML_ATTR_NAME).getNodeValue()) : ToolbarContainerLayoutConstraint.getDefaultAnchor();
        double d = ToolbarContainerLayoutConstraint.containsNode(namedNodeMap, POS_XML_ATTR_NAME) ? Double.valueOf(namedNodeMap.getNamedItem(POS_XML_ATTR_NAME).getNodeValue()) : ToolbarContainerLayoutConstraint.getDefaultPosition();
        double d2 = ToolbarContainerLayoutConstraint.containsNode(namedNodeMap, WIDTH_XML_ATTR_NAME) ? Double.valueOf(namedNodeMap.getNamedItem(WIDTH_XML_ATTR_NAME).getNodeValue()) : ToolbarContainerLayoutConstraint.getDefaultWidth();
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = new ToolbarContainerLayoutConstraint(n, d, d2, anchor);
        if (namedNodeMap.getLength() > 0) {
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                Node node2 = namedNodeMap.item(n2);
                String string = node2.getNodeName();
                if (!(ROW_XML_ATTR_NAME.equals(string) || POS_XML_ATTR_NAME.equals(string) || WIDTH_XML_ATTR_NAME.equals(string) || ANCHOR_XML_ATTR_NAME.equals(string))) {
                    toolbarContainerLayoutConstraint.putAttribute(string, node2.getNodeValue());
                }
                ++n2;
            }
        }
        return toolbarContainerLayoutConstraint;
    }

    public ToolbarContainerLayoutConstraint copy() {
        ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = new ToolbarContainerLayoutConstraint(this.getRow(), this.getPreferredPosition(), this.getPreferredWidth(), this.getAnchor());
        if (this.attrs != null) {
            toolbarContainerLayoutConstraint.attrs.putAll(this.attrs);
        }
        return toolbarContainerLayoutConstraint;
    }

    public void update(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
        if (this.row != toolbarContainerLayoutConstraint.row) {
            this.row = toolbarContainerLayoutConstraint.row;
            this.modified = true;
        }
        if (this.pos != toolbarContainerLayoutConstraint.pos) {
            this.pos = toolbarContainerLayoutConstraint.pos;
            this.modified = true;
        }
        if (this.anchor != toolbarContainerLayoutConstraint.anchor) {
            this.anchor = toolbarContainerLayoutConstraint.anchor;
            this.modified = true;
        }
        if (this.width != toolbarContainerLayoutConstraint.width) {
            this.width = toolbarContainerLayoutConstraint.width;
            this.modified = true;
        }
    }

    public boolean modified() {
        return this.modified;
    }

    public int getRow() {
        return this.row;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public double getPosition() {
        return this.pos;
    }

    public double getPreferredPosition() {
        return this.prefPos;
    }

    public double getWidth() {
        return this.width;
    }

    public double getPreferredWidth() {
        return this.prefWidth;
    }

    public void setRow(int n) {
        if (this.row != n) {
            this.row = n;
            this.modified = true;
            this.fireRowChanged();
        }
    }

    public void setAnchor(Anchor anchor) {
        if (this.anchor != anchor) {
            this.anchor = anchor;
            this.modified = true;
            this.fireAnchorChanged();
        }
    }

    public void setPosition(double d) {
        if (this.pos != d) {
            this.pos = d;
            this.modified = true;
        }
    }

    public void setPreferredPosition(double d) {
        if (this.prefPos != d) {
            this.prefPos = d;
            this.firePreferredPositionChanged();
        }
    }

    public void setWidth(double d) {
        if (this.width != d) {
            this.width = d;
            this.modified = true;
        }
    }

    public void setPreferredWidth(double d) {
        if (this.prefWidth != d) {
            this.prefWidth = d;
            this.firePreferredWidthChanged();
        }
    }

    public String getAttribute(String string) {
        if (this.attrs != null) {
            return this.attrs.get(string);
        }
        return null;
    }

    public void putAttribute(String string, String string2) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(string, string2);
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.getXmlElementName());
        String string = this.attrsToXML();
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(">");
        String string2 = this.childrenToXML();
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getXmlElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public void addConstraintListener(IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IToolbarLayoutConstraintListener>();
        }
        if (!this.listeners.contains(iToolbarLayoutConstraintListener)) {
            this.listeners.add(iToolbarLayoutConstraintListener);
        }
    }

    public void removeConstraintListener(IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener) {
        if (this.listeners != null) {
            this.listeners.remove(iToolbarLayoutConstraintListener);
        }
    }

    public static int getDefaultRow() {
        return 0;
    }

    public static Anchor getDefaultAnchor() {
        return Anchor.left;
    }

    public static double getDefaultPosition() {
        return 0.0;
    }

    public static double getDefaultWidth() {
        return -1.0;
    }

    protected String getXmlElementName() {
        return XML_ELEMENT_NAME;
    }

    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(ROW_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Integer.toString(this.row));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(POS_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Double.toString(this.pos));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(ANCHOR_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(this.anchor.name());
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(WIDTH_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(this.prefWidth < 0.0 ? Double.toString(this.prefWidth) : Double.toString(this.width));
        stringBuilder.append("\"");
        if (this.attrs != null) {
            for (Map.Entry<String, String> entry : this.attrs.entrySet()) {
                stringBuilder.append(" ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=\"");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("\"");
            }
        }
        return stringBuilder.toString();
    }

    protected String childrenToXML() {
        return null;
    }

    private void firePreferredPositionChanged() {
        if (this.listeners != null) {
            for (IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener : this.listeners) {
                iToolbarLayoutConstraintListener.preferredPositionChanged(this);
            }
        }
    }

    private void firePreferredWidthChanged() {
        if (this.listeners != null) {
            for (IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener : this.listeners) {
                iToolbarLayoutConstraintListener.preferredWidthChanged(this);
            }
        }
    }

    private void fireAnchorChanged() {
        if (this.listeners != null) {
            for (IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener : this.listeners) {
                iToolbarLayoutConstraintListener.anchorChanged(this);
            }
        }
    }

    private void fireRowChanged() {
        if (this.listeners != null) {
            for (IToolbarLayoutConstraintListener iToolbarLayoutConstraintListener : this.listeners) {
                iToolbarLayoutConstraintListener.rowChanged(this);
            }
        }
    }

    private static boolean containsNode(NamedNodeMap namedNodeMap, String string) {
        return namedNodeMap.getNamedItem(string) != null;
    }

    public static enum Anchor {
        left,
        center,
        right;

    }

    public static interface IToolbarLayoutConstraintListener {
        public void preferredPositionChanged(ToolbarContainerLayoutConstraint var1);

        public void preferredWidthChanged(ToolbarContainerLayoutConstraint var1);

        public void anchorChanged(ToolbarContainerLayoutConstraint var1);

        public void rowChanged(ToolbarContainerLayoutConstraint var1);
    }
}

