/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.impaxee.toolbar.ToolbarAction;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainerLayoutConstraint;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolbarModel {
    private static final ALogger log = ALogger.getLogger(ToolbarModel.class);
    public static final String XML_ELEMENT_NAME = "toolbar";
    private static final String NAME_XML_ATTR_NAME = "name";
    private static final String RESIZEABLE_XML_ATTR_NAME = "resizeable";
    private static final String RELOCATABLE_XML_ATTR_NAME = "relocatable";
    private static final String CONFIGURABLE_XML_ATTR_NAME = "configurable";
    private static final String REMOVABLE_XML_ATTR_NAME = "removable";
    private String name;
    private boolean resizeable;
    private boolean relocatable;
    private boolean configurable;
    private boolean removable;
    private ToolbarContainerLayoutConstraint layoutConstraint;
    private ToolbarContainerLayoutConstraint origLayoutConstraint;
    private List<ToolbarAction> actions;
    private LinkedHashSet<IToolbarModelListener> listeners;
    private final ToolbarActionHandler actionHandler;
    private final LayoutConstraintHandler layoutConstraintHandler;
    private boolean modified;

    public ToolbarModel(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
        this.name = string;
        this.resizeable = bl;
        this.relocatable = bl2;
        this.configurable = bl3;
        this.removable = bl4;
        this.modified = false;
        this.actions = new ArrayList<ToolbarAction>();
        this.layoutConstraint = toolbarContainerLayoutConstraint;
        this.origLayoutConstraint = null;
        this.actionHandler = new ToolbarActionHandler();
        this.layoutConstraintHandler = new LayoutConstraintHandler();
        if (this.layoutConstraint != null) {
            this.layoutConstraint.addConstraintListener(this.layoutConstraintHandler);
            this.origLayoutConstraint = this.layoutConstraint.copy();
        }
    }

    public ToolbarModel(String string) {
        this(string, true, true, true, true, ToolbarContainerLayoutConstraint.create());
    }

    public ToolbarModel(Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.modified = false;
        this.name = namedNodeMap.getNamedItem(NAME_XML_ATTR_NAME).getNodeValue();
        this.resizeable = Boolean.valueOf(namedNodeMap.getNamedItem(RESIZEABLE_XML_ATTR_NAME).getNodeValue());
        this.relocatable = Boolean.valueOf(namedNodeMap.getNamedItem(RELOCATABLE_XML_ATTR_NAME).getNodeValue());
        this.configurable = Boolean.valueOf(namedNodeMap.getNamedItem(CONFIGURABLE_XML_ATTR_NAME).getNodeValue());
        this.removable = Boolean.valueOf(namedNodeMap.getNamedItem(REMOVABLE_XML_ATTR_NAME).getNodeValue());
        this.actions = new ArrayList<ToolbarAction>();
        this.actionHandler = new ToolbarActionHandler();
        this.layoutConstraintHandler = new LayoutConstraintHandler();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if ("layout-constraint".equals(node2.getNodeName())) {
                    if (this.layoutConstraint == null) {
                        this.layoutConstraint = ToolbarContainerLayoutConstraint.create(node2);
                        this.layoutConstraint.addConstraintListener(this.layoutConstraintHandler);
                        this.origLayoutConstraint = this.layoutConstraint.copy();
                    }
                } else if ("action-ref".equals(node2.getNodeName())) {
                    try {
                        this.actions.add(ToolbarAction.create(this.name, node2));
                    }
                    catch (Exception exception) {
                        log.warn("Reading toolbar action from configuration failed! Skipped...");
                    }
                }
                ++n;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public boolean isRelocatable() {
        return this.relocatable;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public ToolbarContainerLayoutConstraint getLayoutConstraint() {
        return this.layoutConstraint;
    }

    public void setLayoutConstraint(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
        if (this.layoutConstraint != toolbarContainerLayoutConstraint) {
            if (this.layoutConstraint != null) {
                this.layoutConstraint.removeConstraintListener(this.layoutConstraintHandler);
            }
            this.layoutConstraint = toolbarContainerLayoutConstraint;
            if (this.layoutConstraint != null) {
                this.layoutConstraint.addConstraintListener(this.layoutConstraintHandler);
            }
            this.modified = true;
        }
    }

    public ToolbarAction getAction(String string) {
        for (ToolbarAction toolbarAction : this.actions) {
            if (!string.equals(toolbarAction.getActionId())) continue;
            return toolbarAction;
        }
        return null;
    }

    public Collection<ToolbarAction> getActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    public void setActions(Collection<ToolbarAction> collection) {
        if (this.actions != null) {
            for (ToolbarAction toolbarAction3 : this.actions) {
                toolbarAction3.removeActionListener(this.actionHandler);
            }
            this.actions.clear();
        }
        if (collection != null && this.actions != null) {
            for (ToolbarAction toolbarAction3 : collection) {
                toolbarAction3.addActionListener(this.actionHandler);
                this.actions.add(toolbarAction3);
            }
            Collections.sort(this.actions, (toolbarAction, toolbarAction2) -> Integer.compare(toolbarAction.getColumn(), toolbarAction2.getColumn()));
        }
        this.modified = true;
        this.fireActionsChanged(this.getActions());
    }

    public int indexOfAction(ToolbarAction toolbarAction) {
        return this.actions.indexOf(toolbarAction);
    }

    public boolean insertActionAt(ToolbarAction toolbarAction, int n) {
        toolbarAction.addActionListener(this.actionHandler);
        this.actions.add(n < 0 ? this.actions.size() : n, toolbarAction);
        int n2 = 0;
        while (n2 < this.actions.size()) {
            this.actions.get(n2).setColumn(n2);
            ++n2;
        }
        this.modified = true;
        this.fireActionAdded(toolbarAction);
        return true;
    }

    public boolean addAction(ToolbarAction toolbarAction) {
        return this.insertActionAt(toolbarAction, this.actions.size());
    }

    public boolean removeAction(ToolbarAction toolbarAction) throws NoSuchElementException {
        if (!this.actions.contains(toolbarAction)) {
            throw new NoSuchElementException();
        }
        toolbarAction.removeActionListener(this.actionHandler);
        this.actions.remove(toolbarAction);
        int n = 0;
        while (n < this.actions.size()) {
            this.actions.get(n).setColumn(n);
            ++n;
        }
        this.modified = true;
        this.fireActionRemoved(toolbarAction);
        return true;
    }

    public void moveAction(ToolbarAction toolbarAction, int n) throws NoSuchElementException, IndexOutOfBoundsException {
        if (!this.actions.contains(toolbarAction)) {
            throw new NoSuchElementException();
        }
        this.actions.remove(toolbarAction);
        this.actions.add(n, toolbarAction);
        int n2 = 0;
        while (n2 < this.actions.size()) {
            this.actions.get(n2).setColumn(n2);
            ++n2;
        }
        this.modified = true;
        this.fireActionMoved(toolbarAction, n);
    }

    public void addModelListener(IToolbarModelListener iToolbarModelListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet(4);
        }
        if (!this.listeners.contains(iToolbarModelListener)) {
            this.listeners.add(iToolbarModelListener);
        }
    }

    public void removeModelListener(IToolbarModelListener iToolbarModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(iToolbarModelListener);
        }
    }

    public boolean isModified() {
        return this.modified || this.layoutConstraint != null && this.layoutConstraint.modified();
    }

    public ToolbarModel copy() {
        ToolbarModel toolbarModel = new ToolbarModel(this.getName(), this.isResizeable(), this.isRelocatable(), this.isConfigurable(), this.isRemovable(), this.layoutConstraint != null ? this.layoutConstraint.copy() : null);
        for (ToolbarAction toolbarAction : this.actions) {
            ToolbarAction toolbarAction2 = toolbarAction.copy();
            toolbarAction2.addActionListener(toolbarModel.actionHandler);
            toolbarModel.actions.add(toolbarAction2);
        }
        return toolbarModel;
    }

    public final String toXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.getXmlElementName());
        String string = this.attrsToXML();
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(">");
        String string2 = this.childrenToXML(bl);
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getXmlElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    protected String getXmlElementName() {
        return XML_ELEMENT_NAME;
    }

    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(NAME_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(RESIZEABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.resizeable));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(RELOCATABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.relocatable));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(CONFIGURABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.configurable));
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(REMOVABLE_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Boolean.toString(this.removable));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String childrenToXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.layoutConstraint != null) {
            void var3_6;
            boolean bl2;
            Object object = null;
            boolean bl3 = bl2 = this.isResizeable() || this.isRelocatable();
            if (bl && bl2 || this.origLayoutConstraint == null) {
                String string = this.layoutConstraint.toXML();
                this.origLayoutConstraint = this.layoutConstraint.copy();
            } else {
                String string = this.origLayoutConstraint.toXML();
            }
            if (var3_6 != null) {
                stringBuilder.append((String)var3_6);
            }
        }
        if (this.actions != null) {
            for (ToolbarAction toolbarAction : this.actions) {
                String string = toolbarAction.toXML();
                if (string == null) continue;
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    private void fireActionsChanged(Collection<ToolbarAction> collection) {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.actionsChanged(this, collection);
            }
        }
    }

    private void fireActionChanged(ToolbarAction toolbarAction) {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.actionChanged(toolbarAction, this);
            }
        }
    }

    private void fireActionAdded(ToolbarAction toolbarAction) {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.actionAdded(this, toolbarAction);
            }
        }
    }

    private void fireActionRemoved(ToolbarAction toolbarAction) {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.actionRemoved(this, toolbarAction);
            }
        }
    }

    private void fireActionMoved(ToolbarAction toolbarAction, int n) {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.actionMoved(this, toolbarAction, n);
            }
        }
    }

    private void fireLayoutConstraintChanged() {
        if (this.listeners != null) {
            for (IToolbarModelListener iToolbarModelListener : this.listeners) {
                iToolbarModelListener.layoutConstraintChanged(this);
            }
        }
    }

    public static interface IToolbarModelListener {
        public void actionsChanged(ToolbarModel var1, Collection<ToolbarAction> var2);

        public void actionChanged(ToolbarAction var1, ToolbarModel var2);

        public void actionAdded(ToolbarModel var1, ToolbarAction var2);

        public void actionRemoved(ToolbarModel var1, ToolbarAction var2);

        public void actionMoved(ToolbarModel var1, ToolbarAction var2, int var3);

        public void layoutConstraintChanged(ToolbarModel var1);
    }

    private class LayoutConstraintHandler
    implements ToolbarContainerLayoutConstraint.IToolbarLayoutConstraintListener {
        private LayoutConstraintHandler() {
        }

        @Override
        public void preferredPositionChanged(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
            ToolbarModel.this.fireLayoutConstraintChanged();
        }

        @Override
        public void preferredWidthChanged(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
            ToolbarModel.this.fireLayoutConstraintChanged();
        }

        @Override
        public void anchorChanged(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
            ToolbarModel.this.fireLayoutConstraintChanged();
        }

        @Override
        public void rowChanged(ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
            ToolbarModel.this.fireLayoutConstraintChanged();
        }
    }

    private class ToolbarActionHandler
    implements ToolbarAction.ToolbarActionListener {
        private ToolbarActionHandler() {
        }

        @Override
        public void actionChanged(ToolbarAction toolbarAction) {
            ToolbarModel.this.fireActionChanged(toolbarAction);
        }
    }
}

