/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toptoolbar;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigTree;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.toolbar.ToolbarAction;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainerLayoutConstraint;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarConfigModel;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TopToolbarActionConfigTree
extends ActionConfigTree {
    private static final ALogger log = ALogger.getLogger(TopToolbarActionConfigTree.class);
    private TopToolbarConfigModel configModel;

    public TopToolbarActionConfigTree(TopToolbarConfigModel topToolbarConfigModel, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.configModel = topToolbarConfigModel;
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.getModel().setRoot(this.createRoot());
        this.expandAll();
    }

    public void update() {
        this.getModel().setRoot(this.createRoot());
        this.expandAll();
    }

    @Override
    protected ActionConfigTree.ActionTreeAction[] getMenuActions() {
        return new ActionConfigTree.ActionTreeAction[]{new AddToolbarAction(this), new RemoveToolbarAction(this), new RemoveAction(this)};
    }

    protected DefaultMutableTreeNode createRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        Collection<ToolbarModel> collection = this.configModel.getToolbarModels();
        for (ToolbarModel toolbarModel : collection) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNode(toolbarModel);
            if (defaultMutableTreeNode2 == null) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    @Override
    protected boolean canHandleDndImport(Component component, PAction pAction, JTree.DropLocation dropLocation) {
        if (super.canHandleDndImport(component, pAction, dropLocation)) {
            if ("PATIENT_INFO".equals(pAction.getID())) {
                return false;
            }
            TreePath treePath = dropLocation.getPath();
            if (treePath != null && treePath.getPathCount() > 0) {
                Serializable serializable;
                if (treePath.getPathCount() == 1) {
                    serializable = ((JTree)component).getClosestPathForLocation(dropLocation.getDropPoint().x, dropLocation.getDropPoint().y);
                    treePath = ((TreePath)serializable).getParentPath();
                }
                if (treePath.getPathCount() == 2 && ((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent())).getUserObject() instanceof ToolbarNodeObject) {
                    ToolbarModel toolbarModel = ((ToolbarNodeObject)((DefaultMutableTreeNode)serializable).getUserObject()).getToolbarModel();
                    return toolbarModel.isConfigurable();
                }
            }
        }
        return false;
    }

    @Override
    protected boolean handleDndExport(Component component, ActionConfigTree.NodeObject nodeObject) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (nodeObject instanceof ActionConfigTree.ActionNodeObject && (defaultMutableTreeNode = this.findNode(nodeObject)) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            try {
                ToolbarModel toolbarModel = ((ToolbarNodeObject)defaultMutableTreeNode2.getUserObject()).getToolbarModel();
                if (toolbarModel.isConfigurable() && this.isRemovable(defaultMutableTreeNode)) {
                    toolbarModel.removeAction(((ToolbarActionNodeObject)nodeObject).getToolbarAction());
                    if (super.handleDndExport(component, nodeObject)) {
                        Collection<ToolbarAction> collection = toolbarModel.getActions();
                        if (collection == null || collection.isEmpty()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DummyNodeObject());
                            this.getModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        }
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
            }
        }
        return false;
    }

    private boolean isRemovable(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getUserObject() instanceof ToolbarActionNodeObject) {
            ToolbarActionNodeObject toolbarActionNodeObject = (ToolbarActionNodeObject)defaultMutableTreeNode.getUserObject();
            return toolbarActionNodeObject.getToolbarAction().isRemovable();
        }
        return true;
    }

    @Override
    protected boolean handleDndImport(PAction pAction, JTree.DropLocation dropLocation) {
        Serializable serializable;
        TreePath treePath = dropLocation.getPath();
        int n = dropLocation.getChildIndex();
        if (treePath.getPathCount() == 1) {
            serializable = this.getClosestPathForLocation(dropLocation.getDropPoint().x, dropLocation.getDropPoint().y);
            treePath = ((TreePath)serializable).getParentPath();
            n = -1;
        }
        if (((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent())).getUserObject() instanceof ToolbarNodeObject) {
            ToolbarModel toolbarModel = ((ToolbarNodeObject)((DefaultMutableTreeNode)serializable).getUserObject()).getToolbarModel();
            this.cleanupNode((DefaultMutableTreeNode)serializable);
            int n2 = n < 0 ? ((DefaultMutableTreeNode)serializable).getChildCount() : n;
            ToolbarAction toolbarAction = toolbarModel.getAction(pAction.getID());
            if (toolbarAction != null) {
                if (toolbarModel.indexOfAction(toolbarAction) < n2) {
                    --n2;
                }
                toolbarModel.moveAction(toolbarAction, n2);
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                int n3 = 0;
                while (n3 < ((DefaultMutableTreeNode)serializable).getChildCount()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getChildAt(n3);
                    PAction pAction2 = ((ActionConfigTree.ActionNodeObject)defaultMutableTreeNode2.getUserObject()).getAction();
                    if (pAction2.getID().equals(pAction.getID())) {
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                        break;
                    }
                    ++n3;
                }
                if (defaultMutableTreeNode != null) {
                    defaultMutableTreeNode.removeFromParent();
                    ((DefaultMutableTreeNode)serializable).insert(defaultMutableTreeNode, n2);
                    this.getModel().nodeStructureChanged((TreeNode)((Object)serializable));
                }
                return false;
            }
            toolbarAction = new ToolbarAction(toolbarModel.getName(), pAction.getID(), n2);
            toolbarModel.insertActionAt(toolbarAction, n2);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ToolbarActionNodeObject(toolbarAction));
            this.getModel().insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)((Object)serializable), n2);
            TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
            this.makeVisible(treePath2);
            this.scrollRectToVisible(this.getPathBounds(treePath2));
            return true;
        }
        return false;
    }

    private void cleanupNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        ActionConfigTree.NodeObject nodeObject;
        if (defaultMutableTreeNode.getChildCount() > 0 && (nodeObject = (ActionConfigTree.NodeObject)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getUserObject()) instanceof DummyNodeObject) {
            this.getModel().removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode createNode(ToolbarModel toolbarModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ToolbarNodeObject(toolbarModel));
        Collection<ToolbarAction> collection = toolbarModel.getActions();
        if (collection != null) {
            for (ToolbarAction toolbarAction : collection) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNode(toolbarAction);
                    if (defaultMutableTreeNode2 == null) continue;
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Action '" + toolbarAction.getActionId() + "' not registered! Skipped...!");
                }
            }
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createNode(ToolbarAction toolbarAction) {
        return new DefaultMutableTreeNode(new ToolbarActionNodeObject(toolbarAction));
    }

    class AddToolbarAction
    extends ActionConfigTree.ActionTreeAction {
        public AddToolbarAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.AddToolbar.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            return true;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            InputPanel inputPanel = new InputPanel();
            MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)"Dialog Title", (Object)inputPanel, (boolean)true, (int)4, (String)"OK_CANCEL_OPTION");
            messageDialog.showCenteredInOwner();
            if (messageDialog.getSelectedOption().equals("OK_OPTION")) {
                try {
                    String string = inputPanel.getToolbarName();
                    ToolbarModel toolbarModel = new ToolbarModel(string);
                    TopToolbarActionConfigTree.this.configModel.addToolbar(toolbarModel);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ToolbarNodeObject(toolbarModel));
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new DummyNodeObject()));
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)TopToolbarActionConfigTree.this.getModel().getRoot();
                    TopToolbarActionConfigTree.this.getModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                }
                catch (TopToolbarConfigModel.DuplicateToolbarException duplicateToolbarException) {
                    MessageDialog messageDialog2 = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)"Warning dialog title", (Object)"Toolbar already exists", (boolean)true, (int)1, (String)"OK_OPTION");
                    messageDialog2.showCenteredInOwner();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageDialog messageDialog3 = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)"Warning dialog title", (Object)"Name of toolbar must not be empty", (boolean)true, (int)1, (String)"OK_OPTION");
                    messageDialog3.showCenteredInOwner();
                }
            }
        }

        class InputPanel
        extends JPanel {
            public InputPanel() {
                this.setLayout(new FlowLayout());
                this.add(new JLabel("Toolbar Name:"));
                this.add(new JTextField("Default Name"));
            }

            public String getToolbarName() {
                return ((JTextField)this.getComponent(1)).getText();
            }
        }
    }

    protected static class DummyNodeObject
    extends ActionConfigTree.NodeObject {
        protected DummyNodeObject() {
        }

        @Override
        public DummyNodeObject copy() {
            return new DummyNodeObject();
        }

        @Override
        public void configureCellRendererComponent(JTree jTree, Component component, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        }

        public String toString() {
            return "";
        }
    }

    class EditToolbarAction
    extends ActionConfigTree.ActionTreeAction {
        public EditToolbarAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.EditToolbar.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object;
            if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) != null && object instanceof ToolbarNodeObject) {
                ToolbarModel toolbarModel = ((ToolbarNodeObject)object).getToolbarModel();
                return toolbarModel.isResizeable() || toolbarModel.isRelocatable();
            }
            return false;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            ToolbarModel toolbarModel = ((ToolbarNodeObject)defaultMutableTreeNode.getUserObject()).getToolbarModel();
            ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint = toolbarModel.getLayoutConstraint();
            MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)(String.valueOf(Messages.getString("ActionConfigDialog.EditToolbarDialog.Title.Prefix")) + toolbarModel.getName() + Messages.getString("ActionConfigDialog.EditToolbarDialog.Title.Suffix")), (Object)this.createEditToolbarPanel(toolbarContainerLayoutConstraint), (boolean)true, (int)3, (String)"OK_CANCEL_OPTION");
            messageDialog.setSize(GUI.getScaledDiagnosticDimension((int)540, (int)420));
            messageDialog.showCenteredInOwner();
            if ("OK_OPTION".equals(messageDialog.getSelectedOption())) {
                toolbarModel.getLayoutConstraint().update(toolbarContainerLayoutConstraint);
            }
        }

        private JPanel createEditToolbarPanel(final ToolbarContainerLayoutConstraint toolbarContainerLayoutConstraint) {
            double d = toolbarContainerLayoutConstraint.getWidth();
            JLabel jLabel = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditToolbarDialog.Row.Caption"));
            JSpinner jSpinner = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(0, 0, 4, 1));
            jSpinner.setPreferredSize(new Dimension(GUI.getScaledDiagnosticInt((int)50), jSpinner.getPreferredSize().height));
            jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    toolbarContainerLayoutConstraint.setRow((Integer)((JSpinner)changeEvent.getSource()).getValue());
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ActionConfigDialog.EditToolbarDialog.Row.Title")));
            jPanel.setLayout(new FlowLayout(0, 5, 0));
            jPanel.add(jLabel);
            jPanel.add(jSpinner);
            JLabel jLabel2 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditToolbarDialog.Pos.Caption"));
            JSpinner jSpinner2 = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(toolbarContainerLayoutConstraint.getPosition(), 0.0, 1.0, 0.05));
            jSpinner2.setPreferredSize(new Dimension(GUI.getScaledDiagnosticInt((int)50), jSpinner2.getPreferredSize().height));
            jSpinner2.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    toolbarContainerLayoutConstraint.setPosition((Double)((JSpinner)changeEvent.getSource()).getValue());
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 0));
            jPanel2.add(jLabel2);
            jPanel2.add(jSpinner2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ActionConfigDialog.EditToolbarDialog.Pos.Title")));
            jPanel3.setLayout((LayoutManager)new RowLayout(2));
            jPanel3.add(jPanel2);
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = ComponentFactory.instance.createRadioButton(Messages.getString("ActionConfigDialog.EditorToolbarDialog.Anchor.Left.Caption"), ToolbarContainerLayoutConstraint.Anchor.left.equals((Object)toolbarContainerLayoutConstraint.getAnchor()));
            JRadioButton jRadioButton2 = ComponentFactory.instance.createRadioButton(Messages.getString("ActionConfigDialog.EditorToolbarDialog.Anchor.Center.Caption"), ToolbarContainerLayoutConstraint.Anchor.center.equals((Object)toolbarContainerLayoutConstraint.getAnchor()));
            JRadioButton jRadioButton3 = ComponentFactory.instance.createRadioButton(Messages.getString("ActionConfigDialog.EditorToolbarDialog.Anchor.Right.Caption"), ToolbarContainerLayoutConstraint.Anchor.right.equals((Object)toolbarContainerLayoutConstraint.getAnchor()));
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton3);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    toolbarContainerLayoutConstraint.setAnchor(ToolbarContainerLayoutConstraint.Anchor.left);
                }
            });
            jRadioButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    toolbarContainerLayoutConstraint.setAnchor(ToolbarContainerLayoutConstraint.Anchor.center);
                }
            });
            jRadioButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    toolbarContainerLayoutConstraint.setAnchor(ToolbarContainerLayoutConstraint.Anchor.right);
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ActionConfigDialog.EditToolbarDialog.Anchor.Title")));
            jPanel4.setLayout((LayoutManager)new RowLayout(2));
            jPanel4.add(jRadioButton);
            jPanel4.add(jRadioButton2);
            jPanel4.add(jRadioButton3);
            boolean bl = d < 0.0;
            boolean bl2 = d >= 0.0 && d <= 1.0;
            boolean bl3 = d > 1.0;
            JLabel jLabel3 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditorToolbarDialog.AutoWidth.Caption"));
            JLabel jLabel4 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditorToolbarDialog.AbsWidth.Caption.Prefix"));
            JLabel jLabel5 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditorToolbarDialog.AbsWidth.Caption.Suffix"));
            JLabel jLabel6 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditorToolbarDialog.RelWidth.Caption.Prefix"));
            JLabel jLabel7 = ComponentFactory.instance.createLabel(Messages.getString("ActionConfigDialog.EditorToolbarDialog.RelWidth.Caption.Suffix"));
            final JSpinner jSpinner3 = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(bl3 ? (int)d : 2, 2, 800, 10));
            final JSpinner jSpinner4 = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(bl2 ? (int)(d * 100.0 + 0.5) : 0, 0, 100, 5));
            jSpinner3.setEnabled(bl3);
            jSpinner4.setEnabled(bl2);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            JRadioButton jRadioButton4 = ComponentFactory.instance.createRadioButton(null, bl);
            JRadioButton jRadioButton5 = ComponentFactory.instance.createRadioButton(null, bl3);
            JRadioButton jRadioButton6 = ComponentFactory.instance.createRadioButton(null, bl2);
            buttonGroup2.add(jRadioButton4);
            buttonGroup2.add(jRadioButton5);
            buttonGroup2.add(jRadioButton6);
            jRadioButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jSpinner3.setEnabled(false);
                    jSpinner4.setEnabled(false);
                    toolbarContainerLayoutConstraint.setWidth(-1.0);
                }
            });
            jRadioButton5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jSpinner3.setEnabled(true);
                    jSpinner4.setEnabled(false);
                    int n = (Integer)((SpinnerNumberModel)jSpinner3.getModel()).getMinimum();
                    jSpinner3.setValue(n);
                    toolbarContainerLayoutConstraint.setWidth(n);
                }
            });
            jRadioButton6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jSpinner3.setEnabled(false);
                    jSpinner4.setEnabled(true);
                    Integer n = (Integer)((SpinnerNumberModel)jSpinner4.getModel()).getMinimum();
                    jSpinner4.setValue(n);
                    toolbarContainerLayoutConstraint.setWidth((double)n.intValue() / 100.0);
                }
            });
            jSpinner3.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    toolbarContainerLayoutConstraint.setWidth(((Integer)((JSpinner)changeEvent.getSource()).getValue()).intValue());
                }
            });
            jSpinner4.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    toolbarContainerLayoutConstraint.setWidth((Double)((JSpinner)changeEvent.getSource()).getValue());
                }
            });
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(0, 5, 0));
            jPanel5.add(jRadioButton4);
            jPanel5.add(jLabel3);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new FlowLayout(0, 5, 0));
            jPanel6.add(jRadioButton5);
            jPanel6.add(jLabel4);
            jPanel6.add(jSpinner3);
            jPanel6.add(jLabel5);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new FlowLayout(0, 5, 0));
            jPanel7.add(jRadioButton6);
            jPanel7.add(jLabel6);
            jPanel7.add(jSpinner4);
            jPanel7.add(jLabel7);
            JPanel jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getString("ActionConfigDialog.EditToolbarDialog.Width.Title")));
            jPanel8.setLayout((LayoutManager)new RowLayout(2));
            jPanel8.add(jPanel5);
            jPanel8.add(jPanel6);
            jPanel8.add(jPanel7);
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new GridLayout(1, 2, 10, 0));
            jPanel9.add(jPanel3);
            jPanel9.add(jPanel4);
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout((LayoutManager)new RowLayout(10));
            jPanel10.add(jPanel);
            jPanel10.add(jPanel9);
            jPanel10.add(jPanel8);
            return jPanel10;
        }
    }

    class RemoveAction
    extends ActionConfigTree.ActionTreeAction {
        public RemoveAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.RemoveTool.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            ToolbarAction toolbarAction;
            Object object;
            if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) != null && object instanceof ToolbarActionNodeObject && (toolbarAction = ((ToolbarActionNodeObject)object).getToolbarAction()).isRemovable() && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) != null && defaultMutableTreeNode2.getUserObject() instanceof ToolbarNodeObject) {
                ToolbarModel toolbarModel = ((ToolbarNodeObject)defaultMutableTreeNode2.getUserObject()).getToolbarModel();
                return toolbarModel.isConfigurable();
            }
            return false;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof ToolbarNodeObject) {
                ToolbarModel toolbarModel = ((ToolbarNodeObject)object).getToolbarModel();
                ToolbarAction toolbarAction = ((ToolbarActionNodeObject)defaultMutableTreeNode.getUserObject()).getToolbarAction();
                toolbarModel.removeAction(toolbarAction);
                TopToolbarActionConfigTree.this.getModel().removeNodeFromParent(defaultMutableTreeNode);
                Collection<ToolbarAction> collection = toolbarModel.getActions();
                if (collection == null || collection.isEmpty()) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DummyNodeObject());
                    TopToolbarActionConfigTree.this.getModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                }
            }
        }
    }

    class RemoveToolbarAction
    extends ActionConfigTree.ActionTreeAction {
        public RemoveToolbarAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.RemoveToolbar.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object;
            if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) != null && object instanceof ToolbarNodeObject) {
                ToolbarModel toolbarModel = ((ToolbarNodeObject)object).getToolbarModel();
                return toolbarModel.isRemovable();
            }
            return false;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            try {
                ToolbarNodeObject toolbarNodeObject = (ToolbarNodeObject)defaultMutableTreeNode.getUserObject();
                TopToolbarActionConfigTree.this.configModel.removeToolbar(toolbarNodeObject.getToolbarModel());
                TopToolbarActionConfigTree.this.getModel().removeNodeFromParent(defaultMutableTreeNode);
            }
            catch (TopToolbarConfigModel.NoSuchToolbarException noSuchToolbarException) {
                MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)"Warning dialog title", (Object)"No such toolbar!", (boolean)true, (int)1, (String)"OK_OPTION");
                messageDialog.showCenteredInOwner();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)TopToolbarActionConfigTree.this, (String)"Warning dialog title", (Object)"Name of toolbar must not be empty", (boolean)true, (int)1, (String)"OK_OPTION");
                messageDialog.showCenteredInOwner();
            }
        }
    }

    protected static class ToolbarActionNodeObject
    extends ActionConfigTree.ActionNodeObject {
        private ToolbarAction toolbarAction;

        public ToolbarActionNodeObject(ToolbarAction toolbarAction) throws ActionNotFoundException {
            super(toolbarAction.resolveAction(null));
            this.toolbarAction = toolbarAction;
        }

        public ToolbarAction getToolbarAction() {
            return this.toolbarAction;
        }

        @Override
        public ToolbarActionNodeObject copy() {
            try {
                return new ToolbarActionNodeObject(this.toolbarAction);
            }
            catch (ActionNotFoundException actionNotFoundException) {
                log.error(null, (Throwable)actionNotFoundException);
                return null;
            }
        }

        @Override
        public void configureCellRendererComponent(JTree jTree, Component component, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.configureCellRendererComponent(jTree, component, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                ToolbarModel toolbarModel;
                JLabel jLabel = (JLabel)component;
                DefaultMutableTreeNode defaultMutableTreeNode = this.getParentNode(jTree);
                if (!(defaultMutableTreeNode == null || (toolbarModel = ((ToolbarNodeObject)defaultMutableTreeNode.getUserObject()).getToolbarModel()).isConfigurable() && (bl || this.toolbarAction.isRemovable()))) {
                    jLabel.setForeground(UIManager.getColor("color.primary.2"));
                }
            }
        }

        private DefaultMutableTreeNode getParentNode(JTree jTree) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)jTree.getModel().getRoot()).breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object != this) continue;
                return (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
            return null;
        }
    }

    public static class ToolbarNodeObject
    extends ActionConfigTree.NodeObject {
        private ToolbarModel toolbarModel;

        public ToolbarNodeObject(ToolbarModel toolbarModel) {
            this.toolbarModel = toolbarModel;
        }

        public ToolbarModel getToolbarModel() {
            return this.toolbarModel;
        }

        @Override
        public ToolbarNodeObject copy() {
            return new ToolbarNodeObject(this.toolbarModel);
        }

        @Override
        public void configureCellRendererComponent(JTree jTree, Component component, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setText("<html><b>Toolbar '" + this.toolbarModel.getName() + "'</b></html>");
                jLabel.setEnabled(true);
                if (!bl) {
                    if (this.toolbarModel.isConfigurable() || this.toolbarModel.isRemovable() || this.toolbarModel.isResizeable() || this.toolbarModel.isRelocatable()) {
                        jLabel.setForeground(UIManager.getColor(LookAndFeelManager.getInstance().isMonochromeLookAndFeel() ? "color.secondary.6" : "color.primary.3"));
                    } else {
                        jLabel.setForeground(UIManager.getColor(LookAndFeelManager.getInstance().isMonochromeLookAndFeel() ? "color.secondary.4" : "color.primary.2"));
                    }
                }
            }
        }
    }
}

