/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toptoolbar;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.toolbar.ToolbarAction;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class TopToolbarPaneModel {
    private static final ALogger log = ALogger.getLogger(TopToolbarPaneModel.class);
    private static final String MULTISCREEN_CONFIG_KEY = Config.impaxee.jvision.TOPTOOLBAR.MultiScreen.getKey();
    private static final String DEFAULT_TOOLBARS_DEFAULT_KEY = Config.impaxee.jvision.TOPTOOLBAR.DefaultToolbars.getKey();
    private static final String DEFAULT_TOOLBARS_CONFIG_KEY = String.valueOf(Config.impaxee.jvision.TOPTOOLBAR.getKey()) + ".Toolbars";
    private static final String TOUCH_TOOLBARS_DEFAULT_KEY = Config.impaxee.jvision.TOPTOOLBAR.TouchToolbars.getKey();
    private static final String TOUCH_TOOLBARS_CONFIG_KEY = String.valueOf(Config.impaxee.jvision.TOPTOOLBAR.getKey()) + ".ToolbarsTouch";
    private static final String TOOLBARS_XML_ELEMENT_NAME = "top-toolbars";
    private static TopToolbarPaneModel runtimeInstanceDefaultToolbar;
    private static TopToolbarPaneModel runtimeInstanceTouchToolbar;
    private IConfigurationProvider rootCp;
    private Collection<ToolbarModel> toolbars;
    private Collection<ModelListener> listeners;
    private ToolbarModelListener toolbarListener;
    private boolean multiscreen;
    private boolean modified;
    private boolean isTouchTopToolbar;

    private TopToolbarPaneModel(IConfigurationProvider iConfigurationProvider, boolean bl) {
        this.rootCp = iConfigurationProvider != null ? iConfigurationProvider : ConfigurationProviderFactory.getConfig();
        this.isTouchTopToolbar = bl;
        this.toolbarListener = new ToolbarModelListener();
        this.multiscreen = this.rootCp.getBoolean(MULTISCREEN_CONFIG_KEY);
        this.toolbars = this.readConfiguredToolbars();
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.addModelListener(this.toolbarListener);
        }
        this.modified = false;
    }

    public static synchronized TopToolbarPaneModel getRuntimeInstanceTouchToolbar() {
        if (runtimeInstanceTouchToolbar == null) {
            runtimeInstanceTouchToolbar = new TopToolbarPaneModel(ConfigurationProviderFactory.getConfig(), true);
        }
        return runtimeInstanceTouchToolbar;
    }

    public static synchronized TopToolbarPaneModel getRuntimeInstanceDefaultToolbar() {
        if (runtimeInstanceDefaultToolbar == null) {
            runtimeInstanceDefaultToolbar = new TopToolbarPaneModel(ConfigurationProviderFactory.getConfig(), false);
        }
        return runtimeInstanceDefaultToolbar;
    }

    public static TopToolbarPaneModel createInstance(IConfigurationProvider iConfigurationProvider, boolean bl) {
        return new TopToolbarPaneModel(iConfigurationProvider, bl);
    }

    public boolean equalsRuntimeInstance() {
        return this.rootCp == ConfigurationProviderFactory.getConfig();
    }

    public boolean isMultiScreenEnabled() {
        return this.multiscreen;
    }

    public boolean isTouchTopToolbar() {
        return this.isTouchTopToolbar;
    }

    public void setMultiScreenEnabled(boolean bl) {
        if (this.multiscreen != bl) {
            this.multiscreen = bl;
            this.modified = true;
            this.fireModelChanged();
        }
    }

    public Collection<ToolbarModel> getToolbars() {
        return Collections.unmodifiableCollection(this.toolbars);
    }

    public void addToolbar(ToolbarModel toolbarModel) {
        if (!this.toolbars.contains(toolbarModel)) {
            this.toolbars.add(toolbarModel);
            toolbarModel.addModelListener(this.toolbarListener);
            this.modified = true;
            this.fireToolbarAdded(toolbarModel);
        }
    }

    public void removeToolbar(ToolbarModel toolbarModel) {
        if (this.toolbars.remove(toolbarModel)) {
            toolbarModel.removeModelListener(this.toolbarListener);
            this.modified = true;
            this.fireToolbarRemoved(toolbarModel);
        }
    }

    public boolean modified() {
        if (this.toolbars != null) {
            for (ToolbarModel toolbarModel : this.toolbars) {
                if (!toolbarModel.isModified()) continue;
                return true;
            }
        }
        return this.modified;
    }

    public void resetToDefault() throws Exception {
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.removeModelListener(this.toolbarListener);
        }
        this.toolbars = this.readDefaultToolbars();
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.addModelListener(this.toolbarListener);
        }
        this.saveToolbars(true);
        this.fireModelChanged();
    }

    public void resetToRole() throws Exception {
        this.updateRootConfigProvider();
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.removeModelListener(this.toolbarListener);
        }
        this.toolbars = this.readConfiguredToolbars();
        this.modified = false;
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.addModelListener(this.toolbarListener);
        }
        this.fireModelChanged();
    }

    private void updateRootConfigProvider() {
        String string;
        String string2 = string = this.isTouchTopToolbar ? TOUCH_TOOLBARS_CONFIG_KEY : DEFAULT_TOOLBARS_CONFIG_KEY;
        if (this.rootCp.exists(string)) {
            this.rootCp.removeValue(string);
            this.rootCp.storeAllConfiguration();
            this.rootCp.updateCache(string);
        }
    }

    public void init(TopToolbarPaneModel topToolbarPaneModel, boolean bl) {
        for (ToolbarModel toolbarModel : this.toolbars) {
            toolbarModel.removeModelListener(this.toolbarListener);
        }
        this.toolbars.clear();
        this.multiscreen = topToolbarPaneModel.isMultiScreenEnabled();
        this.isTouchTopToolbar = bl;
        for (ToolbarModel toolbarModel : topToolbarPaneModel.getToolbars()) {
            ToolbarModel toolbarModel2 = toolbarModel.copy();
            toolbarModel2.addModelListener(this.toolbarListener);
            this.toolbars.add(toolbarModel2);
        }
        this.modified = true;
        this.fireModelChanged();
    }

    public void init(Document document) throws Exception {
        for (ToolbarModel object2 : this.toolbars) {
            object2.removeModelListener(this.toolbarListener);
        }
        this.toolbars.clear();
        NodeList nodeList = document.getElementsByTagName("toolbar");
        int n = 0;
        while (n < nodeList.getLength()) {
            ToolbarModel toolbarModel = new ToolbarModel(nodeList.item(n));
            toolbarModel.addModelListener(this.toolbarListener);
            this.toolbars.add(toolbarModel);
            ++n;
        }
        this.modified = true;
        this.fireModelChanged();
    }

    public void save(boolean bl) throws Exception {
        if (this.modified()) {
            Config.impaxee.jvision.TOPTOOLBAR.MultiScreen.set(this.multiscreen);
            this.saveToolbars(bl);
        }
    }

    public String toXML(boolean bl) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(TOOLBARS_XML_ELEMENT_NAME);
        stringBuilder.append(">");
        for (ToolbarModel toolbarModel : this.toolbars) {
            stringBuilder.append(toolbarModel.toXML(bl));
        }
        stringBuilder.append("</");
        stringBuilder.append(TOOLBARS_XML_ELEMENT_NAME);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public void addModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModelListener>();
        }
        if (!this.listeners.contains(modelListener)) {
            this.listeners.add(modelListener);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners != null) {
            this.listeners.remove(modelListener);
        }
    }

    private String getConfigKey() {
        return this.isTouchTopToolbar ? TOUCH_TOOLBARS_CONFIG_KEY : DEFAULT_TOOLBARS_CONFIG_KEY;
    }

    private String getDefaultKey() {
        return this.isTouchTopToolbar ? TOUCH_TOOLBARS_DEFAULT_KEY : DEFAULT_TOOLBARS_DEFAULT_KEY;
    }

    private void saveToolbars(boolean bl) throws Exception {
        String string = this.getConfigKey();
        ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)this.rootCp, (String)string, (String)this.toXML(bl));
    }

    private Collection<ToolbarModel> readConfiguredToolbars() {
        return this.readToolbarsImpl(this.getConfigKey());
    }

    private Collection<ToolbarModel> readDefaultToolbars() {
        return this.readToolbarsImpl(this.getDefaultKey());
    }

    private Collection<ToolbarModel> readToolbarsImpl(String string) {
        try {
            Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)this.rootCp, (String)(this.rootCp.exists(string) ? string : this.getDefaultKey()));
            NodeList nodeList = document.getElementsByTagName("toolbar");
            ArrayList<ToolbarModel> arrayList = new ArrayList<ToolbarModel>();
            int n = 0;
            while (n < nodeList.getLength()) {
                try {
                    ToolbarModel toolbarModel = new ToolbarModel(nodeList.item(n));
                    arrayList.add(toolbarModel);
                }
                catch (Exception exception) {
                    log.error("Initializing top-toolbar failed! Toolbar is skipped", (Throwable)exception);
                }
                ++n;
            }
            return arrayList;
        }
        catch (Exception exception) {
            log.error("Initializing top-toolbars failed!", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    private void fireModelChanged() {
        if (this.listeners != null) {
            for (ModelListener modelListener : this.listeners) {
                modelListener.modelChanged();
            }
        }
    }

    private void fireToolbarChanged(ToolbarModel toolbarModel) {
        if (this.listeners != null) {
            for (ModelListener modelListener : this.listeners) {
                modelListener.toolbarChanged(toolbarModel);
            }
        }
    }

    private void fireToolbarAdded(ToolbarModel toolbarModel) {
        if (this.listeners != null) {
            for (ModelListener modelListener : this.listeners) {
                modelListener.toolbarAdded(toolbarModel);
            }
        }
    }

    private void fireToolbarRemoved(ToolbarModel toolbarModel) {
        if (this.listeners != null) {
            for (ModelListener modelListener : this.listeners) {
                modelListener.toolbarRemoved(toolbarModel);
            }
        }
    }

    public static interface ModelListener {
        public void modelChanged();

        public void toolbarChanged(ToolbarModel var1);

        public void toolbarAdded(ToolbarModel var1);

        public void toolbarRemoved(ToolbarModel var1);
    }

    private class ToolbarModelListener
    implements ToolbarModel.IToolbarModelListener {
        private ToolbarModelListener() {
        }

        @Override
        public void layoutConstraintChanged(ToolbarModel toolbarModel) {
        }

        @Override
        public void actionsChanged(ToolbarModel toolbarModel, Collection<ToolbarAction> collection) {
            TopToolbarPaneModel.this.fireToolbarChanged(toolbarModel);
        }

        @Override
        public void actionChanged(ToolbarAction toolbarAction, ToolbarModel toolbarModel) {
            TopToolbarPaneModel.this.fireToolbarChanged(toolbarModel);
        }

        @Override
        public void actionAdded(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
            TopToolbarPaneModel.this.fireToolbarChanged(toolbarModel);
        }

        @Override
        public void actionRemoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction) {
            TopToolbarPaneModel.this.fireToolbarChanged(toolbarModel);
        }

        @Override
        public void actionMoved(ToolbarModel toolbarModel, ToolbarAction toolbarAction, int n) {
            TopToolbarPaneModel.this.fireToolbarChanged(toolbarModel);
        }
    }
}

