/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.utils;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.enums.FontStyle;

public class FontUtils {
    public static void mergeFonts(Font font, Font font2, Font font3) {
        if (font2 != null) {
            font3.setColor(font2.getColor());
            font3.setName(font2.getName());
            font3.setSize(font2.getSize());
            font3.setStyle(font2.getStyle());
        }
        if (font != null) {
            if (font.getColor() != null) {
                font3.setColor(font.getColor());
            }
            if (font.getName() != null) {
                font3.setName(font.getName());
            }
            if (font.getSize() != null) {
                font3.setSize(font.getSize());
            }
            if (font.getStyle() != null) {
                font3.setStyle(font.getStyle());
            }
        }
    }

    public static Font mergeFonts(Font font, Font font2) {
        Font font3 = new Font();
        FontUtils.mergeFonts(font, font2, font3);
        return font3;
    }

    public static void correctWithConfig(Font font, IConfigurationProvider iConfigurationProvider) {
        int n;
        if (font.getColor() == null) {
            n = (int)iConfigurationProvider.getLong(Config.impaxee.jvision.MAPPING.MappingColor.getKey());
            font.setColor(Integer.toHexString(n & 0xFFFFFF).toUpperCase());
        }
        if (font.getName() == null) {
            String string = iConfigurationProvider.getString(Config.impaxee.jvision.MAPPING.DisplayFontFace.getKey());
            font.setName(string);
        }
        if (font.getSize() == null) {
            n = (int)iConfigurationProvider.getLong(Config.impaxee.jvision.MAPPING.DisplayFontSize.getKey());
            font.setSize(n);
        }
        if (font.getStyle() == null) {
            n = (int)iConfigurationProvider.getLong(Config.impaxee.jvision.MAPPING.DisplayFontStyle.getKey());
            if ((n & 1) != 0) {
                if ((n & 2) != 0) {
                    font.setStyle(FontStyle.BOLD_ITALIC);
                } else {
                    font.setStyle(FontStyle.BOLD);
                }
            } else if ((n & 2) != 0) {
                font.setStyle(FontStyle.ITALIC);
            } else {
                font.setStyle(FontStyle.PLAIN);
            }
        }
    }

    public static FontStyle awtFontStyle2MappingFontStyle(int n) {
        FontStyle fontStyle = (n & 1) > 0 ? ((n & 2) > 0 ? FontStyle.BOLD_ITALIC : FontStyle.BOLD) : ((n & 2) > 0 ? FontStyle.ITALIC : FontStyle.PLAIN);
        return fontStyle;
    }

    public static int mappingFontStyle2awtFontStyle(FontStyle fontStyle) {
        if (fontStyle == FontStyle.BOLD_ITALIC) {
            return 3;
        }
        if (fontStyle == FontStyle.BOLD) {
            return 1;
        }
        if (fontStyle == FontStyle.ITALIC) {
            return 2;
        }
        return 0;
    }
}

