/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.utils;

import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.math.Matrix2d;
import com.agfa.pacs.tools.DoubleEquals;

public class SpatialTransformationUtils {
    private SpatialTransformationUtils() {
    }

    public static SpatialTransformationModule toSpatialTransformationModule(Matrix2d matrix2d) {
        SpatialTransformationModule spatialTransformationModule = new SpatialTransformationModule();
        int n = 0;
        YN yN = null;
        Matrix2d matrix2d2 = new Matrix2d(matrix2d);
        while (!SpatialTransformationUtils.isIdentityMatrix(matrix2d2) && n < 360) {
            n += 90;
            matrix2d2.mul(Matrix2d.trafoRotL, matrix2d2);
        }
        if (n == 360) {
            matrix2d2.set(matrix2d);
            matrix2d2.mul(Matrix2d.trafoFlipV, matrix2d2);
            n = 0;
            while (!SpatialTransformationUtils.isIdentityMatrix(matrix2d2) && n < 360) {
                n += 90;
                matrix2d2.mul(Matrix2d.trafoRotL, matrix2d2);
            }
            if (n < 360) {
                yN = YN.Yes;
            }
        } else {
            yN = YN.No;
        }
        spatialTransformationModule.setImageHorizontalFlip(yN);
        spatialTransformationModule.setImageRotation(Integer.valueOf(n));
        return spatialTransformationModule;
    }

    private static boolean isIdentityMatrix(Matrix2d matrix2d) {
        return DoubleEquals.equals((double)matrix2d.m00, (double)1.0) && DoubleEquals.equals((double)matrix2d.m01, (double)0.0) && DoubleEquals.equals((double)matrix2d.m10, (double)0.0) && DoubleEquals.equals((double)matrix2d.m11, (double)1.0);
    }

    public static Matrix2d toImageTransform(SpatialTransformationModule spatialTransformationModule) {
        Matrix2d matrix2d = new Matrix2d();
        SpatialTransformationUtils.toImageTransform(spatialTransformationModule, matrix2d);
        return matrix2d;
    }

    public static void toImageTransform(SpatialTransformationModule spatialTransformationModule, Matrix2d matrix2d) {
        int n = spatialTransformationModule.getImageRotation();
        while (n > 0) {
            matrix2d.mul(Matrix2d.trafoRotR, matrix2d);
            n -= 90;
        }
        if (spatialTransformationModule.getImageHorizontalFlip() == YN.Yes) {
            matrix2d.mul(Matrix2d.trafoFlipV, matrix2d);
        }
    }
}

