/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.function.BiFunction;

abstract class AbstractSUVDataAction
extends AbstractPDataAction
implements BiFunction<VisDisplay2, IFrameObjectData, IValueMappingFactory> {
    private static final ALogger LOGGER = ALogger.getLogger(AbstractSUVDataAction.class);

    AbstractSUVDataAction() {
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public abstract IValueMappingFactory apply(VisDisplay2 var1, IFrameObjectData var2);

    abstract class AbstractSUVAction
    extends AbstractPDataAction.AbstractInnerPAction {
        AbstractSUVAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        AbstractSUVAction(String string, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(string, pDataScope, pDataProvider);
        }

        @Override
        public boolean isAvailable() {
            return SUVUtil.isSUVPermitted();
        }

        @Override
        protected boolean isEnabledImpl() {
            return this.provider == null || SUVUtil.isSUVSupported(this.getVisDisplay());
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return SUVUtil.isSUVSupported(visData.getParent().getVisDisplay());
        }

        @Override
        public boolean perform(Component component) {
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            if (visDisplay2 == null || !visDisplay2.hasData()) {
                return false;
            }
            SUVUtil.SUVSupport sUVSupport = SUVUtil.getSUVSupport(visDisplay2);
            if (sUVSupport != SUVUtil.SUVSupport.Supported) {
                LOGGER.debug("SUV calculation not supported for current display: " + (Object)((Object)sUVSupport));
                Message.info(MessageFormat.format(Messages.getString("SUVDataAction." + (Object)((Object)sUVSupport) + ".Warning"), visDisplay2.getData().getPlugin().getDescription()));
                return false;
            }
            this.notifyActionPerformed();
            CursorUtil.setWaitCursor((Component)visDisplay2);
            visDisplay2.getVis(visDisplay2.getNavigPos()).getView().getFrameData().addListener(new SUVActivator(visDisplay2));
            return true;
        }
    }

    private class SUVActivator
    implements IFrameListener {
        private final VisDisplay2 vd;

        SUVActivator(VisDisplay2 visDisplay2) {
            this.vd = visDisplay2;
        }

        @Override
        public void notifyHasError(String string) {
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
        }

        @Override
        public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
            IValueMappingFactory iValueMappingFactory;
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
            if ((iValueMappingFactory = AbstractSUVDataAction.this.apply(this.vd, iFrameObjectData)) != null) {
                TEvent tEvent = new TEvent(120);
                TEventDispatch.sendEventToVis(this.vd, tEvent, iValueMappingFactory, 16);
            }
            if (this.vd.hasAction("SUV")) {
                this.vd.getAction("SUV").forcedSelectionChanged();
            }
            return false;
        }
    }
}

