/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.hap.pacs.data.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.hap.pacs.data.valuemapping.StandardizedUptakeValueMethod;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.valuemapping.suv.AbstractSUVDataAction;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.vis.VisDisplay2;

class SUVActivatorDataAction
extends AbstractSUVDataAction {
    public static final String ID_PREFIX = "SUV_";
    private final StandardizedUptakeValueMethod method;

    SUVActivatorDataAction(StandardizedUptakeValueMethod standardizedUptakeValueMethod) {
        this.method = standardizedUptakeValueMethod;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SUVActivatorAction(pDataScope, pDataProvider);
    }

    @Override
    public String getID() {
        return ID_PREFIX + this.method.name();
    }

    @Override
    public IValueMappingFactory apply(VisDisplay2 visDisplay2, IFrameObjectData iFrameObjectData) {
        ISUVData iSUVData = SUVUtil.getSUVDataForFrame(visDisplay2, iFrameObjectData);
        iSUVData.setMethod((IStandardizedUptakeValueMethod)this.method);
        if (SUVUtil.isSUVApplicable(visDisplay2, iSUVData)) {
            return new SUVMappingFactory(iSUVData);
        }
        return null;
    }

    private class SUVActivatorAction
    extends AbstractSUVDataAction.AbstractSUVAction {
        SUVActivatorAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public boolean isAvailable() {
            return Product.isRunningAutoTests() && super.isAvailable();
        }

        @Override
        public String getCaption() {
            return SUVActivatorDataAction.this.method.getName();
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        @Override
        public String getToolTipText() {
            return SUVActivatorDataAction.this.method.toString();
        }
    }
}

