/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.impaxee.valuemapping.suv.AbstractSUVDataAction;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVCalibrationDialog;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.text.MessageFormat;
import java.util.Date;

public class SUVDataAction
extends AbstractSUVDataAction {
    public static final String ID = "SUV";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SUVAction(pDataScope, pDataProvider);
    }

    @Override
    public String getID() {
        return ID;
    }

    private static Date getEarliestAcquisitionDate(IDisplaySet iDisplaySet) {
        Date date = null;
        for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iDisplaySet.getFrames())) {
            Date date2 = iFrameObjectData.getImageInformation().getAcquisitionDateTime();
            if (date != null && (date2 == null || !date2.before(date))) continue;
            date = date2;
        }
        return date;
    }

    @Override
    public IValueMappingFactory apply(VisDisplay2 visDisplay2, IFrameObjectData iFrameObjectData) {
        DefaultValueMappingOption defaultValueMappingOption = SUVUtil.isSUVActive(visDisplay2) ? new DefaultValueMappingOption(null) : this.createSUVMapping(visDisplay2, iFrameObjectData);
        return defaultValueMappingOption;
    }

    private IValueMappingFactory createSUVMapping(VisDisplay2 visDisplay2, IFrameObjectData iFrameObjectData) {
        ISUVData iSUVData = SUVUtil.getSUVDataForFrame(visDisplay2, iFrameObjectData);
        SUVCalibrationDialog sUVCalibrationDialog = new SUVCalibrationDialog(JVision2.getMainFrame(), iSUVData, SUVDataAction.getEarliestAcquisitionDate(visDisplay2.getData().getDisplaySet()));
        sUVCalibrationDialog.setVisible(true);
        if (sUVCalibrationDialog.isOKPressed()) {
            if (SUVUtil.isSUVApplicable(visDisplay2, iSUVData)) {
                return new SUVMappingFactory(iSUVData);
            }
            Message.info(MessageFormat.format(Messages.getString("SUVDataAction.SupportedOnlyIn2D.Warning"), visDisplay2.getData().getPlugin().getDescription()));
        }
        return null;
    }

    private class SUVAction
    extends AbstractSUVDataAction.AbstractSUVAction {
        SUVAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("suv.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            return Messages.getString("ValueMapping.SUV.Label");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ValueMapping.SUV.ToolTip");
        }

        @Override
        public final boolean isSelectable() {
            return this.provider != null;
        }

        @Override
        public final boolean isSelected() {
            return this.isSelectable() && SUVUtil.isSUVActive(this.getVisDisplay());
        }
    }
}

