/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.hap.pacs.data.valuemapping.DecayCorrectionMethod;
import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.hap.pacs.data.valuemapping.ISUVStudyData;
import com.agfa.hap.pacs.data.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.SUVData;
import com.agfa.hap.pacs.data.valuemapping.SUVMapping;
import com.agfa.hap.pacs.data.valuemapping.SUVStudyData;
import com.agfa.hap.pacs.data.valuemapping.StandardizedUptakeValueMethod;
import com.agfa.hap.pacs.data.valuemapping.ValueMappingUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.DisplaySetUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.valuemapping.ValueMappingProperties;
import com.agfa.pacs.impaxee.valuemapping.suv.ImpaxEESUVMapping;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.ImageInformation2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.renderer.IWindowableRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import org.dcm4che3.data.Attributes;

public class SUVUtil {
    private static final boolean autoApplySUV = Config.impaxee.jvision.ValueMapping.SUV.AutoApply.get();
    private static final Set<PluginName> SUPPORTED_3D_PLUGINS = EnumSet.of(PluginName.EMPR);
    private static final Set<PluginName> SUPPORTED_PLUGINS = EnumSet.of(PluginName.DEFAULT, PluginName.ADDSUB, PluginName.ANIM2D, PluginName.NUK);

    static {
        SUPPORTED_PLUGINS.addAll(SUPPORTED_3D_PLUGINS);
    }

    private SUVUtil() {
    }

    public static boolean isSUVPermitted() {
        return !Product.isCDViewer();
    }

    static SUVSupport getSUVSupport(VisDisplay2 visDisplay2) {
        if (visDisplay2 != null && visDisplay2.getData() != null && visDisplay2.getData().getDisplaySet() != null) {
            PluginName pluginName = visDisplay2.getData().getPlugin().getPluginName();
            if (!SUPPORTED_PLUGINS.contains((Object)pluginName)) {
                return SUVSupport.UnsupportedPlugin;
            }
            IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
            if (SUVUtil.isSUVSupported(iDisplaySet.getOneObject())) {
                if (SUPPORTED_3D_PLUGINS.contains((Object)pluginName) && !SUVUtil.isSUVEnabledForVolume(iDisplaySet)) {
                    return SUVSupport.SupportedOnlyIn2D;
                }
                return SUVSupport.Supported;
            }
        }
        return SUVSupport.UnsupportedData;
    }

    static boolean isSUVSupported(VisDisplay2 visDisplay2) {
        return SUVUtil.getSUVSupport(visDisplay2) == SUVSupport.Supported;
    }

    public static boolean isSUVSupported(IFrameObjectData iFrameObjectData) {
        return iFrameObjectData != null && SUVUtil.isSUVSupported(iFrameObjectData.getImageInformation());
    }

    static boolean isSUVSupported(IImageInformation iImageInformation) {
        return iImageInformation != null && SUVUtil.isSUVSupported(iImageInformation.getDataset(), iImageInformation.getImageClass());
    }

    static boolean isSUVSupported(Attributes attributes) {
        return attributes != null && SUVUtil.isSUVSupported(attributes, ImageInformation2.getImageClass(attributes.getString(524310)));
    }

    private static boolean isSUVSupported(Attributes attributes, IImageInformation.ImageClass imageClass) {
        return imageClass == IImageInformation.ImageClass.PT && ValueMappingUtils.containsDateAndTime((long)2251945843097650L, (Attributes)attributes) && SUVUtil.isBQML(attributes.getString(5509121)) && DecayCorrectionMethod.isSupported((Attributes)attributes);
    }

    private static boolean isSUVEnabledForVolume(IDisplaySet iDisplaySet) {
        ISUVData iSUVData = SUVUtil.getSUVDataForFrame(iDisplaySet, iDisplaySet.getOneObject());
        return !iSUVData.isDataFromDicomComplete() || iSUVData.getAcquisitionDelayStatus(DisplaySetUtils.getAttributes(iDisplaySet)) == ISUVData.AcquisitionDelayStatus.ALL_EQUAL;
    }

    private static boolean isBQML(String string) {
        return "BQML".equalsIgnoreCase(string);
    }

    static boolean isSUVActive(VisDisplay2 visDisplay2) {
        for (VisData visData : visDisplay2.getVisDatas()) {
            if (!SUVUtil.isSUVActive(visData.getView())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSUVActive(View view) {
        if (view != null) {
            Renderer renderer = view.getRenderer();
            return renderer != null && renderer.getImageState().getCurrentValueMapping() instanceof SUVMapping;
        }
        return false;
    }

    static boolean isSUVApplicable(VisDisplay2 visDisplay2, ISUVData iSUVData) {
        if (visDisplay2 == null || visDisplay2.getData() == null) {
            return false;
        }
        PluginName pluginName = visDisplay2.getData().getPlugin().getPluginName();
        if (SUPPORTED_3D_PLUGINS.contains((Object)pluginName)) {
            return SUVUtil.isSUVApplicableForVolume(visDisplay2.getData().getDisplaySet(), iSUVData);
        }
        return SUVUtil.isSUVApplicableForFrame(iSUVData);
    }

    private static boolean isSUVApplicableForFrame(ISUVData iSUVData) {
        return !iSUVData.needsData();
    }

    private static boolean isSUVApplicableForVolume(IDisplaySet iDisplaySet, ISUVData iSUVData) {
        return iDisplaySet != null && !iSUVData.needsData() && iSUVData.getAcquisitionDelayStatus(DisplaySetUtils.getAttributes(iDisplaySet)) == ISUVData.AcquisitionDelayStatus.ALL_EQUAL;
    }

    public static void initSUVMappingForFrame(VisDisplay2 visDisplay2, IWindowableRenderer iWindowableRenderer) {
        SUVUtil.initSUVMapping(visDisplay2, iWindowableRenderer, SUVUtil::isSUVApplicableForFrame);
    }

    public static void initSUVMappingForVolume(VisDisplay2 visDisplay2, IWindowableRenderer iWindowableRenderer) {
        if (visDisplay2 != null && visDisplay2.getData() != null) {
            IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
            SUVUtil.initSUVMapping(visDisplay2, iWindowableRenderer, iSUVData -> SUVUtil.isSUVApplicableForVolume(iDisplaySet, iSUVData));
        }
    }

    private static void initSUVMapping(VisDisplay2 visDisplay2, IWindowableRenderer iWindowableRenderer, Predicate<ISUVData> predicate) {
        if (iWindowableRenderer != null && SUVUtil.isSUVSupported(iWindowableRenderer.getFrameObjectData())) {
            if (visDisplay2 != null) {
                visDisplay2.updateSUVEnabledState();
            }
            if (autoApplySUV && visDisplay2 != null && SUVUtil.activateSUV(visDisplay2, iWindowableRenderer, predicate)) {
                visDisplay2.updateSUVSelectionState();
            }
        }
    }

    private static boolean activateSUV(VisDisplay2 visDisplay2, IWindowableRenderer iWindowableRenderer, Predicate<ISUVData> predicate) {
        ISUVData iSUVData = SUVUtil.getSUVDataForFrame(visDisplay2, iWindowableRenderer.getFrameObjectData());
        if (SUVUtil.isSUVPermitted() && predicate.test(iSUVData)) {
            iWindowableRenderer.getImageState().setCurrentValueMapping((IValueMapping)new ImpaxEESUVMapping(iSUVData, new ValueMappingProperties(iWindowableRenderer)));
            return true;
        }
        return false;
    }

    public static ISUVData getSUVDataForFrame(VisDisplay2 visDisplay2, IFrameObjectData iFrameObjectData) {
        IDisplaySet iDisplaySet = null;
        if (visDisplay2 != null && visDisplay2.hasData()) {
            iDisplaySet = visDisplay2.getData().getDisplaySet();
        }
        return SUVUtil.getSUVDataForFrame(iDisplaySet, iFrameObjectData);
    }

    public static ISUVData getSUVDataForFrame(IDisplaySet iDisplaySet, IFrameObjectData iFrameObjectData) {
        ISUVData iSUVData = null;
        if (iDisplaySet != null) {
            iSUVData = iDisplaySet.getSUVData();
        }
        if (iSUVData == null) {
            IStudyData iStudyData = iFrameObjectData.getParent().getParent();
            ISUVStudyData iSUVStudyData = iStudyData.getSUVData();
            if (iSUVStudyData == null) {
                iSUVStudyData = new SUVStudyData(iFrameObjectData.getDicomObject(), SUVUtil.getDefaultMethod());
                iStudyData.setSUVData(iSUVStudyData);
            }
            iSUVData = new SUVData(iFrameObjectData.getDicomObject(), SUVUtil.getBaseDateForSUVCalculation(iDisplaySet), iSUVStudyData);
            if (iDisplaySet != null) {
                iDisplaySet.setSUVData(iSUVData);
            }
        }
        return iSUVData;
    }

    private static Date getBaseDateForSUVCalculation(IDisplaySet iDisplaySet) {
        if (iDisplaySet == null) {
            return null;
        }
        Attributes attributes = iDisplaySet.getOneObject().getDicomObject();
        Date date = ValueMappingUtils.getDateAndTime((long)2251941548130353L, (Attributes)attributes);
        Date date2 = ValueMappingUtils.getDateAndTime((long)2251945843097650L, (Attributes)attributes);
        if (date == null || date2 == null || date.after(date2)) {
            return null;
        }
        for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iDisplaySet.getFrames())) {
            Date date3 = iFrameObjectData.getImageInformation().getAcquisitionDateTime();
            if (date3 != null && date3.equals(date2)) continue;
            return null;
        }
        return date;
    }

    public static StandardizedUptakeValueMethod[] getMethods() {
        return StandardizedUptakeValueMethod.values();
    }

    static IStandardizedUptakeValueMethod getDefaultMethod() {
        try {
            return StandardizedUptakeValueMethod.valueOf((String)Config.impaxee.jvision.ValueMapping.SUV.Method.get());
        }
        catch (Exception exception) {
            return StandardizedUptakeValueMethod.BodyWeight;
        }
    }

    static enum SUVSupport {
        Supported,
        SupportedOnlyIn2D,
        UnsupportedPlugin,
        UnsupportedData;

    }
}

