/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigTree;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigListModel;
import com.agfa.pacs.impaxee.vismenu.AbstractVisMenuModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuActionConfigItem;
import com.agfa.pacs.impaxee.vismenu.VisMenuItemsModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuTemplateAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class VisMenuItemsConfigModel {
    private AbstractVisMenuModel menuModel;
    private List<VisMenuActionConfigItem> items;
    private VisMenuActionHandler actionListener;
    private ItemsListModelAdapter itemsListModelAdapter;
    private ItemsTreeModelAdapter itemsTreeModelAdapter;
    private Collection<IVisMenuConfigModelListener> listeners;
    private boolean modified = false;

    private VisMenuItemsConfigModel(AbstractVisMenuModel abstractVisMenuModel) {
        this.menuModel = abstractVisMenuModel;
        this.actionListener = new VisMenuActionHandler();
        this.items = new ArrayList<VisMenuActionConfigItem>();
        this.itemsListModelAdapter = new ItemsListModelAdapter(this.items);
        this.itemsTreeModelAdapter = new ItemsTreeModelAdapter(this.items);
        this.init();
    }

    public static VisMenuItemsConfigModel createRuntimeInstance() {
        return new VisMenuItemsConfigModel(VisMenuItemsModel.getRuntimeInstance());
    }

    public static VisMenuItemsConfigModel createInstance(AbstractVisMenuModel abstractVisMenuModel) {
        return new VisMenuItemsConfigModel(abstractVisMenuModel);
    }

    public AbstractVisMenuModel getMenuModel() {
        return this.menuModel;
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getItemCount() {
        int n = 0;
        if (this.items != null) {
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                n += visMenuActionConfigItem.getLeafItemCount();
            }
        }
        return n;
    }

    public Collection<VisMenuActionConfigItem> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    public boolean addItem(VisMenuActionConfigItem visMenuActionConfigItem) {
        return this.insertItemAt(visMenuActionConfigItem, this.items.size());
    }

    public boolean insertItemAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
        return this.insertItemAt(null, visMenuActionConfigItem, n);
    }

    public boolean insertItemAt(VisMenuActionConfigItem visMenuActionConfigItem, VisMenuActionConfigItem visMenuActionConfigItem2, int n) {
        boolean bl = false;
        if (visMenuActionConfigItem == null) {
            if (!this.items.contains(visMenuActionConfigItem2)) {
                visMenuActionConfigItem2.getVisMenuAction().addActionListener(this.actionListener);
                this.items.add(n, visMenuActionConfigItem2);
                this.updatePositionToIndex(this.items);
                bl = true;
            }
        } else if (visMenuActionConfigItem.getVisMenuAction() instanceof VisMenuSubmenuAction && visMenuActionConfigItem.insertSubItemAt(visMenuActionConfigItem2, n)) {
            bl = true;
        }
        if (bl) {
            this.modified = true;
            this.fireItemAdded(visMenuActionConfigItem2);
        }
        return bl;
    }

    public boolean removeItem(VisMenuActionConfigItem visMenuActionConfigItem) {
        boolean bl = false;
        visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
        bl = this.items.remove(visMenuActionConfigItem);
        if (bl) {
            this.updatePositionToIndex(this.items);
        }
        if (bl) {
            this.modified = true;
            this.fireItemRemoved(visMenuActionConfigItem);
        }
        return bl;
    }

    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
            }
            this.items.clear();
            this.modified = true;
            this.fireAllItemsRemoved();
        }
    }

    public IActionConfigListModel<VisMenuActionConfigItem> getItemsListModel() {
        return this.itemsListModelAdapter;
    }

    public ItemsTreeModelAdapter getItemsTreeModel() {
        return this.itemsTreeModelAdapter;
    }

    public List<PAction> getAvailableActions() {
        List<PAction> list = PActionRegistry.getAllUserConfigurableTextActions();
        ActionUIUtilities.removeActionByID(list, "ONLY_ONE_STUDY");
        for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
            this.checkToRemoveFromAvailableActions(list, visMenuActionConfigItem);
        }
        Collections.sort(list, new Comparator<PAction>(){

            @Override
            public int compare(PAction pAction, PAction pAction2) {
                String string = ActionUIUtilities.getActionConfigText(pAction);
                String string2 = ActionUIUtilities.getActionConfigText(pAction2);
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null) {
                    return -1;
                }
                if (string2 != null) {
                    return 1;
                }
                return -1;
            }
        });
        list.add(0, new VisMenuSubmenuTemplateAction());
        return list;
    }

    public void update() {
        this.init();
    }

    public void save() {
        if (this.modified) {
            this.menuModel.removeAllActions();
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                this.menuModel.addAction(visMenuActionConfigItem.getVisMenuAction());
            }
            this.menuModel.save();
        }
    }

    public void addModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVisMenuConfigModelListener>();
        }
        if (!this.listeners.contains(iVisMenuConfigModelListener)) {
            this.listeners.add(iVisMenuConfigModelListener);
        }
    }

    public void removeModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(iVisMenuConfigModelListener);
        }
    }

    public VisMenuActionConfigItem findItem(PAction pAction) {
        return VisMenuItemsConfigModel.findItem(this.items, pAction);
    }

    private void init() {
        this.removeAllItems();
        for (Map.Entry<VisMenuAction, PAction> entry : this.menuModel.getActions(null).entrySet()) {
            VisMenuAction visMenuAction = entry.getKey().copy();
            visMenuAction.addActionListener(this.actionListener);
            this.items.add(VisMenuActionConfigItem.create(visMenuAction, entry.getValue()));
        }
        this.updatePositionToIndex(this.items);
        this.itemsListModelAdapter.notifyModelChange();
        this.itemsTreeModelAdapter.setRoot(new ItemTreeNode(this.items));
        this.modified = false;
    }

    private void updatePositionToIndex(Collection<VisMenuActionConfigItem> collection) {
        int n = 0;
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
            visMenuActionConfigItem.getVisMenuAction().setPosition(n);
            visMenuActionConfigItem.getVisMenuAction().addActionListener(this.actionListener);
            ++n;
        }
    }

    private static VisMenuActionConfigItem findItem(Collection<VisMenuActionConfigItem> collection, VisMenuAction visMenuAction) {
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            if (!visMenuActionConfigItem.getVisMenuAction().equals(visMenuAction)) continue;
            return visMenuActionConfigItem;
        }
        return null;
    }

    private static VisMenuActionConfigItem findItem(Collection<VisMenuActionConfigItem> collection, PAction pAction) {
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            if (!visMenuActionConfigItem.getAction().equals(pAction)) continue;
            return visMenuActionConfigItem;
        }
        return null;
    }

    private void checkToRemoveFromAvailableActions(List<PAction> list, VisMenuActionConfigItem visMenuActionConfigItem) {
        List<VisMenuActionConfigItem> list2;
        if (!"SEPARATOR".equals(visMenuActionConfigItem.getAction().getID())) {
            list.remove(visMenuActionConfigItem.getAction());
        }
        if ((list2 = visMenuActionConfigItem.getSubItems()) != null) {
            for (VisMenuActionConfigItem visMenuActionConfigItem2 : list2) {
                this.checkToRemoveFromAvailableActions(list, visMenuActionConfigItem2);
            }
        }
    }

    private void fireItemAdded(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemAdded(visMenuActionConfigItem);
            }
        }
    }

    private void fireItemRemoved(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemRemoved(visMenuActionConfigItem);
            }
        }
    }

    private void fireItemChanged(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemChanged(visMenuActionConfigItem);
            }
        }
    }

    private void fireAllItemsRemoved() {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.allItemsRemoved();
            }
        }
    }

    public static interface IVisMenuConfigModelListener {
        public void itemAdded(VisMenuActionConfigItem var1);

        public void itemRemoved(VisMenuActionConfigItem var1);

        public void itemChanged(VisMenuActionConfigItem var1);

        public void allItemsRemoved();
    }

    public static class ItemNodeObject
    extends ActionConfigTree.ActionNodeObject {
        private VisMenuActionConfigItem item;

        public ItemNodeObject(VisMenuActionConfigItem visMenuActionConfigItem) {
            super(visMenuActionConfigItem.getAction());
            this.item = visMenuActionConfigItem;
        }

        public VisMenuActionConfigItem getItem() {
            return this.item;
        }

        @Override
        public ItemNodeObject copy() {
            return new ItemNodeObject(this.item);
        }

        @Override
        public void configureCellRendererComponent(JTree jTree, Component component, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.configureCellRendererComponent(jTree, component, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (this.item.getVisMenuAction() instanceof VisMenuSubmenuAction) {
                    jLabel.setFont(jTree.getFont().deriveFont(3));
                    jLabel.setText(((VisMenuSubmenuAction)this.item.getVisMenuAction()).getCaption());
                } else {
                    jLabel.setFont(jTree.getFont().deriveFont(0));
                }
            }
        }
    }

    public class ItemTreeNode
    extends DefaultMutableTreeNode {
        public ItemTreeNode(VisMenuActionConfigItem visMenuActionConfigItem) {
            if (visMenuActionConfigItem != null) {
                this.setUserObject(new ItemNodeObject(visMenuActionConfigItem));
                List<VisMenuActionConfigItem> list = visMenuActionConfigItem.getSubItems();
                if (list != null && !list.isEmpty()) {
                    for (VisMenuActionConfigItem visMenuActionConfigItem2 : list) {
                        this.add(new ItemTreeNode(visMenuActionConfigItem2));
                    }
                }
            }
        }

        public ItemTreeNode(List<VisMenuActionConfigItem> list) {
            if (list != null) {
                for (VisMenuActionConfigItem visMenuActionConfigItem : list) {
                    this.add(new ItemTreeNode(visMenuActionConfigItem));
                }
            }
        }

        public ItemTreeNode createAndInsertAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            ItemTreeNode itemTreeNode;
            if (this.getAllowsChildren() && this.insertNodeAt(itemTreeNode = new ItemTreeNode(visMenuActionConfigItem), n < 0 ? this.getChildCount() : n)) {
                return itemTreeNode;
            }
            return null;
        }

        public boolean remove(VisMenuActionConfigItem visMenuActionConfigItem) {
            VisMenuActionConfigItem visMenuActionConfigItem2 = this.getItem();
            if (visMenuActionConfigItem2 == null) {
                return VisMenuItemsConfigModel.this.removeItem(visMenuActionConfigItem);
            }
            return visMenuActionConfigItem2.removeSubItem(visMenuActionConfigItem);
        }

        public ItemTreeNode findNode(PAction pAction) {
            VisMenuActionConfigItem visMenuActionConfigItem = this.getItem();
            if (visMenuActionConfigItem != null && visMenuActionConfigItem.getAction().equals(pAction)) {
                return this;
            }
            int n = this.getChildCount();
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    ItemTreeNode itemTreeNode = ((ItemTreeNode)this.getChildAt(n2)).findNode(pAction);
                    if (itemTreeNode != null) {
                        return itemTreeNode;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public ItemTreeNode findNode(ActionConfigTree.NodeObject nodeObject) {
            Object object = this.getUserObject();
            if (object != null && object.equals(nodeObject)) {
                return this;
            }
            int n = this.getChildCount();
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    ItemTreeNode itemTreeNode = ((ItemTreeNode)this.getChildAt(n2)).findNode(nodeObject);
                    if (itemTreeNode != null) {
                        return itemTreeNode;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean isEditable() {
            return this.getItem() != null && this.getItem().getVisMenuAction() instanceof VisMenuSubmenuAction;
        }

        public VisMenuActionConfigItem getItem() {
            ItemNodeObject itemNodeObject = (ItemNodeObject)this.getUserObject();
            return itemNodeObject != null ? itemNodeObject.getItem() : null;
        }

        @Override
        public ItemTreeNode getParent() {
            return (ItemTreeNode)super.getParent();
        }

        @Override
        public boolean getAllowsChildren() {
            return this.getItem() == null || this.getItem().getVisMenuAction() instanceof VisMenuSubmenuAction;
        }

        public boolean insertNodeAt(ItemTreeNode itemTreeNode, int n) {
            if (this.getAllowsChildren() && VisMenuItemsConfigModel.this.insertItemAt(this.getItem(), itemTreeNode.getItem(), n)) {
                this.insert(itemTreeNode, n < 0 ? this.getChildCount() : n);
                return true;
            }
            return false;
        }
    }

    private class ItemsListModelAdapter
    extends AbstractListModel<VisMenuActionConfigItem>
    implements IActionConfigListModel<VisMenuActionConfigItem> {
        private List<VisMenuActionConfigItem> items;

        public ItemsListModelAdapter(List<VisMenuActionConfigItem> list) {
            this.items = list;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public boolean hasElement(VisMenuActionConfigItem visMenuActionConfigItem) {
            return this.items.contains(visMenuActionConfigItem);
        }

        @Override
        public boolean hasAction(PAction pAction) {
            return VisMenuItemsConfigModel.findItem((Collection<VisMenuActionConfigItem>)this.items, pAction) != null;
        }

        @Override
        public VisMenuActionConfigItem createElement(PAction pAction) {
            VisMenuAction visMenuAction = new VisMenuAction(pAction.getID(), -1);
            visMenuAction.addActionListener(VisMenuItemsConfigModel.this.actionListener);
            return VisMenuActionConfigItem.create(visMenuAction, pAction);
        }

        @Override
        public VisMenuActionConfigItem getElement(PAction pAction) {
            return VisMenuItemsConfigModel.findItem((Collection<VisMenuActionConfigItem>)this.items, pAction);
        }

        @Override
        public VisMenuActionConfigItem getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public void setElements(Collection<VisMenuActionConfigItem> collection) {
            this.removeAllElements();
            if (collection != null && collection.size() > 0) {
                for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
                    VisMenuItemsConfigModel.this.addItem(visMenuActionConfigItem);
                }
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        @Override
        public void insertElementAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            if (VisMenuItemsConfigModel.this.insertItemAt(visMenuActionConfigItem, n)) {
                this.fireIntervalAdded(this, n, n);
            }
        }

        @Override
        public void removeElement(VisMenuActionConfigItem visMenuActionConfigItem) {
            int n = this.items.indexOf(visMenuActionConfigItem);
            if (VisMenuItemsConfigModel.this.removeItem(visMenuActionConfigItem)) {
                this.fireIntervalRemoved(this, n, n);
            }
        }

        @Override
        public void removeAllElements() {
            int n = this.getSize();
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                visMenuActionConfigItem.getVisMenuAction().removeActionListener(VisMenuItemsConfigModel.this.actionListener);
            }
            this.items.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        @Override
        public void moveElement(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            int n2 = this.items.indexOf(visMenuActionConfigItem);
            this.removeElement(visMenuActionConfigItem);
            this.insertElementAt(visMenuActionConfigItem, n2 < n ? n - 1 : n);
        }

        protected void notifyModelChange() {
            this.fireContentsChanged(this, 0, VisMenuItemsConfigModel.this.getItemCount());
        }
    }

    public class ItemsTreeModelAdapter
    extends DefaultTreeModel {
        public ItemsTreeModelAdapter(List<VisMenuActionConfigItem> list) {
            super(new ItemTreeNode(list), true);
        }

        public VisMenuActionConfigItem createItem(PAction pAction) {
            return VisMenuActionConfigItem.create(pAction);
        }

        public ItemTreeNode insertItemIntoParent(ItemTreeNode itemTreeNode, VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            ItemTreeNode itemTreeNode2 = itemTreeNode.createAndInsertAt(visMenuActionConfigItem, n);
            if (itemTreeNode2 != null) {
                super.nodesWereInserted(itemTreeNode, new int[]{itemTreeNode.getIndex(itemTreeNode2)});
            }
            return itemTreeNode2;
        }

        public boolean removeFromParent(ItemTreeNode itemTreeNode) {
            ItemTreeNode itemTreeNode2 = itemTreeNode.getParent();
            if (itemTreeNode2 != null && itemTreeNode2.remove(itemTreeNode.getItem())) {
                this.removeNodeFromParent(itemTreeNode);
                return true;
            }
            return false;
        }

        public boolean moveToParent(ItemTreeNode itemTreeNode, ItemTreeNode itemTreeNode2, int n) {
            ItemTreeNode itemTreeNode3 = itemTreeNode2.getParent();
            if (itemTreeNode3 != null && (itemTreeNode.getIndex(itemTreeNode2) == -1 || itemTreeNode3.getIndex(itemTreeNode2) != n)) {
                int n2 = n;
                if (n > 0 && itemTreeNode == itemTreeNode2.getParent() && itemTreeNode.getIndex(itemTreeNode2) < n) {
                    n2 = Math.max(0, n - 1);
                }
                if (this.removeFromParent(itemTreeNode2)) {
                    if (itemTreeNode.insertNodeAt(itemTreeNode2, n2 < 0 ? itemTreeNode.getChildCount() : n2)) {
                        this.nodesWereInserted(itemTreeNode, new int[]{itemTreeNode.getIndex(itemTreeNode2)});
                    }
                    return true;
                }
            }
            return false;
        }

        public ItemTreeNode findNode(PAction pAction) {
            return ((ItemTreeNode)this.getRoot()).findNode(pAction);
        }

        public ItemTreeNode findNode(ActionConfigTree.NodeObject nodeObject) {
            return ((ItemTreeNode)this.getRoot()).findNode(nodeObject);
        }
    }

    private class VisMenuActionHandler
    implements VisMenuAction.VisMenuActionListener {
        private VisMenuActionHandler() {
        }

        @Override
        public void actionChanged(VisMenuAction visMenuAction) {
            VisMenuActionConfigItem visMenuActionConfigItem = VisMenuItemsConfigModel.findItem((Collection<VisMenuActionConfigItem>)VisMenuItemsConfigModel.this.items, visMenuAction);
            if (visMenuActionConfigItem != null) {
                int n = VisMenuItemsConfigModel.this.items.indexOf(visMenuActionConfigItem);
                if (VisMenuItemsConfigModel.this.items.remove(visMenuActionConfigItem)) {
                    VisMenuItemsConfigModel.this.items.add(n, visMenuActionConfigItem);
                }
            }
            if (visMenuActionConfigItem != null) {
                VisMenuItemsConfigModel.this.modified = true;
                VisMenuItemsConfigModel.this.fireItemChanged(visMenuActionConfigItem);
            }
        }
    }
}

