/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.AbstractActionConfigListModel;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigItem;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigList;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigTree;
import com.agfa.pacs.impaxee.actions.ui.config.ActionDnD;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigItem;
import com.agfa.pacs.impaxee.vismenu.VisMenuItemsConfigModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuItemsConfigTree;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;

public class VisMenuItemsConfigPanel
extends JPanel {
    private static final ALogger log = ALogger.getLogger(VisMenuItemsConfigPanel.class);
    private VisMenuItemsConfigModel model;
    private final IComponentFactory componentFactory;
    private JPanel availPanel;
    private JPanel configPanel;
    private JPanel buttonPanel;
    private JButton resetToDefaultBtn;
    private JButton resetToRoleBtn;
    private JButton exportBtn;
    private JButton importBtn;
    private JLabel availSearchLabel;
    private JTextField availSearchField;
    private AvailableActionList availList;
    private JScrollPane availListScrollPane;
    private JScrollPane configTreeScrollPane;
    private VisMenuItemsConfigTree configTree;

    public VisMenuItemsConfigPanel(VisMenuItemsConfigModel visMenuItemsConfigModel, IComponentFactory iComponentFactory) {
        this.model = visMenuItemsConfigModel;
        this.componentFactory = iComponentFactory;
        this.createComponents();
        this.initComponents();
        this.installLayout();
        this.installListeners();
    }

    public void update() {
        this.availList.init(this.model.getAvailableActions());
        this.configTree.setModel(this.model.getItemsTreeModel());
    }

    public boolean isButtonPanelVisible() {
        return this.buttonPanel.isVisible();
    }

    public void setButtonPanelVisible(boolean bl) {
        this.buttonPanel.setVisible(bl);
    }

    private void createComponents() {
        this.availList = new AvailableActionList(this.model.getAvailableActions());
        this.configTree = new VisMenuItemsConfigTree(this.model.getItemsTreeModel(), this.componentFactory){

            @Override
            protected ActionConfigTree.ActionTreeAction[] getMenuActions() {
                return new ActionConfigTree.ActionTreeAction[]{new RemoveAction(this), new EditCaptionAction(this)};
            }
        };
        this.availPanel = new JPanel();
        this.configPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.resetToDefaultBtn = this.componentFactory.createButton((Action)new ResetToDefaultAction());
        this.resetToRoleBtn = this.componentFactory.createButton((Action)new ResetToRoleAction());
        this.exportBtn = this.componentFactory.createButton((Action)new ExportAction());
        this.importBtn = this.componentFactory.createButton((Action)new ImportAction());
        this.availSearchField = this.componentFactory.createTextField();
        this.availSearchLabel = this.componentFactory.createLabel(Messages.getString("ActionConfigDialog.SearchTool.Text"));
        this.configTreeScrollPane = this.componentFactory.createScrollPane((Component)this.configTree, Integer.valueOf(20), Integer.valueOf(31), Boolean.valueOf(true), Boolean.valueOf(false));
        this.availListScrollPane = this.componentFactory.createScrollPane((Component)this.availList, Integer.valueOf(20), Integer.valueOf(30), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private void initComponents() {
        this.componentFactory.scaleFont((Component)this.availList);
        this.componentFactory.scaleFont((Component)this.configTree);
        this.availSearchLabel.setEnabled(false);
        this.availList.setOpaque(false);
        this.configTree.setOpaque(false);
        this.availList.setBackground(new Color(0, 0, 0, 0));
        this.updateTitles();
    }

    private void installLayout() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)this.availSearchLabel, "West");
        jPanel.add((Component)this.availSearchField, "Center");
        jPanel.add((Component)SwingUtilities2.createSeparator((JSeparator2.SeparatorOrientation)JSeparator2.SeparatorOrientation.HORIZONTAL, (JSeparator2.SeparatorType)JSeparator2.SeparatorType.LINE, null), "South");
        this.buttonPanel.setLayout(new GridLayout(2, 2, 2, 2));
        this.buttonPanel.add(this.resetToDefaultBtn);
        this.buttonPanel.add(this.resetToRoleBtn);
        this.buttonPanel.add(this.exportBtn);
        this.buttonPanel.add(this.importBtn);
        this.configPanel.setLayout(new BorderLayout(0, 5));
        this.configPanel.add((Component)this.configTreeScrollPane, "Center");
        this.configPanel.add((Component)this.buttonPanel, "South");
        this.availPanel.setLayout(new BorderLayout(0, 10));
        this.availPanel.add((Component)jPanel, "North");
        this.availPanel.add((Component)this.availListScrollPane, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.setLayout(new GridLayout(1, 2, 10, 0));
        this.add(this.availPanel);
        this.add(this.configPanel);
    }

    private void installListeners() {
        ListDataListener listDataListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                VisMenuItemsConfigPanel.this.updateTitles();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (listDataEvent.getSource() != VisMenuItemsConfigPanel.this.availList.getModel()) {
                    VisMenuItemsConfigPanel.this.updateAvailableList();
                }
                VisMenuItemsConfigPanel.this.updateTitles();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                VisMenuItemsConfigPanel.this.updateTitles();
            }
        };
        TreeModelListener treeModelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                VisMenuItemsConfigPanel.this.updateAvailableList();
                VisMenuItemsConfigPanel.this.updateTitles();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                VisMenuItemsConfigPanel.this.updateAvailableList();
                VisMenuItemsConfigPanel.this.updateTitles();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                VisMenuItemsConfigPanel.this.updateTitles();
            }
        };
        SearchActionHandler searchActionHandler = new SearchActionHandler();
        this.availList.getModel().addListDataListener(listDataListener);
        this.configTree.getModel().addTreeModelListener(treeModelListener);
        this.availSearchField.getDocument().addDocumentListener(searchActionHandler);
        this.availSearchField.addKeyListener(searchActionHandler);
    }

    private void updateTitles() {
        this.availPanel.setBorder(this.componentFactory.createTitledBorder(this.getAvailableActionsTitle()));
        this.configTreeScrollPane.setBorder(this.componentFactory.createTitledBorder(this.getMenuItemsActionsTitle()));
    }

    private void updateAvailableList() {
        this.availList.init(this.model.getAvailableActions());
    }

    private String getAvailableActionsTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("ActionConfigDialog.AvailableActions"));
        stringBuilder.append(" (");
        stringBuilder.append(this.availList.getModel().getSize());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String getMenuItemsActionsTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("ActionConfigDialog.ConfiguredActions"));
        stringBuilder.append(" (");
        stringBuilder.append(this.model.getItemCount());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private class AvailableActionList
    extends ActionConfigList<ActionConfigItem> {
        public AvailableActionList(List<PAction> list) {
            super(new AbstractActionConfigListModel<ActionConfigItem>(list){

                @Override
                public ActionConfigItem createElement(PAction pAction) {
                    return new ActionConfigItem(pAction);
                }
            }, VisMenuItemsConfigPanel.this.componentFactory);
            this.setDropMode(DropMode.INSERT);
        }

        @Override
        protected boolean handleDndImport(TransferHandler.TransferSupport transferSupport) throws Exception {
            return true;
        }

        @Override
        protected boolean canHandleDndImport(TransferHandler.TransferSupport transferSupport) throws Exception {
            JList.DropLocation dropLocation;
            if (super.canHandleDndImport(transferSupport) && (dropLocation = (JList.DropLocation)transferSupport.getDropLocation()).getIndex() >= 0) {
                PAction pAction;
                block4: {
                    try {
                        pAction = (PAction)transferSupport.getTransferable().getTransferData(ActionDnD.ActionFlavor);
                        if (!"SEPARATOR".equals(pAction.getID())) break block4;
                        return true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {}
                }
                return !this.getModel().hasAction(pAction);
            }
            return false;
        }

        @Override
        protected boolean handleDndExport(JComponent jComponent, Transferable transferable, int n) throws Exception {
            ActionConfigItem actionConfigItem = (ActionConfigItem)transferable.getTransferData(ActionDnD.ActionItemFlavor);
            if (!"SEPARATOR".equals(actionConfigItem.getAction().getID()) && !"VIS_MENU_SUBMENU".equals(actionConfigItem.getAction().getID())) {
                return super.handleDndExport(jComponent, transferable, n);
            }
            return false;
        }

        @Override
        protected Collection<ActionConfigList.ActionListAction> getMenuActions() {
            ArrayList<ActionConfigList.ActionListAction> arrayList = new ArrayList<ActionConfigList.ActionListAction>();
            arrayList.add(new AddSelectedAction(this));
            return arrayList;
        }

        private class AddSelectedAction
        extends ActionConfigList.ActionListAction {
            public AddSelectedAction(AvailableActionList availableActionList2) {
                super(availableActionList2, Messages.getString("ActionConfigDialog.AddTool.Text"));
            }

            protected boolean canPerform(ActionConfigItem actionConfigItem) {
                return actionConfigItem != null;
            }

            protected void perform(ActionConfigItem actionConfigItem) {
                VisMenuItemsConfigModel.ItemsTreeModelAdapter itemsTreeModelAdapter = (VisMenuItemsConfigModel.ItemsTreeModelAdapter)VisMenuItemsConfigPanel.this.configTree.getModel();
                itemsTreeModelAdapter.insertItemIntoParent((VisMenuItemsConfigModel.ItemTreeNode)itemsTreeModelAdapter.getRoot(), itemsTreeModelAdapter.createItem(actionConfigItem.getAction()), -1);
                if (!"SEPARATOR".equals(actionConfigItem.getAction().getID()) && !"VIS_MENU_SUBMENU".equals(actionConfigItem.getAction().getID())) {
                    this.list.getModel().removeElement(actionConfigItem);
                }
            }
        }
    }

    private class EditCaptionAction
    extends ActionConfigTree.ActionTreeAction {
        public EditCaptionAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.EditToolCaption.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (defaultMutableTreeNode instanceof VisMenuItemsConfigModel.ItemTreeNode) {
                return ((VisMenuItemsConfigModel.ItemTreeNode)defaultMutableTreeNode).isEditable();
            }
            return false;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (defaultMutableTreeNode instanceof VisMenuItemsConfigModel.ItemTreeNode) {
                this.tree.startEditingAtPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super(Messages.getString("ActionConfigDialog.Export.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File file;
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                if (VisMenuItemsConfigPanel.this.model.isModified()) {
                    file = MessageDialog.createMessageDialog((Component)VisMenuItemsConfigPanel.this, (String)Messages.getString("ActionConfigDialog.Export.UnsavedChangesDialog.Title"), (Object)Messages.getString("ActionConfigDialog.Export.UnsavedChangesDialog.Message"), (boolean)true, (int)4, (String)"OK_CANCEL_OPTION");
                    file.showCenteredInOwner();
                    if ("OK_OPTION".equals(file.getSelectedOption())) {
                        VisMenuItemsConfigPanel.this.model.save();
                    } else {
                        return;
                    }
                }
                try {
                    file = ActionUIUtilities.getSettingsFile(false, VisMenuItemsConfigPanel.this);
                    if (file != null) {
                        ActionUIUtilities.writeToFile(file, VisMenuItemsConfigPanel.this.model.getMenuModel().toXML());
                    }
                }
                catch (Exception exception) {
                    log.error("Exporting vis-menu items configuration failed!", (Throwable)exception);
                    MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("ActionConfigDialog.Export.ErrorDialog.Title"), (Object)Messages.getString("ActionConfigDialog.Export.ErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
                    ImpaxEEUtils.showMessageDialogCenteredInWindow(messageDialog);
                }
            }
            finally {
                if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                    CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                }
            }
        }
    }

    private class ImportAction
    extends AbstractAction {
        public ImportAction() {
            super(Messages.getString("ActionConfigDialog.Import.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                try {
                    CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                    File file = ActionUIUtilities.getSettingsFile(true, VisMenuItemsConfigPanel.this);
                    if (file != null) {
                        Document document = ActionUIUtilities.readFromFile(file);
                        VisMenuItemsConfigPanel.this.model.getMenuModel().init(document);
                        VisMenuItemsConfigPanel.this.model.update();
                        VisMenuItemsConfigPanel.this.update();
                    }
                }
                catch (Exception exception) {
                    log.error("Importing vis-menu items configuration failed!", (Throwable)exception);
                    MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("ActionConfigDialog.Import.ErrorDialog.Title"), (Object)Messages.getString("ActionConfigDialog.Import.ErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
                    ImpaxEEUtils.showMessageDialogCenteredInWindow(messageDialog);
                    if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                        CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                    }
                }
            }
            finally {
                if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                    CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                }
            }
        }
    }

    private class RemoveAction
    extends ActionConfigTree.ActionTreeAction {
        public RemoveAction(ActionConfigTree actionConfigTree) {
            super(actionConfigTree, Messages.getString("ActionConfigDialog.RemoveTool.Text"));
        }

        @Override
        protected boolean canPerform(DefaultMutableTreeNode defaultMutableTreeNode) {
            return true;
        }

        @Override
        protected void perform(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (defaultMutableTreeNode instanceof VisMenuItemsConfigModel.ItemTreeNode && ((VisMenuItemsConfigModel.ItemsTreeModelAdapter)this.tree.getModel()).removeFromParent((VisMenuItemsConfigModel.ItemTreeNode)defaultMutableTreeNode)) {
                VisMenuItemsConfigPanel.this.updateAvailableList();
            }
        }
    }

    private class ResetToDefaultAction
    extends AbstractAction {
        public ResetToDefaultAction() {
            super(Messages.getString("ActionConfigDialog.ResetToDefault.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                try {
                    CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                    VisMenuItemsConfigPanel.this.model.getMenuModel().resetToDefault();
                    VisMenuItemsConfigPanel.this.model.update();
                    VisMenuItemsConfigPanel.this.update();
                }
                catch (Exception exception) {
                    log.error("Reseting vis-menu configuration to default failed!", (Throwable)exception);
                    MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("VisMenu.ResetToDefault.ErrorDialog.Title"), (Object)Messages.getString("VisMenu.ResetToDefault.ErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
                    ImpaxEEUtils.showMessageDialogCenteredInWindow(messageDialog);
                    if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                        CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                    }
                }
            }
            finally {
                if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                    CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                }
            }
        }
    }

    private class ResetToRoleAction
    extends AbstractAction {
        public ResetToRoleAction() {
            super(Messages.getString("ActionConfigDialog.ResetToRole.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                try {
                    CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                    VisMenuItemsConfigPanel.this.model.getMenuModel().resetToRole();
                    VisMenuItemsConfigPanel.this.model.update();
                    VisMenuItemsConfigPanel.this.update();
                }
                catch (Exception exception) {
                    log.error("Reseting vis-menu configuration to role failed!", (Throwable)exception);
                    MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("VisMenu.ResetToRole.ErrorDialog.Title"), (Object)Messages.getString("VisMenu.ResetToRole.ErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
                    ImpaxEEUtils.showMessageDialogCenteredInWindow(messageDialog);
                    if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                        CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                    }
                }
            }
            finally {
                if (CursorUtil.isWaitCursor((Component)JVision2.getMainFrame())) {
                    CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                }
            }
        }
    }

    private class SearchActionHandler
    extends KeyAdapter
    implements DocumentListener {
        private SearchActionHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (40 == keyEvent.getKeyCode()) {
                this.searchAction(VisMenuItemsConfigPanel.this.availSearchField.getText(), VisMenuItemsConfigPanel.this.availList.getSelectedIndex() + 1);
                keyEvent.consume();
            } else if (27 == keyEvent.getKeyCode()) {
                ((JTextField)keyEvent.getSource()).setText("");
                keyEvent.consume();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.searchAction(VisMenuItemsConfigPanel.this.availSearchField.getText(), 0);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.searchAction(VisMenuItemsConfigPanel.this.availSearchField.getText(), 0);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.searchAction(VisMenuItemsConfigPanel.this.availSearchField.getText(), 0);
        }

        private void searchAction(String string, int n) {
            IActionConfigItem iActionConfigItem;
            if (string != null && string.length() > 0 && (iActionConfigItem = VisMenuItemsConfigPanel.this.availList.findItem(string, n)) != null) {
                VisMenuItemsConfigPanel.this.availList.setSelectedValue(iActionConfigItem, true);
                return;
            }
            VisMenuItemsConfigPanel.this.availList.clearSelection();
        }
    }
}

