/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigTree;
import com.agfa.pacs.impaxee.vismenu.VisMenuActionConfigItem;
import com.agfa.pacs.impaxee.vismenu.VisMenuItemsConfigModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuTemplateAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DropMode;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class VisMenuItemsConfigTree
extends ActionConfigTree {
    private final VisMenuItemsConfigModel.ItemsTreeModelAdapter itemsTreeModel;

    public VisMenuItemsConfigTree(VisMenuItemsConfigModel.ItemsTreeModelAdapter itemsTreeModelAdapter, IComponentFactory iComponentFactory) {
        super(itemsTreeModelAdapter, iComponentFactory);
        this.itemsTreeModel = itemsTreeModelAdapter;
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(0);
        this.setEditable(true);
        this.setCellEditor(new SubmenuCaptionEditor());
        this.update();
    }

    public void update() {
        this.getModel().reload();
        this.expandAll();
    }

    @Override
    protected boolean canHandleDndImport(Component component, PAction pAction, JTree.DropLocation dropLocation) {
        if (super.canHandleDndImport(component, pAction, dropLocation)) {
            TreePath treePath = dropLocation.getPath();
            VisMenuItemsConfigModel.ItemTreeNode itemTreeNode = (VisMenuItemsConfigModel.ItemTreeNode)treePath.getLastPathComponent();
            return itemTreeNode.isRoot() || itemTreeNode.getAllowsChildren();
        }
        return false;
    }

    @Override
    protected boolean handleDndImport(PAction pAction, JTree.DropLocation dropLocation) {
        TreePath treePath = dropLocation.getPath();
        int n = dropLocation.getChildIndex();
        VisMenuItemsConfigModel.ItemTreeNode itemTreeNode = (VisMenuItemsConfigModel.ItemTreeNode)treePath.getLastPathComponent();
        PAction pAction2 = pAction;
        if (pAction instanceof VisMenuSubmenuTemplateAction) {
            pAction2 = ((VisMenuSubmenuTemplateAction)pAction).createConcreteAction();
        }
        VisMenuItemsConfigModel.ItemTreeNode itemTreeNode2 = pAction2 instanceof SeparatorPAction ? null : this.itemsTreeModel.findNode(pAction2);
        boolean bl = false;
        if (itemTreeNode2 == null) {
            bl = this.itemsTreeModel.insertItemIntoParent(itemTreeNode, this.itemsTreeModel.createItem(pAction2), n) != null;
        } else {
            this.itemsTreeModel.moveToParent(itemTreeNode, itemTreeNode2, n);
        }
        if (bl && itemTreeNode != null) {
            this.expandPath(new TreePath(itemTreeNode.getPath()));
        }
        return bl;
    }

    @Override
    protected boolean handleDndExport(Component component, ActionConfigTree.NodeObject nodeObject) {
        if (nodeObject instanceof VisMenuItemsConfigModel.ItemNodeObject) {
            VisMenuItemsConfigModel.ItemTreeNode itemTreeNode = null;
            PAction pAction = ((VisMenuItemsConfigModel.ItemNodeObject)nodeObject).getItem().getAction();
            itemTreeNode = pAction instanceof SeparatorPAction ? this.itemsTreeModel.findNode(nodeObject) : this.itemsTreeModel.findNode(pAction);
            return this.itemsTreeModel.removeFromParent(itemTreeNode);
        }
        return false;
    }

    private class SubmenuCaptionEditor
    extends AbstractCellEditor
    implements TreeCellEditor,
    ActionListener {
        protected JTextField tf = new JTextField();
        protected int clickCountToStart = 2;
        protected VisMenuSubmenuAction curEditedAction;
        protected VisMenuItemsConfigModel.ItemNodeObject curEditedObject;

        public SubmenuCaptionEditor() {
            this.tf.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.curEditedObject != null ? this.curEditedObject : this.tf.getText();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent;
                TreePath treePath;
                return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart && (treePath = VisMenuItemsConfigTree.this.getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null && treePath.getPathCount() > 0 && ((VisMenuItemsConfigModel.ItemTreeNode)treePath.getLastPathComponent()).isEditable();
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.curEditedAction != null) {
                this.curEditedAction.setCaption(this.tf.getText());
            }
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.curEditedObject = object instanceof VisMenuItemsConfigModel.ItemTreeNode ? (VisMenuItemsConfigModel.ItemNodeObject)((VisMenuItemsConfigModel.ItemTreeNode)object).getUserObject() : null;
            this.curEditedAction = this.getSubmenuAction(object);
            String string = this.curEditedAction != null ? this.curEditedAction.getCaption() : jTree.convertValueToText(object, bl, bl2, bl3, n, false);
            this.tf.setFont(jTree.getFont());
            this.tf.setText(string != null ? string : "");
            this.tf.setPreferredSize(new Dimension(jTree.getRowBounds((int)n).width, this.tf.getPreferredSize().height));
            return this.tf;
        }

        private VisMenuSubmenuAction getSubmenuAction(Object object) {
            VisMenuActionConfigItem visMenuActionConfigItem;
            Object object2;
            if (object instanceof VisMenuItemsConfigModel.ItemTreeNode && (object2 = ((VisMenuItemsConfigModel.ItemTreeNode)object).getUserObject()) instanceof VisMenuItemsConfigModel.ItemNodeObject && (visMenuActionConfigItem = ((VisMenuItemsConfigModel.ItemNodeObject)object2).getItem()) != null && visMenuActionConfigItem.getVisMenuAction() instanceof VisMenuSubmenuAction) {
                return (VisMenuSubmenuAction)visMenuActionConfigItem.getVisMenuAction();
            }
            return null;
        }
    }
}

