/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vistoolbar;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigListModel;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarAction;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarActionConfigItem;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;

public class VisDisplayToolbarConfigModel {
    private VisDisplayToolbarModel toolbarModel;
    private List<VisDisplayToolbarActionConfigItem> items;
    private VisDisplayToolbarActionHandler actionListener;
    private ItemsListModelAdapter itemsModelAdapter;
    private Collection<IVisMenuConfigModelListener> listeners;
    private boolean modified = false;

    private VisDisplayToolbarConfigModel(VisDisplayToolbarModel visDisplayToolbarModel) {
        this.toolbarModel = visDisplayToolbarModel;
        this.actionListener = new VisDisplayToolbarActionHandler();
        this.items = new ArrayList<VisDisplayToolbarActionConfigItem>();
        this.itemsModelAdapter = new ItemsListModelAdapter(this.items);
        this.init();
    }

    public static VisDisplayToolbarConfigModel createRuntimeInstance() {
        return new VisDisplayToolbarConfigModel(VisDisplayToolbarModel.getRuntimeInstance());
    }

    public static VisDisplayToolbarConfigModel createInstance(VisDisplayToolbarModel visDisplayToolbarModel) {
        return new VisDisplayToolbarConfigModel(visDisplayToolbarModel);
    }

    public VisDisplayToolbarModel getToolbarModel() {
        return this.toolbarModel;
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public Collection<VisDisplayToolbarActionConfigItem> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    public boolean addItem(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
        return this.insertItemAt(visDisplayToolbarActionConfigItem, this.items.size());
    }

    public boolean insertItemAt(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem, int n) {
        if (!this.items.contains(visDisplayToolbarActionConfigItem)) {
            visDisplayToolbarActionConfigItem.getToolbarAction().addActionListener(this.actionListener);
            this.items.add(n, visDisplayToolbarActionConfigItem);
            this.updatePositionToIndex(this.items);
            this.modified = true;
            this.fireItemAdded(visDisplayToolbarActionConfigItem);
            return true;
        }
        return false;
    }

    public boolean removeItem(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
        if (this.items.remove(visDisplayToolbarActionConfigItem)) {
            visDisplayToolbarActionConfigItem.getToolbarAction().removeActionListener(this.actionListener);
            this.updatePositionToIndex(this.items);
            this.modified = true;
            this.fireItemRemoved(visDisplayToolbarActionConfigItem);
            return true;
        }
        return false;
    }

    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : this.items) {
                visDisplayToolbarActionConfigItem.getToolbarAction().removeActionListener(this.actionListener);
            }
            this.items.clear();
            this.modified = true;
            this.fireAllItemsRemoved();
        }
    }

    public IActionConfigListModel<VisDisplayToolbarActionConfigItem> getItemsListModel() {
        return this.itemsModelAdapter;
    }

    public Collection<PAction> getAvailableActions() {
        List<PAction> list = PActionRegistry.getAllUserConfigurableToolbarActions(PDataProvider.ProviderType.Display);
        ActionUIUtilities.removeActionByID(list, "ONLY_ONE_STUDY");
        HashSet<String> hashSet = new HashSet<String>(this.items.size());
        for (VisDisplayToolbarActionConfigItem object2 : this.items) {
            hashSet.add(object2.getAction().getID());
        }
        Iterator<PAction> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!hashSet.contains(iterator.next().getID())) continue;
            iterator.remove();
        }
        PAction pAction = ActionUIUtilities.findActionWithId(list, "SEPARATOR");
        if (pAction != null) {
            list.remove(pAction);
        }
        Collections.sort(list, new Comparator<PAction>(){

            @Override
            public int compare(PAction pAction, PAction pAction2) {
                String string = ActionUIUtilities.getActionConfigText(pAction);
                String string2 = ActionUIUtilities.getActionConfigText(pAction2);
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null) {
                    return -1;
                }
                if (string2 != null) {
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    public void update() {
        this.init();
    }

    public void save() {
        if (this.modified) {
            this.toolbarModel.removeAllActions();
            for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : this.items) {
                this.toolbarModel.addAction(visDisplayToolbarActionConfigItem.getToolbarAction());
            }
            this.toolbarModel.save();
        }
    }

    public void addModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVisMenuConfigModelListener>();
        }
        if (!this.listeners.contains(iVisMenuConfigModelListener)) {
            this.listeners.add(iVisMenuConfigModelListener);
        }
    }

    public void removeModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(iVisMenuConfigModelListener);
        }
    }

    private void init() {
        this.removeAllItems();
        for (Map.Entry<VisDisplayToolbarAction, PAction> entry : this.toolbarModel.getActions(null).entrySet()) {
            VisDisplayToolbarAction visDisplayToolbarAction = entry.getKey().copy();
            visDisplayToolbarAction.addActionListener(this.actionListener);
            this.items.add(new VisDisplayToolbarActionConfigItem(visDisplayToolbarAction, entry.getValue()));
        }
        this.updatePositionToIndex(this.items);
        this.itemsModelAdapter.notifyModelChange();
        this.modified = false;
    }

    private void updatePositionToIndex(Collection<VisDisplayToolbarActionConfigItem> collection) {
        int n = 0;
        for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : collection) {
            visDisplayToolbarActionConfigItem.getToolbarAction().removeActionListener(this.actionListener);
            visDisplayToolbarActionConfigItem.getToolbarAction().setPosition(n);
            visDisplayToolbarActionConfigItem.getToolbarAction().addActionListener(this.actionListener);
            ++n;
        }
    }

    private static VisDisplayToolbarActionConfigItem findItem(Collection<VisDisplayToolbarActionConfigItem> collection, VisDisplayToolbarAction visDisplayToolbarAction) {
        for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : collection) {
            if (!visDisplayToolbarActionConfigItem.getToolbarAction().equals(visDisplayToolbarAction)) continue;
            return visDisplayToolbarActionConfigItem;
        }
        return null;
    }

    private static VisDisplayToolbarActionConfigItem findItem(Collection<VisDisplayToolbarActionConfigItem> collection, PAction pAction) {
        for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : collection) {
            if (!visDisplayToolbarActionConfigItem.getAction().equals(pAction)) continue;
            return visDisplayToolbarActionConfigItem;
        }
        return null;
    }

    private void fireItemAdded(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemAdded(visDisplayToolbarActionConfigItem);
            }
        }
    }

    private void fireItemRemoved(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemRemoved(visDisplayToolbarActionConfigItem);
            }
        }
    }

    private void fireItemChanged(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemChanged(visDisplayToolbarActionConfigItem);
            }
        }
    }

    private void fireAllItemsRemoved() {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.allItemsRemoved();
            }
        }
    }

    private static interface IVisMenuConfigModelListener {
        public void itemAdded(VisDisplayToolbarActionConfigItem var1);

        public void itemRemoved(VisDisplayToolbarActionConfigItem var1);

        public void itemChanged(VisDisplayToolbarActionConfigItem var1);

        public void allItemsRemoved();
    }

    private class ItemsListModelAdapter
    extends AbstractListModel<VisDisplayToolbarActionConfigItem>
    implements IActionConfigListModel<VisDisplayToolbarActionConfigItem> {
        private List<VisDisplayToolbarActionConfigItem> items;

        public ItemsListModelAdapter(List<VisDisplayToolbarActionConfigItem> list) {
            this.items = list;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public boolean hasElement(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
            return this.items.contains(visDisplayToolbarActionConfigItem);
        }

        @Override
        public boolean hasAction(PAction pAction) {
            return VisDisplayToolbarConfigModel.findItem((Collection<VisDisplayToolbarActionConfigItem>)this.items, pAction) != null;
        }

        @Override
        public VisDisplayToolbarActionConfigItem createElement(PAction pAction) {
            return new VisDisplayToolbarActionConfigItem(new VisDisplayToolbarAction(pAction.getID(), -1), pAction);
        }

        @Override
        public VisDisplayToolbarActionConfigItem getElement(PAction pAction) {
            return VisDisplayToolbarConfigModel.findItem((Collection<VisDisplayToolbarActionConfigItem>)this.items, pAction);
        }

        @Override
        public VisDisplayToolbarActionConfigItem getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public void setElements(Collection<VisDisplayToolbarActionConfigItem> collection) {
            this.removeAllElements();
            if (collection != null && collection.size() > 0) {
                for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : collection) {
                    VisDisplayToolbarConfigModel.this.addItem(visDisplayToolbarActionConfigItem);
                }
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        @Override
        public void insertElementAt(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem, int n) {
            if (VisDisplayToolbarConfigModel.this.insertItemAt(visDisplayToolbarActionConfigItem, n)) {
                this.fireIntervalAdded(this, n, n);
            }
        }

        @Override
        public void removeElement(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem) {
            int n = this.items.indexOf(visDisplayToolbarActionConfigItem);
            if (VisDisplayToolbarConfigModel.this.removeItem(visDisplayToolbarActionConfigItem)) {
                this.fireIntervalRemoved(this, n, n);
            }
        }

        @Override
        public void removeAllElements() {
            int n = this.getSize();
            for (VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem : this.items) {
                visDisplayToolbarActionConfigItem.getToolbarAction().removeActionListener(VisDisplayToolbarConfigModel.this.actionListener);
            }
            this.items.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        @Override
        public void moveElement(VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem, int n) {
            int n2 = this.items.indexOf(visDisplayToolbarActionConfigItem);
            this.removeElement(visDisplayToolbarActionConfigItem);
            this.insertElementAt(visDisplayToolbarActionConfigItem, n2 < n ? n - 1 : n);
        }

        protected void notifyModelChange() {
            this.fireContentsChanged(this, 0, VisDisplayToolbarConfigModel.this.getItemCount());
        }
    }

    private class VisDisplayToolbarActionHandler
    implements VisDisplayToolbarAction.IVisDisplayToolbarActionListener {
        private VisDisplayToolbarActionHandler() {
        }

        @Override
        public void actionChanged(VisDisplayToolbarAction visDisplayToolbarAction) {
            VisDisplayToolbarActionConfigItem visDisplayToolbarActionConfigItem = VisDisplayToolbarConfigModel.findItem((Collection<VisDisplayToolbarActionConfigItem>)VisDisplayToolbarConfigModel.this.items, visDisplayToolbarAction);
            if (visDisplayToolbarActionConfigItem != null) {
                VisDisplayToolbarConfigModel.this.items.remove(visDisplayToolbarActionConfigItem);
                VisDisplayToolbarConfigModel.this.items.add(visDisplayToolbarActionConfigItem);
            }
            if (visDisplayToolbarActionConfigItem != null) {
                VisDisplayToolbarConfigModel.this.modified = true;
                VisDisplayToolbarConfigModel.this.fireItemChanged(visDisplayToolbarActionConfigItem);
            }
        }
    }
}

