/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vistoolbar;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceContainer;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.DummyPDataProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VisDisplayToolbarModel {
    private static final ALogger log = ALogger.getLogger(VisDisplayToolbarModel.class);
    private static VisDisplayToolbarModel instance;
    private VisDisplayToolbarActionPersistenceContainer actionContainer;
    private Collection<IVisDisplayToolbarModelListener> listeners;

    private VisDisplayToolbarModel(IConfigurationProvider iConfigurationProvider) {
        this.actionContainer = new VisDisplayToolbarActionPersistenceContainer(iConfigurationProvider);
    }

    public static synchronized VisDisplayToolbarModel getRuntimeInstance() {
        if (instance == null) {
            instance = new VisDisplayToolbarModel(ConfigurationProviderFactory.getConfig());
        }
        return instance;
    }

    public static VisDisplayToolbarModel createInstance(IConfigurationProvider iConfigurationProvider) {
        return new VisDisplayToolbarModel(iConfigurationProvider);
    }

    public boolean equalsRuntimeInstance() {
        return this.actionContainer.getConfigurationProvider() == ConfigurationProviderFactory.getConfig();
    }

    public void addAction(VisDisplayToolbarAction visDisplayToolbarAction) {
        if (!this.actionContainer.containsActionRef(visDisplayToolbarAction)) {
            this.actionContainer.addActionRef(visDisplayToolbarAction);
            this.fireActionAdded(visDisplayToolbarAction);
        }
    }

    public void removeAction(VisDisplayToolbarAction visDisplayToolbarAction) {
        if (this.actionContainer.containsActionRef(visDisplayToolbarAction)) {
            this.actionContainer.removeActionRef(visDisplayToolbarAction);
            this.fireActionRemoved(visDisplayToolbarAction);
        }
    }

    public void removeAllActions() {
        if (this.actionContainer.getActionRefCount() > 0) {
            this.actionContainer.removeAll();
            this.fireAllActionsRemoved();
        }
    }

    public SortedMap<VisDisplayToolbarAction, PAction> getDynamicActions(VisDisplay2 visDisplay2) {
        TreeMap<VisDisplayToolbarAction, PAction> treeMap = new TreeMap<VisDisplayToolbarAction, PAction>(new VisDisplayToolbarActionComparator());
        return treeMap;
    }

    public SortedMap<VisDisplayToolbarAction, PAction> getActions(VisDisplay2 visDisplay2) {
        Collection collection;
        TreeMap<VisDisplayToolbarAction, PAction> treeMap = new TreeMap<VisDisplayToolbarAction, PAction>(new VisDisplayToolbarActionComparator());
        int n = -1;
        if (this.actionContainer.getActionRefCount() > 0 && (collection = this.actionContainer.getActionRefs()) != null) {
            for (VisDisplayToolbarAction visDisplayToolbarAction : collection) {
                try {
                    PAction pAction = this.resolveAction(visDisplayToolbarAction, visDisplay2);
                    if (pAction == null) continue;
                    n = Math.max(n, visDisplayToolbarAction.getPosition());
                    treeMap.put(visDisplayToolbarAction, pAction);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Resolving vis-display toolbar-action '" + visDisplayToolbarAction.getActionId() + " failed! Skipped");
                }
            }
        }
        return treeMap;
    }

    public PAction resolveAction(VisDisplayToolbarAction visDisplayToolbarAction, VisDisplay2 visDisplay2) {
        return PActionRegistry.getAction(visDisplayToolbarAction.getActionId(), visDisplay2 == null ? new DummyPDataProvider(PDataProvider.ProviderType.Display) : visDisplay2);
    }

    public void resetToDefault() throws Exception {
        this.actionContainer.resetToDefault();
        this.save();
        this.fireModelChanged();
    }

    public void resetToRole() throws Exception {
        this.actionContainer.resetToRole();
        this.save();
        this.fireModelChanged();
    }

    public void init(VisDisplayToolbarModel visDisplayToolbarModel) {
        this.actionContainer.init(visDisplayToolbarModel.actionContainer);
        this.fireModelChanged();
    }

    public void init(Document document) {
        this.actionContainer.init(document);
    }

    public void save() {
        try {
            this.actionContainer.save();
        }
        catch (Exception exception) {
            log.error("Writing vis-display toolbar-action references to config failed!", (Throwable)exception);
        }
    }

    public String toXML() {
        return this.actionContainer.toXML();
    }

    public void addModelListener(IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVisDisplayToolbarModelListener>();
        }
        if (!this.listeners.contains(iVisDisplayToolbarModelListener)) {
            this.listeners.add(iVisDisplayToolbarModelListener);
        }
    }

    public void removeModelListener(IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(iVisDisplayToolbarModelListener);
        }
    }

    private void fireModelChanged() {
        if (this.listeners != null) {
            for (IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener : this.listeners) {
                iVisDisplayToolbarModelListener.modelChanged();
            }
        }
    }

    private void fireActionAdded(VisDisplayToolbarAction visDisplayToolbarAction) {
        if (this.listeners != null) {
            for (IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener : this.listeners) {
                iVisDisplayToolbarModelListener.actionAdded(visDisplayToolbarAction);
            }
        }
    }

    private void fireActionRemoved(VisDisplayToolbarAction visDisplayToolbarAction) {
        if (this.listeners != null) {
            for (IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener : this.listeners) {
                iVisDisplayToolbarModelListener.actionRemoved(visDisplayToolbarAction);
            }
        }
    }

    private void fireAllActionsRemoved() {
        if (this.listeners != null) {
            for (IVisDisplayToolbarModelListener iVisDisplayToolbarModelListener : this.listeners) {
                iVisDisplayToolbarModelListener.allActionsRemoved();
            }
        }
    }

    public static interface IVisDisplayToolbarModelListener {
        public void modelChanged();

        public void actionAdded(VisDisplayToolbarAction var1);

        public void actionRemoved(VisDisplayToolbarAction var1);

        public void allActionsRemoved();
    }

    private static class VisDisplayToolbarActionComparator
    implements Comparator<VisDisplayToolbarAction> {
        private VisDisplayToolbarActionComparator() {
        }

        @Override
        public int compare(VisDisplayToolbarAction visDisplayToolbarAction, VisDisplayToolbarAction visDisplayToolbarAction2) {
            return Integer.compare(visDisplayToolbarAction.getPosition(), visDisplayToolbarAction2.getPosition());
        }
    }

    private static class VisDisplayToolbarActionPersistenceContainer
    extends PActionPersistenceContainer<VisDisplayToolbarAction> {
        public VisDisplayToolbarActionPersistenceContainer(IConfigurationProvider iConfigurationProvider) {
            super(iConfigurationProvider, String.valueOf(Config.impaxee.jvision.VisDisplayToolbar.getKey()) + ".Entries", Config.impaxee.jvision.VisDisplayToolbar.DefaultEntries.getKey());
        }

        @Override
        protected VisDisplayToolbarAction createActionRef(Node node) throws Exception {
            return VisDisplayToolbarAction.create(node);
        }
    }
}

