/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.windowingtree;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.windowingtree.WindowingTreeCellEditor;
import com.agfa.pacs.impaxee.windowingtree.WindowingTreeCellRenderer;
import com.agfa.pacs.impaxee.windowingtree.WindowingTreeDlg;
import com.agfa.pacs.impaxee.windowingtree.WindowingTreeNode;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.gui.util.tree.ImpaxEETree;
import com.tiani.jvision.main.windowing.WindowingValue;
import com.tiani.util.message.Message;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WindowingTree
extends ImpaxEETree
implements TreeSelectionListener,
ActionListener {
    static String LEVEL0 = "Level0";
    static String LEVEL1 = "Level1";
    static String ROOT = "Root";
    private static final String ITEMS_KEY = "items";
    protected static final String CATEGORY_KEY = "category";
    protected static final String NAME_KEY = "name";
    protected static final String CENTER_KEY = "center";
    protected static final String WIDTH_KEY = "width";
    private static final String TEXT_NEW_NODE = Messages.getString("WINDOWING_TREE_NEWNODE");
    private static final String TEXT_NEW_SUB_NODE = Messages.getString("WINDOWING_TREE_NEWSUBNODE");
    protected JPopupMenu popupRoot = new JPopupMenu();
    protected JPopupMenu popupLevel0 = new JPopupMenu();
    protected JPopupMenu popupLevel1 = new JPopupMenu();
    protected JMenuItem itemRootAdd = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_ROOT_NEWNODE"));
    protected JMenuItem itemLevel0Add = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_LEVEL0_NEWNODE"));
    protected JMenuItem itemLevel0Rename = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_LEVEL0_RENAMENODE"));
    protected JMenuItem itemLevel0Remove = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_LEVEL0_REMOVENODE"));
    protected JMenuItem itemLevel1Rename = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_LEVEL1_RENAMENODE"));
    protected JMenuItem itemLevel1Remove = ComponentFactory.instance.createMenuItem(Messages.getString("WINDOWING_TREE_POPUP_LEVEL1_REMOVENODE"));
    protected WindowingTreeNode popupNode = null;
    private final WindowingTreeDlg windowingTreeDialog;

    public WindowingTree(WindowingTreeDlg windowingTreeDlg) {
        super(ComponentFactory.instance);
        this.windowingTreeDialog = windowingTreeDlg;
        this.setInvokesStopCellEditing(true);
        WindowingTreeCellRenderer windowingTreeCellRenderer = new WindowingTreeCellRenderer();
        this.setCellRenderer(windowingTreeCellRenderer);
        DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this, windowingTreeCellRenderer, new WindowingTreeCellEditor());
        this.setCellEditor(defaultTreeCellEditor);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this);
        this.popupRoot.add(this.itemRootAdd);
        this.popupLevel0.add(this.itemLevel0Add);
        this.popupLevel0.add(this.itemLevel0Rename);
        this.popupLevel0.add(this.itemLevel0Remove);
        this.popupLevel1.add(this.itemLevel1Rename);
        this.popupLevel1.add(this.itemLevel1Remove);
        this.itemRootAdd.addActionListener(this);
        this.itemLevel0Add.addActionListener(this);
        this.itemLevel0Rename.addActionListener(this);
        this.itemLevel0Remove.addActionListener(this);
        this.itemLevel1Rename.addActionListener(this);
        this.itemLevel1Remove.addActionListener(this);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!ModifierKeys.isRMB((MouseEvent)mouseEvent)) {
                    return;
                }
                if (!Permissions.getInstance().isAllowed("ImageArea/AllowToEditWindowingTree")) {
                    return;
                }
                int n = WindowingTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n == -1) {
                    return;
                }
                TreePath treePath = WindowingTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                WindowingTree.this.popupNode = null;
                if (treePath != null) {
                    WindowingTree.this.popupNode = (WindowingTreeNode)treePath.getLastPathComponent();
                }
                if (WindowingTree.this.popupNode == null) {
                    return;
                }
                if (WindowingTree.this.popupNode.getID().equals(ROOT)) {
                    WindowingTree.this.popupRoot.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (WindowingTree.this.popupNode.getID().equals(LEVEL0)) {
                    WindowingTree.this.popupLevel0.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (WindowingTree.this.popupNode.getID().equals(LEVEL1)) {
                    WindowingTree.this.popupLevel1.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
                    return;
                }
                int n = WindowingTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    TreePath treePath = WindowingTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    WindowingTreeNode windowingTreeNode = null;
                    if (treePath != null) {
                        windowingTreeNode = (WindowingTreeNode)treePath.getLastPathComponent();
                    }
                    if (windowingTreeNode != null && (windowingTreeNode.getID().equals(WindowingTree.CENTER_KEY) || windowingTreeNode.getID().equals(WindowingTree.WIDTH_KEY))) {
                        WindowingTree.this.startEditingAtPath(treePath);
                    }
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.fillTree();
        this.getModel().addTreeModelListener(new MyTreeModelListener());
    }

    public String getNodeName() {
        WindowingTreeNode windowingTreeNode = (WindowingTreeNode)this.getSelectionPath().getLastPathComponent();
        if (windowingTreeNode == null) {
            return null;
        }
        return (String)windowingTreeNode.getUserObject();
    }

    public void expandLevel0() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            ++n;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.popupNode == null) {
            return;
        }
        if (actionEvent.getSource() == this.itemRootAdd) {
            this.onPopupItemRootAdd();
        } else if (actionEvent.getSource() == this.itemLevel0Add) {
            this.onPopupItemLevel0Add();
        } else if (actionEvent.getSource() == this.itemLevel0Rename || actionEvent.getSource() == this.itemLevel1Rename) {
            this.startEditingAtPath(new TreePath(this.popupNode.getPath()));
        } else if (actionEvent.getSource() == this.itemLevel0Remove) {
            if (Message.yesNo(Messages.getString("QUESTION"), Messages.getString("WINDOWING_TREE_ASK_DELETE_TEXT")) != 0) {
                return;
            }
            this.onPopupItemLevel0Remove();
        } else if (actionEvent.getSource() == this.itemLevel1Remove) {
            if (Message.yesNo(Messages.getString("QUESTION"), Messages.getString("WINDOWING_TREE_ASK_DELETE_TEXT")) != 0) {
                return;
            }
            this.onPopupItemLevel1Remove();
        }
    }

    public void onPopupItemRootAdd() {
        WindowingTreeNode windowingTreeNode;
        WindowingTreeNode windowingTreeNode2 = this.popupNode;
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingTree.getList();
        int n = 0;
        while (n < windowingTreeNode2.getChildCount()) {
            windowingTreeNode = (WindowingTreeNode)windowingTreeNode2.getChildAt(n);
            if (windowingTreeNode.toString().equals(TEXT_NEW_NODE)) {
                Message.error(Messages.getString("ERROR"), (Object)Messages.getString("WINDOWING_TREE_ERR_RENAME_NEWNODE"));
                return;
            }
            ++n;
        }
        IConfigurationProvider iConfigurationProvider = iConfigurationList.appendItem();
        String string = iConfigurationList.getIdOfLastNewElement();
        IConfigurationList iConfigurationList2 = iConfigurationProvider.createList(ITEMS_KEY);
        IConfigurationProvider iConfigurationProvider2 = iConfigurationList2.appendItem();
        String string2 = iConfigurationList2.getIdOfLastNewElement();
        WindowingTreeNode windowingTreeNode3 = new WindowingTreeNode(TEXT_NEW_NODE, iConfigurationProvider, string);
        iConfigurationProvider.setString(CATEGORY_KEY, TEXT_NEW_NODE);
        windowingTreeNode3.setID(LEVEL0);
        windowingTreeNode2.add(windowingTreeNode3);
        windowingTreeNode = new WindowingTreeNode(TEXT_NEW_SUB_NODE, iConfigurationProvider2, string2);
        iConfigurationProvider2.setString(NAME_KEY, TEXT_NEW_SUB_NODE);
        windowingTreeNode.setID(LEVEL1);
        windowingTreeNode3.add(windowingTreeNode);
        WindowingTreeNode windowingTreeNode4 = new WindowingTreeNode("0", iConfigurationProvider2, string2);
        iConfigurationProvider2.setLong(CENTER_KEY, 0L);
        windowingTreeNode4.setID(CENTER_KEY);
        WindowingTreeNode windowingTreeNode5 = new WindowingTreeNode("0", iConfigurationProvider2, string2);
        iConfigurationProvider2.setLong(WIDTH_KEY, 0L);
        windowingTreeNode5.setID(WIDTH_KEY);
        windowingTreeNode.add(windowingTreeNode4);
        windowingTreeNode.add(windowingTreeNode5);
        ((DefaultTreeModel)this.getModel()).reload(windowingTreeNode2);
        this.expandLevel0();
        this.startEditingAtPath(new TreePath(windowingTreeNode3.getPath()));
    }

    public void onPopupItemLevel0Add() {
        WindowingTreeNode windowingTreeNode;
        WindowingTreeNode windowingTreeNode2 = this.popupNode;
        int n = 0;
        while (n < windowingTreeNode2.getChildCount()) {
            windowingTreeNode = (WindowingTreeNode)windowingTreeNode2.getChildAt(n);
            if (windowingTreeNode.toString().equals(TEXT_NEW_SUB_NODE)) {
                Message.error(Messages.getString("ERROR"), (Object)Messages.getString("WINDOWING_TREE_ERR_RENAME_NEWSUBNODE"));
                return;
            }
            ++n;
        }
        IConfigurationProvider iConfigurationProvider = windowingTreeNode2.getConfigProvider().getList(ITEMS_KEY).appendItem();
        String string = windowingTreeNode2.getConfigProvider().getList(ITEMS_KEY).getIdOfLastNewElement();
        WindowingTreeNode windowingTreeNode3 = new WindowingTreeNode(TEXT_NEW_SUB_NODE, iConfigurationProvider, string);
        iConfigurationProvider.setString(NAME_KEY, TEXT_NEW_SUB_NODE);
        windowingTreeNode3.setID(LEVEL1);
        windowingTreeNode2.add(windowingTreeNode3);
        windowingTreeNode = new WindowingTreeNode(0L, iConfigurationProvider, string);
        iConfigurationProvider.setLong(CENTER_KEY, 0L);
        windowingTreeNode.setID(CENTER_KEY);
        WindowingTreeNode windowingTreeNode4 = new WindowingTreeNode(0L, iConfigurationProvider, string);
        iConfigurationProvider.setLong(WIDTH_KEY, 0L);
        windowingTreeNode4.setID(WIDTH_KEY);
        String string2 = windowingTreeNode2.getConfigProvider().getString(CATEGORY_KEY);
        windowingTreeNode2.getConfigProvider().setString(CATEGORY_KEY, String.valueOf(string2) + "temp");
        windowingTreeNode2.getConfigProvider().setString(CATEGORY_KEY, string2);
        windowingTreeNode3.add(windowingTreeNode);
        windowingTreeNode3.add(windowingTreeNode4);
        ((DefaultTreeModel)this.getModel()).reload(windowingTreeNode2);
        this.expandLevel0();
        this.expandPath(new TreePath(windowingTreeNode3.getPath()));
        this.startEditingAtPath(new TreePath(windowingTreeNode3.getPath()));
    }

    public void onPopupItemLevel0Remove() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupNode.getParent();
        Config.impaxee.jvision.windowingTree.getList().remove(this.popupNode.getConfigID());
        defaultMutableTreeNode.remove(this.popupNode);
        ((DefaultTreeModel)this.getModel()).reload(defaultMutableTreeNode);
        this.expandLevel0();
    }

    public void onPopupItemLevel1Remove() {
        WindowingTreeNode windowingTreeNode = (WindowingTreeNode)this.popupNode.getParent();
        windowingTreeNode.getConfigProvider().getList(ITEMS_KEY).remove(this.popupNode.getConfigID());
        windowingTreeNode.remove(this.popupNode);
        ((DefaultTreeModel)this.getModel()).reload(windowingTreeNode);
        this.expandLevel0();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n = 0;
        int n2 = 0;
        WindowingTreeNode windowingTreeNode = (WindowingTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (windowingTreeNode.getID().equals(CENTER_KEY) || windowingTreeNode.getID().equals(WIDTH_KEY)) {
            windowingTreeNode = (WindowingTreeNode)windowingTreeNode.getParent();
        }
        if (windowingTreeNode.getID().equals(LEVEL1)) {
            n = ((Long)((DefaultMutableTreeNode)windowingTreeNode.getChildAt(0)).getUserObject()).intValue();
            n2 = ((Long)((DefaultMutableTreeNode)windowingTreeNode.getChildAt(1)).getUserObject()).intValue();
        }
        this.windowingTreeDialog.setValue(new WindowingValue(null, n, n2));
    }

    public void load(WindowingTreeNode windowingTreeNode) {
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingTree.getList();
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            if (!((IConfigurationProvider)entry.getValue()).exists(CATEGORY_KEY)) continue;
            String string = ((IConfigurationProvider)entry.getValue()).getString(CATEGORY_KEY);
            string = Messages.getPossibleTranslatedString("Windowing.Category." + string, string);
            WindowingTreeNode windowingTreeNode2 = new WindowingTreeNode(string, (IConfigurationProvider)entry.getValue(), (String)entry.getKey());
            windowingTreeNode2.setID(LEVEL0);
            IConfigurationList iConfigurationList2 = ((IConfigurationProvider)entry.getValue()).getList(ITEMS_KEY);
            for (Map.Entry entry2 : iConfigurationList2.getChildrenItems().entrySet()) {
                if (!((IConfigurationProvider)entry2.getValue()).exists(NAME_KEY) || !((IConfigurationProvider)entry2.getValue()).exists(CENTER_KEY) || !((IConfigurationProvider)entry2.getValue()).exists(WIDTH_KEY)) continue;
                String string2 = ((IConfigurationProvider)entry2.getValue()).getString(NAME_KEY);
                string2 = Messages.getPossibleTranslatedString("Windowing.Item." + string2, string2);
                Long l = ((IConfigurationProvider)entry2.getValue()).getLong(CENTER_KEY);
                Long l2 = ((IConfigurationProvider)entry2.getValue()).getLong(WIDTH_KEY);
                WindowingTreeNode windowingTreeNode3 = new WindowingTreeNode(string2, (IConfigurationProvider)entry2.getValue(), (String)entry2.getKey());
                WindowingTreeNode windowingTreeNode4 = new WindowingTreeNode(l, (IConfigurationProvider)entry2.getValue(), (String)entry2.getKey());
                WindowingTreeNode windowingTreeNode5 = new WindowingTreeNode(l2, (IConfigurationProvider)entry2.getValue(), (String)entry2.getKey());
                windowingTreeNode3.setID(LEVEL1);
                windowingTreeNode4.setID(CENTER_KEY);
                windowingTreeNode5.setID(WIDTH_KEY);
                windowingTreeNode3.add(windowingTreeNode4);
                windowingTreeNode3.add(windowingTreeNode5);
                windowingTreeNode2.add(windowingTreeNode3);
            }
            windowingTreeNode2.sortChilds();
            windowingTreeNode.add(windowingTreeNode2);
        }
        windowingTreeNode.sortChilds();
    }

    private void fillTree() {
        WindowingTreeNode windowingTreeNode = new WindowingTreeNode(Messages.getString("WINDOWING_TREE_ROOT"));
        windowingTreeNode.setID(ROOT);
        this.load(windowingTreeNode);
        ((DefaultTreeModel)this.getModel()).setRoot(windowingTreeNode);
        ((DefaultTreeModel)this.getModel()).reload();
        TreeNode treeNode = windowingTreeNode.children().nextElement();
        TreePath treePath = new TreePath(new Object[]{windowingTreeNode, treeNode});
        this.expandPath(treePath);
    }

    private class MyTreeModelListener
    implements TreeModelListener {
        private MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            WindowingTreeNode windowingTreeNode;
            Object object;
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof WindowingTreeNode && (windowingTreeNode = (WindowingTreeNode)object).getID() != null && (windowingTreeNode.getID().equals(ROOT) || windowingTreeNode.getID().equals(LEVEL0))) {
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)WindowingTree.this.getModel();
                Object[] objectArray = treeModelEvent.getChildren();
                if (objectArray != null) {
                    Enumeration<TreePath> enumeration = WindowingTree.this.getExpandedDescendants(treePath);
                    Object[] objectArray2 = objectArray;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object2 = objectArray2[n2];
                        if (object2 instanceof WindowingTreeNode) {
                            WindowingTreeNode windowingTreeNode2 = (WindowingTreeNode)object2;
                            defaultTreeModel.removeNodeFromParent(windowingTreeNode2);
                            defaultTreeModel.insertNodeInto(windowingTreeNode2, windowingTreeNode, windowingTreeNode.getIndexFor(windowingTreeNode2));
                        }
                        ++n2;
                    }
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            WindowingTree.this.setExpandedState(enumeration.nextElement(), true);
                        }
                    }
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

