/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.tiani.base.data.IImageInformation;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public abstract class AbstractImageInformation
implements IImageInformation {
    private volatile Point3d pointOrigin;
    private volatile Point3d pointCenter;
    private volatile Vector3d sizedVectorU;
    private volatile Vector3d sizedVectorV;
    private volatile Vector3d normalVector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point3d getPointOrigin() {
        Point3d point3d;
        block5: {
            point3d = this.pointOrigin;
            if (point3d != null) break block5;
            AbstractImageInformation abstractImageInformation = this;
            synchronized (abstractImageInformation) {
                double[] dArray;
                block4: {
                    point3d = this.pointOrigin;
                    if (point3d != null) break block5;
                    dArray = this.getImagePosition();
                    if (dArray != null && dArray.length >= 3) break block4;
                    return null;
                }
                point3d = this.pointOrigin = new Point3d(dArray[0], dArray[1], dArray[2]);
            }
        }
        return point3d;
    }

    @Override
    public Vector3d getVectorU() {
        double[] dArray = this.getImageOrientation();
        if (dArray == null || dArray.length < 3) {
            return null;
        }
        return new Vector3d(dArray[0], dArray[1], dArray[2]);
    }

    @Override
    public Vector3d getVectorV() {
        double[] dArray = this.getImageOrientation();
        if (dArray == null || dArray.length < 6) {
            return null;
        }
        return new Vector3d(dArray[3], dArray[4], dArray[5]);
    }

    @Override
    public Vector3d getScaledVectorU() {
        double[] dArray = this.getPixelSpacing();
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = this.getImageOrientation();
        if (dArray2 == null || dArray2.length < 3) {
            return null;
        }
        Vector3d vector3d = new Vector3d(dArray2[0], dArray2[1], dArray2[2]);
        vector3d.scale(dArray[1]);
        return vector3d;
    }

    @Override
    public Vector3d getScaledVectorV() {
        double[] dArray = this.getPixelSpacing();
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = this.getImageOrientation();
        if (dArray2 == null || dArray2.length < 6) {
            return null;
        }
        Vector3d vector3d = new Vector3d(dArray2[3], dArray2[4], dArray2[5]);
        vector3d.scale(dArray[0]);
        return vector3d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector3d getPlaneNormalUV() {
        Vector3d vector3d;
        block5: {
            vector3d = this.normalVector;
            if (vector3d != null) break block5;
            AbstractImageInformation abstractImageInformation = this;
            synchronized (abstractImageInformation) {
                double[] dArray;
                block4: {
                    vector3d = this.normalVector;
                    if (vector3d != null) break block5;
                    dArray = this.getImageOrientation();
                    if (dArray != null && dArray.length >= 6) break block4;
                    return null;
                }
                vector3d = new Vector3d();
                vector3d.x = dArray[1] * dArray[5] - dArray[2] * dArray[4];
                vector3d.y = dArray[3] * dArray[2] - dArray[5] * dArray[0];
                vector3d.z = dArray[0] * dArray[4] - dArray[1] * dArray[3];
                vector3d.normalize();
                this.normalVector = vector3d;
            }
        }
        return vector3d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector3d getScaledSizedVectorU() {
        Vector3d vector3d;
        block5: {
            vector3d = this.sizedVectorU;
            if (vector3d != null) break block5;
            AbstractImageInformation abstractImageInformation = this;
            synchronized (abstractImageInformation) {
                Vector3d vector3d2;
                block4: {
                    vector3d = this.sizedVectorU;
                    if (vector3d != null) break block5;
                    vector3d2 = this.getScaledVectorU();
                    if (vector3d2 != null) break block4;
                    return null;
                }
                vector3d2.scale((double)this.getColumns());
                vector3d = this.sizedVectorU = vector3d2;
            }
        }
        return vector3d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector3d getScaledSizedVectorV() {
        Vector3d vector3d;
        block5: {
            vector3d = this.sizedVectorV;
            if (vector3d != null) break block5;
            AbstractImageInformation abstractImageInformation = this;
            synchronized (abstractImageInformation) {
                Vector3d vector3d2;
                block4: {
                    vector3d = this.sizedVectorV;
                    if (vector3d != null) break block5;
                    vector3d2 = this.getScaledVectorV();
                    if (vector3d2 != null) break block4;
                    return null;
                }
                vector3d2.scale((double)this.getRows());
                vector3d = this.sizedVectorV = vector3d2;
            }
        }
        return vector3d;
    }

    @Override
    public Vector2d getVectorPixelSpacing() {
        double[] dArray = this.getPixelSpacing();
        if (dArray == null || dArray.length < 2) {
            return null;
        }
        return new Vector2d(dArray[1], dArray[0]);
    }

    @Override
    public Vector3d getVectorOrigin() {
        Point3d point3d = this.getPointOrigin();
        if (point3d == null) {
            return null;
        }
        return new Vector3d((Tuple3d)point3d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point3d getPointCenter() {
        Point3d point3d = this.pointCenter;
        if (point3d == null) {
            AbstractImageInformation abstractImageInformation = this;
            synchronized (abstractImageInformation) {
                point3d = this.pointCenter;
                if (point3d == null) {
                    point3d = this.pointCenter = this.computePointCenter();
                }
            }
        }
        return point3d;
    }

    private Point3d computePointCenter() {
        Point3d point3d = this.getPointOrigin();
        Vector3d vector3d = this.getScaledSizedVectorU();
        Vector3d vector3d2 = this.getScaledSizedVectorV();
        if (point3d == null || vector3d == null || vector3d2 == null) {
            return null;
        }
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.scale(0.5);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.scale(0.5);
        Point3d point3d2 = new Point3d(point3d);
        point3d2.add((Tuple3d)vector3d3);
        point3d2.add((Tuple3d)vector3d4);
        return point3d2;
    }

    @Override
    public Vector3d getVectorCenter() {
        Point3d point3d = this.getPointCenter();
        if (point3d == null) {
            return null;
        }
        return new Vector3d((Tuple3d)point3d);
    }
}

