/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.ResetableLazyInitializer;

abstract class AbstractRawDataContainer
implements RawDataContainer {
    protected final IPixelDataFrame<?> pixelDataFrame;
    private boolean nearestNeighbour = false;
    protected ResetableLazyInitializer<Histogram> histogram;

    protected AbstractRawDataContainer(IPixelDataFrame<?> iPixelDataFrame) {
        this.pixelDataFrame = iPixelDataFrame;
        if (iPixelDataFrame.getPhotometricInterpretation() == PhotometricInterpretation.IndexedColor) {
            this.setNearestNeighbourInterpolation(true);
        }
    }

    protected IPixelAccessor<?> getAccessor() {
        return this.pixelDataFrame.getPixelAccessor();
    }

    @Override
    public int getColumns() {
        return this.pixelDataFrame.getWidth();
    }

    @Override
    public int getRows() {
        return this.pixelDataFrame.getHeight();
    }

    @Override
    public IPixelAccessor<?> getData() {
        return this.pixelDataFrame.getPixelAccessor();
    }

    @Override
    public IPixelDataFrame<?> getPixelDataFrame() {
        return this.pixelDataFrame;
    }

    @Override
    public void setNearestNeighbourInterpolation(boolean bl) {
        this.nearestNeighbour = bl;
    }

    protected abstract void extractBilinear(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected abstract void extractBilinearWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15);

    protected abstract void extractSummedSubsampling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected abstract void extractSummedSubsamplingWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15);

    protected abstract void extractNearestNeighbor(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    protected abstract void extractNearestNeighborWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int[] var12, int var13);

    protected abstract void copyFull(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected abstract void copyFullWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int[] var8, int var9);

    protected abstract void fastSubsampling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected abstract void fastSubsamplingWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15);

    private void summedSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        int n11 = this.pixelDataFrame.getHeight();
        int n12 = 1;
        int n13 = n10;
        if (!(n10 <= 256 && n11 <= 256 || this.nearestNeighbour)) {
            this.extractSummedSubsampling(object, n, n2, n3, n4, n12, n13, 1, 1, n5, n6, n7, n8, n9);
        } else {
            this.extractNearestNeighbor(object, n, n2, n3, n4, n12, n13, n5, n6, n7, n8, n9);
        }
    }

    private void summedSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        int n11 = this.pixelDataFrame.getHeight();
        int n12 = 1;
        int n13 = n10;
        if (!(n10 <= 256 && n11 <= 256 || this.nearestNeighbour)) {
            this.extractSummedSubsamplingWithLUT(nArray, n, n2, n3, n4, n12, n13, 1, 1, n5, n6, n7, n8, nArray2, n9);
        } else {
            this.extractNearestNeighborWithLUT(nArray, n, n2, n3, n4, n12, n13, n5, n6, n7, n8, nArray2, n9);
        }
    }

    protected abstract void enlarge(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    protected abstract void enlargeWithLUT(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10, int var11);

    private void extractNonIdentityFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int[] nArray, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        int n11 = this.pixelDataFrame.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int n12 = n7 >> 8;
        int n13 = n8 >> 8;
        double[] dArray = new double[]{n10, n11};
        matrix2d.transform(dArray);
        double[] dArray2 = new double[]{1.0, 0.0};
        matrix2d.transform(dArray2);
        int n14 = (int)(dArray2[0] + dArray2[1] * (double)n10);
        if (n14 < 0) {
            n14 *= -1;
        }
        dArray2[0] = 0.0;
        dArray2[1] = 1.0;
        matrix2d.transform(dArray2);
        int n15 = (int)(dArray2[0] + dArray2[1] * (double)n10);
        if (n15 < 0) {
            n15 *= -1;
        }
        int n16 = 0;
        int n17 = 0;
        int n18 = 1;
        int n19 = 1;
        if (dArray[0] < 0.0) {
            n16 = -((int)dArray[0]) << 8;
            n18 = -1;
        }
        if (dArray[1] < 0.0) {
            n17 = -((int)dArray[1]) << 8;
            n19 = -1;
        }
        n16 += n18 * n5;
        n17 += n19 * n6;
        int n20 = n18 * n7;
        int n21 = n19 * n8;
        if (n > n12 && n2 > n13 && !this.nearestNeighbour) {
            if (nArray == null) {
                this.extractBilinear(object, n, n2, n3, n4, n14, n15, n18, n19, n16, n17, n20, n21, n9);
            } else {
                this.extractBilinearWithLUT((int[])object, n, n2, n3, n4, n14, n15, n18, n19, n16, n17, n20, n21, nArray, n9);
            }
        } else if (!(n10 < 256 && n11 < 256 || this.nearestNeighbour)) {
            if (nArray == null) {
                this.extractSummedSubsampling(object, n, n2, n3, n4, n14, n15, n18, n19, n16, n17, n20, n21, n9);
            } else {
                this.extractSummedSubsamplingWithLUT((int[])object, n, n2, n3, n4, n14, n15, n18, n19, n16, n17, n20, n21, nArray, n9);
            }
        } else if (nArray == null) {
            this.extractNearestNeighbor(object, n, n2, n3, n4, n14, n15, n16, n17, n20, n21, n9);
        } else {
            this.extractNearestNeighborWithLUT((int[])object, n, n2, n3, n4, n14, n15, n16, n17, n20, n21, nArray, n9);
        }
    }

    @Override
    public synchronized void extract16bitFull(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int n9) {
        this.extract(sArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, null, n9);
    }

    private void extract(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int[] nArray, int n9) {
        block19: {
            if (n <= 0 || n2 <= 0) {
                return;
            }
            if (matrix2d != null && !matrix2d.isIdentity()) {
                this.extractNonIdentityFull(object, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, nArray, n9);
            } else {
                int n10 = n5;
                int n11 = n6;
                int n12 = n7;
                int n13 = n8;
                n5 >>= 8;
                n6 >>= 8;
                if (n == (n7 >>= 8) && n2 == (n8 >>= 8)) {
                    if (nArray == null) {
                        this.copyFull(object, n, n2, n3, n4, n5, n6, n9);
                    } else {
                        this.copyFullWithLUT((int[])object, n, n2, n3, n4, n5, n6, nArray, n9);
                    }
                } else if (n <= 128 && n2 <= 128 && n < n7 && n2 < n8 && !this.nearestNeighbour) {
                    try {
                        if (nArray == null) {
                            this.fastSubsampling(object, n, n2, n3, n4, n5, n6, n7, n8, n10, n11, n12, n13, n9);
                            break block19;
                        }
                        this.fastSubsamplingWithLUT((int[])object, n, n2, n3, n4, n5, n6, n7, n8, n10, n11, n12, n13, nArray, n9);
                    }
                    catch (Exception exception) {
                        if (nArray == null) {
                            this.summedSubsampling(object, n, n2, n3, n4, n10, n11, n12, n13, n9);
                            break block19;
                        }
                        this.summedSubsamplingWithLUT((int[])object, n, n2, n3, n4, n10, n11, n12, n13, nArray, n9);
                    }
                } else if (n > n7 / 2 && n2 > n8 / 2 && !this.nearestNeighbour) {
                    if (nArray == null) {
                        this.enlarge(object, n, n2, n3, n4, n10, n11, n12, n13, n9);
                    } else {
                        this.enlargeWithLUT((int[])object, n, n2, n3, n4, n10, n11, n12, n13, nArray, n9);
                    }
                } else if (nArray == null) {
                    this.summedSubsampling(object, n, n2, n3, n4, n10, n11, n12, n13, n9);
                } else {
                    this.summedSubsamplingWithLUT((int[])object, n, n2, n3, n4, n10, n11, n12, n13, nArray, n9);
                }
            }
        }
    }

    @Override
    public synchronized void extract8bitFull(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int n9) {
        this.extract(byArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, null, n9);
    }

    @Override
    public synchronized void extract32bitFull(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int[] nArray2, int n9) {
        this.extract(nArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, nArray2, n9);
    }

    @Override
    public int getInfoSourcePriority() {
        return 1;
    }

    @Override
    public IImageRegionProperties getImageRegionProperties(ImageRegion imageRegion, int n, int n2, IValueMapping iValueMapping) {
        return this.getImageRegionProperties(imageRegion, n, n2, iValueMapping, null, null);
    }

    @Override
    public void resetHistogram() {
        this.histogram.reset();
    }

    @Override
    public Histogram getHistogram() {
        return this.histogram.get();
    }
}

