/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.dicom.Laterality;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.impaxee.tagdictionary.PrivateTagMapper;
import com.agfa.pacs.impaxee.valuemapping.RealWorldValueMappingFactory;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUTFunction;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.listtext.dicomobject.type.LossyImageCompression;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.AbstractImageInformation;
import com.tiani.base.data.HierarchicalAttributes;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageRegionSpacing;
import com.tiani.base.data.MissingWindowCreator;
import com.tiani.base.data.UltrasoundRegionSpacing;
import com.tiani.jvision.image.ILocalizerPlane;
import com.tiani.jvision.image.LocalizerPlane;
import com.tiani.jvision.image.PassiveLocalizerPlane;
import com.tiani.jvision.overlay.PointSequence;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class ImageInformation2
extends AbstractImageInformation
implements IImageInformation {
    private static final ALogger log = ALogger.getLogger(ImageInformation2.class);
    private static final Map<String, IImageInformation.ImageClass> sopClassMap = new HashMap<String, IImageInformation.ImageClass>();
    private static final Set<String> lossyTransferSyntaxUIDs = new HashSet<String>();
    protected Set<ImageProperties> properties = EnumSet.noneOf(ImageProperties.class);
    protected Attributes dcm = null;
    private int highBit;
    private int bitsStored;
    protected String sopInstanceUID;
    private String frameOfReferenceUID;
    private PaletteColorLUTModule pclmt = null;
    protected PresentationLUT pLUT = null;
    protected ModalityLUT mLUT = null;
    protected IVOILUT vLUT = null;
    private double sliceThickness = Double.NaN;
    private ILocalizerPlane locPlane = null;
    private Set<ImageType> imageTypes;
    private IImageInformation.ImageClass imageClass;
    private List<RealWorldValueMapping> realWorldValueMappings;
    private List<UltrasoundRegionSpacing> ultrasoundRegions;

    static {
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.20", IImageInformation.ImageClass.NM);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.5", IImageInformation.ImageClass.NM);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.2", IImageInformation.ImageClass.CT);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.2.1", IImageInformation.ImageClass.CT);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.128", IImageInformation.ImageClass.PT);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.130", IImageInformation.ImageClass.PT);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.4", IImageInformation.ImageClass.MR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.4.1", IImageInformation.ImageClass.MR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1", IImageInformation.ImageClass.CR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.1", IImageInformation.ImageClass.CR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.1.1", IImageInformation.ImageClass.CR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.2", IImageInformation.ImageClass.MG);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.2.1", IImageInformation.ImageClass.MG);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.13.1.3", IImageInformation.ImageClass.TOMO);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.3", IImageInformation.ImageClass.CR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.1.3.1", IImageInformation.ImageClass.CR);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.12.1", IImageInformation.ImageClass.XA);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.12.2", IImageInformation.ImageClass.XA);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.7", IImageInformation.ImageClass.SC);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.7.4", IImageInformation.ImageClass.SC);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.77.1.5.4", IImageInformation.ImageClass.OPT3D);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.77.1.5.1", IImageInformation.ImageClass.OPT2D);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.77.1.5.2", IImageInformation.ImageClass.OPT2D);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.6.1", IImageInformation.ImageClass.US);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.6", IImageInformation.ImageClass.US);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.3.1", IImageInformation.ImageClass.US);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.3", IImageInformation.ImageClass.US);
        sopClassMap.put("1.2.840.10008.5.1.4.1.1.104.1", IImageInformation.ImageClass.PDF);
        for (String string : UIDUtilities.getTransferSyntaxUIDs()) {
            if (!UIDUtilities.isTransferSyntaxType((String)string, (UIDType)UIDType.Lossy)) continue;
            lossyTransferSyntaxUIDs.add(string);
        }
    }

    public boolean getForceLUT() {
        return true;
    }

    public void setForceLUT(boolean bl) {
    }

    public ImageInformation2(Attributes attributes, boolean bl) {
        this.dcm = bl ? new Attributes(attributes) : attributes;
        this.init(true);
    }

    @Override
    public int getTemporalPosition() {
        return this.dcm.getInt(0x200100, -1);
    }

    @Override
    public void reinit(Attributes attributes) {
        if (!attributes.getString(524312).equals(this.sopInstanceUID)) {
            throw new IllegalArgumentException("Incorrect reinitialisation");
        }
        this.dcm = attributes;
        this.properties.remove((Object)ImageProperties.LossyCompression);
        this.init(false);
    }

    private void init(boolean bl) {
        String string;
        boolean bl2;
        Integer n;
        Object object;
        if (this.dcm == null) {
            return;
        }
        Attributes attributes = this.dcm;
        if (attributes instanceof HierarchicalAttributes) {
            attributes = ((HierarchicalAttributes)attributes).getLeafDicomObject();
        }
        if (bl) {
            String string2;
            if (attributes instanceof IObjectInfo) {
                object = (IObjectInfo)attributes;
                this.sopInstanceUID = object.getSOPInstanceUID();
                string2 = object.getSOPClassUID();
            } else {
                this.sopInstanceUID = attributes.getString(524312);
                string2 = attributes.getString(524310);
            }
            this.imageClass = sopClassMap.get(string2);
            if (this.imageClass == null) {
                this.imageClass = IImageInformation.ImageClass.UNKNOWN;
            }
        }
        boolean bl3 = true;
        if (bl || !this.properties.contains((Object)ImageProperties.RenderInformationAvailable)) {
            object = null;
            n = null;
            if (attributes.containsValue(2621697)) {
                object = attributes.getInt(2621697, 0);
            }
            if (attributes.containsValue(2621698)) {
                n = attributes.getInt(2621698, 0);
            }
            if (object != null) {
                this.bitsStored = (Integer)object;
            }
            if (n != null) {
                this.highBit = n;
            }
            bl3 = false;
            if (object != null || n != null) {
                this.properties.add(ImageProperties.RenderInformationAvailable);
                bl3 = true;
                if (object == null && n != null) {
                    this.bitsStored = n + 1;
                    this.highBit = n;
                }
                if (object != null && n == null) {
                    this.highBit = (Integer)object - 1;
                    this.bitsStored = (Integer)object;
                }
                if (this.highBit != this.bitsStored - 1) {
                    this.highBit = this.bitsStored - 1;
                    log.debug("Value for \"high bit\" and \"bits stored\" are equal. Set highBit = bitsStored-1.");
                }
            }
        }
        object = PhotometricInterpretation.get((String)attributes.getString(2621444));
        n = null;
        String string3 = attributes.getString(0x20500020, null);
        if (string3 != null) {
            n = PresentationLUTShape.get((String)string3);
        }
        boolean bl4 = bl2 = n == PresentationLUTShape.Inverse;
        if (n == null) {
            boolean bl5 = bl2 = bl2 || object == PhotometricInterpretation.InverseMonochrome;
        }
        if (bl2) {
            this.properties.add(ImageProperties.Inverse);
        }
        if ((string = attributes.getString(2629904)) != null && !string.isEmpty()) {
            if (string.equals(LossyImageCompression.LossyCompressed.dicom())) {
                this.properties.add(ImageProperties.LossyCompression);
            }
        } else {
            String string4 = attributes.getString(131088);
            if (string4 != null && lossyTransferSyntaxUIDs.contains(string4)) {
                this.properties.add(ImageProperties.LossyCompression);
            }
        }
        if (attributes.containsValue(2621699) && attributes.getInt(2621699, 0) != 0) {
            this.properties.add(ImageProperties.Signed);
        }
        if (bl3) {
            this.initLUTs((PhotometricInterpretation)object);
        }
        this.realWorldValueMappings = null;
        this.ultrasoundRegions = UltrasoundRegionSpacing.create(attributes);
    }

    protected void initLUTs(PhotometricInterpretation photometricInterpretation) {
        if (photometricInterpretation.isColor() && photometricInterpretation != PhotometricInterpretation.IndexedColor) {
            this.vLUT = VOILUT.create((double)128.0, (double)256.0);
            this.pLUT = null;
            this.mLUT = null;
        } else {
            this.vLUT = VOILUT.create((Attributes)ImageInformation2.getVOILUTAttributes(this.dcm, this));
            this.pLUT = PresentationLUT.create((Attributes)this.dcm);
            this.mLUT = ModalityLUT.create((Attributes)this.dcm);
            if (PaletteColorLUTModule.hasLookupTable((Attributes)this.dcm)) {
                int[] nArray;
                this.properties.add(ImageProperties.HasColorLUT);
                if (photometricInterpretation == PhotometricInterpretation.IndexedColor && (nArray = this.dcm.getInts(2625793)) != null && nArray.length == 3) {
                    int n = nArray[0];
                    if (n == 0) {
                        n = 65536;
                    }
                    this.vLUT = VOILUT.create((double)((n - 1 + nArray[1]) / 2), (double)(n - 1));
                }
            } else if (this.vLUT == null) {
                this.vLUT = ImageInformation2.createMissingWindow(this);
            }
        }
    }

    private static Attributes getVOILUTAttributes(Attributes attributes, IImageInformation iImageInformation) {
        if ("MG".equals(attributes.getString(524384)) && StringUtils.startsWith((CharSequence)attributes.getString(524400), (CharSequence)"GE ") && !attributes.contains(2625622)) {
            Attributes attributes2 = new Attributes(attributes);
            attributes2.setString(2625622, VR.CS, VOILUTFunction.Sigmoid.dicom());
            return attributes2;
        }
        if ("Siemens".equalsIgnoreCase(attributes.getString(524400)) && 512.0 == attributes.getDouble(2625616, 0.0) && 1024.0 == attributes.getDouble(2625617, 0.0) && iImageInformation.getImageType().contains(ImageType.EXAM_PROTOCOL)) {
            Attributes attributes3 = new Attributes(4);
            attributes3.setDouble(2625616, VR.DS, new double[]{2500.0});
            attributes3.setDouble(2625617, VR.DS, new double[]{4096.0});
            return attributes3;
        }
        return attributes;
    }

    private static boolean hasValidPixelMinMaxValues(ImageInformation2 imageInformation2) {
        Integer n = imageInformation2.getSmallestImagePixelValueInSeries();
        if (n == null) {
            return false;
        }
        Integer n2 = imageInformation2.getLargestImagePixelValueInSeries();
        if (n2 == null) {
            return false;
        }
        return n < n2;
    }

    protected static IVOILUT createMissingWindow(ImageInformation2 imageInformation2) {
        if (ImageInformation2.hasValidPixelMinMaxValues(imageInformation2)) {
            Integer n = imageInformation2.getSmallestImagePixelValueInSeries();
            Integer n2 = imageInformation2.getLargestImagePixelValueInSeries();
            double d = n2 - n;
            double d2 = ImageInformation2.dataToLogicalNoLut((double)n.intValue() + d / 2.0, imageInformation2.mLUT, imageInformation2.getBitsStored());
            double d3 = ImageInformation2.dataToLogicalNoLut(Math.abs(d), imageInformation2.mLUT, imageInformation2.getBitsStored());
            return VOILUT.create((double)d2, (double)d3);
        }
        Attributes attributes = imageInformation2.getDataset();
        if (attributes.containsValue(2621702) && attributes.containsValue(2621703)) {
            int n = attributes.getInt(2621702, 0);
            int n3 = attributes.getInt(2621703, 0);
            if (n3 > n) {
                double d = n3 - n;
                double d4 = ImageInformation2.dataToLogicalNoLut((double)n + d / 2.0, imageInformation2.mLUT, imageInformation2.getBitsStored());
                double d5 = ImageInformation2.dataToLogicalNoLut(Math.abs(d), imageInformation2.mLUT, imageInformation2.getBitsStored());
                return VOILUT.create((double)d4, (double)d5);
            }
        } else if (imageInformation2.getPhotometricInterpretation() == PhotometricInterpretation.RGBColor) {
            return VOILUT.create((double)128.0, (double)256.0);
        }
        return null;
    }

    private static IVOILUT createMissingWindowBasedOnData(ImageInformation2 imageInformation2, IHistogramProvider iHistogramProvider) {
        if (iHistogramProvider == null) {
            return null;
        }
        return MissingWindowCreator.createMissingWindowLevels(imageInformation2, iHistogramProvider, null);
    }

    private static double dataToLogicalNoLut(double d, ModalityLUT modalityLUT, int n) {
        if (modalityLUT == null) {
            return d;
        }
        if (modalityLUT.getModalityLookupTable() == null || modalityLUT.getModalityLookupTable().getLookupTable() == null) {
            double d2 = d;
            if (modalityLUT.getRescaleSlope() != null) {
                d2 *= modalityLUT.getRescaleSlope().doubleValue();
            }
            if (modalityLUT.getRescaleIntercept() != null) {
                d2 += modalityLUT.getRescaleIntercept().doubleValue();
            }
            return d2;
        }
        return d * (double)(1 << n - modalityLUT.getModalityLookupTable().getLookupTable().getOutputBits());
    }

    public static IImageInformation.ImageClass getImageClass(String string) {
        return sopClassMap.get(string);
    }

    public static boolean isTomosynthesisImage(IImageInformation iImageInformation) {
        return iImageInformation.getImageClass() == IImageInformation.ImageClass.TOMO || iImageInformation.getImageClass() == IImageInformation.ImageClass.CT && iImageInformation.getImageType().contains(ImageType.TOMO);
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    public String getFrameOfReferenceUID() {
        if (this.frameOfReferenceUID == null) {
            this.frameOfReferenceUID = this.dcm.getString(0x200052, null);
        }
        return this.frameOfReferenceUID;
    }

    @Override
    public double[] getPixelSpacing() {
        if (this.hasImageRegionSpacing()) {
            return null;
        }
        try {
            return this.dcm.getDoubles(2621488);
        }
        catch (Exception exception) {
            log.info("Pixel Spacing could not be parsed");
            try {
                String[] stringArray = this.dcm.getStrings(2621488);
                if (stringArray != null) {
                    double[] dArray = new double[stringArray.length];
                    int n = 0;
                    while (n < dArray.length) {
                        stringArray[n] = stringArray[n].replace(',', '.');
                        dArray[n] = Double.valueOf(stringArray[n]);
                        ++n;
                    }
                    return dArray;
                }
            }
            catch (Exception exception2) {
                log.error("Pixel Spacing could not really be parsed");
            }
        }
        return null;
    }

    @Override
    public int getColumns() {
        return this.dcm.getInt(2621457, 0);
    }

    @Override
    public int getRows() {
        return this.dcm.getInt(2621456, 0);
    }

    @Override
    public int[] getPixelAspectRatio() {
        if (!this.dcm.containsValue(2621492)) {
            return null;
        }
        int[] nArray = null;
        try {
            nArray = this.dcm.getInts(2621492);
        }
        catch (Exception exception) {
            log.error("Could not parse aspect ratio", (Throwable)exception);
        }
        if (nArray != null) {
            if (nArray.length != 2) {
                nArray = null;
            } else if (nArray[0] == 0) {
                nArray = null;
            }
        }
        return nArray;
    }

    @Override
    public PhotometricInterpretation getPhotometricInterpretation() {
        return PhotometricInterpretation.get((String)this.dcm.getString(2621444));
    }

    @Override
    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    @Override
    public String getKey() {
        return this.sopInstanceUID;
    }

    @Override
    public int getFrameNumber() {
        return -1;
    }

    @Override
    public String getSOPClassUID() {
        return this.dcm.getString(524310);
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.dcm.getString(0x20000E);
    }

    @Override
    public String getStudyInstanceUID() {
        return this.dcm.getString(0x20000D);
    }

    @Override
    public int getInstanceNumber() {
        try {
            return this.dcm.getInt(2097171, 0);
        }
        catch (Exception exception) {
            log.error("Not parsable value", (Throwable)exception);
            return 1;
        }
    }

    @Override
    public String[] getPatientOrientation() {
        return this.dcm.getStrings(0x200020);
    }

    @Override
    public Set<ImageType> getImageType() {
        if (this.imageTypes == null) {
            this.imageTypes = ImageType.get((String[])this.dcm.getStrings(524296));
        }
        return this.imageTypes;
    }

    @Override
    public String getModality() {
        return this.dcm.getString(524384);
    }

    @Override
    public String getBodyPartExamined() {
        return this.dcm.getString(1572885);
    }

    @Override
    public Laterality getImageLaterality() {
        if (this.imageClass == IImageInformation.ImageClass.CR) {
            return Laterality.get((String)this.dcm.getString(0x200060));
        }
        return Laterality.get((String)this.dcm.getString(0x200062));
    }

    @Override
    public double[] getImageOrientation() {
        double[] dArray = this.dcm.getDoubles(2097207);
        if (dArray == null || dArray.length != 6) {
            return null;
        }
        return dArray;
    }

    @Override
    public double[] getImagePosition() {
        return this.dcm.getDoubles(0x200032);
    }

    @Override
    public Double getSliceLocation() {
        if (this.dcm.containsValue(2101313)) {
            return this.dcm.getDouble(2101313, 0.0);
        }
        return null;
    }

    @Override
    public Double getSliceThickness() {
        if (this.dcm.containsValue(1572944)) {
            return this.dcm.getDouble(1572944, 0.0);
        }
        if (!Double.isNaN(this.sliceThickness)) {
            return this.sliceThickness;
        }
        return null;
    }

    @Override
    public void setSliceThickness(double d) {
        if (this.dcm.containsValue(1572944)) {
            log.warn("Setting thickness ignores as present");
        } else {
            this.sliceThickness = d;
        }
    }

    @Override
    public Double getGantryDetectorTilt() {
        if (this.dcm.containsValue(1577248)) {
            return this.dcm.getDouble(1577248, 0.0);
        }
        return null;
    }

    @Override
    public IImageInformation.ImageClass getImageClass() {
        return this.imageClass;
    }

    @Override
    public int getBitsStored() {
        return this.bitsStored;
    }

    @Override
    public int getHighBit() {
        return this.highBit;
    }

    @Override
    public Integer getPixelRepresentation() {
        return this.dcm.getInt(2621699, 0);
    }

    @Override
    public Date getAcquisitionDateTime() {
        return this.dcm.getDate(2251945843097650L);
    }

    @Override
    public long getAcquisitionDateTimeMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getAcquisitionDateTime());
        return calendar.getTimeInMillis();
    }

    @Override
    public Integer getAcquisitionNumber() {
        return this.dcm.getInt(0x200012, 0);
    }

    @Override
    public Double getTriggerTime() {
        if (this.dcm.containsValue(1577056)) {
            return this.dcm.getDouble(1577056, 0.0);
        }
        return null;
    }

    @Override
    public Double getDiffusionBValue() {
        return PrivateTagMapper.getInstance().getDouble(this.dcm, 1609863);
    }

    @Override
    public String getDerivationDescription() {
        return this.dcm.getString(532753);
    }

    @Override
    public boolean isInverse() {
        return this.properties.contains((Object)ImageProperties.Inverse);
    }

    @Override
    public boolean isSigned() {
        return this.properties.contains((Object)ImageProperties.Signed);
    }

    @Override
    public boolean isLossy() {
        return this.properties.contains((Object)ImageProperties.LossyCompression);
    }

    @Override
    public String resolveString(int n) {
        return this.dcm.getString(n);
    }

    @Override
    public String[] resolveStrings(int n) {
        return this.dcm.getStrings(n);
    }

    @Override
    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        return Dcm4cheUtils.getNestedDataset((int[])nArray, (Attributes)this.dcm, (boolean)false);
    }

    public ModalityLUT getModalityLUT() {
        return this.mLUT;
    }

    public IColorLookupTableSource getPaletteColorLUT() {
        if (this.pclmt == null) {
            this.pclmt = new PaletteColorLUTModule();
            this.pclmt.readFrom(this.dcm);
        }
        return this.pclmt;
    }

    @Override
    public boolean hasColorPaletteLUT() {
        return this.properties.contains((Object)ImageProperties.HasColorLUT);
    }

    public PresentationLUT getPresentationLUT() {
        return this.pLUT;
    }

    public IVOILUT getVOILUT() {
        return this.vLUT;
    }

    public void setVOILUT(IVOILUT iVOILUT) {
    }

    public IVOILUT getVOILUT(IHistogramProvider iHistogramProvider) {
        if (this.vLUT != null && this.vLUT.hasWindow() && this.vLUT.getWindowWidth() == 1.0 && iHistogramProvider != null) {
            this.vLUT = MissingWindowCreator.createMissingWindowLevels(this, iHistogramProvider, MissingWindowCreator.WindowCreationFunction.MinMax);
        }
        if (this.vLUT == null) {
            this.vLUT = ImageInformation2.createMissingWindowBasedOnData(this, iHistogramProvider);
        }
        return this.vLUT;
    }

    @Override
    public List<RealWorldValueMapping> getRealWorldValueMappings() {
        if (this.realWorldValueMappings == null) {
            this.realWorldValueMappings = this.createRealWorldValueMappings();
        }
        return this.realWorldValueMappings;
    }

    protected List<RealWorldValueMapping> createRealWorldValueMappings() {
        return RealWorldValueMappingFactory.create(this.dcm);
    }

    @Override
    public boolean hasImageRegionSpacing() {
        return this.ultrasoundRegions != null && !this.ultrasoundRegions.isEmpty();
    }

    @Override
    public IImageRegionSpacing getImageRegionSpacing(PointSequence pointSequence) {
        if (this.ultrasoundRegions != null) {
            for (UltrasoundRegionSpacing ultrasoundRegionSpacing : this.ultrasoundRegions) {
                if (!ultrasoundRegionSpacing.isInBounds(pointSequence)) continue;
                return ultrasoundRegionSpacing;
            }
        }
        return null;
    }

    @Override
    public String getStationName() {
        return this.dcm.getString(528400);
    }

    @Override
    public double[] getImagerPixelSpacing() {
        return this.dcm.getDoubles(1577316);
    }

    @Override
    public double[] getImagePlanePixelSpacing() {
        return this.dcm.getDoubles(805437457);
    }

    @Override
    public Double getEstimatedRadiographicMagnificationFactor() {
        if (this.dcm.containsValue(0x181114)) {
            return this.dcm.getDouble(0x181114, 0.0);
        }
        return null;
    }

    @Override
    public boolean containsRenderInformation() {
        return this.properties.contains((Object)ImageProperties.RenderInformationAvailable);
    }

    public String getIssuerOfPatientID() {
        return this.dcm.getString(0x100021);
    }

    public Date getPatientBirthDate() {
        return Dcm4cheUtils.getDate((int)0x100030, (Attributes)this.dcm);
    }

    public String getPatientID() {
        return this.dcm.getString(0x100020);
    }

    public String getPatientName() {
        return this.dcm.getString(0x100010);
    }

    public String getPatientSex() {
        return this.dcm.getString(0x100040);
    }

    public void setIssuerOfPatientID(String string) {
        throw new UnsupportedOperationException();
    }

    public void setPatientBirthDate(Date date) {
        throw new UnsupportedOperationException();
    }

    public void setPatientID(String string) {
        throw new UnsupportedOperationException();
    }

    public void setPatientName(String string) {
        throw new UnsupportedOperationException();
    }

    public void setPatientSex(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ILocalizerPlane getLocalizerPlane() {
        if (this.locPlane == null) {
            try {
                this.locPlane = this.imageClass == IImageInformation.ImageClass.OPT2D ? new PassiveLocalizerPlane(this) : new LocalizerPlane(this);
            }
            catch (LocalizerPlane.IllegalLocalizerData illegalLocalizerData) {
                log.debug("Incorrect localizer", (Throwable)illegalLocalizerData);
                return null;
            }
        }
        return this.locPlane;
    }

    @Override
    public Attributes getDataset() {
        return this.dcm;
    }

    @Override
    public Attributes getDatasetPerFrame() {
        return this.dcm;
    }

    @Override
    public double[] getNominalScannedPixelSpacing() {
        return this.dcm.getDoubles(1581072);
    }

    @Override
    public Integer getLargestImagePixelValueInSeries() {
        if (this.dcm.containsValue(2621705)) {
            return this.dcm.getInt(2621705, 0);
        }
        return null;
    }

    @Override
    public Integer getSmallestImagePixelValueInSeries() {
        if (this.dcm.containsValue(2621704)) {
            return this.dcm.getInt(2621704, 0);
        }
        return null;
    }

    @Override
    public boolean setLossyFetching() {
        double[] dArray = this.dcm.getDoubles(2621488);
        if (dArray != null && (dArray.length != 2 || dArray[0] != dArray[1])) {
            return false;
        }
        dArray = this.dcm.getDoubles(2621492);
        if (dArray != null && (dArray.length != 2 || dArray[0] != dArray[1])) {
            return false;
        }
        this.properties.add(ImageProperties.LossyCompression);
        this.properties.add(ImageProperties.LossyPrefetch);
        this.vLUT = VOILUT.create((double)128.0, (double)256.0);
        this.pLUT = null;
        this.mLUT = null;
        return true;
    }

    @Override
    public boolean isBeingLossyPrefetched() {
        return this.properties.contains((Object)ImageProperties.LossyPrefetch);
    }

    @Override
    public int getNMVectorValue(int n, int n2) {
        int[] nArray = this.dcm.getInts(n);
        if (nArray != null && nArray.length > n2) {
            return nArray[n2];
        }
        return -1;
    }

    @Override
    public Double getRepetitionTime() {
        if (this.dcm.containsValue(0x180080)) {
            return this.dcm.getDouble(0x180080, 0.0);
        }
        return null;
    }

    @Override
    public Double getInversionTime() {
        if (this.dcm.containsValue(1572994)) {
            return this.dcm.getDouble(1572994, 0.0);
        }
        return null;
    }

    @Override
    public Double getEchoTime() {
        if (this.dcm.containsValue(0x180081)) {
            return this.dcm.getDouble(0x180081, 0.0);
        }
        return null;
    }

    static enum ImageProperties {
        Signed,
        Inverse,
        LossyCompression,
        RenderInformationAvailable,
        HasColorLUT,
        LossyPrefetch;

    }
}

