/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IdentityValueMapping;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import org.apache.commons.lang3.StringUtils;

public class ImagePointProperties
implements IImageRegionProperties {
    private final IValueMapping mapping;
    private final double mean;

    public ImagePointProperties(int n, IValueMapping iValueMapping) {
        this.mapping = iValueMapping == null ? IdentityValueMapping.INSTANCE : iValueMapping;
        this.mean = this.mapping.applyMapping(n);
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.mean);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStdDev() {
        return 0.0;
    }

    @Override
    public double getMin() {
        return this.getMean();
    }

    @Override
    public double getMax() {
        return this.getMean();
    }

    @Override
    public String getUnit() {
        return this.mapping.getUnit();
    }

    @Override
    public Histogram getHistogram() {
        return null;
    }

    @Override
    public String getStatistics() {
        if (Double.isNaN(this.mean)) {
            return "NA";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mapping.formatValue(this.mean));
        String string = this.getUnit();
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getStatistics();
    }
}

