/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IdentityValueMapping;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IMemoryPool;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.tiani.base.data.IPixelDataMask;
import com.tiani.base.data.IPixelDataWrapper;
import com.tiani.jvision.renderer.filter.ImageFilterOperator;
import java.util.ArrayDeque;
import javax.vecmath.Point2i;

public class PixelDataWrapperFactory {
    private static final IMemoryPool MEM_POOL = DataCacheProviderFactory.getMemoryPool();

    private PixelDataWrapperFactory() {
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame) {
        return PixelDataWrapperFactory.createPixelData(iPixelDataFrame, IdentityValueMapping.INSTANCE);
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new BytePixelDataWrapper(iPixelDataFrame, iValueMapping);
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new ShortPixelDataWrapper(iPixelDataFrame, iValueMapping);
        }
        return null;
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        if (imageFilterOperatorArray == null || imageFilterOperatorArray.length == 0 || imageFilterOperatorArray.length == 1 && imageFilterOperatorArray[0] == null) {
            return PixelDataWrapperFactory.createPixelData(iPixelDataFrame, iValueMapping);
        }
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new CachedArrayPixelDataWrapper(PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, iValueMapping, imageFilterOperatorArray));
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new CachedArrayPixelDataWrapper(PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, iValueMapping, imageFilterOperatorArray));
        }
        return null;
    }

    private static double[] filterBytePixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        byte[] byArray = null;
        try {
            byArray = PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, imageFilterOperatorArray);
            double[] dArray = MEM_POOL.allocDoubles((long)byArray.length);
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = iValueMapping.applyMapping((int)byArray[n]);
                ++n;
            }
            double[] dArray2 = dArray;
            return dArray2;
        }
        finally {
            if (byArray != null) {
                MEM_POOL.free(byArray);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] filterBytePixelData(IPixelDataFrame<?> var0, ImageFilterOperator ... var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static double[] filterShortPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        short[] sArray = null;
        try {
            sArray = PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, imageFilterOperatorArray);
            double[] dArray = MEM_POOL.allocDoubles((long)sArray.length);
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = iValueMapping.applyMapping((int)sArray[n]);
                ++n;
            }
            double[] dArray2 = dArray;
            return dArray2;
        }
        finally {
            if (sArray != null) {
                MEM_POOL.free(sArray);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static short[] filterShortPixelData(IPixelDataFrame<?> var0, ImageFilterOperator ... var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IPixelDataMask createThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new CachedArrayPixelDataMask(PixelDataWrapperFactory.createByteThresholdMask(iPixelDataFrame, n, imageFilterOperatorArray));
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new CachedArrayPixelDataMask(PixelDataWrapperFactory.createShortThresholdMask(iPixelDataFrame, n, imageFilterOperatorArray));
        }
        return null;
    }

    private static int[] createByteThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        byte[] byArray = null;
        try {
            byArray = PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, imageFilterOperatorArray);
            int[] nArray = MEM_POOL.allocAndClearInts((long)((byArray.length + 31) / 32));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, 0));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, 0));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, iPixelDataFrame.getHeight() - 1));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, iPixelDataFrame.getHeight() - 1));
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            if (byArray != null) {
                MEM_POOL.free(byArray);
            }
        }
    }

    private static void floodByteThresholdMask(byte[] byArray, int[] nArray, int n, int n2, int n3, Point2i point2i) {
        ArrayDeque<Point2i> arrayDeque = new ArrayDeque<Point2i>();
        Point2i point2i2 = point2i;
        while (point2i2 != null) {
            int n4 = point2i2.y * n;
            int n5 = n4 + point2i2.x;
            if (byArray[n5] < n3 && (nArray[n5 >> 5] & 1 << (n5 & 0x1F)) == 0) {
                int n6 = point2i2.x;
                while (n6 >= 0 && byArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n7 = n5 >> 5;
                    nArray[n7] = nArray[n7] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && byArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && byArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    --n6;
                }
                n6 = point2i2.x + 1;
                while (n6 < n && byArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n8 = n5 >> 5;
                    nArray[n8] = nArray[n8] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && byArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && byArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    ++n6;
                }
            }
            point2i2 = (Point2i)arrayDeque.poll();
        }
    }

    private static int[] createShortThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        short[] sArray = null;
        try {
            sArray = PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, imageFilterOperatorArray);
            int[] nArray = MEM_POOL.allocAndClearInts((long)((sArray.length + 31) / 32));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, 0));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, 0));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, iPixelDataFrame.getHeight() - 1));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, iPixelDataFrame.getHeight() - 1));
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            if (sArray != null) {
                MEM_POOL.free(sArray);
            }
        }
    }

    private static void floodShortThresholdMask(short[] sArray, int[] nArray, int n, int n2, int n3, Point2i point2i) {
        ArrayDeque<Point2i> arrayDeque = new ArrayDeque<Point2i>();
        Point2i point2i2 = point2i;
        while (point2i2 != null) {
            int n4 = point2i2.y * n;
            int n5 = n4 + point2i2.x;
            if (sArray[n5] < n3 && (nArray[n5 >> 5] & 1 << (n5 & 0x1F)) == 0) {
                int n6 = point2i2.x;
                while (n6 >= 0 && sArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n7 = n5 >> 5;
                    nArray[n7] = nArray[n7] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && sArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && sArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    --n6;
                }
                n6 = point2i2.x + 1;
                while (n6 < n && sArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n8 = n5 >> 5;
                    nArray[n8] = nArray[n8] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && sArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && sArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    ++n6;
                }
            }
            point2i2 = (Point2i)arrayDeque.poll();
        }
    }

    private static abstract class AbstractPixelDataWrapper
    implements IPixelDataWrapper {
        protected final IPixelAccessor<?> pa;
        private final boolean isUnsigned;
        private final int mask;
        private final IValueMapping mapping;

        public AbstractPixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            this.pa = iPixelDataFrame.getPixelAccessor();
            this.isUnsigned = !iPixelDataFrame.isSigned();
            this.mask = this.pa.getMask();
            this.mapping = iValueMapping;
        }

        @Override
        public double getValueAt(int n) {
            int n2 = this.getRawValueAt(n);
            if (this.isUnsigned) {
                n2 &= this.mask;
            }
            return this.mapping.applyMapping(n2);
        }

        abstract int getRawValueAt(int var1);

        @Override
        public void release() {
            this.pa.close();
        }
    }

    private static class BytePixelDataWrapper
    extends AbstractPixelDataWrapper {
        private final byte[] data;

        BytePixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            super(iPixelDataFrame, iValueMapping);
            this.data = (byte[])this.pa.getData();
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        int getRawValueAt(int n) {
            return this.data[n];
        }
    }

    private static class CachedArrayPixelDataMask
    implements IPixelDataMask {
        private final int[] mask;

        public CachedArrayPixelDataMask(int[] nArray) {
            this.mask = nArray;
        }

        @Override
        public boolean isMasked(int n) {
            return (this.mask[n >> 5] & 1 << (n & 0x1F)) != 0;
        }

        @Override
        public void release() {
            MEM_POOL.free(this.mask);
        }
    }

    private static class CachedArrayPixelDataWrapper
    implements IPixelDataWrapper {
        private final double[] data;

        public CachedArrayPixelDataWrapper(double[] dArray) {
            this.data = dArray;
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        public double getValueAt(int n) {
            return this.data[n];
        }

        @Override
        public void release() {
            MEM_POOL.free(this.data);
        }
    }

    private static class ShortPixelDataWrapper
    extends AbstractPixelDataWrapper {
        private final short[] data;

        ShortPixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            super(iPixelDataFrame, iValueMapping);
            this.data = (short[])this.pa.getData();
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        int getRawValueAt(int n) {
            return this.data[n];
        }
    }
}

