/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.AbstractRawDataContainer;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImagePointProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.ImageRegionProperties;
import com.tiani.base.data.ResetableLazyInitializer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class RawDataContainer16CT
extends AbstractRawDataContainer {
    private static final ALogger log = ALogger.getLogger(RawDataContainer16CT.class);

    public RawDataContainer16CT(IPixelDataFrame<?> iPixelDataFrame) {
        super(iPixelDataFrame);
        this.histogram = new LazyHistogramm();
    }

    @Override
    public IImageRegionProperties getImageRegionProperties(ImageRegion imageRegion, int n, int n2, IValueMapping iValueMapping, Integer n3, Integer n4) {
        IImageRegionProperties iImageRegionProperties = null;
        Throwable throwable = null;
        Object var9_10 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            short[] sArray = (short[])iPixelAccessor.getData();
            int n5 = this.pixelDataFrame.getWidth();
            int n6 = this.pixelDataFrame.getHeight();
            int n7 = this.pixelDataFrame.getHighBit();
            if (imageRegion.clip == null) {
                if (imageRegion.x >= 0 && imageRegion.x < n5 && imageRegion.y >= 0 && imageRegion.y < n6) {
                    int n8 = this.pixelDataFrame.isSigned() ? sArray[imageRegion.x + imageRegion.y * n5] : sArray[imageRegion.x + imageRegion.y * n5] & 0xFFFF;
                    iImageRegionProperties = new ImagePointProperties(n8, iValueMapping);
                } else {
                    iImageRegionProperties = IImageRegionProperties.INVALID;
                }
            } else {
                Histogram histogram = new Histogram(sArray, 2 << n7, n5, n6, imageRegion.clip, iValueMapping, n3, n4, this.pixelDataFrame.isSigned() ? 1 << n7 : 0);
                iImageRegionProperties = new ImageRegionProperties(histogram);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return iImageRegionProperties;
    }

    @Override
    protected void fastSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingInt(object, (short[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingInt(Object var1_1, short[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int var15_15) {
        var16_16 = this.pixelDataFrame.getWidth();
        var17_17 = (short[])var1_1;
        var18_18 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var19_19 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var20_20 = var11_11 << 2;
        var21_21 = var12_12 << 2;
        while (var20_20 >= 1024) {
            var20_20 -= 1024;
        }
        while (var21_21 >= 1024) {
            var21_21 -= 1024;
        }
        var22_22 = var20_20;
        var23_23 = var7_7 + var8_8 * var16_16;
        var24_24 = var5_5;
        var25_25 = var23_23;
        var26_26 = 0;
        ** GOTO lbl41
        {
            var21_21 -= 1024;
            var23_23 += var16_16;
            do {
                if (var21_21 >= 512) continue block2;
                var25_25 = var23_23;
                var27_27 = var24_24;
                var21_21 += var19_19;
                var20_20 = var22_22;
                var28_28 = 0;
                while (var28_28 < var3_3) {
                    if (var20_20 >= 512) {
                        while (var20_20 >= 512) {
                            var20_20 -= 1024;
                            ++var25_25;
                        }
                    }
                    var17_17[var27_27] = var28_28 == var3_3 - 1 && var26_26 == var4_4 - 1 ? (short)(var15_15 + var2_2[var25_25] & 65535) : (var26_26 == var4_4 - 1 ? (short)((var15_15 + var2_2[var25_25] & 65535) + (var15_15 + var2_2[var25_25 + 1] & 65535) >> 1) : (var28_28 == var3_3 - 1 ? (short)((var15_15 + var2_2[var25_25] & 65535) + (var15_15 + var2_2[var25_25 + var16_16] & 65535) >> 1) : (short)((var15_15 + var2_2[var25_25] & 65535) + (var15_15 + var2_2[var25_25 + 1] & 65535) + (var15_15 + var2_2[var25_25 + var16_16] & 65535) + (var15_15 + var2_2[var25_25 + var16_16 + 1] & 65535) >> 2)));
                    var20_20 += var18_18;
                    ++var27_27;
                    ++var28_28;
                }
                var24_24 += var6_6;
                ++var26_26;
lbl41:
                // 2 sources

            } while (var26_26 < var4_4);
        }
    }

    @Override
    protected void fastSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingWithLUTInt(nArray, iPixelAccessor, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, nArray2, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingWithLUTInt(int[] var1_1, IPixelAccessor<?> var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int[] var15_15, int var16_16) {
        var17_17 = var2_2.getMask();
        var18_18 = (short[])var2_2.getData();
        var19_19 = this.pixelDataFrame.getWidth();
        var20_20 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var21_21 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var22_22 = var11_11 << 2;
        var23_23 = var12_12 << 2;
        while (var22_22 >= 1024) {
            var22_22 -= 1024;
        }
        while (var23_23 >= 1024) {
            var23_23 -= 1024;
        }
        var24_24 = var22_22;
        var25_25 = var7_7 + var8_8 * var19_19;
        var26_26 = var5_5;
        var27_27 = var25_25;
        var28_28 = 0;
        ** GOTO lbl42
        {
            var23_23 -= 1024;
            var25_25 += var19_19;
            do {
                if (var23_23 >= 512) continue block2;
                var27_27 = var25_25;
                var29_29 = var26_26;
                var23_23 += var21_21;
                var22_22 = var24_24;
                var30_30 = 0;
                while (var30_30 < var3_3) {
                    if (var22_22 >= 512) {
                        while (var22_22 >= 512) {
                            var22_22 -= 1024;
                            ++var27_27;
                        }
                    }
                    var1_1[var29_29] = var30_30 == var3_3 - 1 && var28_28 == var4_4 - 1 ? var15_15[var16_16 + var18_18[var27_27] & var17_17] : (var28_28 == var4_4 - 1 ? var15_15[(var16_16 + var18_18[var27_27] & var17_17) + (var16_16 + var18_18[var27_27 + 1] & var17_17) >> 1] : (var30_30 == var3_3 - 1 ? var15_15[(var16_16 + var18_18[var27_27] & var17_17) + (var16_16 + var18_18[var27_27 + var19_19] & var17_17) >> 1] : var15_15[(var16_16 + var18_18[var27_27] & var17_17) + (var16_16 + var18_18[var27_27 + 1] & var17_17) + (var16_16 + var18_18[var27_27 + var19_19] & var17_17) + (var16_16 + var18_18[var27_27 + var19_19 + 1] & var17_17) >> 2]));
                    var22_22 += var20_20;
                    ++var29_29;
                    ++var30_30;
                }
                var26_26 += var6_6;
                ++var28_28;
lbl42:
                // 2 sources

            } while (var28_28 < var4_4);
        }
    }

    @Override
    protected void copyFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Throwable throwable = null;
        Object var10_11 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            short[] sArray = (short[])iPixelAccessor.getData();
            int n8 = this.pixelDataFrame.getWidth();
            if (n2 == this.pixelDataFrame.getHeight() && n == n8 && n7 == 0 && n5 == 0 && n6 == 0 && n4 == n) {
                System.arraycopy(sArray, 0, object, n3, n * n2);
            } else {
                short[] sArray2 = (short[])object;
                int n9 = n3;
                int n10 = n5 + n6 * n8;
                int n11 = 0;
                while (n11 < n2) {
                    int n12 = 0;
                    while (n12 < n) {
                        sArray2[n9 + n12] = (short)(n7 + sArray[n10 + n12]);
                        ++n12;
                    }
                    n9 += n4;
                    n10 += n8;
                    ++n11;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void copyFullWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray2, int n7) {
        Throwable throwable = null;
        Object var11_12 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int n8 = iPixelAccessor.getMask();
            short[] sArray = (short[])iPixelAccessor.getData();
            int n9 = this.pixelDataFrame.getWidth();
            int n10 = n3;
            int n11 = n5 + n6 * n9;
            int n12 = 0;
            while (n12 < n2) {
                int n13 = 0;
                while (n13 < n) {
                    nArray[n10 + n13] = nArray2[n7 + sArray[n11 + n13] & n8];
                    ++n13;
                }
                n10 += n4;
                n11 += n9;
                ++n12;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Throwable throwable = null;
        Object var12_13 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.enlargeInt(object, (short[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlargeInt(Object object, short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        short[] sArray2 = (short[])object;
        int n11 = (n7 - 256 << 8) / (n - 1);
        int n12 = (n8 - 256 << 8) / (n2 - 1);
        int n13 = 0;
        int n14 = 0;
        if (n11 < 65535 && n12 < 65535) {
            int n15 = n10 - 1;
            int n16 = n6 << 8;
            int n17 = 0;
            while (n17 < n2) {
                int n18 = n5 << 8;
                int n19 = (n16 >> 16) * n10;
                int n20 = n19 + n10;
                int n21 = n16 >> 4 & 0xFFF;
                int n22 = 4096 - n21;
                int n23 = n3 + n17 * n4;
                int n24 = 1048575;
                int n25 = 0;
                while (n25 < n) {
                    int n26 = n18 >> 16;
                    int n27 = n18 >> 4 & 0xFFF;
                    n18 += n11;
                    if (n27 <= n24) {
                        n13 = n21 == 0 ? n9 + sArray[n19 + n26] & 0xFFFF : (n9 + sArray[n19 + n26] & 0xFFFF) * n22 + (n9 + sArray[n20 + n26] & 0xFFFF) * n21 >> 12;
                        n14 = n26 == n15 ? 0 : (n21 == 0 ? n9 + sArray[n19 + n26 + 1] & 0xFFFF : (n9 + sArray[n19 + n26 + 1] & 0xFFFF) * n22 + (n9 + sArray[n20 + n26 + 1] & 0xFFFF) * n21 >> 12);
                    }
                    n24 = n27;
                    sArray2[n23 + n25] = (short)(n13 * (4096 - n27) + n14 * n27 >> 12);
                    ++n25;
                }
                n16 += n12;
                ++n17;
            }
        } else {
            int n28 = n6 << 8;
            int n29 = 0;
            while (n29 < n2) {
                int n30;
                int n31;
                int n32;
                int n33 = n5 << 8;
                int n34 = (n28 >> 16) * n10;
                int n35 = n34 + n10;
                int n36 = n28 >> 4 & 0xFFF;
                int n37 = 4096 - n36;
                int n38 = n3 + n29 * n4;
                if (n36 == 0) {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = n9 + sArray[n34 + n31] & 0xFFFF;
                        n14 = n30 == 0 ? 0 : n9 + sArray[n34 + n31 + 1] & 0xFFFF;
                        sArray2[n38 + n32] = (short)(n13 * (4096 - n30) + n14 * n30 >> 12);
                        ++n32;
                    }
                } else {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = (n9 + sArray[n34 + n31] & 0xFFFF) * n37 + (n9 + sArray[n35 + n31] & 0xFFFF) * n36 >> 12;
                        n14 = n30 == 0 ? 0 : (n9 + sArray[n34 + n31 + 1] & 0xFFFF) * n37 + (n9 + sArray[n35 + n31 + 1] & 0xFFFF) * n36 >> 12;
                        sArray2[n38 + n32] = (short)(n13 * (4096 - n30) + n14 * n30 >> 12);
                        ++n32;
                    }
                }
                n28 += n12;
                ++n29;
            }
        }
    }

    @Override
    protected void enlargeWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        Throwable throwable = null;
        Object var13_14 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.enlargeWithLUTInt(nArray, iPixelAccessor, n, n2, n3, n4, n5, n6, n7, n8, nArray2, n9);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlargeWithLUTInt(int[] nArray, IPixelAccessor<?> iPixelAccessor, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        int n10 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n11 = this.pixelDataFrame.getWidth();
        int n12 = (n7 - 256 << 8) / (n - 1);
        int n13 = (n8 - 256 << 8) / (n2 - 1);
        int n14 = 0;
        int n15 = 0;
        if (n12 < 65535 && n13 < 65535) {
            int n16 = n11 - 1;
            int n17 = n6 << 8;
            int n18 = 0;
            while (n18 < n2) {
                int n19 = n5 << 8;
                int n20 = (n17 >> 16) * n11;
                int n21 = n20 + n11;
                int n22 = n17 >> 4 & 0xFFF;
                int n23 = 4096 - n22;
                int n24 = n3 + n18 * n4;
                int n25 = 1048575;
                int n26 = 0;
                while (n26 < n) {
                    int n27 = n19 >> 16;
                    int n28 = n19 >> 4 & 0xFFF;
                    n19 += n12;
                    if (n28 <= n25) {
                        n14 = n22 == 0 ? n9 + sArray[n20 + n27] & 0xFFFF : (n9 + sArray[n20 + n27] & 0xFFFF) * n23 + (n9 + sArray[n21 + n27] & 0xFFFF) * n22 >> 12;
                        n15 = n27 == n16 ? 0 : (n22 == 0 ? n9 + sArray[n20 + n27 + 1] & 0xFFFF : (n9 + sArray[n20 + n27 + 1] & 0xFFFF) * n23 + (n9 + sArray[n21 + n27 + 1] & 0xFFFF) * n22 >> 12);
                    }
                    n25 = n28;
                    nArray[n24 + n26] = nArray2[n14 * (4096 - n28) + n15 * n28 >> 12 & n10];
                    ++n26;
                }
                n17 += n13;
                ++n18;
            }
        } else {
            int n29 = n6 << 8;
            int n30 = 0;
            while (n30 < n2) {
                int n31;
                int n32;
                int n33;
                int n34 = n5 << 8;
                int n35 = (n29 >> 16) * n11;
                int n36 = n35 + n11;
                int n37 = n29 >> 4 & 0xFFF;
                int n38 = 4096 - n37;
                int n39 = n3 + n30 * n4;
                if (n37 == 0) {
                    n33 = 0;
                    while (n33 < n) {
                        n32 = n34 >> 16;
                        n31 = n34 >> 4 & 0xFFF;
                        n34 += n12;
                        n14 = n9 + sArray[n35 + n32] & 0xFFFF;
                        n15 = n31 == 0 ? 0 : n9 + sArray[n35 + n32 + 1] & 0xFFFF;
                        nArray[n39 + n33] = nArray2[n14 * (4096 - n31) + n15 * n31 >> 12 & n10];
                        ++n33;
                    }
                } else {
                    n33 = 0;
                    while (n33 < n) {
                        n32 = n34 >> 16;
                        n31 = n34 >> 4 & 0xFFF;
                        n34 += n12;
                        n14 = (n9 + sArray[n35 + n32] & 0xFFFF) * n38 + (n9 + sArray[n36 + n32] & 0xFFFF) * n37 >> 12;
                        n15 = n31 == 0 ? 0 : (n9 + sArray[n35 + n32 + 1] & 0xFFFF) * n38 + (n9 + sArray[n36 + n32 + 1] & 0xFFFF) * n37 >> 12;
                        nArray[n39 + n33] = nArray2[n14 * (4096 - n31) + n15 * n31 >> 12 & n10];
                        ++n33;
                    }
                }
                n29 += n13;
                ++n30;
            }
        }
    }

    @Override
    protected void extractBilinear(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            short[] sArray = (short[])iPixelAccessor.getData();
            short[] sArray2 = (short[])object;
            int[] nArray = new int[n];
            long[] lArray = new long[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n14 = 0;
            if (n11 < 0) {
                n14 = -256;
            }
            int n15 = 0;
            while (n15 < n) {
                int n16 = (int)((long)(n9 + n14) + l * (long)n15 / l2);
                nArray[n15] = n5 * (n16 >> 8);
                lArray[n15] = n16 & 0xFF;
                ++n15;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2) {
                short s;
                int n20;
                int n21 = (int)((long)(n10 + n17) + l3 * (long)n19 / l4);
                int n22 = n6 * (n21 >> 8);
                long l5 = n21 & 0xFF;
                if (l5 == 0L) {
                    n15 = 0;
                    while (n15 < n) {
                        n20 = nArray[n15] + n22;
                        s = lArray[n15] == 0L ? (short)(n13 + sArray[n20] & 0xFFFF) : (short)((long)(n13 + sArray[n20] & 0xFFFF) * (256L - lArray[n15]) + (long)(n13 + sArray[n20 + n5] & 0xFFFF) * lArray[n15] >> 8);
                        sArray2[n18 + n15] = s;
                        ++n15;
                    }
                } else {
                    n15 = 0;
                    while (n15 < n) {
                        n20 = nArray[n15] + n22;
                        s = lArray[n15] == 0L ? (short)((long)(n13 + sArray[n20] & 0xFFFF) * (256L - l5) + (long)(n13 + sArray[n20 + n6] & 0xFFFF) * l5 >> 8) : (short)(((long)(n13 + sArray[n20] & 0xFFFF) * (256L - lArray[n15]) + (long)(n13 + sArray[n20 + n5] & 0xFFFF) * lArray[n15]) * (256L - l5) + ((long)(n13 + sArray[n20 + n6] & 0xFFFF) * (256L - lArray[n15]) + (long)(n13 + sArray[n20 + n5 + n6] & 0xFFFF) * lArray[n15]) * l5 >> 16);
                        sArray2[n18 + n15] = s;
                        ++n15;
                    }
                }
                n18 += n4;
                ++n19;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractBilinearWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int n14 = iPixelAccessor.getMask();
            short[] sArray = (short[])iPixelAccessor.getData();
            int[] nArray3 = new int[n];
            long[] lArray = new long[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n15 = 0;
            if (n11 < 0) {
                n15 = -256;
            }
            int n16 = 0;
            while (n16 < n) {
                int n17 = (int)((long)(n9 + n15) + l * (long)n16 / l2);
                nArray3[n16] = n5 * (n17 >> 8);
                lArray[n16] = n17 & 0xFF;
                ++n16;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n18 = 0;
            if (n12 < 0) {
                n18 = -256;
            }
            int n19 = n3;
            int n20 = 0;
            while (n20 < n2) {
                int n21;
                int n22;
                int n23 = (int)((long)(n10 + n18) + l3 * (long)n20 / l4);
                int n24 = n6 * (n23 >> 8);
                long l5 = n23 & 0xFF;
                if (l5 == 0L) {
                    n16 = 0;
                    while (n16 < n) {
                        n22 = nArray3[n16] + n24;
                        n21 = lArray[n16] == 0L ? n13 + sArray[n22] & n14 : (int)((long)(n13 + sArray[n22] & n14) * (256L - lArray[n16]) + (long)(n13 + sArray[n22 + n5] & n14) * lArray[n16] >> 8);
                        nArray[n19 + n16] = nArray2[n21];
                        ++n16;
                    }
                } else {
                    n16 = 0;
                    while (n16 < n) {
                        n22 = nArray3[n16] + n24;
                        n21 = lArray[n16] == 0L ? (int)((long)(n13 + sArray[n22] & n14) * (256L - l5) + (long)(n13 + sArray[n22 + n6] & n14) * l5 >> 8) : (int)(((long)(n13 + sArray[n22] & n14) * (256L - lArray[n16]) + (long)(n13 + sArray[n22 + n5] & n14) * lArray[n16]) * (256L - l5) + ((long)(n13 + sArray[n22 + n6] & n14) * (256L - lArray[n16]) + (long)(n13 + sArray[n22 + n5 + n6] & n14) * lArray[n16]) * l5 >> 16);
                        nArray[n19 + n16] = nArray2[n21];
                        ++n16;
                    }
                }
                n19 += n4;
                ++n20;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighbor(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        Throwable throwable = null;
        Object var14_15 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            short[] sArray = (short[])iPixelAccessor.getData();
            short[] sArray2 = (short[])object;
            int[] nArray = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n12 = 0;
            while (n12 < n) {
                nArray[n12] = (int)((long)n5 * ((long)n7 + (long)n9 * ((long)n12 + l) / (long)n >> 8));
                ++n12;
            }
            int n13 = 0;
            int n14 = n2;
            if (n10 < 0) {
                ++n13;
                ++n14;
            }
            int n15 = n3;
            long l2 = n13;
            while (l2 < (long)n14) {
                int n16 = (int)((long)n6 * ((long)n8 + (long)n10 * l2 / (long)n2 >> 8));
                n12 = 0;
                while (n12 < n) {
                    sArray2[n15 + n12] = (short)(n11 + sArray[nArray[n12] + n16]);
                    ++n12;
                }
                n15 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighborWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray2, int n11) {
        Throwable throwable = null;
        Object var15_16 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int n12 = iPixelAccessor.getMask();
            short[] sArray = (short[])iPixelAccessor.getData();
            int[] nArray3 = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n13 = 0;
            while (n13 < n) {
                nArray3[n13] = (int)((long)n5 * ((long)n7 + (long)n9 * ((long)n13 + l) / (long)n >> 8));
                ++n13;
            }
            int n14 = 0;
            int n15 = n2;
            if (n10 < 0) {
                ++n14;
                ++n15;
            }
            int n16 = n3;
            long l2 = n14;
            while (l2 < (long)n15) {
                int n17 = (int)((long)n6 * ((long)n8 + (long)n10 * l2 / (long)n2 >> 8));
                n13 = 0;
                while (n13 < n) {
                    nArray[n16 + n13] = nArray2[n11 + sArray[nArray3[n13] + n17] & n12];
                    ++n13;
                }
                n16 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int n14 = this.pixelDataFrame.isSigned() ? -1 : iPixelAccessor.getMask();
            short[] sArray = (short[])iPixelAccessor.getData();
            short[] sArray2 = (short[])object;
            int[] nArray = new int[n + 1];
            int[] nArray2 = new int[n + 1];
            int n15 = 0;
            if (n11 < 0) {
                n15 = -256;
            }
            nArray[0] = n5 * (n9 + n15 >> 8);
            int n16 = 1;
            while (n16 <= n) {
                nArray[n16] = (int)((long)n5 * ((long)(n9 + n15) + (long)n11 * (long)n16 / (long)n >> 8));
                nArray2[n16] = (nArray[n16] - nArray[n16 - 1]) / n5;
                ++n16;
            }
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n6 * (n10 + n17 >> 8);
            int n19 = n5 * n7;
            int n20 = n6 * n8;
            int n21 = n7 * n8;
            int n22 = n3 - 1;
            long l = 1L;
            while (l <= (long)n2) {
                int n23 = (int)((long)n6 * ((long)(n10 + n17) + (long)n12 * l / (long)n2 >> 8));
                int n24 = (n23 - n18) / n6 * n21;
                n16 = 1;
                while (n16 <= n) {
                    int n25 = nArray2[n16] * n24;
                    if (n25 <= 1) {
                        sArray2[n22 + n16] = (short)(n13 + sArray[nArray[n16 - 1] + n18] & n14);
                    } else {
                        int n26 = 0;
                        int n27 = n18;
                        while (n27 != n23) {
                            int n28 = nArray[n16 - 1];
                            while (n28 != nArray[n16]) {
                                n26 += n13 + sArray[n28 + n27] & n14;
                                n28 += n19;
                            }
                            n27 += n20;
                        }
                        sArray2[n22 + n16] = (short)(n26 / n25);
                    }
                    ++n16;
                }
                n18 = n23;
                n22 += n4;
                ++l;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int n14 = iPixelAccessor.getMask();
            short[] sArray = (short[])iPixelAccessor.getData();
            int[] nArray3 = new int[n + 1];
            int[] nArray4 = new int[n + 1];
            long l = 0L;
            if (n11 < 0) {
                l = -256L;
            }
            nArray3[0] = (int)((long)n5 * ((long)n9 + l >> 8));
            int n15 = 1;
            while (n15 <= n) {
                nArray3[n15] = (int)((long)n5 * ((long)n9 + l + (long)n11 * (long)n15 / (long)n >> 8));
                nArray4[n15] = (nArray3[n15] - nArray3[n15 - 1]) / n5;
                ++n15;
            }
            int n16 = 0;
            if (n12 < 0) {
                n16 = -256;
            }
            int n17 = n6 * (n10 + n16 >> 8);
            int n18 = n5 * n7;
            int n19 = n6 * n8;
            int n20 = n7 * n8;
            int n21 = n3 - 1;
            long l2 = 1L;
            while (l2 <= (long)n2) {
                int n22 = (int)((long)n6 * ((long)(n10 + n16) + (long)n12 * l2 / (long)n2 >> 8));
                int n23 = (n22 - n17) / n6 * n20;
                n15 = 1;
                while (n15 <= n) {
                    int n24 = nArray4[n15] * n23;
                    if (n24 <= 1) {
                        nArray[n21 + n15] = nArray2[n13 + sArray[nArray3[n15 - 1] + n17] & n14];
                    } else {
                        int n25 = 0;
                        int n26 = n17;
                        while (n26 != n22) {
                            int n27 = nArray3[n15 - 1];
                            while (n27 != nArray3[n15]) {
                                n25 += n13 + sArray[n27 + n26] & n14;
                                n27 += n18;
                            }
                            n26 += n19;
                        }
                        nArray[n21 + n15] = nArray2[n25 / n24 & n14];
                    }
                    ++n15;
                }
                n17 = n22;
                n21 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void storeToDicom(Attributes attributes) {
        int n = this.getRows() * this.getColumns();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
                Object object = iPixelAccessor.getData();
                short[] sArray = (short[])object;
                byte[] byArray = DataCacheProviderFactory.getMemoryPool().allocBytes((long)(n * 2));
                int n2 = 0;
                while (n2 < n) {
                    byArray[n2 << 1] = (byte)(sArray[n2] & 0xFFFF);
                    byArray[(n2 << 1) + 1] = (byte)(sArray[n2] >> 8 & 0xFFFF);
                    ++n2;
                }
                attributes.setBytes(2145386512, VR.OB, byArray);
                attributes.setInt(2621456, VR.US, new int[]{this.getRows()});
                attributes.setInt(2621457, VR.US, new int[]{this.getColumns()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.error("Error adding pixel data to dicomobject.", (Throwable)exception);
        }
    }

    private class LazyHistogramm
    extends ResetableLazyInitializer<Histogram> {
        private LazyHistogramm() {
        }

        @Override
        protected Histogram initialize() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IPixelAccessor<?> iPixelAccessor = RawDataContainer16CT.this.getAccessor();){
                short[] sArray = (short[])iPixelAccessor.getData();
                int n = RawDataContainer16CT.this.pixelDataFrame.getHighBit();
                return new Histogram(sArray, 0, RawDataContainer16CT.this.pixelDataFrame.getNumPixels(), 2 << n, RawDataContainer16CT.this.pixelDataFrame.isSigned() ? 1 << n : 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

