/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.AbstractRawDataContainer;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.RawDataContainerRGB;
import com.tiani.base.data.ResetableLazyInitializer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class RawDataContainer3x8
extends AbstractRawDataContainer
implements RawDataContainerRGB {
    private static final ALogger LOGGER = ALogger.getLogger(RawDataContainer3x8.class);
    private boolean windowableGray = false;
    private boolean windowable = true;

    public RawDataContainer3x8(IPixelDataFrame<?> iPixelDataFrame) {
        super(iPixelDataFrame);
        this.histogram = new LazyHistogramm();
    }

    @Override
    public boolean isWindowable() {
        return this.windowable;
    }

    private int[] prepareForWindowingGray(int[] nArray) {
        int n = 5;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (nArray[n2] & 0xFF) - (nArray[n2] >> 8 & 0xFF);
            int n4 = (nArray[n2] & 0xFF) - (nArray[n2] >> 16 & 0xFF);
            int n5 = (nArray[n2] >> 8 & 0xFF) - (nArray[n2] >> 16 & 0xFF);
            if (n3 <= -n || n3 >= n || n4 <= -n || n4 >= n || n5 <= -n || n5 >= n) {
                int n6 = n2;
                nArray[n6] = nArray[n6] | 0xFF000000;
            }
            ++n2;
        }
        return nArray;
    }

    @Override
    public void setWindowable(int n) {
        switch (n) {
            case 1: {
                this.setWindowable(true, false);
                break;
            }
            case 2: {
                this.setWindowable(true, true);
                break;
            }
            default: {
                this.setWindowable(false, false);
            }
        }
    }

    @Override
    public int getWindowableMode() {
        if (!this.windowable) {
            return 0;
        }
        if (this.windowableGray) {
            return 2;
        }
        return 1;
    }

    private void setWindowable(boolean bl, boolean bl2) {
        this.windowable = bl;
        this.windowableGray = bl2;
    }

    @Override
    public synchronized void extract32bitFull(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int[] nArray2, int n9) {
        if (this.windowable) {
            super.extract32bitFull(nArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, nArray2, n9);
        } else {
            super.extract32bitFull(nArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, null, n9);
        }
    }

    @Override
    public synchronized void extract8bitFull(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int n9) {
        int[] nArray = new int[byArray.length];
        this.extract32bitFull(nArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, null, 0);
        int n10 = 0;
        while (n10 < nArray.length) {
            byArray[n10] = (byte)(((nArray[n10] & 0xFF) + ((nArray[n10] & 0xFF00) >> 8) + ((nArray[n10] & 0xFF0000) >> 16)) / 3);
            ++n10;
        }
    }

    @Override
    public synchronized void extract16bitFull(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int n9) {
        int[] nArray = new int[sArray.length];
        this.extract32bitFull(nArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, null, 0);
        int n10 = 0;
        while (n10 < nArray.length) {
            sArray[n10] = (short)((nArray[n10] & 0xFF) + ((nArray[n10] & 0xFF00) >> 8) + ((nArray[n10] & 0xFF0000) >> 16));
            ++n10;
        }
    }

    @Override
    public IImageRegionProperties getImageRegionProperties(ImageRegion imageRegion, int n, int n2, IValueMapping iValueMapping, Integer n3, Integer n4) {
        return IImageRegionProperties.INVALID;
    }

    @Override
    protected void fastSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingInt(object, (int[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingInt(Object var1_1, int[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int var15_15) {
        var16_16 = this.pixelDataFrame.getWidth();
        var17_17 = (int[])var1_1;
        var22_18 = 0;
        var23_19 = 0;
        var24_20 = 0;
        var25_21 = 0;
        var26_22 = 0;
        var27_23 = 0;
        var28_24 = 0;
        var27_23 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var28_24 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var22_18 = var11_11 << 2;
        var23_19 = var12_12 << 2;
        while (var22_18 >= 1024) {
            var22_18 -= 1024;
        }
        while (var23_19 >= 1024) {
            var23_19 -= 1024;
        }
        var24_20 = var22_18;
        var25_21 = var7_7 + var8_8 * var16_16;
        var26_22 = var5_5;
        var21_25 = var25_21;
        var18_26 = 0;
        ** GOTO lbl48
        {
            var23_19 -= 1024;
            var25_21 += var16_16;
            do {
                if (var23_19 >= 512) continue block2;
                var21_25 = var25_21;
                var20_28 = var26_22;
                var23_19 += var28_24;
                var22_18 = var24_20;
                var19_27 = 0;
                while (var19_27 < var3_3) {
                    if (var22_18 >= 512) {
                        while (var22_18 >= 512) {
                            var22_18 -= 1024;
                            ++var21_25;
                        }
                    }
                    var17_17[var20_28] = var19_27 == var3_3 - 1 && var18_26 == var4_4 - 1 ? var2_2[var21_25] & 0xFFFFFF : (var18_26 == var4_4 - 1 ? (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + 1] & 0xFF00FF) >> 1 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + 1] & 65280) >> 1 & 65280 : (var19_27 == var3_3 - 1 ? (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + var16_16] & 0xFF00FF) >> 1 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + var16_16] & 65280) >> 1 & 65280 : (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + 1] & 0xFF00FF) + (var2_2[var21_25 + var16_16] & 0xFF00FF) + (var2_2[var21_25 + var16_16 + 1] & 0xFF00FF) >> 2 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + 1] & 65280) + (var2_2[var21_25 + var16_16] & 65280) + (var2_2[var21_25 + var16_16 + 1] & 65280) >> 2 & 65280));
                    var22_18 += var27_23;
                    ++var20_28;
                    ++var19_27;
                }
                var26_22 += var6_6;
                ++var18_26;
lbl48:
                // 2 sources

            } while (var18_26 < var4_4);
        }
    }

    @Override
    protected void fastSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingWithLUTInt(nArray, (int[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, nArray2, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingWithLUTInt(int[] var1_1, int[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int[] var15_15, int var16_16) {
        var2_2 = this.windowableGray != false ? this.prepareForWindowingGray(var2_2) : this.clearAlpha(var2_2);
        var17_17 = this.pixelDataFrame.getWidth();
        var22_18 = 0;
        var23_19 = 0;
        var24_20 = 0;
        var25_21 = 0;
        var26_22 = 0;
        var27_23 = 0;
        var28_24 = 0;
        var27_23 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var28_24 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var22_18 = var11_11 << 2;
        var23_19 = var12_12 << 2;
        while (var22_18 >= 1024) {
            var22_18 -= 1024;
        }
        while (var23_19 >= 1024) {
            var23_19 -= 1024;
        }
        var24_20 = var22_18;
        var25_21 = var7_7 + var8_8 * var17_17;
        var26_22 = var5_5;
        var21_25 = var25_21;
        var18_26 = 0;
        ** GOTO lbl60
        {
            var23_19 -= 1024;
            var25_21 += var17_17;
            do {
                if (var23_19 >= 512) continue block2;
                var21_25 = var25_21;
                var20_28 = var26_22;
                var23_19 += var28_24;
                var22_18 = var24_20;
                var19_27 = 0;
                while (var19_27 < var3_3) {
                    if (var22_18 >= 512) {
                        while (var22_18 >= 512) {
                            var22_18 -= 1024;
                            ++var21_25;
                        }
                    }
                    if (var19_27 == var3_3 - 1 && var18_26 == var4_4 - 1) {
                        var1_1[var20_28] = (var2_2[var21_25] & -16777216) == 0 ? var15_15[var2_2[var21_25] & 255] & -16776961 | var15_15[(var2_2[var21_25] & 65280) >> 8] & 65280 | var15_15[(var2_2[var21_25] & 0xFF0000) >> 16] & 0xFF0000 : var2_2[var21_25] & 0xFFFFFF;
                    } else if (var18_26 == var4_4 - 1) {
                        var29_29 = (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + 1] & 0xFF00FF) >> 1 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + 1] & 65280) >> 1 & 65280;
                        var1_1[var20_28] = (var2_2[var21_25] & -16777216) == 0 ? var15_15[var29_29 & 255] & -16776961 | var15_15[(var29_29 & 65280) >> 8] & 65280 | var15_15[(var29_29 & 0xFF0000) >> 16] & 0xFF0000 : var29_29;
                    } else if (var19_27 == var3_3 - 1) {
                        var29_29 = (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + var17_17] & 0xFF00FF) >> 1 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + var17_17] & 65280) >> 1 & 65280;
                        var1_1[var20_28] = (var2_2[var21_25] & -16777216) == 0 ? var15_15[var29_29 & 255] & -16776961 | var15_15[(var29_29 & 65280) >> 8] & 65280 | var15_15[(var29_29 & 0xFF0000) >> 16] & 0xFF0000 : var29_29;
                    } else {
                        var29_29 = (var2_2[var21_25] & 0xFF00FF) + (var2_2[var21_25 + 1] & 0xFF00FF) + (var2_2[var21_25 + var17_17] & 0xFF00FF) + (var2_2[var21_25 + var17_17 + 1] & 0xFF00FF) >> 2 & 0xFF00FF | (var2_2[var21_25] & 65280) + (var2_2[var21_25 + 1] & 65280) + (var2_2[var21_25 + var17_17] & 65280) + (var2_2[var21_25 + var17_17 + 1] & 65280) >> 2 & 65280;
                        var1_1[var20_28] = (var2_2[var21_25] & -16777216) == 0 ? var15_15[var29_29 & 255] & -16776961 | var15_15[(var29_29 & 65280) >> 8] & 65280 | var15_15[(var29_29 & 0xFF0000) >> 16] & 0xFF0000 : var29_29;
                    }
                    var22_18 += var27_23;
                    ++var20_28;
                    ++var19_27;
                }
                var26_22 += var6_6;
                ++var18_26;
lbl60:
                // 2 sources

            } while (var18_26 < var4_4);
        }
    }

    @Override
    protected void copyFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Throwable throwable = null;
        Object var10_11 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int n8 = this.pixelDataFrame.getWidth();
            int[] nArray2 = (int[])object;
            int n9 = n3;
            int n10 = n5 + n6 * n8;
            int n11 = 0;
            while (n11 < n2) {
                System.arraycopy(nArray, n10, nArray2, n9, n);
                n9 += n4;
                n10 += n8;
                ++n11;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void copyFullWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray2, int n7) {
        Throwable throwable = null;
        Object var11_12 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray3 = (int[])iPixelAccessor.getData();
            nArray3 = this.windowableGray ? this.prepareForWindowingGray(nArray3) : this.clearAlpha(nArray3);
            int n8 = this.pixelDataFrame.getWidth();
            int n9 = n3;
            int n10 = n5 + n6 * n8;
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n) {
                    nArray[n9 + n12] = (nArray3[n10 + n12] & 0xFF000000) == 0 ? nArray2[nArray3[n10 + n12] & 0xFF] & 0xFF0000FF | nArray2[(nArray3[n10 + n12] & 0xFF00) >> 8] & 0xFF00 | nArray2[(nArray3[n10 + n12] & 0xFF0000) >> 16] & 0xFF0000 : nArray3[n10 + n12];
                    ++n12;
                }
                n9 += n4;
                n10 += n8;
                ++n11;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int[] clearAlpha(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = nArray[n] & 0xFFFFFF;
            ++n;
        }
        return nArray;
    }

    @Override
    protected void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Throwable throwable = null;
        Object var12_13 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int n10 = this.pixelDataFrame.getWidth();
            int n11 = this.pixelDataFrame.getHighBit();
            this.enlarge(object, n, n2, n3, n4, n5, n6, n7, n8, n9, nArray, n10, n11, 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10, int n11, int n12) {
        block11: {
            int[] nArray2 = (int[])object;
            int n13 = (n7 - 256 << 8) / (n - 1);
            int n14 = (n8 - 256 << 8) / (n2 - 1);
            int n15 = n5 << 8;
            int n16 = n6 << 8;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            try {
                if (n13 < 65535 && n14 < 65535) {
                    int n20 = n10 - 1;
                    int n21 = 0;
                    while (n21 < n2) {
                        n15 = n5 << 8;
                        int n22 = (n16 >> 16) * n10 + n12;
                        int n23 = n22 + n10;
                        int n24 = n16 >> 4 & 0xFFF;
                        int n25 = 4096 - n24;
                        int n26 = n3 + n21 * n4;
                        int n27 = 1048575;
                        int n28 = 0;
                        while (n28 < n) {
                            int n29 = n15 >> 16;
                            n19 = n15 >> 4 & 0xFFF;
                            n15 += n13;
                            if (n19 <= n27) {
                                n17 = n24 == 0 ? nArray[n22 + n29] & 0xFFFFFF : (nArray[n22 + n29] & 0xFF) * n25 + (nArray[n23 + n29] & 0xFF) * n24 >> 12 | (nArray[n22 + n29] & 0xFF00) * n25 + (nArray[n23 + n29] & 0xFF00) * n24 >> 12 & 0xFF00 | ((nArray[n22 + n29] & 0xFF0000) >> 8) * n25 + ((nArray[n23 + n29] & 0xFF0000) >> 8) * n24 >> 4 & 0xFF0000;
                                n18 = n29 == n20 ? 0 : (n24 == 0 ? nArray[n22 + n29 + 1] & 0xFFFFFF : (nArray[n22 + n29 + 1] & 0xFF) * n25 + (nArray[n23 + n29 + 1] & 0xFF) * n24 >> 12 | (nArray[n22 + n29 + 1] & 0xFF00) * n25 + (nArray[n23 + n29 + 1] & 0xFF00) * n24 >> 12 & 0xFF00 | ((nArray[n22 + n29 + 1] & 0xFF0000) >> 8) * n25 + ((nArray[n23 + n29 + 1] & 0xFF0000) >> 8) * n24 >> 4 & 0xFF0000);
                            }
                            n27 = n19;
                            nArray2[n26 + n28] = (n17 & 0xFF) * (4096 - n19) + (n18 & 0xFF) * n19 >> 12 | (n17 & 0xFF00) * (4096 - n19) + (n18 & 0xFF00) * n19 >> 12 & 0xFF00 | ((n17 & 0xFF0000) >> 8) * (4096 - n19) + ((n18 & 0xFF0000) >> 8) * n19 >> 4 & 0xFF0000;
                            ++n28;
                        }
                        n16 += n14;
                        ++n21;
                    }
                    break block11;
                }
                int n30 = 0;
                n30 = 0;
                while (n30 < n2) {
                    int n31;
                    int n32;
                    n15 = n5 << 8;
                    int n33 = (n16 >> 16) * n10 + n12;
                    int n34 = n33 + n10;
                    int n35 = n16 >> 4 & 0xFFF;
                    int n36 = 4096 - n35;
                    int n37 = n3 + n30 * n4;
                    if (n35 == 0) {
                        n32 = 0;
                        while (n32 < n) {
                            n31 = n15 >> 16;
                            n19 = n15 >> 4 & 0xFFF;
                            n15 += n13;
                            n17 = nArray[n33 + n31] & 0xFFFFFF;
                            n18 = n19 == 0 ? 0 : nArray[n33 + n31 + 1] & 0xFFFFFF;
                            nArray2[n37 + n32] = (n17 & 0xFF) * (4096 - n19) + (n18 & 0xFF) * n19 >> 12 | (n17 & 0xFF00) * (4096 - n19) + (n18 & 0xFF00) * n19 >> 12 & 0xFF00 | ((n17 & 0xFF0000) >> 8) * (4096 - n19) + ((n18 & 0xFF0000) >> 8) * n19 >> 4 & 0xFF0000;
                            ++n32;
                        }
                    } else {
                        n32 = 0;
                        while (n32 < n) {
                            n31 = n15 >> 16;
                            n19 = n15 >> 4 & 0xFFF;
                            n15 += n13;
                            n17 = (nArray[n33 + n31] & 0xFF) * n36 + (nArray[n34 + n31] & 0xFF) * n35 >> 12 | (nArray[n33 + n31] & 0xFF00) * n36 + (nArray[n34 + n31] & 0xFF00) * n35 >> 12 & 0xFF00 | ((nArray[n33 + n31] & 0xFF0000) >> 8) * n36 + ((nArray[n34 + n31] & 0xFF0000) >> 8) * n35 >> 4 & 0xFF0000;
                            n18 = n19 == 0 ? 0 : (nArray[n33 + n31 + 1] & 0xFF) * n36 + (nArray[n34 + n31 + 1] & 0xFF) * n35 >> 12 | (nArray[n33 + n31 + 1] & 0xFF00) * n36 + (nArray[n34 + n31 + 1] & 0xFF00) * n35 >> 12 & 0xFF00 | ((nArray[n33 + n31 + 1] & 0xFF0000) >> 8) * n36 + ((nArray[n34 + n31 + 1] & 0xFF0000) >> 8) * n35 >> 4 & 0xFF0000;
                            nArray2[n37 + n32] = (n17 & 0xFF) * (4096 - n19) + (n18 & 0xFF) * n19 >> 12 | (n17 & 0xFF00) * (4096 - n19) + (n18 & 0xFF00) * n19 >> 12 & 0xFF00 | ((n17 & 0xFF0000) >> 8) * (4096 - n19) + ((n18 & 0xFF0000) >> 8) * n19 >> 4 & 0xFF0000;
                            ++n32;
                        }
                    }
                    n16 += n14;
                    ++n30;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                LOGGER.error("Malformed pixel data", (Throwable)arrayIndexOutOfBoundsException);
            }
        }
    }

    @Override
    protected void enlargeWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        Throwable throwable = null;
        Object var13_14 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.enlargeWithLUTInt(nArray, (int[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, nArray2, n9);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlargeWithLUTInt(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray3, int n9) {
        block11: {
            nArray2 = this.windowableGray ? this.prepareForWindowingGray(nArray2) : this.clearAlpha(nArray2);
            int n10 = this.pixelDataFrame.getWidth();
            int n11 = (n7 - 256 << 8) / (n - 1);
            int n12 = (n8 - 256 << 8) / (n2 - 1);
            int n13 = n5 << 8;
            int n14 = n6 << 8;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            try {
                if (n11 < 65535 && n12 < 65535) {
                    int n18 = n10 - 1;
                    int n19 = 0;
                    while (n19 < n2) {
                        n13 = n5 << 8;
                        int n20 = (n14 >> 16) * n10;
                        int n21 = n20 + n10;
                        int n22 = n14 >> 4 & 0xFFF;
                        int n23 = 4096 - n22;
                        int n24 = n3 + n19 * n4;
                        int n25 = 1048575;
                        int n26 = 0;
                        while (n26 < n) {
                            int n27 = n13 >> 16;
                            n17 = n13 >> 4 & 0xFFF;
                            n13 += n11;
                            if (n17 <= n25) {
                                n15 = n22 == 0 ? nArray2[n20 + n27] & 0xFFFFFF : (nArray2[n20 + n27] & 0xFF) * n23 + (nArray2[n21 + n27] & 0xFF) * n22 >> 12 | (nArray2[n20 + n27] & 0xFF00) * n23 + (nArray2[n21 + n27] & 0xFF00) * n22 >> 12 & 0xFF00 | ((nArray2[n20 + n27] & 0xFF0000) >> 8) * n23 + ((nArray2[n21 + n27] & 0xFF0000) >> 8) * n22 >> 4 & 0xFF0000;
                                n16 = n27 == n18 ? 0 : (n22 == 0 ? nArray2[n20 + n27 + 1] & 0xFFFFFF : (nArray2[n20 + n27 + 1] & 0xFF) * n23 + (nArray2[n21 + n27 + 1] & 0xFF) * n22 >> 12 | (nArray2[n20 + n27 + 1] & 0xFF00) * n23 + (nArray2[n21 + n27 + 1] & 0xFF00) * n22 >> 12 & 0xFF00 | ((nArray2[n20 + n27 + 1] & 0xFF0000) >> 8) * n23 + ((nArray2[n21 + n27 + 1] & 0xFF0000) >> 8) * n22 >> 4 & 0xFF0000);
                            }
                            n25 = n17;
                            nArray[n24 + n26] = (nArray2[n20 + n27] & 0xFF000000) == 0 ? nArray3[(n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12] & 0xFF0000FF | nArray3[(n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 20 & 0xFF] & 0xFF00 | nArray3[((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 20 & 0xFF] & 0xFF0000 : (n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12 | (n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 12 & 0xFF00 | ((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 4 & 0xFF0000;
                            ++n26;
                        }
                        n14 += n12;
                        ++n19;
                    }
                    break block11;
                }
                int n28 = 0;
                n28 = 0;
                while (n28 < n2) {
                    int n29;
                    int n30;
                    n13 = n5 << 8;
                    int n31 = (n14 >> 16) * n10;
                    int n32 = n31 + n10;
                    int n33 = n14 >> 4 & 0xFFF;
                    int n34 = 4096 - n33;
                    int n35 = n3 + n28 * n4;
                    if (n33 == 0) {
                        n30 = 0;
                        while (n30 < n) {
                            n29 = n13 >> 16;
                            n17 = n13 >> 4 & 0xFFF;
                            n13 += n11;
                            n15 = nArray2[n31 + n29] & 0xFFFFFF;
                            n16 = n17 == 0 ? 0 : nArray2[n31 + n29 + 1] & 0xFFFFFF;
                            nArray[n35 + n30] = (nArray2[n31 + n29] & 0xFF000000) == 0 ? nArray3[(n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12] & 0xFF0000FF | nArray3[(n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 20 & 0xFF] & 0xFF00 | nArray3[((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 20 & 0xFF] & 0xFF0000 : (n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12 | (n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 12 & 0xFF00 | ((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 4 & 0xFF0000;
                            ++n30;
                        }
                    } else {
                        n30 = 0;
                        while (n30 < n) {
                            n29 = n13 >> 16;
                            n17 = n13 >> 4 & 0xFFF;
                            n13 += n11;
                            n15 = (nArray2[n31 + n29] & 0xFF) * n34 + (nArray2[n32 + n29] & 0xFF) * n33 >> 12 | (nArray2[n31 + n29] & 0xFF00) * n34 + (nArray2[n32 + n29] & 0xFF00) * n33 >> 12 & 0xFF00 | ((nArray2[n31 + n29] & 0xFF0000) >> 8) * n34 + ((nArray2[n32 + n29] & 0xFF0000) >> 8) * n33 >> 4 & 0xFF0000;
                            n16 = n17 == 0 ? 0 : (nArray2[n31 + n29 + 1] & 0xFF) * n34 + (nArray2[n32 + n29 + 1] & 0xFF) * n33 >> 12 | (nArray2[n31 + n29 + 1] & 0xFF00) * n34 + (nArray2[n32 + n29 + 1] & 0xFF00) * n33 >> 12 & 0xFF00 | ((nArray2[n31 + n29 + 1] & 0xFF0000) >> 8) * n34 + ((nArray2[n32 + n29 + 1] & 0xFF0000) >> 8) * n33 >> 4 & 0xFF0000;
                            nArray[n35 + n30] = (nArray2[n31 + n29] & 0xFF000000) == 0 ? nArray3[(n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12] & 0xFF0000FF | nArray3[(n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 20 & 0xFF] & 0xFF00 | nArray3[((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 20 & 0xFF] & 0xFF0000 : (n15 & 0xFF) * (4096 - n17) + (n16 & 0xFF) * n17 >> 12 | (n15 & 0xFF00) * (4096 - n17) + (n16 & 0xFF00) * n17 >> 12 & 0xFF00 | ((n15 & 0xFF0000) >> 8) * (4096 - n17) + ((n16 & 0xFF0000) >> 8) * n17 >> 4 & 0xFF0000;
                            ++n30;
                        }
                    }
                    n14 += n12;
                    ++n28;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                LOGGER.error("Malformed pixel data", (Throwable)arrayIndexOutOfBoundsException);
            }
        }
    }

    @Override
    protected void extractBilinear(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int[] nArray2 = (int[])object;
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n14 = 0;
            if (n11 < 0) {
                n14 = -256;
            }
            int n15 = 0;
            while (n15 < n) {
                int n16 = (int)((long)(n9 + n14) + l * (long)n15 / l2);
                nArray3[n15] = n5 * (n16 >> 8);
                nArray4[n15] = n16 & 0xFF;
                ++n15;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2) {
                int n20;
                int n21;
                int n22 = (int)((long)(n10 + n17) + l3 * (long)n19 / l4);
                int n23 = n6 * (n22 >> 8);
                int n24 = n22 & 0xFF;
                if (n24 == 0) {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray3[n15] + n23;
                        n20 = nArray4[n15] == 0 ? nArray[n21] & 0xFFFFFF : (nArray[n21] & 0xFF) * (256 - nArray4[n15]) + (nArray[n21 + n5] & 0xFF) * nArray4[n15] >> 8 | ((nArray[n21] & 0xFF00) >> 8) * (256 - nArray4[n15]) + ((nArray[n21 + n5] & 0xFF00) >> 8) * nArray4[n15] >> 8 << 8 | ((nArray[n21] & 0xFF0000) >> 16) * (256 - nArray4[n15]) + ((nArray[n21 + n5] & 0xFF0000) >> 16) * nArray4[n15] >> 8 << 16;
                        nArray2[n18 + n15] = n20;
                        ++n15;
                    }
                } else {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray3[n15] + n23;
                        n20 = nArray4[n15] == 0 ? (nArray[n21] & 0xFF) * (256 - n24) + (nArray[n21 + n6] & 0xFF) * n24 >> 8 | ((nArray[n21] & 0xFF00) >> 8) * (256 - n24) + ((nArray[n21 + n6] & 0xFF00) >> 8) * n24 >> 8 << 8 | ((nArray[n21] & 0xFF0000) >> 16) * (256 - n24) + ((nArray[n21 + n6] & 0xFF0000) >> 16) * n24 >> 8 << 16 : ((nArray[n21] & 0xFF) * (256 - nArray4[n15]) + (nArray[n21 + n5] & 0xFF) * nArray4[n15]) * (256 - n24) + ((nArray[n21 + n6] & 0xFF) * (256 - nArray4[n15]) + (nArray[n21 + n5 + n6] & 0xFF) * nArray4[n15]) * n24 >> 16 | (((nArray[n21] & 0xFF00) >> 8) * (256 - nArray4[n15]) + ((nArray[n21 + n5] & 0xFF00) >> 8) * nArray4[n15]) * (256 - n24) + (((nArray[n21 + n6] & 0xFF00) >> 8) * (256 - nArray4[n15]) + ((nArray[n21 + n5 + n6] & 0xFF00) >> 8) * nArray4[n15]) * n24 >> 16 << 8 | (((nArray[n21] & 0xFF0000) >> 16) * (256 - nArray4[n15]) + ((nArray[n21 + n5] & 0xFF0000) >> 16) * nArray4[n15]) * (256 - n24) + (((nArray[n21 + n6] & 0xFF0000) >> 16) * (256 - nArray4[n15]) + ((nArray[n21 + n5 + n6] & 0xFF0000) >> 16) * nArray4[n15]) * n24 >> 16 << 16;
                        nArray2[n18 + n15] = n20;
                        ++n15;
                    }
                }
                n18 += n4;
                ++n19;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractBilinearWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray3 = (int[])iPixelAccessor.getData();
            nArray3 = this.windowableGray ? this.prepareForWindowingGray(nArray3) : this.clearAlpha(nArray3);
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n14 = 0;
            if (n11 < 0) {
                n14 = -256;
            }
            int n15 = 0;
            while (n15 < n) {
                int n16 = (int)((long)(n9 + n14) + l * (long)n15 / l2);
                nArray4[n15] = n5 * (n16 >> 8);
                nArray5[n15] = n16 & 0xFF;
                ++n15;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2) {
                int n20;
                int n21;
                int n22 = (int)((long)(n10 + n17) + l3 * (long)n19 / l4);
                int n23 = n6 * (n22 >> 8);
                int n24 = n22 & 0xFF;
                if (n24 == 0) {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray4[n15] + n23;
                        n20 = nArray5[n15] == 0 ? ((nArray3[n21] & 0xFF000000) == 0 ? nArray2[nArray3[n21] & 0xFF] & 0xFF0000FF | nArray2[(nArray3[n21] & 0xFF00) >> 8] & 0xFF00 | nArray2[(nArray3[n21] & 0xFF0000) >> 16] & 0xFF0000 : nArray3[n21] & 0xFFFFFF) : ((nArray3[n21] & 0xFF000000) == 0 ? nArray2[(nArray3[n21] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5] & 0xFF) * nArray5[n15] >> 8] & 0xFF0000FF | nArray2[((nArray3[n21] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF00) >> 8) * nArray5[n15] >> 8] & 0xFF00 | nArray2[((nArray3[n21] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF0000) >> 16) * nArray5[n15] >> 8] & 0xFF0000 : (nArray3[n21] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5] & 0xFF) * nArray5[n15] >> 8 | ((nArray3[n21] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF00) >> 8) * nArray5[n15] >> 8 << 8 | ((nArray3[n21] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF0000) >> 16) * nArray5[n15] >> 8 << 16);
                        nArray[n18 + n15] = n20;
                        ++n15;
                    }
                } else {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray4[n15] + n23;
                        n20 = nArray5[n15] == 0 ? ((nArray3[n21] & 0xFF000000) == 0 ? nArray2[(nArray3[n21] & 0xFF) * (256 - n24) + (nArray3[n21 + n6] & 0xFF) * n24 >> 8] & 0xFF0000FF | nArray2[((nArray3[n21] & 0xFF00) >> 8) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF00) >> 8) * n24 >> 8] & 0xFF00 | nArray2[((nArray3[n21] & 0xFF0000) >> 16) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF0000) >> 16) * n24 >> 8] & 0xFF0000 : (nArray3[n21] & 0xFF) * (256 - n24) + (nArray3[n21 + n6] & 0xFF) * n24 >> 8 | ((nArray3[n21] & 0xFF00) >> 8) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF00) >> 8) * n24 >> 8 << 8 | ((nArray3[n21] & 0xFF0000) >> 16) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF0000) >> 16) * n24 >> 8 << 16) : ((nArray3[n21] & 0xFF000000) == 0 ? nArray2[((nArray3[n21] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5] & 0xFF) * nArray5[n15]) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5 + n6] & 0xFF) * nArray5[n15]) * n24 >> 16] & 0xFF0000FF | nArray2[(((nArray3[n21] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF00) >> 8) * nArray5[n15]) * (256 - n24) + (((nArray3[n21 + n6] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5 + n6] & 0xFF00) >> 8) * nArray5[n15]) * n24 >> 16] & 0xFF00 | nArray2[(((nArray3[n21] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF0000) >> 16) * nArray5[n15]) * (256 - n24) + (((nArray3[n21 + n6] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5 + n6] & 0xFF0000) >> 16) * nArray5[n15]) * n24 >> 16] & 0xFF0000 : ((nArray3[n21] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5] & 0xFF) * nArray5[n15]) * (256 - n24) + ((nArray3[n21 + n6] & 0xFF) * (256 - nArray5[n15]) + (nArray3[n21 + n5 + n6] & 0xFF) * nArray5[n15]) * n24 >> 16 | (((nArray3[n21] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF00) >> 8) * nArray5[n15]) * (256 - n24) + (((nArray3[n21 + n6] & 0xFF00) >> 8) * (256 - nArray5[n15]) + ((nArray3[n21 + n5 + n6] & 0xFF00) >> 8) * nArray5[n15]) * n24 >> 16 << 8 | (((nArray3[n21] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5] & 0xFF0000) >> 16) * nArray5[n15]) * (256 - n24) + (((nArray3[n21 + n6] & 0xFF0000) >> 16) * (256 - nArray5[n15]) + ((nArray3[n21 + n5 + n6] & 0xFF0000) >> 16) * nArray5[n15]) * n24 >> 16 << 16);
                        nArray[n18 + n15] = n20;
                        ++n15;
                    }
                }
                n18 += n4;
                ++n19;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighbor(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        Throwable throwable = null;
        Object var14_15 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int[] nArray2 = (int[])object;
            int[] nArray3 = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n12 = 0;
            while (n12 < n) {
                nArray3[n12] = (int)((long)n5 * ((long)n7 + (long)n9 * ((long)n12 + l) / (long)n >> 8));
                ++n12;
            }
            int n13 = 0;
            int n14 = n2;
            if (n10 < 0) {
                ++n13;
                ++n14;
            }
            int n15 = n3;
            long l2 = n13;
            while (l2 < (long)n14) {
                int n16 = (int)((long)n6 * ((long)n8 + (long)n10 * l2 / (long)n2 >> 8));
                n12 = 0;
                while (n12 < n) {
                    nArray2[n15 + n12] = nArray[nArray3[n12] + n16];
                    ++n12;
                }
                n15 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighborWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray2, int n11) {
        Throwable throwable = null;
        Object var15_16 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray3 = (int[])iPixelAccessor.getData();
            nArray3 = this.windowableGray ? this.prepareForWindowingGray(nArray3) : this.clearAlpha(nArray3);
            int[] nArray4 = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n12 = 0;
            while (n12 < n) {
                nArray4[n12] = (int)((long)n5 * ((long)n7 + (long)n9 * ((long)n12 + l) / (long)n >> 8));
                ++n12;
            }
            int n13 = 0;
            int n14 = n2;
            if (n10 < 0) {
                ++n13;
                ++n14;
            }
            int n15 = n3;
            long l2 = n13;
            while (l2 < (long)n14) {
                int n16 = (int)((long)n6 * ((long)n8 + (long)n10 * l2 / (long)n2 >> 8));
                n12 = 0;
                while (n12 < n) {
                    nArray[n15 + n12] = (nArray3[nArray4[n12] + n16] & 0xFF000000) == 0 ? nArray2[nArray3[nArray4[n12] + n16] & 0xFF] & 0xFF0000FF | nArray2[(nArray3[nArray4[n12] + n16] & 0xFF00) >> 8] & 0xFF00 | nArray2[(nArray3[nArray4[n12] + n16] & 0xFF0000) >> 16] & 0xFF0000 : nArray3[nArray4[n12] + n16];
                    ++n12;
                }
                n15 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int[] nArray2 = (int[])object;
            int[] nArray3 = new int[n + 1];
            int[] nArray4 = new int[n + 1];
            long l = 0L;
            if (n11 < 0) {
                l = -256L;
            }
            nArray3[0] = (int)((long)n5 * ((long)n9 + l >> 8));
            int n14 = 1;
            while (n14 <= n) {
                nArray3[n14] = (int)((long)n5 * ((long)n9 + l + (long)n11 * (long)n14 / (long)n >> 8));
                nArray4[n14] = (nArray3[n14] - nArray3[n14 - 1]) / n5;
                ++n14;
            }
            int n15 = 0;
            if (n12 < 0) {
                n15 = -256;
            }
            int n16 = n6 * (n10 + n15 >> 8);
            int n17 = n5 * n7;
            int n18 = n6 * n8;
            int n19 = n7 * n8;
            int n20 = n3 - 1;
            long l2 = 1L;
            while (l2 <= (long)n2) {
                int n21 = (int)((long)n6 * ((long)(n10 + n15) + (long)n12 * l2 / (long)n2 >> 8));
                int n22 = (n21 - n16) / n6 * n19;
                n14 = 1;
                while (n14 <= n) {
                    int n23 = nArray4[n14] * n22;
                    if (n23 <= 1) {
                        nArray2[n20 + n14] = nArray[nArray3[n14 - 1] + n16];
                    } else {
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = n16;
                        while (n27 != n21) {
                            int n28 = nArray3[n14 - 1];
                            while (n28 != nArray3[n14]) {
                                n24 += (nArray[n28 + n27] & 0xFF0000) >> 16;
                                n25 += (nArray[n28 + n27] & 0xFF00) >> 8;
                                n26 += nArray[n28 + n27] & 0xFF;
                                n28 += n17;
                            }
                            n27 += n18;
                        }
                        nArray2[n20 + n14] = n26 / n23 | n24 / n23 << 16 | n25 / n23 << 8;
                    }
                    ++n14;
                }
                n16 = n21;
                n20 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray3 = (int[])iPixelAccessor.getData();
            nArray3 = this.windowableGray ? this.prepareForWindowingGray(nArray3) : this.clearAlpha(nArray3);
            int[] nArray4 = new int[n + 1];
            int[] nArray5 = new int[n + 1];
            long l = 0L;
            if (n11 < 0) {
                l = -256L;
            }
            nArray4[0] = (int)((long)n5 * ((long)n9 + l >> 8));
            int n14 = 1;
            while (n14 <= n) {
                nArray4[n14] = (int)((long)n5 * ((long)n9 + l + (long)n11 * (long)n14 / (long)n >> 8));
                nArray5[n14] = (nArray4[n14] - nArray4[n14 - 1]) / n5;
                ++n14;
            }
            int n15 = 0;
            if (n12 < 0) {
                n15 = -256;
            }
            int n16 = n6 * (n10 + n15 >> 8);
            int n17 = n5 * n7;
            int n18 = n6 * n8;
            int n19 = n7 * n8;
            int n20 = n3 - 1;
            long l2 = 1L;
            while (l2 <= (long)n2) {
                int n21 = (int)((long)n6 * ((long)n10 + (long)n12 * l2 / (long)n2 >> 8));
                int n22 = (n21 - n16) / n6 * n19;
                n14 = 1;
                while (n14 <= n) {
                    int n23 = nArray5[n14] * n22;
                    if (n23 <= 1) {
                        int n24 = nArray3[nArray4[n14 - 1] + n16];
                        nArray[n20 + n14] = (n24 & 0xFF000000) == 0 ? nArray2[n24 & 0xFF] & 0xFF | nArray2[(n24 & 0xFF0000) >> 16] << 16 & 0xFF0000 | nArray2[(n24 & 0xFF00) >> 8] << 8 & 0xFF00 : n24;
                    } else {
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        int n28 = n16;
                        while (n28 != n21) {
                            int n29 = nArray4[n14 - 1];
                            while (n29 != nArray4[n14]) {
                                n26 += (nArray3[n29 + n28] & 0xFF0000) >> 16;
                                n27 += (nArray3[n29 + n28] & 0xFF00) >> 8;
                                n25 += nArray3[n29 + n28] & 0xFF;
                                n29 += n17;
                            }
                            n28 += n18;
                        }
                        nArray[n20 + n14] = (nArray3[nArray4[n14 - 1] + n16] & 0xFF000000) == 0 ? nArray2[n25 / n23] & 0xFF | nArray2[n26 / n23] << 16 & 0xFF0000 | nArray2[n27 / n23] << 8 & 0xFF00 : n25 / n23 | n26 / n23 << 16 | n27 / n23 << 8;
                    }
                    ++n14;
                }
                n16 = n21;
                n20 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void storeToDicom(Attributes attributes) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            int[] nArray = (int[])iPixelAccessor.getData();
            int n = nArray.length;
            attributes.setInt(0x280002, VR.US, new int[]{3});
            attributes.setString(2621444, VR.CS, "RGB");
            attributes.setInt(2621446, VR.US, new int[]{0});
            attributes.setInt(2621456, VR.US, new int[]{this.getRows()});
            attributes.setInt(2621457, VR.US, new int[]{this.getColumns()});
            attributes.setInt(2621696, VR.US, new int[]{8});
            attributes.setInt(2621697, VR.US, new int[]{8});
            attributes.setInt(2621698, VR.US, new int[]{7});
            attributes.setInt(2621699, VR.US, new int[]{0});
            byte[] byArray = DataCacheProviderFactory.getMemoryPool().allocBytes(3L * (long)n);
            int n2 = 0;
            int n3 = 0;
            while (n3 < nArray.length) {
                byArray[n2++] = (byte)(nArray[n3] >> 16 & 0xFF);
                byArray[n2++] = (byte)(nArray[n3] >> 8 & 0xFF);
                byArray[n2++] = (byte)(nArray[n3] & 0xFF);
                ++n3;
            }
            attributes.setBytes(2145386512, VR.OB, byArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class LazyHistogramm
    extends ResetableLazyInitializer<Histogram> {
        private LazyHistogramm() {
        }

        @Override
        protected Histogram initialize() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IPixelAccessor<?> iPixelAccessor = RawDataContainer3x8.this.getAccessor();){
                return new Histogram((int[])iPixelAccessor.getData(), 0, RawDataContainer3x8.this.pixelDataFrame.getNumPixels(), 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

