/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.AbstractRawDataContainer;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImagePointProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.ImageRegionProperties;
import com.tiani.base.data.ResetableLazyInitializer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class RawDataContainer8CT
extends AbstractRawDataContainer {
    public RawDataContainer8CT(IPixelDataFrame<?> iPixelDataFrame) {
        super(iPixelDataFrame);
        this.histogram = new LazyHistogram();
    }

    @Override
    public synchronized void extract16bitFull(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Matrix2d matrix2d, int n9) {
        byte[] byArray = new byte[sArray.length];
        this.extract8bitFull(byArray, n, n2, n3, n4, n5, n6, n7, n8, matrix2d, n9);
        int n10 = n3;
        while (n10 < n3 + n * n2) {
            sArray[n10] = (short)(byArray[n10] & 0xFF);
            ++n10;
        }
    }

    @Override
    public IImageRegionProperties getImageRegionProperties(ImageRegion imageRegion, int n, int n2, IValueMapping iValueMapping, Integer n3, Integer n4) {
        IImageRegionProperties iImageRegionProperties = null;
        Throwable throwable = null;
        Object var9_10 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int n5 = this.pixelDataFrame.getWidth();
            int n6 = this.pixelDataFrame.getHeight();
            int n7 = this.pixelDataFrame.getHighBit();
            if (imageRegion.clip == null) {
                if (imageRegion.x >= 0 && imageRegion.x < n5 && imageRegion.y >= 0 && imageRegion.y < n6) {
                    int n8 = this.pixelDataFrame.isSigned() ? byArray[imageRegion.x + imageRegion.y * n5] : byArray[imageRegion.x + imageRegion.y * n5] & 0xFF;
                    iImageRegionProperties = new ImagePointProperties(n8, iValueMapping);
                } else {
                    iImageRegionProperties = IImageRegionProperties.INVALID;
                }
            } else {
                Histogram histogram = new Histogram(byArray, 2 << n7, n5, n6, imageRegion.clip, iValueMapping, n3, n4, this.pixelDataFrame.isSigned() ? 1 << n7 : 0);
                iImageRegionProperties = new ImageRegionProperties(histogram);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return iImageRegionProperties;
    }

    @Override
    protected void fastSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingInt(object, (byte[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingInt(Object var1_1, byte[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int var15_15) {
        var16_16 = this.pixelDataFrame.getWidth();
        var17_17 = (byte[])var1_1;
        var22_18 = 0;
        var23_19 = 0;
        var24_20 = 0;
        var25_21 = 0;
        var26_22 = 0;
        var27_23 = 0;
        var28_24 = 0;
        var27_23 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var28_24 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var22_18 = var11_11 << 2;
        var23_19 = var12_12 << 2;
        while (var22_18 >= 1024) {
            var22_18 -= 1024;
        }
        while (var23_19 >= 1024) {
            var23_19 -= 1024;
        }
        var24_20 = var22_18;
        var25_21 = var7_7 + var8_8 * var16_16;
        var26_22 = var5_5;
        var21_25 = var25_21;
        var18_26 = 0;
        ** GOTO lbl48
        {
            var23_19 -= 1024;
            var25_21 += var16_16;
            do {
                if (var23_19 >= 512) continue block2;
                var21_25 = var25_21;
                var20_28 = var26_22;
                var23_19 += var28_24;
                var22_18 = var24_20;
                var19_27 = 0;
                while (var19_27 < var3_3) {
                    if (var22_18 >= 512) {
                        while (var22_18 >= 512) {
                            var22_18 -= 1024;
                            ++var21_25;
                        }
                    }
                    var17_17[var20_28] = var19_27 == var3_3 - 1 && var18_26 == var4_4 - 1 ? (byte)(var15_15 + var2_2[var21_25] & 255) : (var18_26 == var4_4 - 1 ? (byte)((var15_15 + var2_2[var21_25] & 255) + (var15_15 + var2_2[var21_25 + 1] & 255) >> 1) : (var19_27 == var3_3 - 1 ? (byte)((var15_15 + var2_2[var21_25] & 255) + (var15_15 + var2_2[var21_25 + var16_16] & 255) >> 1) : (byte)((var15_15 + var2_2[var21_25] & 255) + (var15_15 + var2_2[var21_25 + 1] & 255) + (var15_15 + var2_2[var21_25 + var16_16] & 255) + (var15_15 + var2_2[var21_25 + var16_16 + 1] & 255) >> 2)));
                    var22_18 += var27_23;
                    ++var20_28;
                    ++var19_27;
                }
                var26_22 += var6_6;
                ++var18_26;
lbl48:
                // 2 sources

            } while (var18_26 < var4_4);
        }
    }

    @Override
    protected void fastSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.fastSubsamplingWithLUTInt(nArray, (byte[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, nArray2, n13);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fastSubsamplingWithLUTInt(int[] var1_1, byte[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14, int[] var15_15, int var16_16) {
        var17_17 = this.pixelDataFrame.getWidth();
        var18_18 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var19_19 = (var14_14 - 256 << 2) / (var4_4 - 1);
        var20_20 = var11_11 << 2;
        var21_21 = var12_12 << 2;
        while (var20_20 >= 1024) {
            var20_20 -= 1024;
        }
        while (var21_21 >= 1024) {
            var21_21 -= 1024;
        }
        var22_22 = var20_20;
        var23_23 = var7_7 + var8_8 * var17_17;
        var24_24 = var5_5;
        var25_25 = 0;
        ** GOTO lbl39
        {
            var21_21 -= 1024;
            var23_23 += var17_17;
            do {
                if (var21_21 >= 512) continue block2;
                var26_26 = var23_23;
                var27_27 = var24_24;
                var21_21 += var19_19;
                var20_20 = var22_22;
                var28_28 = 0;
                while (var28_28 < var3_3) {
                    if (var20_20 >= 512) {
                        while (var20_20 >= 512) {
                            var20_20 -= 1024;
                            ++var26_26;
                        }
                    }
                    var1_1[var27_27] = var28_28 == var3_3 - 1 && var25_25 == var4_4 - 1 ? var15_15[var16_16 + var2_2[var26_26] & 255] : (var25_25 == var4_4 - 1 ? var15_15[(var16_16 + var2_2[var26_26] & 255) + (var16_16 + var2_2[var26_26 + 1] & 255) >> 1] : (var28_28 == var3_3 - 1 ? var15_15[(var16_16 + var2_2[var26_26] & 255) + (var16_16 + var2_2[var26_26 + var17_17] & 255) >> 1] : var15_15[(var16_16 + var2_2[var26_26] & 255) + (var16_16 + var2_2[var26_26 + 1] & 255) + (var16_16 + var2_2[var26_26 + var17_17] & 255) + (var16_16 + var2_2[var26_26 + var17_17 + 1] & 255) >> 2]));
                    var20_20 += var18_18;
                    ++var27_27;
                    ++var28_28;
                }
                var24_24 += var6_6;
                ++var25_25;
lbl39:
                // 2 sources

            } while (var25_25 < var4_4);
        }
    }

    @Override
    protected void copyFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Throwable throwable = null;
        Object var10_11 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int n8 = this.pixelDataFrame.getWidth();
            byte[] byArray2 = (byte[])object;
            int n9 = n3;
            int n10 = n5 + n6 * n8;
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n) {
                    byArray2[n9 + n12] = (byte)(n7 + byArray[n10 + n12]);
                    ++n12;
                }
                n9 += n4;
                n10 += n8;
                ++n11;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void copyFullWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray2, int n7) {
        Throwable throwable = null;
        Object var11_12 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int n8 = this.pixelDataFrame.getWidth();
            int n9 = n3;
            int n10 = n5 + n6 * n8;
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n) {
                    nArray[n9 + n12] = nArray2[n7 + byArray[n10 + n12] & 0xFF];
                    ++n12;
                }
                n9 += n4;
                n10 += n8;
                ++n11;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Throwable throwable = null;
        Object var12_13 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.enlargeInt(object, (byte[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlargeInt(Object object, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        byte[] byArray2 = (byte[])object;
        int n11 = (n7 - 256 << 8) / (n - 1);
        int n12 = (n8 - 256 << 8) / (n2 - 1);
        int n13 = 0;
        int n14 = 0;
        if (n11 < 65535 && n12 < 65535) {
            int n15 = n10 - 1;
            int n16 = n6 << 8;
            int n17 = 0;
            while (n17 < n2) {
                int n18 = n5 << 8;
                int n19 = (n16 >> 16) * n10;
                int n20 = n19 + n10;
                int n21 = n16 >> 4 & 0xFFF;
                int n22 = 4096 - n21;
                int n23 = n3 + n17 * n4;
                int n24 = 1048575;
                int n25 = 0;
                while (n25 < n) {
                    int n26 = n18 >> 16;
                    int n27 = n18 >> 4 & 0xFFF;
                    n18 += n11;
                    if (n27 <= n24) {
                        n13 = n21 == 0 ? n9 + byArray[n19 + n26] & 0xFF : (n9 + byArray[n19 + n26] & 0xFF) * n22 + (n9 + byArray[n20 + n26] & 0xFF) * n21 >> 12;
                        n14 = n26 == n15 ? 0 : (n21 == 0 ? n9 + byArray[n19 + n26 + 1] & 0xFF : (n9 + byArray[n19 + n26 + 1] & 0xFF) * n22 + (n9 + byArray[n20 + n26 + 1] & 0xFF) * n21 >> 12);
                    }
                    n24 = n27;
                    byArray2[n23 + n25] = (byte)(n13 * (4096 - n27) + n14 * n27 >> 12);
                    ++n25;
                }
                n16 += n12;
                ++n17;
            }
        } else {
            int n28 = n6 << 8;
            int n29 = 0;
            while (n29 < n2) {
                int n30;
                int n31;
                int n32;
                int n33 = n5 << 8;
                int n34 = (n28 >> 16) * n10;
                int n35 = n34 + n10;
                int n36 = n28 >> 4 & 0xFFF;
                int n37 = 4096 - n36;
                int n38 = n3 + n29 * n4;
                if (n36 == 0) {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = n9 + byArray[n34 + n31] & 0xFF;
                        n14 = n30 == 0 ? 0 : n9 + byArray[n34 + n31 + 1] & 0xFF;
                        byArray2[n38 + n32] = (byte)(n13 * (4096 - n30) + n14 * n30 >> 12);
                        ++n32;
                    }
                } else {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = (n9 + byArray[n34 + n31] & 0xFF) * n37 + (n9 + byArray[n35 + n31] & 0xFF) * n36 >> 12;
                        n14 = n30 == 0 ? 0 : (n9 + byArray[n34 + n31 + 1] & 0xFF) * n37 + (n9 + byArray[n35 + n31 + 1] & 0xFF) * n36 >> 12;
                        byArray2[n38 + n32] = (byte)(n13 * (4096 - n30) + n14 * n30 >> 12);
                        ++n32;
                    }
                }
                n28 += n12;
                ++n29;
            }
        }
    }

    @Override
    protected void enlargeWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        Throwable throwable = null;
        Object var13_14 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            this.enlargeWithLUTInt(nArray, (byte[])iPixelAccessor.getData(), n, n2, n3, n4, n5, n6, n7, n8, nArray2, n9);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void enlargeWithLUTInt(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int n9) {
        int n10 = this.pixelDataFrame.getWidth();
        int n11 = (n7 - 256 << 8) / (n - 1);
        int n12 = (n8 - 256 << 8) / (n2 - 1);
        int n13 = 0;
        int n14 = 0;
        if (n11 < 65535 && n12 < 65535) {
            int n15 = n10 - 1;
            int n16 = n6 << 8;
            int n17 = 0;
            while (n17 < n2) {
                int n18 = n5 << 8;
                int n19 = (n16 >> 16) * n10;
                int n20 = n19 + n10;
                int n21 = n16 >> 4 & 0xFFF;
                int n22 = 4096 - n21;
                int n23 = n3 + n17 * n4;
                int n24 = 1048575;
                int n25 = 0;
                while (n25 < n) {
                    int n26 = n18 >> 16;
                    int n27 = n18 >> 4 & 0xFFF;
                    n18 += n11;
                    if (n27 <= n24) {
                        n13 = n21 == 0 ? n9 + byArray[n19 + n26] & 0xFF : (n9 + byArray[n19 + n26] & 0xFF) * n22 + (n9 + byArray[n20 + n26] & 0xFF) * n21 >> 12;
                        n14 = n26 == n15 ? 0 : (n21 == 0 ? n9 + byArray[n19 + n26 + 1] & 0xFF : (n9 + byArray[n19 + n26 + 1] & 0xFF) * n22 + (n9 + byArray[n20 + n26 + 1] & 0xFF) * n21 >> 12);
                    }
                    n24 = n27;
                    nArray[n23 + n25] = nArray2[n13 * (4096 - n27) + n14 * n27 >> 12];
                    ++n25;
                }
                n16 += n12;
                ++n17;
            }
        } else {
            int n28 = n6 << 8;
            int n29 = 0;
            while (n29 < n2) {
                int n30;
                int n31;
                int n32;
                int n33 = n5 << 8;
                int n34 = (n28 >> 16) * n10;
                int n35 = n34 + n10;
                int n36 = n28 >> 4 & 0xFFF;
                int n37 = 4096 - n36;
                int n38 = n3 + n29 * n4;
                if (n36 == 0) {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = n9 + byArray[n34 + n31] & 0xFF;
                        n14 = n30 == 0 ? 0 : n9 + byArray[n34 + n31 + 1] & 0xFF;
                        nArray[n38 + n32] = nArray2[n13 * (4096 - n30) + n14 * n30 >> 12];
                        ++n32;
                    }
                } else {
                    n32 = 0;
                    while (n32 < n) {
                        n31 = n33 >> 16;
                        n30 = n33 >> 4 & 0xFFF;
                        n33 += n11;
                        n13 = (n9 + byArray[n34 + n31] & 0xFF) * n37 + (n9 + byArray[n35 + n31] & 0xFF) * n36 >> 12;
                        n14 = n30 == 0 ? 0 : (n9 + byArray[n34 + n31 + 1] & 0xFF) * n37 + (n9 + byArray[n35 + n31 + 1] & 0xFF) * n36 >> 12;
                        nArray[n38 + n32] = nArray2[n13 * (4096 - n30) + n14 * n30 >> 12];
                        ++n32;
                    }
                }
                n28 += n12;
                ++n29;
            }
        }
    }

    @Override
    protected void extractBilinear(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            byte[] byArray2 = (byte[])object;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n14 = 0;
            if (n11 < 0) {
                n14 = -256;
            }
            int n15 = 0;
            while (n15 < n) {
                int n16 = (int)((long)(n9 + n14) + l * (long)n15 / l2);
                nArray[n15] = n5 * (n16 >> 8);
                nArray2[n15] = n16 & 0xFF;
                ++n15;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2) {
                byte by;
                int n20;
                int n21 = (int)((long)(n10 + n17) + l3 * (long)n19 / l4);
                int n22 = n6 * (n21 >> 8);
                int n23 = n21 & 0xFF;
                if (n23 == 0) {
                    n15 = 0;
                    while (n15 < n) {
                        n20 = nArray[n15] + n22;
                        by = nArray2[n15] == 0 ? (byte)(n13 + byArray[n20] & 0xFF) : (byte)((n13 + byArray[n20] & 0xFF) * (256 - nArray2[n15]) + (n13 + byArray[n20 + n5] & 0xFF) * nArray2[n15] >> 8);
                        byArray2[n18 + n15] = by;
                        ++n15;
                    }
                } else {
                    n15 = 0;
                    while (n15 < n) {
                        n20 = nArray[n15] + n22;
                        by = nArray2[n15] == 0 ? (byte)((n13 + byArray[n20] & 0xFF) * (256 - n23) + (n13 + byArray[n20 + n6] & 0xFF) * n23 >> 8) : (byte)(((n13 + byArray[n20] & 0xFF) * (256 - nArray2[n15]) + (n13 + byArray[n20 + n5] & 0xFF) * nArray2[n15]) * (256 - n23) + ((n13 + byArray[n20 + n6] & 0xFF) * (256 - nArray2[n15]) + (n13 + byArray[n20 + n5 + n6] & 0xFF) * nArray2[n15]) * n23 >> 16);
                        byArray2[n18 + n15] = by;
                        ++n15;
                    }
                }
                n18 += n4;
                ++n19;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractBilinearWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long l = (long)n11 - (long)n7 * 256L;
            long l2 = (long)n - 1L;
            int n14 = 0;
            if (n11 < 0) {
                n14 = -256;
            }
            int n15 = 0;
            while (n15 < n) {
                int n16 = (int)((long)(n9 + n14) + l * (long)n15 / l2);
                nArray3[n15] = n5 * (n16 >> 8);
                nArray4[n15] = n16 & 0xFF;
                ++n15;
            }
            long l3 = (long)n12 - (long)n8 * 256L;
            long l4 = (long)n2 - 1L;
            int n17 = 0;
            if (n12 < 0) {
                n17 = -256;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2) {
                int n20;
                int n21;
                int n22 = (int)((long)(n10 + n17) + l3 * (long)n19 / l4);
                int n23 = n6 * (n22 >> 8);
                int n24 = n22 & 0xFF;
                if (n24 == 0) {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray3[n15] + n23;
                        n20 = nArray4[n15] == 0 ? n13 + byArray[n21] & 0xFF : (n13 + byArray[n21] & 0xFF) * (256 - nArray4[n15]) + (n13 + byArray[n21 + n5] & 0xFF) * nArray4[n15] >> 8;
                        nArray[n18 + n15] = nArray2[n20];
                        ++n15;
                    }
                } else {
                    n15 = 0;
                    while (n15 < n) {
                        n21 = nArray3[n15] + n23;
                        n20 = nArray4[n15] == 0 ? (n13 + byArray[n21] & 0xFF) * (256 - n24) + (n13 + byArray[n21 + n6] & 0xFF) * n24 >> 8 : ((n13 + byArray[n21] & 0xFF) * (256 - nArray4[n15]) + (n13 + byArray[n21 + n5] & 0xFF) * nArray4[n15]) * (256 - n24) + ((n13 + byArray[n21 + n6] & 0xFF) * (256 - nArray4[n15]) + (n13 + byArray[n21 + n5 + n6] & 0xFF) * nArray4[n15]) * n24 >> 16;
                        nArray[n18 + n15] = nArray2[n20];
                        ++n15;
                    }
                }
                n18 += n4;
                ++n19;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighbor(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        Throwable throwable = null;
        Object var14_15 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            byte[] byArray2 = (byte[])object;
            int[] nArray = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n12 = 0;
            while (n12 < n) {
                nArray[n12] = (int)((long)n5 * ((long)n8 + (long)n9 * ((long)n12 + l) / (long)n >> 8));
                ++n12;
            }
            int n13 = 0;
            int n14 = n2;
            if (n10 < 0) {
                ++n13;
                ++n14;
            }
            int n15 = n3;
            long l2 = n13;
            while (l2 < (long)n14) {
                int n16 = (int)((long)n6 * ((long)n7 + (long)n10 * l2 / (long)n2 >> 8));
                n12 = 0;
                while (n12 < n) {
                    byArray2[n15 + n12] = (byte)(n11 + byArray[nArray[n12] + n16]);
                    ++n12;
                }
                n15 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractNearestNeighborWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray2, int n11) {
        Throwable throwable = null;
        Object var15_16 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int[] nArray3 = new int[n];
            long l = 0L;
            if (n9 < 0) {
                l = 1L;
            }
            int n12 = 0;
            while (n12 < n) {
                nArray3[n12] = (int)((long)n5 * ((long)n7 + (long)n9 * ((long)n12 + l) / (long)n >> 8));
                ++n12;
            }
            int n13 = 0;
            int n14 = n2;
            if (n10 < 0) {
                ++n13;
                ++n14;
            }
            int n15 = n3;
            long l2 = n13;
            while (l2 < (long)n14) {
                int n16 = (int)((long)n6 * ((long)n8 + (long)n10 * l2 / (long)n2 >> 8));
                n12 = 0;
                while (n12 < n) {
                    nArray[n15 + n12] = nArray2[n11 + byArray[nArray3[n12] + n16] & 0xFF];
                    ++n12;
                }
                n15 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsampling(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        Throwable throwable = null;
        Object var16_17 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            byte[] byArray2 = (byte[])object;
            int[] nArray = new int[n + 1];
            int[] nArray2 = new int[n + 1];
            long l = 0L;
            if (n11 < 0) {
                l = -256L;
            }
            nArray[0] = (int)((long)n5 * ((long)n9 + l >> 8));
            int n14 = 1;
            while (n14 <= n) {
                nArray[n14] = (int)((long)n5 * ((long)n9 + l + (long)n11 * (long)n14 / (long)n >> 8));
                nArray2[n14] = (nArray[n14] - nArray[n14 - 1]) / n5;
                ++n14;
            }
            int n15 = 0;
            if (n12 < 0) {
                n15 = -256;
            }
            int n16 = n6 * (n10 + n15 >> 8);
            int n17 = n5 * n7;
            int n18 = n6 * n8;
            int n19 = n7 * n8;
            int n20 = n3 - 1;
            long l2 = 1L;
            while (l2 <= (long)n2) {
                int n21 = (int)((long)n6 * ((long)(n10 + n15) + (long)n12 * l2 / (long)n2 >> 8));
                int n22 = (n21 - n16) / n6 * n19;
                n14 = 1;
                while (n14 <= n) {
                    int n23 = nArray2[n14] * n22;
                    if (n23 <= 1) {
                        byArray2[n20 + n14] = (byte)(n13 + byArray[nArray[n14 - 1] + n16]);
                    } else {
                        int n24 = 0;
                        int n25 = n16;
                        while (n25 != n21) {
                            int n26 = nArray[n14 - 1];
                            while (n26 != nArray[n14]) {
                                n24 += n13 + byArray[n26 + n25] & 0xFF;
                                n26 += n17;
                            }
                            n25 += n18;
                        }
                        byArray2[n20 + n14] = (byte)(n24 / n23);
                    }
                    ++n14;
                }
                n16 = n21;
                n20 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractSummedSubsamplingWithLUT(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray2, int n13) {
        Throwable throwable = null;
        Object var17_18 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            int[] nArray3 = new int[n + 1];
            int[] nArray4 = new int[n + 1];
            long l = 0L;
            if (n11 < 0) {
                l = -256L;
            }
            nArray3[0] = (int)((long)n5 * ((long)n9 + l >> 8));
            int n14 = 1;
            while (n14 <= n) {
                nArray3[n14] = (int)((long)n5 * ((long)n9 + l + (long)n11 * (long)n14 / (long)n >> 8));
                nArray4[n14] = (nArray3[n14] - nArray3[n14 - 1]) / n5;
                ++n14;
            }
            int n15 = 0;
            if (n12 < 0) {
                n15 = -256;
            }
            int n16 = n6 * (n10 + n15 >> 8);
            int n17 = n5 * n7;
            int n18 = n6 * n8;
            int n19 = n7 * n8;
            int n20 = n3 - 1;
            long l2 = 1L;
            while (l2 <= (long)n2) {
                int n21 = (int)((long)n6 * ((long)n10 + (long)n12 * l2 / (long)n2 >> 8));
                int n22 = (n21 - n16) / n6 * n19;
                n14 = 1;
                while (n14 <= n) {
                    int n23 = nArray4[n14] * n22;
                    if (n23 <= 1) {
                        nArray[n20 + n14] = nArray2[n13 + byArray[nArray3[n14 - 1] + n16] & 0xFF];
                    } else {
                        int n24 = 0;
                        int n25 = n16;
                        while (n25 != n21) {
                            int n26 = nArray3[n14 - 1];
                            while (n26 != nArray3[n14]) {
                                n24 += n13 + byArray[n26 + n25] & 0xFF;
                                n26 += n17;
                            }
                            n25 += n18;
                        }
                        nArray[n20 + n14] = nArray2[n24 / n23];
                    }
                    ++n14;
                }
                n16 = n21;
                n20 += n4;
                ++l2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void storeToDicom(Attributes attributes) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IPixelAccessor<?> iPixelAccessor = this.getAccessor();){
            byte[] byArray = (byte[])iPixelAccessor.getData();
            byte[] byArray2 = DataCacheProviderFactory.getMemoryPool().allocBytes((long)byArray.length);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            attributes.setInt(2621456, VR.US, new int[]{this.getRows()});
            attributes.setInt(2621457, VR.US, new int[]{this.getColumns()});
            attributes.setBytes(2145386512, VR.OB, byArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class LazyHistogram
    extends ResetableLazyInitializer<Histogram> {
        private LazyHistogram() {
        }

        @Override
        protected Histogram initialize() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IPixelAccessor<?> iPixelAccessor = RawDataContainer8CT.this.getAccessor();){
                byte[] byArray = (byte[])iPixelAccessor.getData();
                int n = RawDataContainer8CT.this.pixelDataFrame.getHighBit();
                return new Histogram(byArray, RawDataContainer8CT.this.pixelDataFrame.getNumPixels(), 2 << n, RawDataContainer8CT.this.pixelDataFrame.isSigned() ? 1 << n : 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

