/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.listtext.dicomobject.renderer.DicomObjectRendererUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.BufferedImageTokenData;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.data.Attributes;

public class RawDataContainerTokenData
implements TokenData {
    private static final ALogger log = ALogger.getLogger(RawDataContainerTokenData.class);
    private List<TokenListener> tokenListener;
    private int width;
    private int height;
    private BufferedImage icon;
    private RawDataContainer rawDataContainer;
    private TokenData oldToken;
    private boolean makeNew;
    private IFrameObjectData frameObject;
    private boolean isFinalToken = false;

    public RawDataContainerTokenData(IFrameObjectData iFrameObjectData, RawDataContainer rawDataContainer, TokenData tokenData) {
        this.rawDataContainer = rawDataContainer;
        this.width = 64;
        this.height = 64;
        this.tokenListener = new LinkedList<TokenListener>();
        this.icon = null;
        this.oldToken = tokenData;
        this.makeNew = true;
        this.frameObject = iFrameObjectData;
    }

    @Override
    public void addTokenListener(TokenListener tokenListener) {
        this.tokenListener.add(tokenListener);
    }

    public void setRawDataContainer(RawDataContainer rawDataContainer) {
        if (this.rawDataContainer == rawDataContainer) {
            return;
        }
        this.rawDataContainer = rawDataContainer;
        if (this.icon != null) {
            this.oldToken = new BufferedImageTokenData(this.icon);
            this.makeNew = true;
        }
    }

    private void tokenChanged() {
        ArrayList<TokenListener> arrayList = new ArrayList<TokenListener>(this.tokenListener);
        for (TokenListener tokenListener : arrayList) {
            tokenListener.tokenChanged(this);
        }
    }

    @Override
    public int getWidth() {
        if (this.oldToken != null) {
            return this.oldToken.getWidth();
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.oldToken != null) {
            return this.oldToken.getHeight();
        }
        return this.height;
    }

    @Override
    public boolean hasToken() {
        return this.icon != null;
    }

    @Override
    public void paintToken(Graphics graphics, int n, int n2, int n3, int n4, TokenListener tokenListener) {
        if (this.hasToken()) {
            graphics.drawImage(this.icon, n, n2, n3, n4, null);
        } else if (this.oldToken != null) {
            this.oldToken.paintToken(graphics, n, n2, n3, n4, tokenListener);
        } else if (tokenListener != null) {
            this.addTokenListener(tokenListener);
            this.ensureToken();
        }
    }

    @Override
    public BufferedImage getImage(TokenListener tokenListener) {
        if (this.oldToken != null) {
            return this.oldToken.getImage(tokenListener);
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        try {
            this.paintToken(bufferedImage.getGraphics(), 0, 0, this.width, this.height, tokenListener);
        }
        catch (Exception exception) {
            log.warn("Could not draw token", (Throwable)exception);
        }
        return bufferedImage;
    }

    @Override
    public BufferedImage getFinalImage() {
        if (!this.hasToken()) {
            return this.recreateImage();
        }
        return this.getImage(null);
    }

    public BufferedImage recreateImage() {
        this.oldToken = null;
        this.icon = null;
        WaitingAdapter waitingAdapter = new WaitingAdapter();
        this.getImage(waitingAdapter);
        waitingAdapter.waitForImage();
        return this.getImage(null);
    }

    private void ensureToken() {
        if (!this.makeNew) {
            return;
        }
        if (this.rawDataContainer == null) {
            return;
        }
        this.icon = new BufferedImage(this.width, this.height, 1);
        RawDataContainerTokenCreator.getInstance().addTokenData(this);
    }

    protected synchronized void createIcon() {
        this.icon = DicomObjectRendererUtils.toBufferedImage((Attributes)this.frameObject.getDicomObject(), null, (boolean)true, this.rawDataContainer.getPixelDataFrame(), (int)this.frameObject.getFrameNumber(), (Object)this.frameObject, (int)this.width, (int)this.height, (int)1);
        this.isFinalToken = true;
        this.tokenChanged();
        this.oldToken = null;
        this.makeNew = false;
    }

    @Override
    public synchronized boolean isFinalToken() {
        if (this.oldToken != null && this.oldToken.isFinalToken()) {
            return true;
        }
        return this.isFinalToken;
    }

    public synchronized void setData(IFrameObjectData iFrameObjectData, RawDataContainer rawDataContainer) {
        this.frameObject = iFrameObjectData;
        this.rawDataContainer = rawDataContainer;
    }

    @Override
    public void cleanup() {
        if (this.oldToken != null) {
            this.oldToken.cleanup();
        }
        this.tokenListener.clear();
        this.icon = null;
    }

    private static class WaitingAdapter
    implements TokenListener {
        private CountDownLatch latch = new CountDownLatch(1);

        private WaitingAdapter() {
        }

        @Override
        public void tokenChanged(TokenData tokenData) {
            this.latch.countDown();
        }

        public void waitForImage() {
            try {
                this.latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

