/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageObjectData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SliceDistanceCalculator {
    private static final ALogger LOGGER = ALogger.getLogger(SliceDistanceCalculator.class);
    private static final double MINIMUM_SLICE_DISTANCE = 0.01;
    public static final double VOLUME_ORIENTATION_DIFFERENCE = 2.0E-6;

    public static double[] getSliceDistances(IFrameObjectData[] iFrameObjectDataArray, List<IFrameObjectData> list) throws SortingException {
        try {
            return SliceDistanceCalculator.getSliceDistancesImpl(iFrameObjectDataArray, list);
        }
        catch (SortingException sortingException) {
            throw sortingException;
        }
        catch (Exception exception) {
            throw new SortingException(exception);
        }
    }

    private static double[] getSliceDistancesImpl(IFrameObjectData[] vector3d, List<IFrameObjectData> list) throws SortingException {
        Object object;
        IImageInformation iImageInformation;
        IImageInformation iImageInformation2;
        double d;
        Vector3d vector3d2;
        IImageInformation iImageInformation3;
        Object object2;
        if (vector3d[0].getImageInformation().getImageClass() == IImageInformation.ImageClass.NM) {
            return SliceDistanceCalculator.handleNMMultiFrame((IFrameObjectData[])vector3d, list);
        }
        SliceDistanceCalculator.checkEnhancedCTMR((IFrameObjectData[])vector3d);
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(((IFrameObjectData[])vector3d).length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(((IFrameObjectData[])vector3d).length);
        boolean bl = ((IFrameObjectData[])vector3d).length > 1;
        Vector3d vector3d3 = vector3d[((IFrameObjectData[])vector3d).length / 2].getImageInformation().getPlaneNormalUV();
        Vector3d vector3d4 = vector3d;
        int n = ((IFrameObjectData[])vector3d4).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = vector3d4[n2];
            iImageInformation3 = object2.getImageInformation();
            if (bl && iImageInformation3.isLocalizer()) {
                LOGGER.info("Skipping scout image: {}", (Object)iImageInformation3.getSOPInstanceUID());
            } else {
                vector3d2 = iImageInformation3.getPlaneNormalUV();
                if (vector3d2 != null && !SliceDistanceCalculator.almostEqual((Tuple3d)vector3d3, (Tuple3d)vector3d2)) {
                    LOGGER.info("Skipping slice with different orientation: {}", (Object)iImageInformation3.getSOPInstanceUID());
                } else {
                    if (iImageInformation3.getImagePosition() != null) {
                        arrayList.add((IFrameObjectData)object2);
                    }
                    if (iImageInformation3.getSliceLocation() != null) {
                        arrayList2.add(object2);
                    }
                }
            }
            ++n2;
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            throw new SortingException("All image frames are localizers");
        }
        if (arrayList2.size() > arrayList.size()) {
            throw new SortingException("Sorting slices by slice location not supported");
        }
        LOGGER.info("Sorting slices by image position...");
        if (arrayList.size() <= 2) {
            return null;
        }
        object2 = new ImgPositionComparator(SliceDistanceCalculator.findExtremalImageOrigin(arrayList));
        Collections.sort(arrayList, object2);
        IImageInformation iImageInformation4 = ((IFrameObjectData)arrayList.get(0)).getImageInformation();
        IImageInformation iImageInformation5 = ((IFrameObjectData)arrayList.get(2)).getImageInformation();
        vector3d4 = iImageInformation4.getVectorU();
        iImageInformation3 = iImageInformation4.getVectorV();
        vector3d2 = iImageInformation5.getVectorOrigin();
        vector3d2.sub((Tuple3d)iImageInformation4.getVectorOrigin());
        if (vector3d4.length() != 0.0 && iImageInformation3.length() != 0.0 && vector3d2.length() != 0.0) {
            vector3d4.normalize();
            iImageInformation3.normalize();
            vector3d2.normalize();
            Vector3d vector3d5 = new Vector3d();
            vector3d5.cross(vector3d4, (Vector3d)iImageInformation3);
            d = vector3d5.dot(vector3d2);
            if (d < 0.0) {
                LOGGER.warn("FLIP ORDER");
                ((ImgPositionComparator)object2).invertOrdering();
                Collections.sort(arrayList, object2);
            }
        }
        int n3 = 0;
        d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        while (n4 < arrayList.size() - 1) {
            iImageInformation2 = ((IFrameObjectData)arrayList.get(n4)).getImageInformation();
            iImageInformation = ((IFrameObjectData)arrayList.get(n4 + 1)).getImageInformation();
            Vector3d vector3d6 = iImageInformation2.getVectorOrigin();
            object = iImageInformation.getVectorOrigin();
            object.sub((Tuple3d)vector3d6);
            double d6 = object.length();
            if (n4 == 0) {
                d3 = d6;
            } else if (n4 == arrayList.size() - 2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (d6 < 0.01 || d != 0.0 && d6 < 0.1 * d && d6 < 0.1 * d2) {
                arrayList.remove(n4 + 1);
                --n4;
                ++n3;
                LOGGER.warn("(almost) duplicate slice!");
            } else {
                d2 = d;
                d = d6;
            }
            ++n4;
        }
        if ((double)n3 > 0.2 * (double)arrayList.size() && n3 > 10) {
            throw new SortingException("Multiple duplicate slices, possible mixed-up series.");
        }
        if (d4 > 3.0 * d5) {
            LOGGER.warn("slice sequence ends with outlier, removed");
            arrayList.remove(arrayList.size() - 1);
        }
        if (d3 > 3.0 * d5) {
            LOGGER.warn("slice sequence starts with outlier, removed");
            arrayList.remove(0);
        }
        list.addAll(arrayList);
        double[] dArray = new double[list.size()];
        iImageInformation2 = list.get(0).getImageInformation().getPointOrigin();
        dArray[0] = 0.0;
        iImageInformation = new Vector3d();
        int n5 = 1;
        while (n5 < list.size()) {
            object = list.get(n5).getImageInformation();
            iImageInformation.sub((Tuple3d)iImageInformation2, (Tuple3d)object.getPointOrigin());
            dArray[n5] = iImageInformation.length();
            ++n5;
        }
        return dArray;
    }

    public static boolean almostEqual(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return Math.abs(tuple3d.x - tuple3d2.x) <= 2.0E-6 && Math.abs(tuple3d.y - tuple3d2.y) <= 2.0E-6 && Math.abs(tuple3d.z - tuple3d2.z) <= 2.0E-6;
    }

    private static Point3d findExtremalImageOrigin(List<IFrameObjectData> list) {
        Point3d point3d = null;
        double d = -1.0;
        for (IFrameObjectData iFrameObjectData : list) {
            Point3d point3d2 = iFrameObjectData.getImageInformation().getPointOrigin();
            double d2 = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
            if (!(d2 > d)) continue;
            d = d2;
            point3d = point3d2;
        }
        return point3d;
    }

    private static double[] handleNMMultiFrame(IFrameObjectData[] iFrameObjectDataArray, List<IFrameObjectData> list) {
        Object object;
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iFrameObjectDataArray2[n2];
            hashSet.add(object.getMainFrame());
            ++n2;
        }
        if (hashSet.size() != 1) {
            LOGGER.error("Images without position can be only NM Multiframes");
            return null;
        }
        object = new HashSet();
        object.add(ImageType.RECON_TOMO);
        object.add(ImageType.RECON_GATED_TOMO);
        object.add(ImageType.RECON_TOMO_GATED);
        IImageObjectData iImageObjectData = (IImageObjectData)hashSet.iterator().next();
        object.retainAll(iImageObjectData.getImageInformation().getImageType());
        if (object.isEmpty()) {
            LOGGER.error("Only RECON TOMO, RECON GATED TOMO, and RECON TOMO GATED are supported");
            return null;
        }
        list.addAll(Arrays.asList(iFrameObjectDataArray));
        Collections.sort(list, new FrameSorter());
        double d = iFrameObjectDataArray[0].getImageInformation().getDataset().getDouble(0x180088, 0.0);
        if (d == 0.0) {
            LOGGER.error("Missing spacing between slices in NM");
            return null;
        }
        if (d < 0.0) {
            Collections.reverse(list);
            d = -d;
        }
        double[] dArray = new double[iFrameObjectDataArray.length];
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = d2;
            d2 += d;
            ++n3;
        }
        return dArray;
    }

    private static void checkEnhancedCTMR(IFrameObjectData[] iFrameObjectDataArray) {
        if (iFrameObjectDataArray[0].getMainFrame().getFrameCount() > 1) {
            HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
            IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iDataObject = iFrameObjectDataArray2[n2];
                hashSet.add(iDataObject.getMainFrame());
                ++n2;
            }
            hashSet.removeIf(iImageObjectData -> iImageObjectData.isHeaderInitialised());
            if (!hashSet.isEmpty()) {
                LOGGER.info("Waiting for enhanced CT/MR instances");
                for (IImageObjectData iImageObjectData2 : hashSet) {
                    DataManager.getInstance().getFetcher().changeToHigherPriority(iImageObjectData2, (byte)0);
                }
                do {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    hashSet.removeIf(iImageObjectData -> iImageObjectData.isHeaderInitialised());
                } while (hashSet.size() > 0);
                LOGGER.info("Waiting finished");
            }
        }
    }

    private static class FrameSorter
    implements Comparator<IFrameObjectData> {
        private FrameSorter() {
        }

        @Override
        public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
            return Integer.compare(iFrameObjectData.getFrameNumber(), iFrameObjectData2.getFrameNumber());
        }
    }

    private static class ImgPositionComparator
    implements Comparator<IFrameObjectData> {
        private int inv;
        private Point3d refPoint;

        ImgPositionComparator(Point3d point3d) {
            this.refPoint = point3d;
            this.inv = 1;
        }

        @Override
        public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
            Vector3d vector3d = new Vector3d();
            vector3d.sub((Tuple3d)this.refPoint, (Tuple3d)iFrameObjectData.getImageInformation().getPointOrigin());
            double d = vector3d.lengthSquared();
            vector3d.sub((Tuple3d)this.refPoint, (Tuple3d)iFrameObjectData2.getImageInformation().getPointOrigin());
            double d2 = vector3d.lengthSquared();
            return Double.compare(d, d2) * this.inv;
        }

        void invertOrdering() {
            this.inv = -this.inv;
        }
    }

    public static class SortingException
    extends Exception {
        private SortingException(String string) {
            super(string);
        }

        private SortingException(Throwable throwable) {
            super(throwable);
        }
    }
}

