/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageRegionSpacing;
import com.tiani.jvision.overlay.PointSequence;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

class UltrasoundRegionSpacing
implements IImageRegionSpacing {
    private static final double EPSILON = 1.0E-5;
    private static final ALogger log = ALogger.getLogger(UltrasoundRegionSpacing.class);
    private final Rectangle bounds;
    private final Unit unit;
    private final double pixelSizeX;
    private final double pixelSizeY;

    private UltrasoundRegionSpacing(Attributes attributes) throws IllegalArgumentException {
        int n = attributes.getInt(1597464, 0);
        int n2 = attributes.getInt(1597466, 0);
        int n3 = attributes.getInt(1597468, 0);
        int n4 = attributes.getInt(1597470, 0);
        this.bounds = new Rectangle(n, n2, n3 - n, n4 - n2);
        int n5 = attributes.getInt(1597476, 0);
        if (n5 != attributes.getInt(1597478, 0)) {
            throw new IllegalArgumentException("Physical units in X and Y direction do not match.");
        }
        this.unit = Unit.getUnitByCode(n5);
        if (this.unit == null) {
            throw new IllegalArgumentException("Unsupported physical unit: " + n5);
        }
        this.pixelSizeX = this.unit.conversionFactor * attributes.getDouble(1597484, 0.0);
        this.pixelSizeY = this.unit.conversionFactor * attributes.getDouble(1597486, 0.0);
    }

    static List<UltrasoundRegionSpacing> create(Attributes attributes) {
        if (attributes == null || !attributes.contains(1597457)) {
            return null;
        }
        Sequence sequence = attributes.getSequence(1597457);
        if (sequence == null) {
            return null;
        }
        int n = sequence.size();
        ArrayList<UltrasoundRegionSpacing> arrayList = new ArrayList<UltrasoundRegionSpacing>(n);
        ArrayList<UltrasoundRegionSpacing> arrayList2 = new ArrayList<UltrasoundRegionSpacing>(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                UltrasoundRegionSpacing.addUltrasoundRegion(arrayList, arrayList2, (Attributes)sequence.get(n2));
            }
            catch (Exception exception) {
                log.warn("Parsing US region failed.", (Throwable)exception);
            }
            ++n2;
        }
        ArrayList<UltrasoundRegionSpacing> arrayList3 = new ArrayList<UltrasoundRegionSpacing>(n);
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        if (arrayList3.isEmpty()) {
            arrayList3 = null;
        }
        return arrayList3;
    }

    private static void addUltrasoundRegion(List<UltrasoundRegionSpacing> list, List<UltrasoundRegionSpacing> list2, Attributes attributes) {
        if (attributes.getInt(1597476, 0) == Unit.LENGTH.code) {
            UltrasoundRegionSpacing ultrasoundRegionSpacing = new UltrasoundRegionSpacing(attributes);
            if (ultrasoundRegionSpacing.isValid()) {
                boolean bl;
                boolean bl2 = bl = (attributes.getInt(1597462, 0) & 1) == 0;
                if (bl) {
                    list.add(ultrasoundRegionSpacing);
                } else {
                    list2.add(ultrasoundRegionSpacing);
                }
            } else {
                log.debug("Skipping invalid US region: " + ultrasoundRegionSpacing);
            }
        }
    }

    @Override
    public double getDataPixelSizeX() {
        return this.pixelSizeX;
    }

    @Override
    public double getDataPixelSizeY() {
        return this.pixelSizeY;
    }

    @Override
    public String getUnit() {
        return this.unit.stringRepresentation;
    }

    boolean isInBounds(PointSequence pointSequence) {
        double[] dArray = pointSequence.getXCoordinates();
        double[] dArray2 = pointSequence.getYCoordinates();
        int n = 0;
        while (n < pointSequence.getPointCount()) {
            if (!this.isInBounds(dArray[n], dArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean isInBounds(double d, double d2) {
        return this.bounds.contains(d, d2);
    }

    private boolean isValid() {
        return UltrasoundRegionSpacing.isValid(this.pixelSizeX) && UltrasoundRegionSpacing.isValid(this.pixelSizeY);
    }

    private static boolean isValid(double d) {
        return !Double.isNaN(d) && !UltrasoundRegionSpacing.isAlmostZero(d);
    }

    private static boolean isAlmostZero(double d) {
        return -1.0E-5 < d && d < 1.0E-5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.pixelSizeX);
        stringBuilder.append(" x ");
        stringBuilder.append(this.pixelSizeY);
        stringBuilder.append(' ');
        stringBuilder.append(this.getUnit());
        stringBuilder.append(" for ");
        stringBuilder.append(this.bounds);
        return stringBuilder.toString();
    }

    private static enum Unit {
        NONE(0, ""),
        PERCENTAGE(1, "%"),
        DECIBEL(2, "dB"),
        LENGTH(3, "mm", 10.0),
        DURATION(4, "s"),
        FREQUENCY(5, "Hz"),
        DECIBEL_PER_SECOND(6, "dB/s"),
        VELOCITY(7, "mm/s", 10.0),
        AREA(8, "mm2", 100.0),
        ACCELERATION(9, "mm2/s", 100.0),
        VOLUME(10, "mm3", 1000.0),
        FLOW(11, "mm3/s", 1000.0),
        DEGREE(12, "\u00b0");

        final int code;
        final String stringRepresentation;
        final double conversionFactor;

        private Unit(int n2, String string2) {
            this(n2, string2, 1.0);
        }

        private Unit(int n2, String string2, double d) {
            this.code = n2;
            this.stringRepresentation = string2;
            this.conversionFactor = d;
        }

        static Unit getUnitByCode(int n) {
            Unit[] unitArray = Unit.values();
            int n2 = unitArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Unit unit = unitArray[n3];
                if (unit.code == n) {
                    return unit;
                }
                ++n3;
            }
            return null;
        }
    }
}

