/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.config.MonitorQueryInterfaceFactory;
import com.tiani.gui.util.GraphicsDeviceInfo;
import java.awt.Dialog;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LayoutConfig {
    private static final ALogger log = ALogger.getLogger(LayoutConfig.class);
    private static final String LAST_USED_MONITOR_SUBSET = "impaxee.local.MONITORS.lastUsedMonitorSubset";
    private static final double ROUNDING_FACTOR = 3000.0;
    private static LayoutConfig instance;
    private GraphicsDeviceInfo gdi;
    private volatile boolean automaticDetectionPerformed;
    private volatile boolean shouldPerformAutoDetection;
    private int screenCount;
    private int screenColumns;
    private int screenRows;
    private int screenWidth;
    private int screenHeight;
    private int imageAreaWidth;
    private int imageAreaHeight;
    private int imageAreaX;
    private int imageAreaY;
    private int firstMonitorNumber;
    private boolean allowMultiMonitor;

    public static synchronized LayoutConfig getInstance() {
        if (instance == null) {
            boolean bl = LicenseManager.getInstance().getLicense("MULTI_MONITOR") != null || Product.isInEmergencyMode();
            instance = new LayoutConfig(Product.isHeadless(), bl);
        }
        if (!LayoutConfig.instance.automaticDetectionPerformed && LayoutConfig.instance.shouldPerformAutoDetection) {
            instance.performAutomaticDetection(LayoutConfig.instance.gdi.screens);
            instance.afterInit();
        }
        return instance;
    }

    LayoutConfig(boolean bl, boolean bl2) {
        this.allowMultiMonitor = bl2;
        if (bl) {
            this.shouldPerformAutoDetection = false;
            return;
        }
        this.gdi = new GraphicsDeviceInfo();
        if (this.gdi != null && Config.impaxee.workstation.MONITORS.UseDynamicMonitorDetection.get()) {
            try {
                this.performAutomaticDetection(this.gdi.screens);
            }
            catch (Exception exception) {
                return;
            }
        } else {
            this.shouldPerformAutoDetection = false;
            this.imageAreaWidth = (int)Config.impaxee.workstation.MONITORS.ScreenSizeX.get();
            this.imageAreaHeight = (int)Config.impaxee.workstation.MONITORS.ScreenSizeY.get();
            this.imageAreaX = (int)Config.impaxee.workstation.MONITORS.ScreenOffsetX.get();
            this.imageAreaY = (int)Config.impaxee.workstation.MONITORS.ScreenOffsetY.get();
            this.screenRows = (int)Config.impaxee.workstation.MONITORS.NumberOfRows.get();
            this.screenCount = (int)Config.impaxee.local.MONITORS.NumberOfMonitorsInUse.get();
            this.checkCurrentConfiguration();
        }
        this.afterInit();
    }

    private void afterInit() {
        if (!this.automaticDetectionPerformed && this.shouldPerformAutoDetection) {
            return;
        }
        int n = 0;
        while (n < this.gdi.screens.length) {
            if (this.gdi.screens[n].bounds.contains(this.imageAreaX, this.imageAreaY)) {
                this.firstMonitorNumber = n + 1;
                break;
            }
            ++n;
        }
        this.screenCount = Math.max(1, this.screenCount);
        this.screenColumns = this.screenCount > this.screenRows ? this.screenCount / this.screenRows : this.screenCount;
        this.screenWidth = Math.round((float)this.imageAreaWidth / (float)this.screenColumns);
        this.screenHeight = Math.round((float)this.imageAreaHeight / (float)this.screenRows);
    }

    void performAutomaticDetection(GraphicsDeviceInfo.RasterScreen[] rasterScreenArray) {
        Object object;
        Object object2;
        this.shouldPerformAutoDetection = true;
        int n = 1;
        int n2 = rasterScreenArray.length - 1;
        Object[] objectArray = this.countMonitorSizes(rasterScreenArray);
        log.info("Found " + objectArray.length + " different monitor sizes");
        boolean bl = this.detectReverseSetup((MonitorSelection[])objectArray);
        if (bl) {
            ArrayUtils.reverse((Object[])objectArray);
        }
        if (rasterScreenArray.length <= 2 && objectArray.length == 1) {
            n = 0;
        }
        if (bl && (rasterScreenArray.length > 2 || objectArray.length > 1)) {
            n = 0;
            n2 = rasterScreenArray.length - 2;
        }
        boolean bl2 = false;
        if (objectArray.length == 2) {
            bl2 = Boolean.parseBoolean(System.getProperty("monitor.selection.force", Boolean.FALSE.toString()));
        }
        if (objectArray.length == 3 && !Product.isCDViewer() || bl2) {
            String string;
            int n3;
            Object[] objectArray2;
            Object object3;
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            object2 = MonitorQueryInterfaceFactory.getInterface();
            object = null;
            Object object4 = null;
            Object object5 = null;
            Object object6 = objectArray;
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                object3 = object6[n5];
                object = object2.getMonitorManufacturer(((MonitorSelection)object3).id);
                if (object != null) {
                    ((MonitorSelection)object3).setName(MessageFormat.format("{0}x {1} ({2}MP)", ((MonitorSelection)object3).getScreenCount(), object, Math.round((double)((MonitorSelection)object3).area / 1048576.0)));
                }
                ++n5;
            }
            object3 = ConfigurationProviderFactory.getConfig();
            if (object3.exists(LAST_USED_MONITOR_SUBSET)) {
                String string2 = object3.getString(LAST_USED_MONITOR_SUBSET);
                objectArray2 = objectArray;
                n3 = objectArray.length;
                int n6 = 0;
                while (n6 < n3) {
                    Object object7 = objectArray2[n6];
                    if (((MonitorSelection)object7).toString().equalsIgnoreCase(string2)) {
                        object5 = object7;
                    }
                    ++n6;
                }
            }
            if ((string = System.getProperty("monitor.selection", "").trim()).length() > 0) {
                objectArray2 = objectArray;
                n3 = objectArray.length;
                int n7 = 0;
                while (n7 < n3) {
                    Object object8 = objectArray2[n7];
                    if (StringUtils.containsIgnoreCase((CharSequence)((MonitorSelection)object8).toString(), (CharSequence)string)) {
                        object4 = object8;
                    }
                    ++n7;
                }
            }
            if (object4 == null) {
                JOptionPane jOptionPane = new JOptionPane(Messages.getString("LayoutConfig.ChooseMonitorConfiguration"), 3, -1, null, objectArray, object5);
                object6 = jOptionPane.createDialog(null, Messages.getString("LayoutConfig.ChooseMonitorConfigurationTitle"));
                ((Window)object6).setAlwaysOnTop(true);
                ((Dialog)object6).setVisible(true);
                object4 = (MonitorSelection)jOptionPane.getValue();
            }
            if (object4 != null) {
                n = ((MonitorSelection)object4).startScreen;
                n2 = ((MonitorSelection)object4).getLastScreen();
                log.info("Selection setup with " + ((MonitorSelection)object4).toString());
                object3.setString(LAST_USED_MONITOR_SUBSET, ((MonitorSelection)object4).toString());
            }
            object5 = null;
        } else if (objectArray.length == 2 && ((MonitorSelection)objectArray[0]).getScreenCount() == 2 && ((MonitorSelection)objectArray[1]).getScreenCount() == 2) {
            object2 = objectArray[1];
            n = ((MonitorSelection)object2).startScreen;
            n2 = ((MonitorSelection)object2).getLastScreen();
            log.info("Detected 2+2 setup, choosing 2 larger monitors");
        }
        if (!this.allowsMultiMonitor()) {
            n2 = n;
        }
        object2 = rasterScreenArray[n].bounds;
        object = rasterScreenArray[n2].bounds;
        this.imageAreaWidth = ((Rectangle)object).x + ((Rectangle)object).width - ((Rectangle)object2).x;
        this.imageAreaHeight = Integer.MAX_VALUE;
        int n8 = n;
        while (n8 <= n2) {
            if (this.imageAreaHeight > rasterScreenArray[n8].bounds.height) {
                this.imageAreaHeight = rasterScreenArray[n8].bounds.height;
            }
            ++n8;
        }
        this.imageAreaX = ((Rectangle)object2).x;
        this.imageAreaY = ((Rectangle)object2).y;
        this.screenCount = n2 - n + 1;
        this.screenRows = 1;
        this.automaticDetectionPerformed = true;
    }

    private boolean detectReverseSetup(MonitorSelection[] monitorSelectionArray) {
        if (monitorSelectionArray.length == 1) {
            return false;
        }
        MonitorSelection monitorSelection = monitorSelectionArray[0];
        MonitorSelection monitorSelection2 = monitorSelectionArray[monitorSelectionArray.length - 1];
        if (monitorSelection.getScreenCount() > 1 && monitorSelection2.getScreenCount() == 1) {
            return true;
        }
        if (monitorSelection2.getScreenCount() > 1 && monitorSelection.getScreenCount() == 1) {
            return false;
        }
        if (monitorSelection.is3To4Monitor() && !monitorSelection2.is3To4Monitor()) {
            return true;
        }
        if (monitorSelection2.is3To4Monitor() && !monitorSelection.is3To4Monitor()) {
            return false;
        }
        return monitorSelection.getArea() > monitorSelection2.getArea();
    }

    private long getArea(GraphicsDeviceInfo.RasterScreen rasterScreen) {
        Rectangle rectangle = rasterScreen.bounds;
        return (long)rectangle.height * (long)rectangle.width;
    }

    private MonitorSelection[] countMonitorSizes(GraphicsDeviceInfo.RasterScreen[] rasterScreenArray) {
        LinkedList<MonitorSelection> linkedList = new LinkedList<MonitorSelection>();
        MonitorSelection monitorSelection = null;
        int n = 0;
        GraphicsDeviceInfo.RasterScreen[] rasterScreenArray2 = rasterScreenArray;
        int n2 = rasterScreenArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GraphicsDeviceInfo.RasterScreen rasterScreen = rasterScreenArray2[n3];
            long l = this.getArea(rasterScreen);
            if (monitorSelection != null && monitorSelection.sameSize(l)) {
                monitorSelection.includeScreen(n);
            } else {
                monitorSelection = new MonitorSelection(n, rasterScreen.bounds, l, rasterScreen.monitorId);
                linkedList.add(monitorSelection);
            }
            ++n;
            ++n3;
        }
        return linkedList.toArray(new MonitorSelection[linkedList.size()]);
    }

    private void checkCurrentConfiguration() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        GraphicsDeviceInfo.RasterScreen[] rasterScreenArray = this.gdi.screens;
        int n5 = this.gdi.screens.length;
        int n6 = 0;
        while (n6 < n5) {
            GraphicsDeviceInfo.RasterScreen rasterScreen = rasterScreenArray[n6];
            Rectangle rectangle = rasterScreen.bounds;
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            if (rectangle.x + rectangle.width > n3) {
                n3 = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > n4) {
                n4 = rectangle.y + rectangle.height;
            }
            ++n6;
        }
        if (this.screenCount > 1 && !this.allowsMultiMonitor()) {
            log.warn("License does not allow Multi-Monitor support");
            this.performAutomaticDetection(this.gdi.screens);
            return;
        }
        if (this.imageAreaX < n || this.imageAreaX + this.imageAreaWidth > n3 || this.imageAreaY < n2 || this.imageAreaY + this.imageAreaHeight > n4) {
            log.warn("The configured screens cannot be displayed falling back to automatic detection.");
            this.performAutomaticDetection(this.gdi.screens);
            return;
        }
    }

    private boolean allowsMultiMonitor() {
        return this.allowMultiMonitor;
    }

    public int monitorColumnForAbsoluteMouseX(int n) {
        int n2 = n - this.imageAreaX;
        return n2 / this.screenWidth;
    }

    public Point getBestJVisionMonitorCenter(Point point) {
        int n = this.monitorColumnForAbsoluteMouseX(point.x);
        n = Math.max(n, 0);
        n = Math.min(n, this.screenColumns - 1);
        int n2 = this.imageAreaX + n * this.screenWidth + this.screenWidth / 2;
        int n3 = this.imageAreaY + this.screenHeight / 2;
        return new Point(n2, n3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LayoutConfig: ");
        stringBuilder.append("usedMonitorsCount=" + this.screenCount + ", ");
        stringBuilder.append("monitorColumns=" + this.screenColumns + ", ");
        stringBuilder.append("monitorRows=" + this.screenRows + ", ");
        stringBuilder.append("monitorWidth=" + this.screenWidth + ", ");
        stringBuilder.append("monitorHeight=" + this.screenHeight + ", ");
        stringBuilder.append("imageAreaWidth=" + this.imageAreaWidth + ", ");
        stringBuilder.append("imageAreaHeight=" + this.imageAreaHeight + ", ");
        stringBuilder.append("imageAreaX=" + this.imageAreaX + ", ");
        stringBuilder.append("imageAreaY=" + this.imageAreaY);
        return stringBuilder.toString();
    }

    public int getImageAreaWidth() {
        return this.imageAreaWidth;
    }

    public GraphicsDeviceInfo.RasterScreen[] getScreens() {
        return this.gdi.screens;
    }

    public int getImageAreaHeight() {
        return this.imageAreaHeight;
    }

    public int getImageAreaX() {
        return this.imageAreaX;
    }

    public int getImageAreaY() {
        return this.imageAreaY;
    }

    public GraphicsConfiguration getImageAreaGraphicsConfiguration() {
        return this.gdi.screens[this.firstMonitorNumber - 1].gc;
    }

    public int getScreenCount() {
        return this.screenCount;
    }

    public int getFirstMonitorNumber() {
        return this.firstMonitorNumber;
    }

    public int getScreenRows() {
        return this.screenRows;
    }

    public int getScreenColumns() {
        return this.screenColumns;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    private static class MonitorSelection {
        public final int startScreen;
        private int lastScreen;
        private Rectangle bounds;
        private String name = null;
        private long area;
        private String id;

        private MonitorSelection(int n, Rectangle rectangle, long l, String string) {
            this.startScreen = n;
            this.lastScreen = n;
            this.area = l;
            this.id = string;
            this.bounds = rectangle;
        }

        public int getLastScreen() {
            return this.lastScreen;
        }

        public boolean sameSize(long l) {
            return Math.round((double)this.area / 3000.0) == Math.round((double)l / 3000.0);
        }

        public long getArea() {
            return this.area;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getScreenCount() {
            return this.lastScreen - this.startScreen + 1;
        }

        public void includeScreen(int n) {
            this.lastScreen = n;
        }

        public boolean is3To4Monitor() {
            double d = (double)this.bounds.width / (double)this.bounds.height;
            return DoubleEquals.equals((double)d, (double)1.3333333333333333) || DoubleEquals.equals((double)d, (double)0.75);
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return "Monitors " + this.bounds.width + "x" + this.bounds.height;
        }
    }
}

