/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.resources;

import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class ResourceManager {
    private static final ALogger log = ALogger.getLogger(ResourceManager.class);
    private static final String ICONBASEPATH = "icons/";

    public static ImageIcon icon(Class<?> clazz, String string) {
        return ResourceManager.icon(clazz, string, null);
    }

    private static ImageIcon icon(Class<?> clazz, String string, Dimension dimension) {
        URL uRL;
        if (!string.startsWith("/")) {
            string = ICONBASEPATH + string;
        }
        if ((uRL = ResourceManager.url(clazz, string)) != null) {
            return ResourceManager.newIcon(uRL, dimension);
        }
        try {
            InputStream inputStream = ResourceManager.inputStream(clazz, string);
            byte[] byArray = StreamUtil.readStream((InputStream)inputStream);
            Image image = Toolkit.getDefaultToolkit().createImage(byArray, 0, byArray.length);
            return ResourceManager.newIcon(image, dimension);
        }
        catch (Exception exception) {
            log.error("cannot load icon '" + string + "', exception is:", (Throwable)exception);
            return null;
        }
    }

    private static ImageIcon newIcon(Image image, Dimension dimension) {
        if (dimension != null) {
            image = IconUtil.scaleImage((Image)image, (int)dimension.width, (int)dimension.height);
        }
        return new ImageIcon(image);
    }

    private static ImageIcon newIcon(URL uRL, Dimension dimension) {
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        return ResourceManager.newIcon(image, dimension);
    }

    private static InputStream inputStream(Class<?> clazz, String string) throws IOException {
        URL uRL = ResourceManager.url(clazz, string);
        if (uRL != null) {
            return uRL.openStream();
        }
        return clazz.getResourceAsStream("//" + string);
    }

    private static URL url(Class<?> clazz, String string) {
        URL uRL;
        if (clazz == null) {
            clazz = ResourceManager.class;
        }
        if ((uRL = clazz.getResource(string)) == null) {
            log.debug("URL not found: " + string + ", relative to " + clazz.getName());
        }
        return uRL;
    }

    private ResourceManager() {
    }
}

