/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.hotregion;

import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.agfa.hap.pacs.impaxee.awt.OutlineFontCache;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.overlay.OverlayFontConfig;
import com.tiani.jvision.vis.Vis2;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class FourDHotRegion
extends HotRegion {
    private static final float NON_TRANSPARENT = 255.0f;
    private static OutlineFont outlineFont;
    private static RGBBufferedImageHolder bufferedImageHolder;
    private Vis2 vis;

    public FourDHotRegion(Vis2 vis2) {
        this.vis = vis2;
    }

    @Override
    protected float getAlphaIn() {
        return 255.0f;
    }

    @Override
    protected float getAlphaAction() {
        return 255.0f;
    }

    @Override
    protected float getAlphaDisabled() {
        return 255.0f;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.draw4DTemporalIndex(graphics);
    }

    @Override
    boolean is4DHotRegion() {
        return true;
    }

    private void draw4DTemporalIndex(Graphics graphics) {
        IDisplayPlugin iDisplayPlugin = this.vis.getVisDisplay().getData().getDisplayPlugin();
        if (this.vis.is4D() && "4D_TEMPORAL".equals(this.getName()) && iDisplayPlugin.getMouseModeInfo().areHotRegionsInside()) {
            Object object;
            Serializable serializable;
            Rectangle rectangle = this.calculateImageRectangle();
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x + rectangle.width;
            rectangle2.y = rectangle.y + rectangle.height;
            rectangle2.width = rectangle.width;
            rectangle2.height = rectangle.height;
            Color color = graphics.getColor();
            graphics.setColor(Vis2.LIGHT_BLUE);
            if (outlineFont == null) {
                serializable = graphics.getFont();
                graphics.setFont(OverlayFontConfig.displayFont);
                outlineFont = new OutlineFontCache(1, Vis2.LIGHT_BLUE).getOutlineFont(graphics.getFont(), graphics.getFontMetrics());
                object = new BufferedImage(rectangle2.width, rectangle2.height, 2);
                bufferedImageHolder = new RGBBufferedImageHolder((BufferedImage)object);
                graphics.setFont((Font)serializable);
            }
            serializable = outlineFont.getFontMetrics();
            object = iDisplayPlugin.get4DProperties();
            String string = String.valueOf(Integer.toString(object.getSecondaryIndex() + 1)) + '/' + Integer.toString(object.getNumberOf4DRuns());
            int n = ((FontMetrics)serializable).stringWidth(string);
            int n2 = ((FontMetrics)serializable).getHeight();
            rectangle2.x -= n;
            rectangle2.y -= n2;
            bufferedImageHolder.clear();
            outlineFont.drawBytes(string.toCharArray(), (IImageHolder)bufferedImageHolder, 0, n2 - 4);
            graphics.setColor(Color.black);
            graphics.fillRect(rectangle2.x - 2, rectangle2.y - 3, n + 5, n2 + 2);
            graphics.setColor(Vis2.LIGHT_BLUE);
            graphics.drawRect(rectangle2.x - 2, rectangle2.y - 3, n + 5, n2 + 2);
            graphics.drawRect(rectangle2.x - 3, rectangle2.y - 4, n + 7, n2 + 4);
            graphics.drawImage(FourDHotRegion.bufferedImageHolder.image, rectangle2.x - 1, rectangle2.y, null);
            graphics.setColor(color);
        }
    }
}

