/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.hotregion;

import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.controls.basic.RepaintListener;
import com.tiani.gui.controls.hotregion.HotRegionImage;
import com.tiani.gui.controls.hotregion.HotRegionListener;
import com.tiani.gui.controls.hotregion.HotRegionListenerExtension;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisHRTags;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;

public class HotRegion
extends JComponent
implements MouseInputListener {
    private static final ALogger LOGGER = ALogger.getLogger(HotRegion.class);
    private static HotRegion theOneInAction = null;
    protected List<HotRegionListener> listeners = new Vector<HotRegionListener>(2);
    private HotRegionType type = HotRegionType.Normal;
    private HotRegionMode mode = HotRegionMode.Out;
    private EnumSet<State> properties = EnumSet.of(State.Enabled, State.Visible, State.VisibleOnPress, State.MouseEnteredHandled);
    private Timer timer = null;
    private DragInfo dragInfo;
    protected int grabOffsetX;
    protected int grabOffsetY;
    private float alpha = -1.0f;
    private float alphaOut = VisHRSet.alphaOut;
    private Rectangle imagePosition;
    private HotRegionImage frontImg;
    private RepaintListener repaintListener;

    public HotRegion() {
        this(VisHRSet.alphaOut);
    }

    HotRegion(float f) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(12));
        this.alphaOut = f;
        this.setAlpha(f);
    }

    public void setRepaintListener(RepaintListener repaintListener) {
        this.repaintListener = repaintListener;
    }

    public void destruct() {
        this.stopThread();
    }

    public void reset() {
        switch (this.type) {
            case Normal: 
            case Normal_Dark: {
                this.mode = HotRegionMode.Out;
                this.setAlpha(this.getAlphaOut());
                break;
            }
            case Twostate: 
            case Twostate_On: 
            case Twostate_Off: {
                if (this.properties.contains((Object)State.On)) {
                    this.mode = HotRegionMode.In;
                    this.setAlpha(this.getAlphaAction());
                    break;
                }
                this.mode = HotRegionMode.Out;
                this.setAlpha(this.getAlphaOut());
            }
        }
    }

    public boolean wasImageDirectlyPressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (VisHRSet.visibilityStatus == VisibilityStatus.DEFAULT) {
            if (this.imagePosition == null) {
                return false;
            }
            if (this.imagePosition.contains(point)) {
                Image image = this.frontImg.getImage().getScaledInstance(this.imagePosition.width, this.imagePosition.height, 1);
                int[] nArray = new int[1];
                PixelGrabber pixelGrabber = new PixelGrabber(image, point.x - this.imagePosition.x, point.y - this.imagePosition.y, 1, 1, nArray, 0, 1);
                try {
                    if (pixelGrabber.grabPixels() && nArray[0] != 0) {
                        return true;
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("Interrupted", (Throwable)interruptedException);
                }
            }
        }
        return false;
    }

    public void addListener(HotRegionListener hotRegionListener) {
        this.listeners.add(hotRegionListener);
    }

    void removeListener(HotRegionListener hotRegionListener) {
        this.listeners.remove(hotRegionListener);
    }

    public HotRegionImage getImage() {
        return this.frontImg;
    }

    public void setImage(PIcon pIcon) {
        this.setImage(new HotRegionImage(pIcon));
    }

    public void setImage(HotRegionImage hotRegionImage) {
        if (hotRegionImage == null) {
            return;
        }
        this.frontImg = hotRegionImage;
    }

    public void setBackImage(Image image) {
    }

    public void setGrabOffset(int n, int n2) {
        this.grabOffsetX = n;
        this.grabOffsetY = n2;
    }

    public HotRegionType getType() {
        return this.type;
    }

    public void setType(HotRegionType hotRegionType) {
        this.type = hotRegionType;
    }

    public boolean isOn() {
        return this.properties.contains((Object)State.On);
    }

    public boolean isClickable() {
        return this.properties.contains((Object)State.Clickable);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (VisHRTags.CLICKABLE_HOT_REGIONS.contains(string)) {
            this.properties.add(State.Clickable);
        }
    }

    public void setOn(boolean bl) {
        this.stopThread();
        if (this.properties.contains((Object)State.On) == bl) {
            return;
        }
        if (bl) {
            this.properties.add(State.On);
            this.mode = HotRegionMode.In;
            this.setAlpha(this.getAlphaAction());
            this.repaint();
        } else {
            this.properties.remove((Object)State.On);
            this.mode = HotRegionMode.Out;
            this.setAlpha(this.getAlphaOut());
            this.repaint();
        }
    }

    public HotRegionMode getMode() {
        return this.mode;
    }

    public void setAlphaOut(float f) {
        this.alphaOut = f;
    }

    public float getAlphaOut() {
        return this.alphaOut;
    }

    protected float getAlphaIn() {
        return VisHRSet.alphaIn;
    }

    protected float getAlphaAction() {
        return VisHRSet.alphaAction;
    }

    protected float getAlphaDisabled() {
        return VisHRSet.alphaDisabled;
    }

    private void setModeIn() {
        this.mode = HotRegionMode.In;
        this.setAlpha(this.getAlphaIn());
    }

    void setModeOut() {
        this.mode = HotRegionMode.Out;
        this.setAlpha(this.getAlphaOut());
    }

    public boolean isDimmed() {
        return this.properties.contains((Object)State.Dimmed);
    }

    public void sendEvents() {
        this.properties.add(State.SendEvents);
    }

    public boolean isSendingEvents() {
        return this.properties.contains((Object)State.SendEvents);
    }

    public void setDimmed(boolean bl) {
        if (this.properties.contains((Object)State.Dimmed) == bl) {
            return;
        }
        if (bl) {
            this.properties.add(State.Dimmed);
        } else {
            this.properties.remove((Object)State.Dimmed);
            this.reset();
        }
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.properties.contains((Object)State.Enabled);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl) {
            this.stopThread();
            if (theOneInAction != null) {
                HotRegion.theOneInAction.properties.remove((Object)State.InAction);
                theOneInAction = null;
            }
        }
        if (this.properties.contains((Object)State.Enabled) == bl) {
            return;
        }
        if (bl) {
            this.properties.add(State.Enabled);
            if (this.type.isTwoState()) {
                if (this.properties.contains((Object)State.On)) {
                    this.setAlpha(this.getAlphaAction());
                } else {
                    this.setAlpha(this.getAlphaOut());
                }
            } else {
                this.setAlpha(this.getAlphaOut());
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.properties.remove((Object)State.Enabled);
            if (this.type.isTwoState()) {
                if (this.properties.contains((Object)State.On)) {
                    float f = this.getAlphaDisabled() + 30.0f;
                    if (f > 255.0f) {
                        f = 255.0f;
                    }
                    this.setAlpha(f);
                } else {
                    this.setAlpha(this.getAlphaDisabled());
                }
            } else {
                this.setAlpha(this.getAlphaDisabled());
                this.mode = HotRegionMode.Out;
            }
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.repaint();
    }

    @Override
    public boolean isVisible() {
        return this.properties.contains((Object)State.Visible);
    }

    private void setProperty(State state, boolean bl) {
        if (bl) {
            this.properties.add(state);
        } else {
            this.properties.remove((Object)state);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.properties.contains((Object)State.Visible) == bl) {
            return;
        }
        this.setProperty(State.Visible, bl);
        this.repaint();
    }

    public boolean isInAction() {
        return this.properties.contains((Object)State.InAction);
    }

    public final void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
    }

    void showTemporarily() {
        if (this.doNotFireAction()) {
            return;
        }
        this.stopThread();
        this.setModeIn();
        this.repaint();
        this.startThread(HotRegionMode.ShowTemporarily);
    }

    private void startDelayFadeIn() {
        if (this.doNotFireAction()) {
            return;
        }
        this.stopThread();
        this.startThread(HotRegionMode.Delay_FadeIn);
    }

    private void startDelayFadeOut() {
        if (this.doNotFireAction()) {
            return;
        }
        this.stopThread();
        this.startThread(HotRegionMode.Delay_FadeOut);
    }

    private void startFadeIn() {
        if (this.doNotFireAction()) {
            return;
        }
        this.stopThread();
        switch (this.mode) {
            case Delay_FadeIn: {
                this.startThread(HotRegionMode.FadeIn);
                break;
            }
            case Delay_FadeOut: 
            case ShowTemporarily: {
                break;
            }
            case FadeIn: {
                break;
            }
            case FadeOut: {
                this.startThread(HotRegionMode.FadeIn, this.alpha);
                break;
            }
            case In: {
                break;
            }
            case Out: {
                this.startThread(HotRegionMode.FadeIn);
            }
        }
    }

    private void startFadeOut() {
        if (this.doNotFireAction()) {
            return;
        }
        this.stopThread();
        switch (this.mode) {
            case Delay_FadeIn: {
                break;
            }
            case Delay_FadeOut: 
            case ShowTemporarily: {
                this.startThread(HotRegionMode.FadeOut);
                break;
            }
            case FadeIn: {
                this.startThread(HotRegionMode.FadeOut, this.alpha);
                break;
            }
            case FadeOut: {
                break;
            }
            case In: {
                this.startThread(HotRegionMode.FadeOut);
                break;
            }
        }
    }

    private void startThread(HotRegionMode hotRegionMode) {
        if (this.doNotFireAction()) {
            return;
        }
        this.mode = hotRegionMode;
        this.timer = this.createTimer(-1.0f);
    }

    private Timer createTimer(float f) {
        Timer timer = null;
        switch (this.getMode()) {
            case Delay_FadeIn: {
                timer = new Timer(VisHRSet.delayFadeIn, new SimpleDelayTimer());
                timer.setRepeats(false);
                break;
            }
            case Delay_FadeOut: {
                timer = new Timer(VisHRSet.delayFadeOut, new SimpleDelayTimer());
                timer.setRepeats(false);
                break;
            }
            case ShowTemporarily: {
                timer = new Timer(VisHRSet.DURATION_SHOW_TEMPORARILY, new SimpleDelayTimer());
                timer.setRepeats(false);
                break;
            }
            default: {
                timer = new Timer(20, new FadeTimer(f));
                timer.setCoalesce(true);
            }
        }
        timer.start();
        return timer;
    }

    private void startThread(HotRegionMode hotRegionMode, float f) {
        if (this.doNotFireAction()) {
            return;
        }
        this.mode = hotRegionMode;
        this.timer = this.createTimer(f);
    }

    private void stopThread() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private int getAlignedImgX(int n) {
        int n2 = this.getWidth();
        return n2 / 2 - n / 2;
    }

    private int getAlignedImgY(int n) {
        int n2 = this.getHeight();
        return n2 / 2 - n / 2;
    }

    private Dimension calculateImageDimension() {
        if (this.frontImg == null) {
            return new Dimension();
        }
        return this.frontImg.calculateImageDimension(this.getBounds());
    }

    public Rectangle calculateImageRectangle() {
        Dimension dimension = this.calculateImageDimension();
        int n = this.getAlignedImgX(dimension.width);
        int n2 = this.getAlignedImgY(dimension.height);
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }

    boolean is4DHotRegion() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.imagePosition = null;
        if (this.alpha <= 0.0f && !this.is4DHotRegion()) {
            return;
        }
        if (!this.properties.contains((Object)State.Visible)) {
            return;
        }
        if (this.properties.contains((Object)State.Dimmed)) {
            return;
        }
        Container container = this.getParent();
        while (container != null && !(container instanceof Dialog) && !(container instanceof Frame)) {
            if (!container.isVisible()) {
                return;
            }
            container = container.getParent();
        }
        this.imagePosition = this.calculateImageRectangle();
        float f = this.alpha;
        if (VisHRSet.visibilityStatus == VisibilityStatus.FULLY_TRANSPARENT && !this.type.isTwoState()) {
            f = 0.0f;
        }
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(10, (float)((double)f / 255.0)));
        if (this.frontImg != null) {
            graphics.drawImage(this.frontImg.getImage(), this.imagePosition.x, this.imagePosition.y, this.imagePosition.width, this.imagePosition.height, null);
        }
        this.paintChildren(graphics);
    }

    private void fireEnteredAction(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 0) {
            if (this.doNotFireAction()) {
                return;
            }
            int n = 0;
            while (n < this.listeners.size()) {
                HotRegionListener hotRegionListener = this.listeners.get(n);
                if (hotRegionListener instanceof HotRegionListenerExtension) {
                    ((HotRegionListenerExtension)hotRegionListener).hotRegionEntered(this, mouseEvent);
                }
                ++n;
            }
        }
    }

    private void fireExitedAction(MouseEvent mouseEvent) {
        if (this.doNotFireAction()) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            HotRegionListener hotRegionListener = this.listeners.get(n);
            if (hotRegionListener instanceof HotRegionListenerExtension) {
                ((HotRegionListenerExtension)hotRegionListener).hotRegionExited(this, mouseEvent);
            }
            ++n;
        }
    }

    private void firePressAction(MouseEvent mouseEvent) {
        if (this.doNotFireAction()) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).hotRegionPressed(this, mouseEvent);
            ++n;
        }
    }

    private void fireDragAction(MouseEvent mouseEvent) {
        if (this.doNotFireAction()) {
            return;
        }
        if (this.dragInfo != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                this.listeners.get(n).hotRegionDragged(this, mouseEvent, this.dragInfo.dragAbsX, this.dragInfo.dragAbsY, this.dragInfo.dragRelX, this.dragInfo.dragRelY);
                ++n;
            }
        }
    }

    private void fireReleaseAction(MouseEvent mouseEvent) {
        if (this.doNotFireAction()) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).hotRegionReleased(this, mouseEvent);
            ++n;
        }
    }

    private boolean isOtherInAction() {
        return theOneInAction != null && theOneInAction != this;
    }

    boolean doNotFireAction() {
        return this.isDimmed() || !this.isEnabled();
    }

    private boolean ignoreMouseEvent() {
        return this.doNotFireAction() || this.isOtherInAction();
    }

    private boolean ignoreMouseEventOrInAction() {
        return this.ignoreMouseEvent() || this.isInAction();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (VisDisplay2.pjvi1754_isNavigDragActive()) {
            return;
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = 0;
        while (n < mouseListenerArray.length) {
            if (mouseListenerArray[n] != this) {
                mouseListenerArray[n].mouseEntered(mouseEvent);
            }
            ++n;
        }
        this.properties.add(State.MouseEnteredHandled);
        if (this.ignoreMouseEventOrInAction()) {
            return;
        }
        if (this.type == HotRegionType.Twostate_Off && !this.properties.contains((Object)State.On)) {
            return;
        }
        switch (this.mode) {
            case Out: {
                this.startDelayFadeIn();
                break;
            }
            case FadeOut: {
                this.startFadeIn();
                break;
            }
            case Delay_FadeOut: 
            case ShowTemporarily: {
                this.stopThread();
                this.mode = HotRegionMode.In;
            }
        }
        this.properties.add(State.MouseEnteredHandled);
        this.fireEnteredAction(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = 0;
        while (n < mouseListenerArray.length) {
            if (mouseListenerArray[n] != this) {
                if (mouseListenerArray[n] instanceof DefaultMouseMoveListener && mouseEvent.getSource() != this) {
                    MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    mouseListenerArray[n].mouseExited(mouseEvent2);
                } else {
                    mouseListenerArray[n].mouseExited(mouseEvent);
                }
            }
            ++n;
        }
        this.properties.remove((Object)State.MouseEnteredHandled);
        if (this.ignoreMouseEventOrInAction()) {
            return;
        }
        switch (this.mode) {
            case In: {
                if (this.type != HotRegionType.Normal && this.type != HotRegionType.Normal_Dark && this.properties.contains((Object)State.On)) break;
                this.startDelayFadeOut();
                break;
            }
            case FadeIn: {
                this.startFadeOut();
                break;
            }
            case Delay_FadeIn: {
                this.stopThread();
                this.mode = HotRegionMode.Out;
            }
        }
        this.fireExitedAction(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ignoreMouseEvent()) {
            return;
        }
        if (!this.properties.contains((Object)State.MouseEnteredHandled)) {
            this.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ignoreMouseEvent()) {
            return;
        }
        if (this.dragInfo != null) {
            this.dragInfo.dragTo(mouseEvent);
        }
        if (this.type == HotRegionType.Normal || this.type == HotRegionType.Normal_Dark) {
            this.fireDragAction(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = 0;
        while (n < mouseListenerArray.length) {
            if (mouseListenerArray[n] != this) {
                mouseListenerArray[n].mousePressed(mouseEvent);
            }
            ++n;
        }
        if (this.ignoreMouseEvent()) {
            return;
        }
        this.stopThread();
        this.setProperty(State.VisibleOnPress, this.properties.contains((Object)State.Visible));
        this.dragInfo = new DragInfo(mouseEvent);
        this.properties.add(State.InAction);
        n = 0;
        switch (this.type) {
            case Normal: {
                this.mode = HotRegionMode.In;
                this.setAlpha(this.getAlphaAction());
                this.repaint();
                n = 1;
                break;
            }
            case Normal_Dark: {
                this.mode = HotRegionMode.In;
                if (!this.is4DHotRegion()) {
                    this.setVisible(false);
                } else {
                    this.setVisible(this.isVisible());
                }
                n = 1;
                break;
            }
            case Twostate: {
                this.setProperty(State.On, !this.properties.contains((Object)State.On));
                if (this.properties.contains((Object)State.On)) {
                    this.mode = HotRegionMode.In;
                    this.setAlpha(this.getAlphaAction());
                    this.repaint();
                } else {
                    this.mode = HotRegionMode.Out;
                    this.setAlpha(this.getAlphaOut());
                    this.repaint();
                }
                n = 1;
                break;
            }
            case Twostate_On: {
                if (this.properties.contains((Object)State.On)) break;
                this.properties.add(State.On);
                this.mode = HotRegionMode.In;
                this.setAlpha(this.getAlphaAction());
                this.repaint();
                n = 1;
                break;
            }
            case Twostate_Off: {
                if (!this.properties.contains((Object)State.On)) break;
                this.properties.remove((Object)State.On);
                this.mode = HotRegionMode.Out;
                this.setAlpha(this.getAlphaOut());
                this.repaint();
                n = 1;
            }
        }
        theOneInAction = this;
        if (n != 0) {
            this.firePressAction(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = 0;
        while (n < mouseListenerArray.length) {
            if (mouseListenerArray[n] != this) {
                mouseListenerArray[n].mouseReleased(mouseEvent);
            }
            ++n;
        }
        this.properties.remove((Object)State.InAction);
        theOneInAction = null;
        if (this.ignoreMouseEvent()) {
            return;
        }
        n = this.getBounds().contains(mouseEvent.getX(), mouseEvent.getY()) ? 1 : 0;
        boolean bl = false;
        switch (this.type) {
            case Normal: 
            case Normal_Dark: {
                if (n != 0) {
                    this.mode = HotRegionMode.In;
                    this.setAlpha(this.getAlphaIn());
                } else if (!this.is4DHotRegion()) {
                    this.mode = HotRegionMode.Out;
                    this.setAlpha(this.getAlphaOut());
                }
                this.repaint();
                bl = true;
                break;
            }
            case Twostate: 
            case Twostate_On: 
            case Twostate_Off: {
                if (this.properties.contains((Object)State.On)) {
                    this.mode = HotRegionMode.In;
                    this.setAlpha(this.getAlphaAction());
                    this.repaint();
                } else {
                    this.mode = HotRegionMode.Out;
                    this.setAlpha(this.getAlphaOut());
                    this.repaint();
                }
                bl = true;
            }
        }
        if (bl) {
            this.fireReleaseAction(mouseEvent);
        }
        this.dragInfo = null;
        this.setVisible(this.properties.contains((Object)State.VisibleOnPress));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Hot region clicked: {}", (Object)this.getName());
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = 0;
        while (n < mouseListenerArray.length) {
            if (mouseListenerArray[n] != this) {
                mouseListenerArray[n].mouseClicked(mouseEvent);
            }
            ++n;
        }
    }

    @Override
    public void repaint() {
        if (this.repaintListener != null && this.repaintListener.handleComponentRepaint(this)) {
            return;
        }
        super.repaint();
    }

    public void updateVisibilityStatus() {
        this.reset();
    }

    @Override
    public String toString() {
        String string = (String)this.getClientProperty("ToolTipText");
        return string != null ? string : super.toString();
    }

    private static class DragInfo {
        private int lastDragX;
        private int lastDragY;
        private int dragRelX;
        private int dragRelY;
        private int dragAbsX;
        private int dragAbsY;

        public DragInfo(MouseEvent mouseEvent) {
            this.lastDragX = mouseEvent.getX();
            this.lastDragY = mouseEvent.getY();
        }

        public void dragTo(MouseEvent mouseEvent) {
            this.dragRelX = mouseEvent.getX() - this.lastDragX;
            this.dragRelY = mouseEvent.getY() - this.lastDragY;
            this.dragAbsX += this.dragRelX;
            this.dragAbsY += this.dragRelY;
            this.lastDragX = mouseEvent.getX();
            this.lastDragY = mouseEvent.getY();
        }
    }

    private class FadeTimer
    implements ActionListener {
        private float startAlpha = 0.0f;
        private float endAlpha = 0.0f;
        private long totalTime = 0L;
        private long passedTime = 0L;
        private long startTime;

        private FadeTimer(float f) {
            if (HotRegion.this.getMode() == HotRegionMode.FadeIn) {
                this.startAlpha = HotRegion.this.getAlphaOut();
                this.endAlpha = HotRegion.this.getAlphaIn();
                this.totalTime = VisHRSet.timeFadeIn;
            } else if (HotRegion.this.getMode() == HotRegionMode.FadeOut) {
                this.startAlpha = HotRegion.this.getAlphaIn();
                this.endAlpha = HotRegion.this.getAlphaOut();
                this.totalTime = VisHRSet.timeFadeOut;
            }
            HotRegion.this.alpha = this.startAlpha;
            if (f > 0.0f) {
                HotRegion.this.alpha = f;
                this.passedTime = this.passedTimeFromAlpha(f, this.startAlpha, this.endAlpha, this.totalTime);
            }
            this.startTime = System.currentTimeMillis();
        }

        private long passedTimeFromAlpha(float f, float f2, float f3, long l) {
            float f4 = (f - f2) / (f3 - f2);
            return Math.round((float)l * f4);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.passedTime = System.currentTimeMillis() - this.startTime;
            float f = (float)this.passedTime / (float)this.totalTime;
            HotRegion.this.alpha = this.startAlpha + (this.endAlpha - this.startAlpha) * f;
            if (this.passedTime >= this.totalTime) {
                HotRegion.this.alpha = this.endAlpha;
            }
            HotRegion.this.setAlpha(HotRegion.this.alpha);
            if (this.passedTime >= this.totalTime) {
                if (HotRegion.this.getMode() == HotRegionMode.FadeIn) {
                    HotRegion.this.setModeIn();
                } else if (HotRegion.this.getMode() == HotRegionMode.FadeOut) {
                    HotRegion.this.setModeOut();
                }
                Object object = actionEvent.getSource();
                if (object instanceof Timer) {
                    ((Timer)object).stop();
                }
            }
            HotRegion.this.repaint();
        }
    }

    public static enum HotRegionMode {
        In,
        Out,
        Delay_FadeIn,
        Delay_FadeOut,
        FadeIn,
        FadeOut,
        ShowTemporarily;

    }

    public static enum HotRegionType {
        Normal(false),
        Normal_Dark(false),
        Twostate(true),
        Twostate_On(true),
        Twostate_Off(true);

        private boolean isTwoState;

        private HotRegionType(boolean bl) {
            this.isTwoState = bl;
        }

        public boolean isTwoState() {
            return this.isTwoState;
        }
    }

    private class SimpleDelayTimer
    implements ActionListener {
        private SimpleDelayTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HotRegion.this.getMode() == HotRegionMode.Delay_FadeIn) {
                HotRegion.this.startFadeIn();
            } else {
                HotRegion.this.startFadeOut();
            }
        }
    }

    private static enum State {
        Enabled,
        Visible,
        Dimmed,
        InAction,
        On,
        VisibleOnPress,
        MouseEnteredHandled,
        SendEvents,
        Clickable;

    }

    public static enum VisibilityStatus {
        FULLY_TRANSPARENT,
        DEFAULT;

    }
}

