/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.dialog;

import com.agfa.pacs.base.swing.monitor.MonitorConfiguration;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.JDoubleField;
import com.agfa.pacs.listtext.swingx.controls.IMessageDialogVisualizer;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.dialog.MessagePopupHandler;
import com.tiani.gui.util.LocationUtil;
import com.tiani.util.message.AbstractMessageHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class GUIMessageHandler
extends AbstractMessageHandler
implements IMessageDialogVisualizer {
    private static final ALogger log = ALogger.getLogger(GUIMessageHandler.class);
    private static final GUIMessageHandler instance = new GUIMessageHandler();
    private static Window parentWindow;

    public static GUIMessageHandler getInstance() {
        return instance;
    }

    public static synchronized Window getParentWindow() {
        return parentWindow;
    }

    public static synchronized void setParentWindow(Window window) {
        if (window != null) {
            parentWindow = window;
        }
    }

    private GUIMessageHandler() {
    }

    @Override
    public void error(Throwable throwable, String string, Object object, Object[] objectArray) {
        object = this.substituteArguments(object, objectArray, throwable);
        this.showMessageDialog(GUIMessageHandler.getParentWindow(), object, string, 0, null, 0);
    }

    @Override
    public void warning(String string, Object object, Object[] objectArray) {
        object = this.substituteArguments(object, objectArray);
        this.showMessageDialog(GUIMessageHandler.getParentWindow(), object, string, 2, null, 0);
    }

    @Override
    public void info(String string, Object object, Object[] objectArray) {
        object = this.substituteArguments(object, objectArray);
        this.showMessageDialog(GUIMessageHandler.getParentWindow(), object, string, 1, null, 0);
    }

    @Override
    public int okCancel(String string, Object object, Object[] objectArray, boolean bl) {
        object = this.substituteArguments(object, objectArray);
        Object object2 = this.showDialogAndWait(GUIMessageHandler.getParentWindow(), object, string, 2, 3, null, 0, bl);
        return Integer.valueOf(0).equals(object2) ? 0 : 2;
    }

    @Override
    public int yesNo(String string, Object object, Object[] objectArray) {
        return this.yesNoDialog(string, object, objectArray, 0, null, 0);
    }

    @Override
    public Object choose(String string, Object object, Object[] objectArray, Object ... objectArray2) {
        return this.choose(string, object, objectArray, -1, objectArray2, objectArray2[0]);
    }

    private Object choose(String string, Object object, Object[] objectArray, int n, Object[] objectArray2, Object object2) {
        object = this.substituteArguments(object, objectArray);
        return this.showDialogAndWait(GUIMessageHandler.getParentWindow(), object, string, n, 3, objectArray2, object2, false);
    }

    @Override
    public Number queryNumber(final String string, Object object, Object[] objectArray, final Double d, final String string2, final boolean bl) {
        final Object object2 = this.substituteArguments(object, objectArray);
        final ResultHolder resultHolder = new ResultHolder();
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                NumberInputPanel numberInputPanel = new NumberInputPanel(d, string2, bl);
                Object[] objectArray = new Object[]{object2, numberInputPanel};
                if (GUIMessageHandler.this.okCancel(string, objectArray, null, false) == 0) {
                    resultHolder.setResult(numberInputPanel.getValue());
                }
            }
        });
        return (Number)resultHolder.getResult();
    }

    @Override
    public Object input(Component component, Object object, String string, Object object2) {
        return this.showInputDialogAndWait(component, object, string, -1, -1, null, object2, false);
    }

    private int yesNoDialog(String string, Object object, Object[] objectArray, int n, Object[] objectArray2, Object object2) {
        Object object3 = this.choose(string, object, objectArray, n, objectArray2, object2);
        if (objectArray2 != null) {
            List<Object> list = Arrays.asList(objectArray2);
            object3 = list.indexOf(object3);
        }
        return Integer.valueOf(0).equals(object3) ? 0 : (Integer.valueOf(1).equals(object3) ? 1 : 2);
    }

    @Override
    protected Object substituteArguments(Object object, Object[] objectArray, Throwable throwable) {
        return this.substituteTextNewlines(super.substituteArguments(object, objectArray, throwable));
    }

    private void showMessageDialog(Window window, Object object, String string, int n, Object[] objectArray, Object object2) {
        this.showDialogAndWait(window, object, string, -1, n, objectArray, object2, false);
    }

    private Object showDialogAndWait(final Window window, final Object object, final String string, final int n, final int n2, final Object[] objectArray, final Object object2, final boolean bl) {
        final ResultHolder resultHolder = new ResultHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = new JOptionPane(object, n2, n, null, objectArray, object2);
                JDialog jDialog = jOptionPane.createDialog(window, string);
                GUIMessageHandler.this.showAndScaleComponentsFont(jDialog, object, bl);
                resultHolder.setResult(jOptionPane.getValue());
            }
        };
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("GUIMessageHandler", (Throwable)exception);
        }
        return resultHolder.getResult();
    }

    private Object showInputDialogAndWait(final Component component, final Object object, final String string, final int n, final int n2, final Object[] objectArray, final Object object2, final boolean bl) {
        final ResultHolder resultHolder = new ResultHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = new JOptionPane(object, n2, n, null, objectArray, object2);
                jOptionPane.setWantsInput(true);
                jOptionPane.setSelectionValues(null);
                jOptionPane.setInitialSelectionValue(object2);
                jOptionPane.setComponentOrientation(component.getComponentOrientation());
                JDialog jDialog = jOptionPane.createDialog(component, string);
                jOptionPane.selectInitialValue();
                GUIMessageHandler.this.showAndScaleComponentsFont(jDialog, object, bl);
                jDialog.dispose();
                Object object3 = jOptionPane.getInputValue();
                if (object3 == JOptionPane.UNINITIALIZED_VALUE) {
                    object3 = null;
                }
                resultHolder.setResult(object3);
            }
        };
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("GUIMessageHandler", (Throwable)exception);
        }
        return resultHolder.getResult();
    }

    public void showCentered(MessageDialog messageDialog) {
        this.showAndScaleComponentsFont((JDialog)messageDialog, null, false);
    }

    private void showAndScaleComponentsFont(JDialog jDialog, Object object, boolean bl) {
        jDialog.setResizable(true);
        if (bl) {
            this.scaleComponentsFont(jDialog, object);
        } else {
            this.scaleComponentsFont(jDialog);
        }
        jDialog.pack();
        Dimension dimension = LocationUtil.getSize(jDialog);
        dimension.width += 10;
        jDialog.setSize(dimension);
        this.showDialog(jDialog);
    }

    private void scaleComponentsFont(Component component) {
        ComponentFactory.instance.scaleFont(component);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                this.scaleComponentsFont(component2);
                ++n2;
            }
        }
    }

    private void scaleComponentsFont(Component component, Object object) {
        ComponentFactory.instance.scaleFont(component);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                if (component2 != object) {
                    this.scaleComponentsFont(component2, object);
                }
                ++n2;
            }
        }
    }

    private void showDialog(JDialog jDialog) {
        GUIMessageHandler.centerSizedWindow(jDialog);
        jDialog.setVisible(true);
    }

    public static void centerSizedWindow(Window window) {
        if (window instanceof JDialog && window.getParent() instanceof JDialog && window.getParent().isShowing()) {
            Rectangle rectangle = window.getParent().getBounds();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            Rectangle rectangle2 = MonitorConfiguration.getConfiguration().getBoundsOfScreenWithPoint(point);
            if (rectangle2 != null) {
                int n = point.x - window.getWidth() / 2;
                int n2 = point.y - window.getHeight() / 2;
                int n3 = rectangle2.x + rectangle2.width - n - window.getWidth();
                if (n3 < 0) {
                    n -= n3;
                }
                if ((n3 = rectangle2.y + rectangle2.height - n2 - window.getHeight()) < 0) {
                    n2 -= n3;
                }
                if (n2 < rectangle2.y) {
                    n2 = rectangle2.y;
                }
                if (n < rectangle2.x) {
                    n = rectangle2.x;
                }
                window.setLocation(n, n2);
            } else {
                ((JDialog)window).setLocationRelativeTo(window.getParent());
            }
        } else {
            Dimension dimension = LocationUtil.getSize(window);
            if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
                dimension = LocationUtil.getDefaultDialogSize();
                window.setSize(dimension);
            }
            Point point = LocationUtil.getProposedDialogLocationCenter();
            assert (point != null) : "the current mouse point must be retrieveable to center a dialog!";
            int n = point.x - dimension.width / 2;
            int n4 = point.y - dimension.height / 2;
            int n5 = LayoutConfig.getInstance().getImageAreaY();
            if (n4 < n5) {
                n4 = n5;
            }
            window.setLocation(n, n4);
        }
    }

    private Object substituteTextNewlines(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        return ((String)object).replace("\\n", "\n");
    }

    @Override
    public void showMessagePopup(String string, Integer n) {
        MessagePopupHandler.getInstance().showMessagePopup(string, n);
    }

    private static class MultiplexingDoubleField
    extends JDoubleField {
        private final KeyStroke[] strokes;

        MultiplexingDoubleField(Double d, boolean bl, KeyStroke ... keyStrokeArray) {
            super(d, bl, 0);
            this.strokes = keyStrokeArray;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && n != 2) {
                int n2 = this.strokes.length - 1;
                while (n2 >= 0) {
                    if (this.strokes[n2].equals(keyStroke)) {
                        return false;
                    }
                    --n2;
                }
            }
            return bl2;
        }
    }

    private static class NumberInputPanel
    extends JPanel
    implements AncestorListener {
        private static final int GAP = ComponentFactory.instance.scaleInt(5);
        private final JDoubleField field;

        NumberInputPanel(Double d, String string, boolean bl) {
            super(new BorderLayout(GAP, 0));
            this.field = new MultiplexingDoubleField(d, bl, KeyStroke.getKeyStroke("ENTER"));
            this.field.addAncestorListener(this);
            this.add((Component)this.field, "Center");
            if (string != null) {
                this.add((Component)new JLabel(string), "After");
            }
        }

        Double getValue() {
            return this.field.getValue();
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComponent jComponent = ancestorEvent.getComponent();
            jComponent.requestFocusInWindow();
            jComponent.removeAncestorListener(this);
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }

    private static class ResultHolder<T> {
        private volatile T result;

        private ResultHolder() {
        }

        T getResult() {
            return this.result;
        }

        void setResult(T t) {
            this.result = t;
        }
    }
}

